/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: api.proto

package v1alpha1

import (
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type SignJWTRequest struct {
	// URL-safe base64 wrapped payload to be signed.
	// Exactly as it appears in the second segment of the JWT
	Claims               string   `protobuf:"bytes,1,opt,name=claims,proto3" json:"claims,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SignJWTRequest) Reset()         { *m = SignJWTRequest{} }
func (m *SignJWTRequest) String() string { return proto.CompactTextString(m) }
func (*SignJWTRequest) ProtoMessage()    {}
func (*SignJWTRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{0}
}
func (m *SignJWTRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SignJWTRequest.Unmarshal(m, b)
}
func (m *SignJWTRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SignJWTRequest.Marshal(b, m, deterministic)
}
func (m *SignJWTRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignJWTRequest.Merge(m, src)
}
func (m *SignJWTRequest) XXX_Size() int {
	return xxx_messageInfo_SignJWTRequest.Size(m)
}
func (m *SignJWTRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SignJWTRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SignJWTRequest proto.InternalMessageInfo

func (m *SignJWTRequest) GetClaims() string {
	if m != nil {
		return m.Claims
	}
	return ""
}

type SignJWTResponse struct {
	// header must contain only alg, kid, typ claims.
	// typ must be “JWT”.
	// kid must be non-empty, <=1024 characters, and its corresponding public key should not be excluded from OIDC discovery.
	// alg must be one of the algorithms supported by kube-apiserver (currently RS256, ES256, ES384, ES512).
	// header cannot have any additional data that kube-apiserver does not recognize.
	// Already wrapped in URL-safe base64, exactly as it appears in the first segment of the JWT.
	Header string `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// The signature for the JWT.
	// Already wrapped in URL-safe base64, exactly as it appears in the final segment of the JWT.
	Signature            string   `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SignJWTResponse) Reset()         { *m = SignJWTResponse{} }
func (m *SignJWTResponse) String() string { return proto.CompactTextString(m) }
func (*SignJWTResponse) ProtoMessage()    {}
func (*SignJWTResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{1}
}
func (m *SignJWTResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SignJWTResponse.Unmarshal(m, b)
}
func (m *SignJWTResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SignJWTResponse.Marshal(b, m, deterministic)
}
func (m *SignJWTResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SignJWTResponse.Merge(m, src)
}
func (m *SignJWTResponse) XXX_Size() int {
	return xxx_messageInfo_SignJWTResponse.Size(m)
}
func (m *SignJWTResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SignJWTResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SignJWTResponse proto.InternalMessageInfo

func (m *SignJWTResponse) GetHeader() string {
	if m != nil {
		return m.Header
	}
	return ""
}

func (m *SignJWTResponse) GetSignature() string {
	if m != nil {
		return m.Signature
	}
	return ""
}

type FetchKeysRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FetchKeysRequest) Reset()         { *m = FetchKeysRequest{} }
func (m *FetchKeysRequest) String() string { return proto.CompactTextString(m) }
func (*FetchKeysRequest) ProtoMessage()    {}
func (*FetchKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{2}
}
func (m *FetchKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FetchKeysRequest.Unmarshal(m, b)
}
func (m *FetchKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FetchKeysRequest.Marshal(b, m, deterministic)
}
func (m *FetchKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FetchKeysRequest.Merge(m, src)
}
func (m *FetchKeysRequest) XXX_Size() int {
	return xxx_messageInfo_FetchKeysRequest.Size(m)
}
func (m *FetchKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_FetchKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_FetchKeysRequest proto.InternalMessageInfo

type FetchKeysResponse struct {
	Keys []*Key `protobuf:"bytes,1,rep,name=keys,proto3" json:"keys,omitempty"`
	// The timestamp when this data was pulled from the authoritative source of
	// truth for verification keys.
	// kube-apiserver can export this from metrics, to enable end-to-end SLOs.
	DataTimestamp *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=data_timestamp,json=dataTimestamp,proto3" json:"data_timestamp,omitempty"`
	// refresh interval for verification keys to pick changes if any.
	// any value <= 0 is considered a misconfiguration.
	RefreshHintSeconds   int64    `protobuf:"varint,3,opt,name=refresh_hint_seconds,json=refreshHintSeconds,proto3" json:"refresh_hint_seconds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FetchKeysResponse) Reset()         { *m = FetchKeysResponse{} }
func (m *FetchKeysResponse) String() string { return proto.CompactTextString(m) }
func (*FetchKeysResponse) ProtoMessage()    {}
func (*FetchKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{3}
}
func (m *FetchKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FetchKeysResponse.Unmarshal(m, b)
}
func (m *FetchKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FetchKeysResponse.Marshal(b, m, deterministic)
}
func (m *FetchKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FetchKeysResponse.Merge(m, src)
}
func (m *FetchKeysResponse) XXX_Size() int {
	return xxx_messageInfo_FetchKeysResponse.Size(m)
}
func (m *FetchKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_FetchKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_FetchKeysResponse proto.InternalMessageInfo

func (m *FetchKeysResponse) GetKeys() []*Key {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *FetchKeysResponse) GetDataTimestamp() *timestamppb.Timestamp {
	if m != nil {
		return m.DataTimestamp
	}
	return nil
}

func (m *FetchKeysResponse) GetRefreshHintSeconds() int64 {
	if m != nil {
		return m.RefreshHintSeconds
	}
	return 0
}

type Key struct {
	// A unique identifier for this key.
	// Length must be <=1024.
	KeyId string `protobuf:"bytes,1,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// The public key, PKIX-serialized.
	// must be a public key supported by kube-apiserver (currently RSA 256 or ECDSA 256/384/521)
	Key []byte `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
	// Set only for keys that are not used to sign bound tokens.
	// eg: supported keys for legacy tokens.
	// If set, key is used for verification but excluded from OIDC discovery docs.
	// if set, external signer should not use this key to sign a JWT.
	ExcludeFromOidcDiscovery bool     `protobuf:"varint,3,opt,name=exclude_from_oidc_discovery,json=excludeFromOidcDiscovery,proto3" json:"exclude_from_oidc_discovery,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *Key) Reset()         { *m = Key{} }
func (m *Key) String() string { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()    {}
func (*Key) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{4}
}
func (m *Key) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Key.Unmarshal(m, b)
}
func (m *Key) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Key.Marshal(b, m, deterministic)
}
func (m *Key) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Key.Merge(m, src)
}
func (m *Key) XXX_Size() int {
	return xxx_messageInfo_Key.Size(m)
}
func (m *Key) XXX_DiscardUnknown() {
	xxx_messageInfo_Key.DiscardUnknown(m)
}

var xxx_messageInfo_Key proto.InternalMessageInfo

func (m *Key) GetKeyId() string {
	if m != nil {
		return m.KeyId
	}
	return ""
}

func (m *Key) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *Key) GetExcludeFromOidcDiscovery() bool {
	if m != nil {
		return m.ExcludeFromOidcDiscovery
	}
	return false
}

type MetadataRequest struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MetadataRequest) Reset()         { *m = MetadataRequest{} }
func (m *MetadataRequest) String() string { return proto.CompactTextString(m) }
func (*MetadataRequest) ProtoMessage()    {}
func (*MetadataRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{5}
}
func (m *MetadataRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetadataRequest.Unmarshal(m, b)
}
func (m *MetadataRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetadataRequest.Marshal(b, m, deterministic)
}
func (m *MetadataRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetadataRequest.Merge(m, src)
}
func (m *MetadataRequest) XXX_Size() int {
	return xxx_messageInfo_MetadataRequest.Size(m)
}
func (m *MetadataRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MetadataRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MetadataRequest proto.InternalMessageInfo

type MetadataResponse struct {
	// used by kube-apiserver for defaulting/validation of JWT lifetime while accounting for configuration flag values:
	// 1. `--service-account-max-token-expiration`
	// 2. `--service-account-extend-token-expiration`
	//
	// * If `--service-account-max-token-expiration` is greater than `max_token_expiration_seconds`, kube-apiserver treats that as misconfiguration and exits.
	// * If `--service-account-max-token-expiration` is not explicitly set, kube-apiserver defaults to `max_token_expiration_seconds`.
	// * If `--service-account-extend-token-expiration` is true, the extended expiration is `min(1 year, max_token_expiration_seconds)`.
	//
	// `max_token_expiration_seconds` must be at least 600s.
	MaxTokenExpirationSeconds int64    `protobuf:"varint,1,opt,name=max_token_expiration_seconds,json=maxTokenExpirationSeconds,proto3" json:"max_token_expiration_seconds,omitempty"`
	XXX_NoUnkeyedLiteral      struct{} `json:"-"`
	XXX_unrecognized          []byte   `json:"-"`
	XXX_sizecache             int32    `json:"-"`
}

func (m *MetadataResponse) Reset()         { *m = MetadataResponse{} }
func (m *MetadataResponse) String() string { return proto.CompactTextString(m) }
func (*MetadataResponse) ProtoMessage()    {}
func (*MetadataResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_00212fb1f9d3bf1c, []int{6}
}
func (m *MetadataResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MetadataResponse.Unmarshal(m, b)
}
func (m *MetadataResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MetadataResponse.Marshal(b, m, deterministic)
}
func (m *MetadataResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MetadataResponse.Merge(m, src)
}
func (m *MetadataResponse) XXX_Size() int {
	return xxx_messageInfo_MetadataResponse.Size(m)
}
func (m *MetadataResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MetadataResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MetadataResponse proto.InternalMessageInfo

func (m *MetadataResponse) GetMaxTokenExpirationSeconds() int64 {
	if m != nil {
		return m.MaxTokenExpirationSeconds
	}
	return 0
}

func init() {
	proto.RegisterType((*SignJWTRequest)(nil), "v1alpha1.SignJWTRequest")
	proto.RegisterType((*SignJWTResponse)(nil), "v1alpha1.SignJWTResponse")
	proto.RegisterType((*FetchKeysRequest)(nil), "v1alpha1.FetchKeysRequest")
	proto.RegisterType((*FetchKeysResponse)(nil), "v1alpha1.FetchKeysResponse")
	proto.RegisterType((*Key)(nil), "v1alpha1.Key")
	proto.RegisterType((*MetadataRequest)(nil), "v1alpha1.MetadataRequest")
	proto.RegisterType((*MetadataResponse)(nil), "v1alpha1.MetadataResponse")
}

func init() { proto.RegisterFile("api.proto", fileDescriptor_00212fb1f9d3bf1c) }

var fileDescriptor_00212fb1f9d3bf1c = []byte{
	// 483 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x6c, 0x92, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0xc7, 0x31, 0x29, 0x51, 0x32, 0xa5, 0x6d, 0xb2, 0x02, 0xe4, 0xba, 0x95, 0x08, 0x3e, 0xe5,
	0x64, 0xd3, 0x70, 0xe1, 0x52, 0x21, 0x3e, 0x1a, 0xa0, 0x11, 0x42, 0x72, 0x22, 0x55, 0xe2, 0x62,
	0x6d, 0xed, 0x49, 0xbc, 0xf8, 0x63, 0xcd, 0xee, 0xa6, 0xd8, 0xcf, 0xc4, 0x43, 0xf1, 0x2a, 0xc8,
	0x1f, 0xeb, 0x94, 0x2a, 0xb7, 0xdd, 0xf9, 0xff, 0x77, 0x66, 0x7e, 0xb3, 0x03, 0x43, 0x9a, 0x33,
	0x27, 0x17, 0x5c, 0x71, 0x32, 0xb8, 0xbb, 0xa0, 0x49, 0x1e, 0xd1, 0x0b, 0xeb, 0xe5, 0x86, 0xf3,
	0x4d, 0x82, 0x6e, 0x1d, 0xbf, 0xdd, 0xae, 0x5d, 0xc5, 0x52, 0x94, 0x8a, 0xa6, 0x79, 0x63, 0xb5,
	0xa7, 0x70, 0xbc, 0x64, 0x9b, 0xec, 0xfa, 0x66, 0xe5, 0xe1, 0xaf, 0x2d, 0x4a, 0x45, 0x5e, 0x40,
	0x3f, 0x48, 0x28, 0x4b, 0xa5, 0x69, 0x4c, 0x8c, 0xe9, 0xd0, 0x6b, 0x6f, 0xf6, 0x67, 0x38, 0xe9,
	0x9c, 0x32, 0xe7, 0x99, 0xc4, 0xca, 0x1a, 0x21, 0x0d, 0x51, 0x68, 0x6b, 0x73, 0x23, 0xe7, 0x30,
	0x94, 0x6c, 0x93, 0x51, 0xb5, 0x15, 0x68, 0x3e, 0xae, 0xa5, 0x5d, 0xc0, 0x26, 0x30, 0x9a, 0xa3,
	0x0a, 0xa2, 0x05, 0x96, 0xb2, 0x2d, 0x6a, 0xff, 0x31, 0x60, 0x7c, 0x2f, 0xd8, 0xe6, 0x7f, 0x05,
	0x07, 0x31, 0x96, 0x55, 0x23, 0xbd, 0xe9, 0xe1, 0xec, 0xc8, 0xd1, 0x58, 0xce, 0x02, 0x4b, 0xaf,
	0x96, 0xc8, 0x7b, 0x38, 0x0e, 0xa9, 0xa2, 0x7e, 0xc7, 0x55, 0xd7, 0x3b, 0x9c, 0x59, 0x4e, 0x43,
	0xee, 0x68, 0x72, 0x67, 0xa5, 0x1d, 0xde, 0x51, 0xf5, 0xa2, 0xbb, 0x92, 0xd7, 0xf0, 0x4c, 0xe0,
	0x5a, 0xa0, 0x8c, 0xfc, 0x88, 0x65, 0xca, 0x97, 0x18, 0xf0, 0x2c, 0x94, 0x66, 0x6f, 0x62, 0x4c,
	0x7b, 0x1e, 0x69, 0xb5, 0x2f, 0x2c, 0x53, 0xcb, 0x46, 0xb1, 0x53, 0xe8, 0x2d, 0xb0, 0x24, 0xcf,
	0xa1, 0x1f, 0x63, 0xe9, 0xb3, 0xb0, 0xc5, 0x7f, 0x12, 0x63, 0xf9, 0x35, 0x24, 0x23, 0xe8, 0xc5,
	0x58, 0xd6, 0x7d, 0x3c, 0xf5, 0xaa, 0x23, 0xb9, 0x84, 0x33, 0x2c, 0x82, 0x64, 0x1b, 0xa2, 0xbf,
	0x16, 0x3c, 0xf5, 0x39, 0x0b, 0x03, 0x3f, 0x64, 0x32, 0xe0, 0x77, 0x28, 0xca, 0xba, 0xd0, 0xc0,
	0x33, 0x5b, 0xcb, 0x5c, 0xf0, 0xf4, 0x3b, 0x0b, 0x83, 0x4f, 0x5a, 0xb7, 0xc7, 0x70, 0xf2, 0x0d,
	0x15, 0xad, 0xba, 0xd6, 0xf3, 0x5a, 0xc2, 0x68, 0x17, 0x6a, 0xa7, 0xf5, 0x0e, 0xce, 0x53, 0x5a,
	0xf8, 0x8a, 0xc7, 0x98, 0xf9, 0x58, 0xe4, 0x4c, 0x50, 0xc5, 0x78, 0xd6, 0xf1, 0x18, 0x35, 0xcf,
	0x69, 0x4a, 0x8b, 0x55, 0x65, 0xb9, 0xea, 0x1c, 0x2d, 0xd6, 0xec, 0xaf, 0x01, 0xe3, 0xab, 0x42,
	0xa1, 0xc8, 0x68, 0x72, 0x7d, 0xb3, 0xaa, 0x7e, 0x1b, 0x05, 0xb9, 0x84, 0x83, 0xea, 0x44, 0xcc,
	0xdd, 0xf8, 0xff, 0xdf, 0x18, 0xeb, 0x74, 0x8f, 0xd2, 0xf4, 0x64, 0x3f, 0x22, 0x73, 0x18, 0x76,
	0x1f, 0x4b, 0xac, 0x9d, 0xf3, 0xe1, 0x0a, 0x58, 0x67, 0x7b, 0xb5, 0x2e, 0xcf, 0x47, 0x18, 0x68,
	0x62, 0x72, 0xaf, 0xe0, 0x83, 0xc1, 0x58, 0xd6, 0x3e, 0x49, 0x27, 0xf9, 0x60, 0xff, 0x98, 0xc4,
	0x6f, 0xa5, 0xc3, 0xb8, 0x8b, 0x2d, 0xe7, 0xcf, 0xdf, 0xca, 0xa5, 0x39, 0x93, 0xae, 0x7e, 0x76,
	0xdb, 0xaf, 0x37, 0xe6, 0xcd, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x90, 0x1b, 0xfb, 0x90, 0x50,
	0x03, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// ExternalJWTSignerClient is the client API for ExternalJWTSigner service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type ExternalJWTSignerClient interface {
	// Sign takes a serialized JWT payload, and returns the serialized header and
	// signature.  The caller can then assemble the JWT from the header, payload,
	// and signature.
	//
	// The plugin MUST set a key id in the returned JWT header.
	Sign(ctx context.Context, in *SignJWTRequest, opts ...grpc.CallOption) (*SignJWTResponse, error)
	// FetchKeys returns the set of public keys that are trusted to sign
	// Kubernetes service account tokens. Kube-apiserver will call this RPC:
	//
	// * Every time it tries to validate a JWT from the service account issuer with an unknown key ID, and
	//
	//   - Periodically, so it can serve reasonably-up-to-date keys from the OIDC
	//     JWKs endpoint.
	FetchKeys(ctx context.Context, in *FetchKeysRequest, opts ...grpc.CallOption) (*FetchKeysResponse, error)
	// Metadata is meant to be called once on startup.
	// Enables sharing metadata with kube-apiserver (eg: the max token lifetime that signer supports)
	Metadata(ctx context.Context, in *MetadataRequest, opts ...grpc.CallOption) (*MetadataResponse, error)
}

type externalJWTSignerClient struct {
	cc *grpc.ClientConn
}

func NewExternalJWTSignerClient(cc *grpc.ClientConn) ExternalJWTSignerClient {
	return &externalJWTSignerClient{cc}
}

func (c *externalJWTSignerClient) Sign(ctx context.Context, in *SignJWTRequest, opts ...grpc.CallOption) (*SignJWTResponse, error) {
	out := new(SignJWTResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.ExternalJWTSigner/Sign", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalJWTSignerClient) FetchKeys(ctx context.Context, in *FetchKeysRequest, opts ...grpc.CallOption) (*FetchKeysResponse, error) {
	out := new(FetchKeysResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.ExternalJWTSigner/FetchKeys", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalJWTSignerClient) Metadata(ctx context.Context, in *MetadataRequest, opts ...grpc.CallOption) (*MetadataResponse, error) {
	out := new(MetadataResponse)
	err := c.cc.Invoke(ctx, "/v1alpha1.ExternalJWTSigner/Metadata", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExternalJWTSignerServer is the server API for ExternalJWTSigner service.
type ExternalJWTSignerServer interface {
	// Sign takes a serialized JWT payload, and returns the serialized header and
	// signature.  The caller can then assemble the JWT from the header, payload,
	// and signature.
	//
	// The plugin MUST set a key id in the returned JWT header.
	Sign(context.Context, *SignJWTRequest) (*SignJWTResponse, error)
	// FetchKeys returns the set of public keys that are trusted to sign
	// Kubernetes service account tokens. Kube-apiserver will call this RPC:
	//
	// * Every time it tries to validate a JWT from the service account issuer with an unknown key ID, and
	//
	//   - Periodically, so it can serve reasonably-up-to-date keys from the OIDC
	//     JWKs endpoint.
	FetchKeys(context.Context, *FetchKeysRequest) (*FetchKeysResponse, error)
	// Metadata is meant to be called once on startup.
	// Enables sharing metadata with kube-apiserver (eg: the max token lifetime that signer supports)
	Metadata(context.Context, *MetadataRequest) (*MetadataResponse, error)
}

// UnimplementedExternalJWTSignerServer can be embedded to have forward compatible implementations.
type UnimplementedExternalJWTSignerServer struct {
}

func (*UnimplementedExternalJWTSignerServer) Sign(ctx context.Context, req *SignJWTRequest) (*SignJWTResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Sign not implemented")
}
func (*UnimplementedExternalJWTSignerServer) FetchKeys(ctx context.Context, req *FetchKeysRequest) (*FetchKeysResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchKeys not implemented")
}
func (*UnimplementedExternalJWTSignerServer) Metadata(ctx context.Context, req *MetadataRequest) (*MetadataResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Metadata not implemented")
}

func RegisterExternalJWTSignerServer(s *grpc.Server, srv ExternalJWTSignerServer) {
	s.RegisterService(&_ExternalJWTSigner_serviceDesc, srv)
}

func _ExternalJWTSigner_Sign_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignJWTRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalJWTSignerServer).Sign(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.ExternalJWTSigner/Sign",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalJWTSignerServer).Sign(ctx, req.(*SignJWTRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalJWTSigner_FetchKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalJWTSignerServer).FetchKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.ExternalJWTSigner/FetchKeys",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalJWTSignerServer).FetchKeys(ctx, req.(*FetchKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalJWTSigner_Metadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MetadataRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalJWTSignerServer).Metadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/v1alpha1.ExternalJWTSigner/Metadata",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalJWTSignerServer).Metadata(ctx, req.(*MetadataRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _ExternalJWTSigner_serviceDesc = grpc.ServiceDesc{
	ServiceName: "v1alpha1.ExternalJWTSigner",
	HandlerType: (*ExternalJWTSignerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Sign",
			Handler:    _ExternalJWTSigner_Sign_Handler,
		},
		{
			MethodName: "FetchKeys",
			Handler:    _ExternalJWTSigner_FetchKeys_Handler,
		},
		{
			MethodName: "Metadata",
			Handler:    _ExternalJWTSigner_Metadata_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "api.proto",
}
