/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.source;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.minidns.AbstractDnsClient;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsqueryresult.StandardDnsQueryResult;
import org.minidns.source.DnsDataSource;
import org.minidns.source.NetworkDataSource;

public class NetworkDataSourceWithAccounting
extends NetworkDataSource {
    private final AtomicInteger successfulQueries = new AtomicInteger();
    private final AtomicInteger responseSize = new AtomicInteger();
    private final AtomicInteger failedQueries = new AtomicInteger();
    private final AtomicInteger successfulUdpQueries = new AtomicInteger();
    private final AtomicInteger udpResponseSize = new AtomicInteger();
    private final AtomicInteger failedUdpQueries = new AtomicInteger();
    private final AtomicInteger successfulTcpQueries = new AtomicInteger();
    private final AtomicInteger tcpResponseSize = new AtomicInteger();
    private final AtomicInteger failedTcpQueries = new AtomicInteger();

    @Override
    public StandardDnsQueryResult query(DnsMessage message, InetAddress address, int port) throws IOException {
        StandardDnsQueryResult response;
        try {
            response = super.query(message, address, port);
        }
        catch (IOException e) {
            this.failedQueries.incrementAndGet();
            throw e;
        }
        this.successfulQueries.incrementAndGet();
        this.responseSize.addAndGet(response.response.toArray().length);
        return response;
    }

    @Override
    protected DnsMessage queryUdp(DnsMessage message, InetAddress address, int port) throws IOException {
        DnsMessage response;
        try {
            response = super.queryUdp(message, address, port);
        }
        catch (IOException e) {
            this.failedUdpQueries.incrementAndGet();
            throw e;
        }
        this.successfulUdpQueries.incrementAndGet();
        this.udpResponseSize.addAndGet(response.toArray().length);
        return response;
    }

    @Override
    protected DnsMessage queryTcp(DnsMessage message, InetAddress address, int port) throws IOException {
        DnsMessage response;
        try {
            response = super.queryTcp(message, address, port);
        }
        catch (IOException e) {
            this.failedTcpQueries.incrementAndGet();
            throw e;
        }
        this.successfulTcpQueries.incrementAndGet();
        this.tcpResponseSize.addAndGet(response.toArray().length);
        return response;
    }

    public Stats getStats() {
        return new Stats(this);
    }

    public static NetworkDataSourceWithAccounting from(AbstractDnsClient client) {
        DnsDataSource ds = client.getDataSource();
        if (ds instanceof NetworkDataSourceWithAccounting) {
            return (NetworkDataSourceWithAccounting)ds;
        }
        return null;
    }

    public static final class Stats {
        public final int successfulQueries;
        public final int responseSize;
        public final int averageResponseSize;
        public final int failedQueries;
        public final int successfulUdpQueries;
        public final int udpResponseSize;
        public final int averageUdpResponseSize;
        public final int failedUdpQueries;
        public final int successfulTcpQueries;
        public final int tcpResponseSize;
        public final int averageTcpResponseSize;
        public final int failedTcpQueries;
        private String stringCache;

        private Stats(NetworkDataSourceWithAccounting ndswa) {
            this.successfulQueries = ndswa.successfulQueries.get();
            this.responseSize = ndswa.responseSize.get();
            this.failedQueries = ndswa.failedQueries.get();
            this.successfulUdpQueries = ndswa.successfulUdpQueries.get();
            this.udpResponseSize = ndswa.udpResponseSize.get();
            this.failedUdpQueries = ndswa.failedUdpQueries.get();
            this.successfulTcpQueries = ndswa.successfulTcpQueries.get();
            this.tcpResponseSize = ndswa.tcpResponseSize.get();
            this.failedTcpQueries = ndswa.failedTcpQueries.get();
            this.averageResponseSize = this.successfulQueries > 0 ? this.responseSize / this.successfulQueries : 0;
            this.averageUdpResponseSize = this.successfulUdpQueries > 0 ? this.udpResponseSize / this.successfulUdpQueries : 0;
            this.averageTcpResponseSize = this.successfulTcpQueries > 0 ? this.tcpResponseSize / this.successfulTcpQueries : 0;
        }

        public String toString() {
            if (this.stringCache != null) {
                return this.stringCache;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("Stats\t").append("# Successful").append('\t').append("# Failed").append('\t').append("Resp. Size").append('\t').append("Avg. Resp. Size").append('\n');
            sb.append("Total\t").append(Stats.toString(this.successfulQueries)).append('\t').append(Stats.toString(this.failedQueries)).append('\t').append(Stats.toString(this.responseSize)).append('\t').append(Stats.toString(this.averageResponseSize)).append('\n');
            sb.append("UDP\t").append(Stats.toString(this.successfulUdpQueries)).append('\t').append(Stats.toString(this.failedUdpQueries)).append('\t').append(Stats.toString(this.udpResponseSize)).append('\t').append(Stats.toString(this.averageUdpResponseSize)).append('\n');
            sb.append("TCP\t").append(Stats.toString(this.successfulTcpQueries)).append('\t').append(Stats.toString(this.failedTcpQueries)).append('\t').append(Stats.toString(this.tcpResponseSize)).append('\t').append(Stats.toString(this.averageTcpResponseSize)).append('\n');
            this.stringCache = sb.toString();
            return this.stringCache;
        }

        private static String toString(int i) {
            return String.format(Locale.US, "%,09d", i);
        }
    }
}

