/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.minidns.dnsname.DnsName;
import org.minidns.record.RRWithTarget;
import org.minidns.record.Record;

public class SRV
extends RRWithTarget
implements Comparable<SRV> {
    public final int priority;
    public final int weight;
    public final int port;

    public static SRV parse(DataInputStream dis, byte[] data) throws IOException {
        int priority = dis.readUnsignedShort();
        int weight = dis.readUnsignedShort();
        int port = dis.readUnsignedShort();
        DnsName target = DnsName.parse(dis, data);
        return new SRV(priority, weight, port, target);
    }

    public SRV(int priority, int weight, int port, String target) {
        this(priority, weight, port, DnsName.from(target));
    }

    public SRV(int priority, int weight, int port, DnsName target) {
        super(target);
        this.priority = priority;
        this.weight = weight;
        this.port = port;
    }

    public boolean isServiceAvailable() {
        return !this.target.isRootLabel();
    }

    @Override
    public void serialize(DataOutputStream dos) throws IOException {
        dos.writeShort(this.priority);
        dos.writeShort(this.weight);
        dos.writeShort(this.port);
        super.serialize(dos);
    }

    @Override
    public String toString() {
        return this.priority + " " + this.weight + " " + this.port + " " + String.valueOf(this.target) + ".";
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.SRV;
    }

    @Override
    public int compareTo(SRV other) {
        int res = other.priority - this.priority;
        if (res == 0) {
            res = this.weight - other.weight;
        }
        return res;
    }
}

