/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub.form;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smackx.pubsub.PresenceState;
import org.jivesoftware.smackx.pubsub.SubscribeOptionFields;
import org.jivesoftware.smackx.xdata.form.FormReader;

public interface SubscribeFormReader
extends FormReader {
    public static final String FORM_TYPE = "http://jabber.org/protocol/pubsub#subscribe_options";

    default public boolean isDeliverOn() {
        return this.readBoolean(SubscribeOptionFields.deliver.getFieldName());
    }

    default public Boolean isDigestOn() {
        return this.readBoolean(SubscribeOptionFields.digest.getFieldName());
    }

    default public Integer getDigestFrequency() {
        return this.readInteger(SubscribeOptionFields.digest_frequency.getFieldName());
    }

    default public Date getExpiry() throws ParseException {
        return this.readDate(SubscribeOptionFields.expire.getFieldName());
    }

    default public Boolean isIncludeBody() {
        return this.readBoolean(SubscribeOptionFields.include_body.getFieldName());
    }

    default public List<PresenceState> getShowValues() {
        List<String> values = this.readStringValues(SubscribeOptionFields.show_values.getFieldName());
        ArrayList<PresenceState> result = new ArrayList<PresenceState>(values.size());
        for (String state : values) {
            result.add(PresenceState.valueOf(state));
        }
        return result;
    }
}

