/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.EmptyResultIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.disco.packet.DiscoverInfoBuilder;
import org.jivesoftware.smackx.disco.packet.DiscoverItems;
import org.jivesoftware.smackx.pubsub.Affiliation;
import org.jivesoftware.smackx.pubsub.AffiliationsExtension;
import org.jivesoftware.smackx.pubsub.CollectionNode;
import org.jivesoftware.smackx.pubsub.FormNode;
import org.jivesoftware.smackx.pubsub.FormNodeType;
import org.jivesoftware.smackx.pubsub.Item;
import org.jivesoftware.smackx.pubsub.LeafNode;
import org.jivesoftware.smackx.pubsub.Node;
import org.jivesoftware.smackx.pubsub.NodeExtension;
import org.jivesoftware.smackx.pubsub.NodeType;
import org.jivesoftware.smackx.pubsub.PubSubElementType;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubFeature;
import org.jivesoftware.smackx.pubsub.Subscription;
import org.jivesoftware.smackx.pubsub.SubscriptionsExtension;
import org.jivesoftware.smackx.pubsub.form.ConfigureForm;
import org.jivesoftware.smackx.pubsub.form.FillableConfigureForm;
import org.jivesoftware.smackx.pubsub.packet.PubSub;
import org.jivesoftware.smackx.pubsub.packet.PubSubNamespace;
import org.jivesoftware.smackx.pubsub.util.NodeUtils;
import org.jivesoftware.smackx.xdata.packet.DataForm;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;

public final class PubSubManager
extends Manager {
    public static final String PLUS_NOTIFY = "+notify";
    public static final String AUTO_CREATE_FEATURE = "http://jabber.org/protocol/pubsub#auto-create";
    private static final Logger LOGGER = Logger.getLogger(PubSubManager.class.getName());
    private static final Map<XMPPConnection, Map<BareJid, PubSubManager>> INSTANCES = new WeakHashMap<XMPPConnection, Map<BareJid, PubSubManager>>();
    private final BareJid pubSubService;
    private final Map<String, Node> nodeMap = new ConcurrentHashMap<String, Node>();
    private static final Set<String> PUBLIC_AND_SUBSCRIBE_FEATURES = CollectionUtil.setOf(PubSubFeature.subscribe.toString(), PubSubFeature.publish.toString());

    public static PubSubManager getInstanceFor(XMPPConnection connection) {
        DomainBareJid pubSubService = null;
        if (connection.isAuthenticated()) {
            try {
                pubSubService = PubSubManager.getPubSubService(connection);
            }
            catch (SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
                LOGGER.log(Level.WARNING, "Could not determine PubSub service", e);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.FINE, "Interrupted while trying to determine PubSub service", e);
            }
        }
        if (pubSubService == null) {
            try {
                pubSubService = JidCreate.domainBareFrom("pubsub." + String.valueOf(connection.getXMPPServiceDomain()));
            }
            catch (XmppStringprepException e) {
                throw new RuntimeException(e);
            }
        }
        return PubSubManager.getInstanceFor(connection, pubSubService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PubSubManager getInstanceFor(XMPPConnection connection, BareJid pubSubService) {
        PubSubManager pubSubManager;
        Map<BareJid, PubSubManager> managers;
        if (pubSubService != null && connection.isAuthenticated() && connection.getUser().asBareJid().equals(pubSubService)) {
            pubSubService = null;
        }
        Map<Object, Object> map = INSTANCES;
        synchronized (map) {
            managers = INSTANCES.get(connection);
            if (managers == null) {
                managers = new HashMap<BareJid, PubSubManager>();
                INSTANCES.put(connection, managers);
            }
        }
        map = managers;
        synchronized (map) {
            pubSubManager = managers.get(pubSubService);
            if (pubSubManager == null) {
                pubSubManager = new PubSubManager(connection, pubSubService);
                managers.put(pubSubService, pubSubManager);
            }
        }
        return pubSubManager;
    }

    PubSubManager(XMPPConnection connection, BareJid toAddress) {
        super(connection);
        this.pubSubService = toAddress;
    }

    private void checkIfXmppErrorBecauseOfNotLeafNode(String nodeId, XMPPException.XMPPErrorException xmppErrorException) throws XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        StanzaError.Condition condition = xmppErrorException.getStanzaError().getCondition();
        if (condition == StanzaError.Condition.feature_not_implemented) {
            throw new PubSubException.NotALeafNodeException(nodeId, this.pubSubService);
        }
        throw xmppErrorException;
    }

    public LeafNode createNode() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.CREATE), null);
        QName qname = new QName(PubSubNamespace.basic.getXmlns(), "create");
        NodeExtension elem = (NodeExtension)reply.getExtension(qname);
        LeafNode newNode = new LeafNode(this, elem.getNode());
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public LeafNode createNode(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return (LeafNode)this.createNode(nodeId, null);
    }

    public Node createNode(String nodeId, FillableConfigureForm config) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub request = PubSub.createPubsubPacket(this.pubSubService, IQ.Type.set, new NodeExtension(PubSubElementType.CREATE, nodeId));
        boolean isLeafNode = true;
        if (config != null) {
            DataForm submitForm = config.getDataFormToSubmit();
            request.addExtension(new FormNode(FormNodeType.CONFIGURE, submitForm));
            NodeType nodeType = config.getNodeType();
            isLeafNode = nodeType == null || nodeType == NodeType.leaf;
        }
        this.sendPubsubPacket(request);
        Node newNode = isLeafNode ? new LeafNode(this, nodeId) : new CollectionNode(this, nodeId);
        this.nodeMap.put(newNode.getId(), newNode);
        return newNode;
    }

    public Node getNode(String id) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotAPubSubNodeException {
        StringUtils.requireNotNullNorEmpty(id, "The node ID can not be null or the empty string");
        Node node = this.nodeMap.get(id);
        if (node == null) {
            DiscoverInfo info;
            XMPPConnection connection = this.connection();
            DiscoverInfo infoReply = (DiscoverInfo)connection.sendIqRequestAndWaitForResponse(info = ((DiscoverInfoBuilder)DiscoverInfo.builder(connection).to(this.pubSubService)).setNode(id).build());
            if (infoReply.hasIdentity("pubsub", "leaf")) {
                node = new LeafNode(this, id);
            } else if (infoReply.hasIdentity("pubsub", "collection")) {
                node = new CollectionNode(this, id);
            } else {
                throw new PubSubException.NotAPubSubNodeException(id, infoReply);
            }
            this.nodeMap.put(id, node);
        }
        return node;
    }

    public LeafNode getOrCreateLeafNode(String id) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, PubSubException.NotALeafNodeException {
        try {
            return this.getLeafNode(id);
        }
        catch (PubSubException.NotAPubSubNodeException e) {
            return this.createNode(id);
        }
        catch (XMPPException.XMPPErrorException e1) {
            if (e1.getStanzaError().getCondition() == StanzaError.Condition.item_not_found) {
                try {
                    return this.createNode(id);
                }
                catch (XMPPException.XMPPErrorException e2) {
                    if (e2.getStanzaError().getCondition() == StanzaError.Condition.conflict) {
                        try {
                            return this.getLeafNode(id);
                        }
                        catch (PubSubException.NotAPubSubNodeException e) {
                            throw new IllegalStateException(e);
                        }
                    }
                    throw e2;
                }
            }
            if (e1.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                LOGGER.warning("The PubSub service " + String.valueOf(this.pubSubService) + " threw an DiscoInfoNodeAssertionError, trying workaround for Prosody bug #805 (https://prosody.im/issues/issue/805)");
                return this.getOrCreateLeafNodeProsodyWorkaround(id);
            }
            throw e1;
        }
    }

    public LeafNode getLeafNode(String id) throws PubSubException.NotALeafNodeException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException, PubSubException.NotAPubSubNodeException {
        Node node;
        try {
            node = this.getNode(id);
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() == StanzaError.Condition.service_unavailable) {
                return this.getLeafNodeProsodyWorkaround(id);
            }
            throw e;
        }
        if (node instanceof LeafNode) {
            return (LeafNode)node;
        }
        throw new PubSubException.NotALeafNodeException(id, this.pubSubService);
    }

    private LeafNode getLeafNodeProsodyWorkaround(String id) throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException {
        LeafNode leafNode = new LeafNode(this, id);
        try {
            leafNode.getItems(1);
        }
        catch (XMPPException.XMPPErrorException e) {
            this.checkIfXmppErrorBecauseOfNotLeafNode(id, e);
        }
        this.nodeMap.put(id, leafNode);
        return leafNode;
    }

    private LeafNode getOrCreateLeafNodeProsodyWorkaround(String id) throws XMPPException.XMPPErrorException, SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotALeafNodeException {
        try {
            return this.createNode(id);
        }
        catch (XMPPException.XMPPErrorException e1) {
            if (e1.getStanzaError().getCondition() == StanzaError.Condition.conflict) {
                return this.getLeafNodeProsodyWorkaround(id);
            }
            throw e1;
        }
    }

    public <I extends Item> LeafNode tryToPublishAndPossibleAutoCreate(String id, I item) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, PubSubException.NotALeafNodeException {
        LeafNode leafNode = new LeafNode(this, id);
        try {
            leafNode.publish(item);
        }
        catch (XMPPException.XMPPErrorException e) {
            this.checkIfXmppErrorBecauseOfNotLeafNode(id, e);
        }
        this.nodeMap.put(id, leafNode);
        return leafNode;
    }

    public DiscoverItems discoverNodes(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DiscoverItems items = new DiscoverItems();
        if (nodeId != null) {
            items.setNode(nodeId);
        }
        items.setTo(this.pubSubService);
        DiscoverItems nodeItems = (DiscoverItems)this.connection().sendIqRequestAndWaitForResponse(items);
        return nodeItems;
    }

    public List<Subscription> getSubscriptions() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.SUBSCRIPTIONS), null);
        SubscriptionsExtension subElem = (SubscriptionsExtension)reply.getExtensionElement(PubSubElementType.SUBSCRIPTIONS.getElementName(), PubSubElementType.SUBSCRIPTIONS.getNamespace().getXmlns());
        return subElem.getSubscriptions();
    }

    public List<Affiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.AFFILIATIONS), null);
        AffiliationsExtension listElem = (AffiliationsExtension)reply.getExtension(PubSubElementType.AFFILIATIONS);
        return listElem.getAffiliations();
    }

    public boolean deleteNode(String nodeId) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        boolean res = true;
        try {
            this.sendPubsubPacket(IQ.Type.set, new NodeExtension(PubSubElementType.DELETE, nodeId), PubSubElementType.DELETE.getNamespace());
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() == StanzaError.Condition.item_not_found) {
                res = false;
            }
            throw e;
        }
        this.nodeMap.remove(nodeId);
        return res;
    }

    public ConfigureForm getDefaultConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub reply = this.sendPubsubPacket(IQ.Type.get, new NodeExtension(PubSubElementType.DEFAULT), PubSubElementType.DEFAULT.getNamespace());
        return NodeUtils.getFormFromPacket(reply, PubSubElementType.DEFAULT);
    }

    public BareJid getServiceJid() {
        return this.pubSubService;
    }

    public DiscoverInfo getSupportedFeatures() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager mgr = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return mgr.discoverInfo(this.pubSubService);
    }

    public boolean supportsAutomaticNodeCreation() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        ServiceDiscoveryManager sdm = ServiceDiscoveryManager.getInstanceFor(this.connection());
        return sdm.supportsFeature(this.pubSubService, AUTO_CREATE_FEATURE);
    }

    public boolean canCreateNodesAndPublishItems() throws SmackException.NoResponseException, SmackException.NotConnectedException, InterruptedException, XMPPException.XMPPErrorException {
        LeafNode leafNode = null;
        try {
            leafNode = this.createNode();
        }
        catch (XMPPException.XMPPErrorException e) {
            if (e.getStanzaError().getCondition() == StanzaError.Condition.forbidden) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (leafNode != null) {
                this.deleteNode(leafNode.getId());
            }
        }
        return true;
    }

    private PubSub sendPubsubPacket(IQ.Type type, XmlElement ext, PubSubNamespace ns) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.sendPubsubPacket(this.pubSubService, type, Collections.singletonList(ext), ns);
    }

    XMPPConnection getConnection() {
        return this.connection();
    }

    PubSub sendPubsubPacket(Jid to, IQ.Type type, List<XmlElement> extList, PubSubNamespace ns) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        PubSub pubSub = new PubSub(to, type, ns);
        for (XmlElement pe : extList) {
            pubSub.addExtension(pe);
        }
        return this.sendPubsubPacket(pubSub);
    }

    PubSub sendPubsubPacket(PubSub packet) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        Object resultIQ = this.connection().sendIqRequestAndWaitForResponse(packet);
        if (resultIQ instanceof EmptyResultIQ) {
            return null;
        }
        return (PubSub)resultIQ;
    }

    public static DomainBareJid getPubSubService(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor(connection).findService(PUBLIC_AND_SUBSCRIBE_FEATURES, true, "pubsub", "service");
    }
}

