/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.util.regex.Pattern;

public class OpenPgpSecretKeyBackupPassphrase
implements CharSequence {
    private static final Pattern PASSPHRASE_PATTERN = Pattern.compile("^([123456789ABCDEFGHIJKLMNPQRSTUVWXYZ]{4}-){5}[123456789ABCDEFGHIJKLMNPQRSTUVWXYZ]{4}$");
    private final String passphrase;

    public OpenPgpSecretKeyBackupPassphrase(String passphrase) {
        if (!PASSPHRASE_PATTERN.matcher(passphrase).matches()) {
            throw new IllegalArgumentException("Passphrase must be 24 upper case letters and numbers from the english alphabet without 'O' and '0', divided into blocks of 4 and separated with dashes ('-').");
        }
        this.passphrase = passphrase;
    }

    @Override
    public int length() {
        return this.passphrase.length();
    }

    @Override
    public char charAt(int i) {
        return this.passphrase.charAt(i);
    }

    @Override
    public CharSequence subSequence(int i, int i1) {
        return this.passphrase.subSequence(i, i1);
    }

    @Override
    public String toString() {
        return this.passphrase;
    }
}

