/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.Async;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.ox.OpenPgpContact;
import org.jivesoftware.smackx.ox.OpenPgpMessage;
import org.jivesoftware.smackx.ox.OpenPgpSecretKeyBackupPassphrase;
import org.jivesoftware.smackx.ox.OpenPgpSelf;
import org.jivesoftware.smackx.ox.callback.backup.AskForBackupCodeCallback;
import org.jivesoftware.smackx.ox.callback.backup.SecretKeyBackupSelectionCallback;
import org.jivesoftware.smackx.ox.crypto.OpenPgpProvider;
import org.jivesoftware.smackx.ox.element.CryptElement;
import org.jivesoftware.smackx.ox.element.OpenPgpContentElement;
import org.jivesoftware.smackx.ox.element.OpenPgpElement;
import org.jivesoftware.smackx.ox.element.PubkeyElement;
import org.jivesoftware.smackx.ox.element.PublicKeysListElement;
import org.jivesoftware.smackx.ox.element.SecretkeyElement;
import org.jivesoftware.smackx.ox.element.SignElement;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.exception.InvalidBackupCodeException;
import org.jivesoftware.smackx.ox.exception.MissingOpenPgpKeyException;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.exception.NoBackupFoundException;
import org.jivesoftware.smackx.ox.listener.CryptElementReceivedListener;
import org.jivesoftware.smackx.ox.listener.SignElementReceivedListener;
import org.jivesoftware.smackx.ox.listener.SigncryptElementReceivedListener;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpStore;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpTrustStore;
import org.jivesoftware.smackx.ox.util.OpenPgpPubSubUtil;
import org.jivesoftware.smackx.ox.util.SecretKeyBackupHelper;
import org.jivesoftware.smackx.pep.PepEventListener;
import org.jivesoftware.smackx.pep.PepManager;
import org.jivesoftware.smackx.pubsub.PubSubException;
import org.jivesoftware.smackx.pubsub.PubSubFeature;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.EntityBareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.util.KeyRingUtils;

public final class OpenPgpManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(OpenPgpManager.class.getName());
    private static final Map<XMPPConnection, OpenPgpManager> INSTANCES = new WeakHashMap<XMPPConnection, OpenPgpManager>();
    private OpenPgpProvider provider;
    private final PepManager pepManager;
    private final Set<SigncryptElementReceivedListener> signcryptElementReceivedListeners = new HashSet<SigncryptElementReceivedListener>();
    private final Set<SignElementReceivedListener> signElementReceivedListeners = new HashSet<SignElementReceivedListener>();
    private final Set<CryptElementReceivedListener> cryptElementReceivedListeners = new HashSet<CryptElementReceivedListener>();
    private final PepEventListener<PublicKeysListElement> pepPublicKeyListElementListener = (from, listElement, id, message) -> this.processPublicKeysListElement(from, (PublicKeysListElement)listElement);

    private OpenPgpManager(XMPPConnection connection) {
        super(connection);
        ChatManager.getInstanceFor(connection).addIncomingListener(this::incomingChatMessageListener);
        this.pepManager = PepManager.getInstanceFor(connection);
    }

    public static synchronized OpenPgpManager getInstanceFor(XMPPConnection connection) {
        OpenPgpManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new OpenPgpManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public BareJid getJidOrThrow() throws SmackException.NotLoggedInException {
        this.throwIfNotAuthenticated();
        return this.connection().getUser().asEntityBareJidOrThrow();
    }

    public void setOpenPgpProvider(OpenPgpProvider provider) {
        this.provider = provider;
    }

    public OpenPgpProvider getOpenPgpProvider() {
        return this.provider;
    }

    public OpenPgpSelf getOpenPgpSelf() throws SmackException.NotLoggedInException {
        this.throwIfNoProviderSet();
        return new OpenPgpSelf(this.getJidOrThrow(), this.provider.getStore());
    }

    public void announceSupportAndPublish() throws NoSuchAlgorithmException, NoSuchProviderException, InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, IOException, InvalidAlgorithmParameterException, SmackException.NotLoggedInException, PGPException {
        PubkeyElement pubkeyElement;
        this.throwIfNoProviderSet();
        this.throwIfNotAuthenticated();
        OpenPgpV4Fingerprint primaryFingerprint = this.getOurFingerprint();
        if (primaryFingerprint == null) {
            primaryFingerprint = this.generateAndImportKeyPair(this.getJidOrThrow());
        }
        try {
            pubkeyElement = this.createPubkeyElement(this.getJidOrThrow(), primaryFingerprint, new Date());
        }
        catch (MissingOpenPgpKeyException e) {
            throw new AssertionError((Object)"Cannot publish our public key, since it is missing (MUST NOT happen!)");
        }
        OpenPgpPubSubUtil.publishPublicKey(this.pepManager, pubkeyElement, primaryFingerprint);
        this.pepManager.addPepEventListener("urn:xmpp:openpgp:0:public-keys", PublicKeysListElement.class, this.pepPublicKeyListElementListener);
        ServiceDiscoveryManager.getInstanceFor(this.connection()).addFeature("urn:xmpp:openpgp:0:public-keys+notify");
    }

    public OpenPgpV4Fingerprint generateAndImportKeyPair(BareJid ourJid) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, NoSuchProviderException, PGPException, IOException {
        this.throwIfNoProviderSet();
        OpenPgpStore store = this.provider.getStore();
        PGPSecretKeyRing keys = this.generateKeyRing(ourJid);
        this.importKeyRing(ourJid, keys);
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(keys);
        store.setTrust(ourJid, fingerprint, OpenPgpTrustStore.Trust.trusted);
        return fingerprint;
    }

    public PGPSecretKeyRing generateKeyRing(BareJid ourJid) throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        this.throwIfNoProviderSet();
        PGPSecretKeyRing keys = this.provider.getStore().generateKeyRing(ourJid);
        return keys;
    }

    private void importKeyRing(BareJid ourJid, PGPSecretKeyRing secretKeys) throws IOException, PGPException {
        try {
            this.provider.getStore().importSecretKey(ourJid, secretKeys);
            this.provider.getStore().importPublicKey(ourJid, KeyRingUtils.publicKeyRingFrom(secretKeys));
        }
        catch (MissingUserIdOnKeyException e) {
            throw new AssertionError((Object)e);
        }
    }

    public OpenPgpV4Fingerprint getOurFingerprint() throws SmackException.NotLoggedInException, IOException, PGPException {
        return this.getOpenPgpSelf().getSigningKeyFingerprint();
    }

    public OpenPgpContact getOpenPgpContact(EntityBareJid jid) {
        this.throwIfNoProviderSet();
        return this.provider.getStore().getOpenPgpContact(jid);
    }

    public boolean hasSecretKeysAvailable() throws SmackException.NotLoggedInException, PGPException, IOException {
        this.throwIfNoProviderSet();
        return this.getOpenPgpSelf().hasSecretKeyAvailable();
    }

    public static boolean serverSupportsSecretKeyBackups(XMPPConnection connection) throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException {
        return ServiceDiscoveryManager.getInstanceFor(connection).serverSupportsFeature(PubSubFeature.access_whitelist.toString());
    }

    public void stopMetadataListener() {
        this.pepManager.removePepEventListener(this.pepPublicKeyListElementListener);
    }

    public OpenPgpSecretKeyBackupPassphrase backupSecretKeyToServer(SecretKeyBackupSelectionCallback selectKeyCallback) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, SmackException.NotLoggedInException, IOException, SmackException.FeatureNotSupportedException, PGPException, MissingOpenPgpKeyException {
        OpenPgpSecretKeyBackupPassphrase passphrase = SecretKeyBackupHelper.generateBackupPassword();
        this.backupSecretKeyToServer(selectKeyCallback, passphrase);
        return passphrase;
    }

    public void backupSecretKeyToServer(SecretKeyBackupSelectionCallback selectKeyCallback, OpenPgpSecretKeyBackupPassphrase passphrase) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, SmackException.NotLoggedInException, IOException, SmackException.FeatureNotSupportedException, PGPException, MissingOpenPgpKeyException {
        this.throwIfNoProviderSet();
        this.throwIfNotAuthenticated();
        BareJid ownJid = this.connection().getUser().asBareJid();
        PGPSecretKeyRingCollection secretKeyRings = this.provider.getStore().getSecretKeysOf(ownJid);
        HashSet<OpenPgpV4Fingerprint> availableKeyPairs = new HashSet<OpenPgpV4Fingerprint>();
        for (PGPSecretKeyRing ring : secretKeyRings) {
            availableKeyPairs.add(new OpenPgpV4Fingerprint(ring));
        }
        Set<OpenPgpV4Fingerprint> selectedKeyPairs = selectKeyCallback.selectKeysToBackup(availableKeyPairs);
        SecretkeyElement secretKey = SecretKeyBackupHelper.createSecretkeyElement(this.provider, ownJid, selectedKeyPairs, passphrase);
        OpenPgpPubSubUtil.depositSecretKey(this.connection(), secretKey);
    }

    public void deleteSecretKeyServerBackup() throws XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, SmackException.NotLoggedInException {
        this.throwIfNotAuthenticated();
        OpenPgpPubSubUtil.deleteSecretKeyNode(this.pepManager);
    }

    public OpenPgpV4Fingerprint restoreSecretKeyServerBackup(AskForBackupCodeCallback codeCallback) throws InterruptedException, PubSubException.NotALeafNodeException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, SmackException.NoResponseException, InvalidBackupCodeException, SmackException.NotLoggedInException, IOException, MissingUserIdOnKeyException, NoBackupFoundException, PGPException {
        this.throwIfNoProviderSet();
        this.throwIfNotAuthenticated();
        SecretkeyElement backup = OpenPgpPubSubUtil.fetchSecretKey(this.pepManager);
        if (backup == null) {
            throw new NoBackupFoundException();
        }
        OpenPgpSecretKeyBackupPassphrase backupCode = codeCallback.askForBackupCode();
        PGPSecretKeyRing secretKeys = SecretKeyBackupHelper.restoreSecretKeyBackup(backup, backupCode);
        OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(secretKeys);
        this.provider.getStore().importSecretKey(this.getJidOrThrow(), secretKeys);
        this.provider.getStore().importPublicKey(this.getJidOrThrow(), KeyRingUtils.publicKeyRingFrom(secretKeys));
        this.getOpenPgpSelf().trust(fingerprint);
        return new OpenPgpV4Fingerprint(secretKeys);
    }

    private void processPublicKeysListElement(BareJid contact, PublicKeysListElement listElement) {
        OpenPgpContact openPgpContact = this.getOpenPgpContact(contact.asEntityBareJidIfPossible());
        try {
            openPgpContact.updateKeys(this.connection(), listElement);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not update contacts keys", e);
        }
    }

    public OpenPgpMessage decryptOpenPgpElement(OpenPgpElement element, OpenPgpContact sender) throws SmackException.NotLoggedInException, IOException, PGPException {
        return this.provider.decryptAndOrVerify(this.getAuthenticatedConnectionOrThrow(), element, this.getOpenPgpSelf(), sender);
    }

    private void incomingChatMessageListener(final EntityBareJid from, final Message message, Chat chat) {
        Async.go(new Runnable(){

            @Override
            public void run() {
                OpenPgpElement element = message.getExtension(OpenPgpElement.class);
                if (element == null) {
                    return;
                }
                OpenPgpContact contact = OpenPgpManager.this.getOpenPgpContact(from);
                OpenPgpMessage decrypted = null;
                OpenPgpContentElement contentElement = null;
                try {
                    decrypted = OpenPgpManager.this.decryptOpenPgpElement(element, contact);
                    contentElement = decrypted.getOpenPgpContentElement();
                }
                catch (PGPException e) {
                    LOGGER.log(Level.WARNING, "Could not decrypt incoming OpenPGP encrypted message", e);
                }
                catch (IOException | XmlPullParserException e) {
                    LOGGER.log(Level.WARNING, "Invalid XML content of incoming OpenPGP encrypted message", e);
                }
                catch (SmackException.NotLoggedInException e) {
                    LOGGER.log(Level.WARNING, "Cannot determine our JID, since we are not logged in.", e);
                }
                if (contentElement instanceof SigncryptElement) {
                    for (SigncryptElementReceivedListener l : OpenPgpManager.this.signcryptElementReceivedListeners) {
                        l.signcryptElementReceived(contact, message, (SigncryptElement)contentElement, decrypted.getMetadata());
                    }
                    return;
                }
                if (contentElement instanceof SignElement) {
                    for (SignElementReceivedListener l : OpenPgpManager.this.signElementReceivedListeners) {
                        l.signElementReceived(contact, message, (SignElement)contentElement, decrypted.getMetadata());
                    }
                    return;
                }
                if (contentElement instanceof CryptElement) {
                    for (CryptElementReceivedListener l : OpenPgpManager.this.cryptElementReceivedListeners) {
                        l.cryptElementReceived(contact, message, (CryptElement)contentElement, decrypted.getMetadata());
                    }
                    return;
                }
                throw new AssertionError((Object)("Invalid element received: " + contentElement.getClass().getName()));
            }
        });
    }

    private PubkeyElement createPubkeyElement(BareJid owner2, OpenPgpV4Fingerprint fingerprint, Date date) throws MissingOpenPgpKeyException, IOException, PGPException {
        PGPPublicKeyRing ring = this.provider.getStore().getPublicKeyRing(owner2, fingerprint);
        if (ring != null) {
            byte[] keyBytes = ring.getEncoded(true);
            return OpenPgpManager.createPubkeyElement(keyBytes, date);
        }
        throw new MissingOpenPgpKeyException(owner2, fingerprint);
    }

    private static PubkeyElement createPubkeyElement(byte[] bytes, Date date) {
        String base64EncodedOpenPgpPubKey = Base64.encodeToString(bytes);
        return new PubkeyElement(new PubkeyElement.PubkeyDataElement(base64EncodedOpenPgpPubKey), date);
    }

    public void registerSigncryptReceivedListener(SigncryptElementReceivedListener listener) {
        this.signcryptElementReceivedListeners.add(listener);
    }

    void unregisterSigncryptElementReceivedListener(SigncryptElementReceivedListener listener) {
        this.signcryptElementReceivedListeners.remove(listener);
    }

    void registerSignElementReceivedListener(SignElementReceivedListener listener) {
        this.signElementReceivedListeners.add(listener);
    }

    void unregisterSignElementReceivedListener(SignElementReceivedListener listener) {
        this.signElementReceivedListeners.remove(listener);
    }

    void registerCryptElementReceivedListener(CryptElementReceivedListener listener) {
        this.cryptElementReceivedListeners.add(listener);
    }

    void unregisterCryptElementReceivedListener(CryptElementReceivedListener listener) {
        this.cryptElementReceivedListeners.remove(listener);
    }

    private void throwIfNoProviderSet() {
        if (this.provider == null) {
            throw new IllegalStateException("No OpenPgpProvider set!");
        }
    }

    private void throwIfNotAuthenticated() throws SmackException.NotLoggedInException {
        if (!this.connection().isAuthenticated()) {
            throw new SmackException.NotLoggedInException();
        }
    }
}

