/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muclight;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat.Chat;
import org.jivesoftware.smack.chat.ChatManager;
import org.jivesoftware.smack.chat.ChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.muclight.MUCLightAffiliation;
import org.jivesoftware.smackx.muclight.MUCLightRoomConfiguration;
import org.jivesoftware.smackx.muclight.MUCLightRoomInfo;
import org.jivesoftware.smackx.muclight.element.MUCLightAffiliationsIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightChangeAffiliationsIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightConfigurationIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightCreateIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightDestroyIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightGetAffiliationsIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightGetConfigsIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightGetInfoIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightInfoIQ;
import org.jivesoftware.smackx.muclight.element.MUCLightSetConfigsIQ;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.Jid;

public class MultiUserChatLight {
    public static final String NAMESPACE = "urn:xmpp:muclight:0";
    public static final String AFFILIATIONS = "#affiliations";
    public static final String INFO = "#info";
    public static final String CONFIGURATION = "#configuration";
    public static final String CREATE = "#create";
    public static final String DESTROY = "#destroy";
    public static final String BLOCKING = "#blocking";
    private final XMPPConnection connection;
    private final EntityJid room;
    private final Set<MessageListener> messageListeners = new CopyOnWriteArraySet<MessageListener>();
    private final StanzaFilter fromRoomFilter;
    private final StanzaFilter fromRoomGroupChatFilter;
    private final StanzaListener messageListener;
    private StanzaCollector messageCollector;

    MultiUserChatLight(XMPPConnection connection, EntityJid room) {
        this.connection = connection;
        this.room = room;
        this.fromRoomFilter = FromMatchesFilter.create(room);
        this.fromRoomGroupChatFilter = new AndFilter(this.fromRoomFilter, MessageTypeFilter.GROUPCHAT);
        this.messageListener = new StanzaListener(){

            @Override
            public void processStanza(Stanza packet) throws SmackException.NotConnectedException {
                Message message = (Message)packet;
                for (MessageListener listener : MultiUserChatLight.this.messageListeners) {
                    listener.processMessage(message);
                }
            }
        };
        connection.addSyncStanzaListener(this.messageListener, this.fromRoomGroupChatFilter);
    }

    public EntityJid getRoom() {
        return this.room;
    }

    public void sendMessage(String text) throws SmackException.NotConnectedException, InterruptedException {
        MessageBuilder message = this.buildMessage();
        message.setBody(text);
        this.connection.sendStanza(message.build());
    }

    @Deprecated
    public Chat createPrivateChat(EntityJid occupant, ChatMessageListener listener) {
        return ChatManager.getInstanceFor(this.connection).createChat(occupant, listener);
    }

    @Deprecated
    public Message createMessage() {
        return ((MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().ofType(Message.Type.groupchat).to(this.room)).build();
    }

    public MessageBuilder buildMessage() {
        return (MessageBuilder)this.connection.getStanzaFactory().buildMessageStanza().ofType(Message.Type.groupchat).to(this.room);
    }

    public void sendMessage(MessageBuilder messageBuilder) throws SmackException.NotConnectedException, InterruptedException {
        Message message = ((MessageBuilder)messageBuilder.to(this.room)).ofType(Message.Type.groupchat).build();
        this.connection.sendStanza(message);
    }

    public Message pollMessage() {
        return (Message)this.messageCollector.pollResult();
    }

    public Message nextMessage() throws InterruptedException {
        return (Message)this.messageCollector.nextResultBlockForever();
    }

    public Message nextMessage(long timeout) throws InterruptedException {
        return (Message)this.messageCollector.nextResult(timeout);
    }

    public boolean addMessageListener(MessageListener listener) {
        return this.messageListeners.add(listener);
    }

    public boolean removeMessageListener(MessageListener listener) {
        return this.messageListeners.remove(listener);
    }

    private void removeConnectionCallbacks() {
        this.connection.removeSyncStanzaListener(this.messageListener);
        if (this.messageCollector != null) {
            this.messageCollector.cancel();
            this.messageCollector = null;
        }
    }

    public String toString() {
        return "MUC Light: " + String.valueOf(this.room) + "(" + String.valueOf(this.connection.getUser()) + ")";
    }

    public void create(String roomName, String subject, Map<String, String> customConfigs, List<Jid> occupants) throws Exception {
        MUCLightCreateIQ createMUCLightIQ = new MUCLightCreateIQ(this.room, roomName, occupants);
        this.messageCollector = this.connection.createStanzaCollector(this.fromRoomGroupChatFilter);
        try {
            this.connection.sendIqRequestAndWaitForResponse(createMUCLightIQ);
        }
        catch (InterruptedException | SmackException.NoResponseException | SmackException.NotConnectedException | XMPPException.XMPPErrorException e) {
            this.removeConnectionCallbacks();
            throw e;
        }
    }

    public void create(String roomName, List<Jid> occupants) throws Exception {
        this.create(roomName, null, null, occupants);
    }

    public void leave() throws SmackException.NotConnectedException, InterruptedException, SmackException.NoResponseException, XMPPException.XMPPErrorException {
        HashMap<Jid, MUCLightAffiliation> affiliations = new HashMap<Jid, MUCLightAffiliation>();
        affiliations.put(this.connection.getUser(), MUCLightAffiliation.none);
        MUCLightChangeAffiliationsIQ changeAffiliationsIQ = new MUCLightChangeAffiliationsIQ(this.room, affiliations);
        Object responseIq = this.connection.sendIqRequestAndWaitForResponse(changeAffiliationsIQ);
        boolean roomLeft = ((IQ)responseIq).getType().equals((Object)IQ.Type.result);
        if (roomLeft) {
            this.removeConnectionCallbacks();
        }
    }

    public MUCLightRoomInfo getFullInfo(String version) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightGetInfoIQ mucLightGetInfoIQ = new MUCLightGetInfoIQ(this.room, version);
        Object responseIq = this.connection.sendIqRequestAndWaitForResponse(mucLightGetInfoIQ);
        MUCLightInfoIQ mucLightInfoResponseIQ = (MUCLightInfoIQ)responseIq;
        return new MUCLightRoomInfo(mucLightInfoResponseIQ.getVersion(), this.room, mucLightInfoResponseIQ.getConfiguration(), mucLightInfoResponseIQ.getOccupants());
    }

    public MUCLightRoomInfo getFullInfo() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getFullInfo(null);
    }

    public MUCLightRoomConfiguration getConfiguration(String version) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightGetConfigsIQ mucLightGetConfigsIQ = new MUCLightGetConfigsIQ(this.room, version);
        Object responseIq = this.connection.sendIqRequestAndWaitForResponse(mucLightGetConfigsIQ);
        MUCLightConfigurationIQ mucLightConfigurationIQ = (MUCLightConfigurationIQ)responseIq;
        return mucLightConfigurationIQ.getConfiguration();
    }

    public MUCLightRoomConfiguration getConfiguration() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getConfiguration(null);
    }

    public Map<Jid, MUCLightAffiliation> getAffiliations(String version) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightGetAffiliationsIQ mucLightGetAffiliationsIQ = new MUCLightGetAffiliationsIQ(this.room, version);
        Object responseIq = this.connection.sendIqRequestAndWaitForResponse(mucLightGetAffiliationsIQ);
        MUCLightAffiliationsIQ mucLightAffiliationsIQ = (MUCLightAffiliationsIQ)responseIq;
        return mucLightAffiliationsIQ.getAffiliations();
    }

    public Map<Jid, MUCLightAffiliation> getAffiliations() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.getAffiliations(null);
    }

    public void changeAffiliations(Map<Jid, MUCLightAffiliation> affiliations) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightChangeAffiliationsIQ changeAffiliationsIQ = new MUCLightChangeAffiliationsIQ(this.room, affiliations);
        this.connection.sendIqRequestAndWaitForResponse(changeAffiliationsIQ);
    }

    public void destroy() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightDestroyIQ mucLightDestroyIQ = new MUCLightDestroyIQ(this.room);
        Object responseIq = this.connection.sendIqRequestAndWaitForResponse(mucLightDestroyIQ);
        boolean roomDestroyed = ((IQ)responseIq).getType().equals((Object)IQ.Type.result);
        if (roomDestroyed) {
            this.removeConnectionCallbacks();
        }
    }

    public void changeSubject(String subject) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightSetConfigsIQ mucLightSetConfigIQ = new MUCLightSetConfigsIQ(this.room, null, subject, null);
        this.connection.sendIqRequestAndWaitForResponse(mucLightSetConfigIQ);
    }

    public void changeRoomName(String roomName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightSetConfigsIQ mucLightSetConfigIQ = new MUCLightSetConfigsIQ(this.room, roomName, null);
        this.connection.sendIqRequestAndWaitForResponse(mucLightSetConfigIQ);
    }

    public void setRoomConfigs(Map<String, String> customConfigs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        this.setRoomConfigs(null, customConfigs);
    }

    public void setRoomConfigs(String roomName, Map<String, String> customConfigs) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        MUCLightSetConfigsIQ mucLightSetConfigIQ = new MUCLightSetConfigsIQ(this.room, roomName, customConfigs);
        this.connection.sendIqRequestAndWaitForResponse(mucLightSetConfigIQ);
    }
}

