/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.file_metadata.element;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.hashes.HashManager;
import org.jivesoftware.smackx.hashes.element.HashElement;
import org.jivesoftware.smackx.thumbnails.element.ThumbnailElement;

public final class FileMetadataElement
implements ExtensionElement {
    public static final String ELEMENT = "file";
    public static final String NAMESPACE = "urn:xmpp:file:metadata:0";
    public static final String ELEM_DATE = "date";
    public static final String ELEM_HEIGHT = "height";
    public static final String ELEM_WIDTH = "width";
    public static final String ELEM_DESC = "desc";
    public static final String ELEM_LENGTH = "length";
    public static final String ELEM_MEDIA_TYPE = "media-type";
    public static final String ELEM_NAME = "name";
    public static final String ELEM_SIZE = "size";
    private final Date date;
    private final Integer height;
    private final Integer width;
    private final Map<String, String> descriptions;
    private final Map<HashManager.ALGORITHM, HashElement> hashElements;
    private final Long length;
    private final String mediaType;
    private final String name;
    private final Long size;
    private final List<ThumbnailElement> thumbnails;

    private FileMetadataElement(Date date, Integer height, Integer width, Map<String, String> descriptions, Map<HashManager.ALGORITHM, HashElement> hashElements, Long length, String mediaType, String name, Long size2, List<ThumbnailElement> thumbnails) {
        this.date = date;
        this.height = height;
        this.width = width;
        this.descriptions = CollectionUtil.cloneAndSeal(descriptions);
        this.hashElements = CollectionUtil.cloneAndSeal(hashElements);
        this.length = length;
        this.mediaType = mediaType;
        this.name = name;
        this.size = size2;
        this.thumbnails = CollectionUtil.cloneAndSeal(thumbnails);
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        XmlStringBuilder sb = new XmlStringBuilder(this).rightAngleBracket().optElement(ELEM_DATE, this.date).optElement(ELEM_HEIGHT, this.height).optElement(ELEM_WIDTH, this.width);
        for (String key : this.descriptions.keySet()) {
            sb.halfOpenElement(ELEM_DESC).optXmlLangAttribute(key).rightAngleBracket().append(this.descriptions.get(key)).closeElement(ELEM_DESC);
        }
        sb.append(this.hashElements.values()).optElement(ELEM_LENGTH, this.length != null ? Long.toString(this.length) : null).optElement(ELEM_MEDIA_TYPE, this.mediaType).optElement(ELEM_NAME, this.name).optElement(ELEM_SIZE, this.size != null ? Long.toString(this.size) : null).append(this.thumbnails);
        return sb.closeElement(this);
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    public Date getDate() {
        return this.date;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Map<String, String> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    public String getDescription() {
        return this.getDescription(this.getLanguage());
    }

    public String getDescription(String lang) {
        return this.descriptions.get(lang != null ? lang : "");
    }

    public Map<HashManager.ALGORITHM, HashElement> getHashElements() {
        return Collections.unmodifiableMap(this.hashElements);
    }

    public HashElement getHashElement(HashManager.ALGORITHM algorithm) {
        return this.hashElements.get((Object)algorithm);
    }

    public Long getLength() {
        return this.length;
    }

    public String getMediaType() {
        return this.mediaType;
    }

    public String getName() {
        if (this.name == null) {
            return null;
        }
        try {
            return URLEncoder.encode(this.name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String getRawName() {
        return this.name;
    }

    public Long getSize() {
        return this.size;
    }

    public List<ThumbnailElement> getThumbnails() {
        return Collections.unmodifiableList(this.thumbnails);
    }

    public int hashCode() {
        return HashCode.builder().append(this.getElementName()).append(this.getNamespace()).append(this.getDate()).append(this.getDescriptions()).append(this.getHeight()).append(this.getWidth()).append(this.getHashElements()).append(this.getLength()).append(this.getMediaType()).append(this.getRawName()).append(this.getSize()).append(this.getThumbnails()).build();
    }

    public boolean equals(Object other) {
        return EqualsUtil.equals(this, other, (equalsBuilder, o) -> equalsBuilder.append(this.getElementName(), o.getElementName()).append(this.getNamespace(), o.getNamespace()).append(this.getDate(), o.getDate()).append(this.getDescriptions(), o.getDescriptions()).append(this.getHeight(), o.getHeight()).append(this.getWidth(), o.getWidth()).append(this.getHashElements(), o.getHashElements()).append(this.getLength(), o.getLength()).append(this.getMediaType(), o.getMediaType()).append(this.getRawName(), o.getRawName()).append(this.getSize(), o.getSize()).append(this.getThumbnails(), o.getThumbnails()));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Date date;
        private Integer height;
        private Integer width;
        private Map<String, String> descriptions = new HashMap<String, String>();
        private Map<HashManager.ALGORITHM, HashElement> hashElements = new HashMap<HashManager.ALGORITHM, HashElement>();
        private Long length;
        private String mediaType;
        private String name;
        private Long size;
        private List<ThumbnailElement> thumbnails = new ArrayList<ThumbnailElement>();

        public Builder setModificationDate(Date date) {
            this.date = date;
            return this;
        }

        public Builder setDimensions(int width, int height) {
            return this.setHeight(height).setWidth(width);
        }

        public Builder setHeight(int height) {
            if (height <= 0) {
                throw new IllegalArgumentException("Height must be a positive number");
            }
            this.height = height;
            return this;
        }

        public Builder setWidth(int width) {
            if (width <= 0) {
                throw new IllegalArgumentException("Width must be a positive number");
            }
            this.width = width;
            return this;
        }

        public Builder addDescription(String description) {
            return this.addDescription(description, null);
        }

        public Builder addDescription(String description, String language2) {
            this.descriptions.put(language2 != null ? language2 : "", StringUtils.requireNotNullNorEmpty(description, "Description MUST NOT be null nor empty"));
            return this;
        }

        public Builder addHash(HashElement hashElement) {
            this.hashElements.put(hashElement.getAlgorithm(), hashElement);
            return this;
        }

        public Builder setLength(long length) {
            if (length < 0L) {
                throw new IllegalArgumentException("Length cannot be negative.");
            }
            this.length = length;
            return this;
        }

        public Builder setMediaType(String mediaType) {
            this.mediaType = StringUtils.requireNotNullNorEmpty(mediaType, "Media-Type MUST NOT be null nor empty");
            return this;
        }

        public Builder setName(String name) {
            this.name = StringUtils.requireNotNullNorEmpty(name, "Name MUST NOT be null nor empty");
            return this;
        }

        public Builder setSize(long size2) {
            if (size2 < 0L) {
                throw new IllegalArgumentException("Size MUST NOT be negative.");
            }
            this.size = size2;
            return this;
        }

        public Builder addThumbnail(ThumbnailElement thumbnail) {
            this.thumbnails.add(thumbnail);
            return this;
        }

        public FileMetadataElement build() {
            return new FileMetadataElement(this.date, this.height, this.width, this.descriptions, this.hashElements, this.length, this.mediaType, this.name, this.size, this.thumbnails);
        }
    }
}

