
;--- v2.17: using "option stackbase" and "assume ss" to
;--- define PROCs with different offset magnitudes for CS and SS.
;--- both PROC and INVOKE are aware of that.
;--- However, when using a 16-bit stack in 32-bit it's not really
;--- a good idea to use BP as base pointer. So if stackbase is
;--- EXPLICITELY set to EBP AND "assume ss" is 16-bit, the only
;--- change will be to use "MOVZX ebp, sp" instead of "MOV ebp, esp".

	.386
	.model tiny
	.stack 1024

;--- an empty 16-bit stack segment for assume
STACK16 segment use16 stack 'STACK'
STACK16 ends

	.data

text1 db "hello",10,0

	.code

	assume ss:stack16
	option stackbase:ebp	; stackbase still 32-bit register

;--- printf: proc assumes 16-bit stack

printf PROC c uses esi di fmt:near32 ptr, args:vararg

local longarg:byte

	lea di, args
	mov esi, fmt
@@:
	lodsb
	mov bh, 0
	mov ah, 0Eh
	int 10h
	and al, al
	jnz @B
	ret

printf ENDP

;--- calling printf() from another proc with 16-bit stack

test1 proc

local v1:word

	invoke printf, addr text1, [v1]
	ret

test1 endp

;--- switch stack back to 32-bit

	assume ss:STACK
	option stackbase:ebp

main proc

local v1:word

;	invoke printf, addr text1, [v1]
	ret

main endp

start32:
	call main
	mov ax,4c00h
	int 21h

	END start32

