/**
 * @file core.h
 *
 * Support for %Cantera core calculations from C++ application programs. This
 * header file includes a minimal set of headers needed to create and use objects
 * that evaluate thermo properties, chemical kinetics and transport properties.
 */

#ifndef CT_INCL_CORE_H
#define CT_INCL_CORE_H

#include "cantera/base/Solution.h"
#include "cantera/base/Interface.h"
#include "cantera/thermo/ThermoPhase.h"
#include "cantera/thermo/Species.h"
#include "cantera/kinetics/Kinetics.h"
#include "cantera/kinetics/Reaction.h"
#include "cantera/transport/Transport.h"

#endif
