#.rst:
# FindUUID
# --------
# Finds the libuuid library
#
# This will define the following target:
#
#   UUID::UUID   - The libuuid library
#

if(NOT TARGET UUID::UUID)
  find_package(PkgConfig ${SEARCH_QUIET})
  if(PKG_CONFIG_FOUND)
    pkg_check_modules(PC_UUID uuid ${SEARCH_QUIET})
  endif()

  find_path(UUID_INCLUDE_DIR uuid/uuid.h
                             HINTS ${PC_UUID_INCLUDEDIR}
                                   ${DEPENDS_PATH}/include)
  find_library(UUID_LIBRARY uuid
                            HINTS ${PC_UUID_LIBRARY}
                                  ${DEPENDS_PATH}/lib)
  set(UUID_VERSION ${PC_UUID_VERSION})

  if(NOT VERBOSE_FIND)
     set(${CMAKE_FIND_PACKAGE_NAME}_FIND_QUIETLY TRUE)
   endif()

  include(FindPackageHandleStandardArgs)
  find_package_handle_standard_args(UUID
                                    REQUIRED_VARS UUID_LIBRARY UUID_INCLUDE_DIR
                                    VERSION_VAR UUID_VERSION)

  if(UUID_FOUND)
    add_library(UUID::UUID UNKNOWN IMPORTED)
    set_target_properties(UUID::UUID PROPERTIES
                                     IMPORTED_LOCATION "${UUID_LIBRARY}"
                                     INTERFACE_INCLUDE_DIRECTORIES "${UUID_INCLUDE_DIR}")
  endif()
endif()
