/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.RewriteUtilsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u001a>\u0010\u0000\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\bH\u0002\u00a8\u0006\r"}, d2={"removeDuplicateImports", "", "node", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "statements", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "existingImports", "", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "replacements", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "js.translator"})
public final class RemoveDuplicateImportsKt {
    public static final void removeDuplicateImports(@NotNull JsNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        node.accept(new RecursiveJsVisitor(){

            public void visitBlock(JsBlock x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                super.visitBlock(x);
                List<JsStatement> list = x.getStatements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                RemoveDuplicateImportsKt.access$removeDuplicateImports(list);
            }
        });
    }

    private static final void removeDuplicateImports(List<JsStatement> statements) {
        Map existingImports = new LinkedHashMap();
        Map replacements = new LinkedHashMap();
        RemoveDuplicateImportsKt.removeDuplicateImports(statements, existingImports, replacements);
        for (JsStatement statement : statements) {
            RewriteUtilsKt.replaceNames((JsNode)statement, replacements);
        }
    }

    private static final void removeDuplicateImports(List<JsStatement> statements, Map<String, JsName> existingImports, Map<JsName, JsExpression> replacements) {
        int index = 0;
        while (index < statements.size()) {
            JsStatement statement = statements.get(index);
            if (statement instanceof JsVars) {
                String importTag = CollectUtilsKt.getImportTag((JsVars)statement);
                if (importTag != null) {
                    JsName name2 = ((JsVars)statement).getVars().get(0).getName();
                    JsName existingName = existingImports.get(importTag);
                    if (existingName != null) {
                        replacements.put(name2, existingName.makeRef());
                        statements.remove(index);
                        continue;
                    }
                    existingImports.put(importTag, name2);
                }
            } else if (statement instanceof JsBlock) {
                List<JsStatement> list = ((JsBlock)statement).getStatements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
                RemoveDuplicateImportsKt.removeDuplicateImports(list, existingImports, replacements);
            }
            ++index;
        }
    }

    public static final /* synthetic */ void access$removeDuplicateImports(List statements) {
        RemoveDuplicateImportsKt.removeDuplicateImports(statements);
    }
}

