/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.progress;

import java.io.IOException;
import java.io.InputStream;
import org.gradle.internal.logging.progress.ProgressLoggingInputStreamListener;

public class ProgressLoggingInputStream
extends InputStream {
    private final InputStream inputStream;
    private final ProgressLoggingInputStreamListener progressLoggingInputStreamListener;

    public ProgressLoggingInputStream(InputStream inputStream, ProgressLoggingInputStreamListener progressLoggingInputStreamListener) {
        this.inputStream = inputStream;
        this.progressLoggingInputStreamListener = progressLoggingInputStreamListener;
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException("Reading from a remote resource should be buffered.");
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.inputStream.read(b, off, len);
        if (read > 0) {
            this.progressLoggingInputStreamListener.onProcessedBytes(read);
        }
        return read;
    }
}

