/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.ecf.core.util.OSGIObjectStreamConstants;
import org.eclipse.ecf.core.util.SerDTO;
import org.eclipse.ecf.core.util.SerVersion;
import org.osgi.framework.Version;
import org.osgi.service.log.LogService;

public class OSGIObjectOutputStream
extends ObjectOutputStream
implements OSGIObjectStreamConstants {
    protected final ObjectOutputStream out;
    protected LogService logger;
    protected boolean allowNonSerializable = false;

    public OSGIObjectOutputStream(OutputStream out, boolean allowNonSerializable, LogService log) throws IOException {
        this.out = new ReplaceableObjectOutputStream(out);
        this.allowNonSerializable = allowNonSerializable;
        this.logger = log;
    }

    public OSGIObjectOutputStream(OutputStream out, boolean allowNonSerializable) throws IOException {
        this(out, allowNonSerializable, null);
    }

    public OSGIObjectOutputStream(OutputStream out) throws IOException {
        this(out, false, null);
    }

    public void setAllowNonSerializable(boolean value) {
        this.allowNonSerializable = value;
    }

    public void setLogService(LogService log) {
        this.logger = log;
    }

    protected void writeExternalizable(Externalizable obj, Class<?> clazz) throws IOException {
        this.out.writeObject(obj);
    }

    protected void trace(String message) {
        LogService ls = this.logger;
        if (ls != null) {
            ls.log(4, message);
        }
    }

    protected void writeFields(Object obj, Class<?> clazz) throws IOException {
        while (clazz != Object.class) {
            try {
                int mod;
                Field[] allFields = clazz.getDeclaredFields();
                int allFieldCount = allFields.length;
                int actualFieldCount = 0;
                int i = 0;
                while (i < allFieldCount) {
                    mod = allFields[i].getModifiers();
                    if (!Modifier.isStatic(mod) && !Modifier.isTransient(mod)) {
                        ++actualFieldCount;
                    }
                    ++i;
                }
                this.out.writeInt(actualFieldCount);
                i = 0;
                while (i < allFieldCount) {
                    mod = allFields[i].getModifiers();
                    if (!Modifier.isStatic(mod) && !Modifier.isTransient(mod)) {
                        Object val;
                        if (!Modifier.isPublic(mod)) {
                            allFields[i].setAccessible(true);
                        }
                        if ((val = allFields[i].get(obj)) != obj) {
                            this.out.writeUTF(allFields[i].getName());
                            this.writeObjectOverride(val);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new NotSerializableException("Exception while serializing " + obj.toString() + ":\n" + e.getMessage());
            }
            clazz = clazz.getSuperclass();
        }
        this.out.writeInt(-1);
    }

    protected void writeNonSerializable(Object obj, Class<?> clazz) throws IOException {
        this.out.writeObject(clazz.getName());
        this.writeFields(obj, clazz);
    }

    protected void writeSerializable(Object obj, Class<?> clazz) throws IOException {
        this.out.writeObject(obj);
    }

    @Override
    protected void writeObjectOverride(Object obj) throws IOException {
        if (obj == null) {
            this.out.writeByte(0);
            return;
        }
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            this.out.writeByte(3);
            int len = Array.getLength(obj);
            this.out.writeInt(len);
            this.out.writeUTF(clazz.getComponentType().getName());
            int i = 0;
            while (i < len) {
                this.writeObjectOverride(Array.get(obj, i));
                ++i;
            }
            return;
        }
        if (obj instanceof Long) {
            if (clazz.isPrimitive()) {
                this.out.writeByte(20);
            } else {
                this.out.writeByte(30);
            }
            this.out.writeLong((Long)obj);
            return;
        }
        if (obj instanceof Integer) {
            if (clazz.isPrimitive()) {
                this.out.writeByte(21);
            } else {
                this.out.writeByte(31);
            }
            this.out.writeInt((Integer)obj);
            return;
        }
        if (obj instanceof Short) {
            if (clazz.isPrimitive()) {
                this.out.writeByte(22);
            } else {
                this.out.writeByte(32);
            }
            this.out.writeShort(((Short)obj).shortValue());
            return;
        }
        if (obj instanceof Boolean) {
            if (clazz.isPrimitive()) {
                this.out.writeByte(23);
            } else {
                this.out.writeByte(33);
            }
            this.out.writeBoolean((Boolean)obj);
            return;
        }
        if (obj instanceof Byte) {
            if (clazz.isPrimitive()) {
                this.out.writeByte(24);
            } else {
                this.out.writeByte(34);
            }
            this.out.writeByte(((Byte)obj).byteValue());
            return;
        }
        if (obj instanceof Character) {
            if (clazz.isPrimitive()) {
                this.out.writeByte(25);
            } else {
                this.out.writeByte(35);
            }
            this.out.writeChar(((Character)obj).charValue());
            return;
        }
        if (obj instanceof Float) {
            if (clazz.isPrimitive()) {
                this.out.writeByte(27);
            } else {
                this.out.writeByte(37);
            }
            this.out.writeFloat(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Double) {
            if (clazz.isPrimitive()) {
                this.out.writeByte(26);
            } else {
                this.out.writeByte(36);
            }
            this.out.writeDouble((Double)obj);
            return;
        }
        if (obj instanceof String) {
            this.out.writeByte(11);
            this.out.writeUTF((String)obj);
            return;
        }
        if (obj instanceof Dictionary) {
            this.trace("writing dictionary");
            this.out.writeByte(14);
            this.out.writeUTF(clazz.getName());
            Dictionary dict = (Dictionary)obj;
            int ds = dict.size();
            this.out.writeInt(ds);
            Enumeration e = dict.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                this.writeObjectOverride(key);
                this.writeObjectOverride(dict.get(key));
            }
            return;
        }
        if (obj instanceof Map) {
            this.out.writeByte(5);
            Map map = (Map)obj;
            int size = map.size();
            this.out.writeInt(size);
            for (Object key : map.keySet()) {
                this.writeObjectOverride(key);
                this.writeObjectOverride(map.get(key));
            }
            return;
        }
        if (obj instanceof List) {
            this.out.writeByte(6);
            List list = (List)obj;
            int size = list.size();
            this.out.writeInt(size);
            for (Object item : list) {
                this.writeObjectOverride(item);
            }
            return;
        }
        if (obj instanceof Set) {
            this.out.writeByte(7);
            Set set = (Set)obj;
            int size = set.size();
            this.out.writeInt(size);
            for (Object item : set) {
                this.writeObjectOverride(item);
            }
            return;
        }
        if (obj instanceof Collection) {
            this.out.writeByte(8);
            Collection col = (Collection)obj;
            int size = col.size();
            this.out.writeInt(size);
            for (Object item : col) {
                this.writeObjectOverride(item);
            }
            return;
        }
        if (obj instanceof Iterable) {
            this.out.writeByte(9);
            Iterable itr = (Iterable)obj;
            int size = 0;
            for (Object v : itr) {
                ++size;
            }
            this.out.writeInt(size);
            for (Object item : itr) {
                this.writeObjectOverride(item);
            }
            return;
        }
        if (obj instanceof Enum) {
            this.out.writeByte(12);
            this.out.writeUTF(obj.getClass().getName());
            this.out.writeUTF(((Enum)obj).name());
            return;
        }
        if (obj instanceof Externalizable) {
            this.out.writeByte(10);
            this.writeExternalizable((Externalizable)obj, clazz);
        } else {
            if (obj instanceof Serializable) {
                this.out.writeByte(1);
                this.writeSerializable(obj, clazz);
                return;
            }
            if (obj instanceof Version) {
                this.writeObjectOverride(new SerVersion((Version)obj));
            } else {
                this.writeObjectOverride(new SerDTO(obj));
                return;
            }
        }
    }

    @Override
    public final void write(int val) throws IOException {
        this.out.write(val);
    }

    @Override
    public final void write(byte[] buf) throws IOException {
        this.out.write(buf);
    }

    @Override
    public final void write(byte[] buf, int off, int len) throws IOException {
        this.out.write(buf, off, len);
    }

    @Override
    public final void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public final void reset() throws IOException {
        this.out.reset();
    }

    @Override
    public final void close() throws IOException {
        this.out.close();
    }

    @Override
    public final void writeBoolean(boolean val) throws IOException {
        this.out.writeBoolean(val);
    }

    @Override
    public final void writeByte(int val) throws IOException {
        this.out.writeByte(val);
    }

    @Override
    public final void writeShort(int val) throws IOException {
        this.out.writeShort(val);
    }

    @Override
    public final void writeChar(int val) throws IOException {
        this.out.writeChar(val);
    }

    @Override
    public final void writeInt(int val) throws IOException {
        this.out.writeInt(val);
    }

    @Override
    public final void writeLong(long val) throws IOException {
        this.out.writeLong(val);
    }

    @Override
    public final void writeFloat(float val) throws IOException {
        this.out.writeFloat(val);
    }

    @Override
    public final void writeDouble(double val) throws IOException {
        this.out.writeDouble(val);
    }

    @Override
    public final void writeBytes(String str) throws IOException {
        this.out.writeBytes(str);
    }

    @Override
    public final void writeChars(String str) throws IOException {
        this.out.writeChars(str);
    }

    @Override
    public final void writeUTF(String str) throws IOException {
        this.out.writeUTF(str);
    }

    class ReplaceableObjectOutputStream
    extends ObjectOutputStream {
        public ReplaceableObjectOutputStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof Version) {
                return new SerVersion((Version)obj);
            }
            if (!(obj instanceof Serializable)) {
                return new SerDTO(obj);
            }
            return super.replaceObject(obj);
        }
    }
}

