// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
//
// Code generated by Microsoft (R) AutoRest C++ Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.
#pragma once

#include <azure/core/context.hpp>
#include <azure/core/internal/extendable_enumeration.hpp>
#include <azure/core/internal/http/pipeline.hpp>
#include <azure/core/nullable.hpp>
#include <azure/core/response.hpp>
#include <azure/core/url.hpp>
#include <azure/keyvault/administration/dll_import_export.hpp>

#include <memory>
#include <string>
#include <vector>

namespace Azure { namespace Security { namespace KeyVault { namespace Administration {
  namespace Models {

    /**
     * @brief The type specifier of the value.
     */
    class SettingType final : public Azure::Core::_internal::ExtendableEnumeration<SettingType> {
    public:
      /**
       * @brief Default constructor
       */
      SettingType() = default;

      /**
       * @brief Constructor
       * @param value Setting Value
       */
      explicit SettingType(std::string value) : ExtendableEnumeration(std::move(value)) {}

      /**
       * @brief Specifies that this represents the Boolean Type
       */
      AZURE_SECURITY_KEYVAULT_ADMINISTRATION_DLLEXPORT const static SettingType Boolean;
    };

    /**
     * @brief Setting struct
     */
    struct Setting final
    {
      /**
       * The account setting to be updated.
       */
      std::string Name;
      /**
       * The value of the pool setting.
       */
      std::string Value;
      /**
       * The type specifier of the value.
       */
      Azure::Nullable<SettingType> Type;
    };

    /**
     * @brief The settings list result.
     */
    struct SettingsListResult final
    {
      /**
       * A response message containing a list of account settings with their
       * associated value.
       */
      std::vector<Setting> Value;
    };

    /**
     * @brief KeyVault Service Error model.
     *
     */
    struct KeyVaultServiceError final
    {
      /**
       * @brief The error code.
       *
       */
      std::string Code;
      /**
       * @brief The error message.
       *
       */
      std::string Message;
    };

    /**
     * @brief The full backup operation.
     *
     */
    struct BackupOperationStatus final
    {
      /**
       * @brief Status of the backup operation.
       *
       */
      std::string Status;
      /**
       * @brief The status details of backup operation.
       *
       */
      Azure::Nullable<std::string> StatusDetails;
      /**
       * @brief Error encountered, if any, during the full backup operation.
       *
       */
      Azure::Nullable<KeyVaultServiceError> Error;
      /**
       * @brief The start time of the backup operation in UTC.
       *
       */
      DateTime StartTime;
      /**
       * @brief The end time of the backup operation in UTC.
       *
       */
      Nullable<DateTime> EndTime;
      /**
       * @brief Identifier for the full backup operation.
       *
       */
      std::string JobId;
      /**
       * @brief The Azure blob storage container Uri which contains the full backup.
       *
       */
      std::string AzureStorageBlobContainerUri;
    };

    /**
     * @brief Sas token parameter for backup and restore operations.
     *
     */
    struct SasTokenParameter final
    {
      /**
       * @brief The SAS token pointing to an Azure Blob storage container.
       *
       */
      Nullable<std::string> Token;
      /**
       * @brief Indicates which authentication method should be used. If set to true, Managed HSM
       * will use the configured user-assigned managed identity to authenticate with Azure Storage.
       * Otherwise, a SAS token has to be specified.
       *
       */
      Nullable<bool> UseManagedIdentity;
    };

    /**
     * @brief Full backup status options.
     *
     */
    struct FullBackupStatusOptions final
    {
      /**
       * @brief Identifier for the full backup operation.
       *
       */
      std::string JobId;
    };

}}}}} // namespace Azure::Security::KeyVault::Administration::Models
