/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.concurrencyVisualizer.tool.panels;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.concurrencyVisualizer.PythonConcurrencyVisualizerBundle;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.PythonPluginDisposable;
import com.jetbrains.python.debugger.PySourcePosition;
import com.jetbrains.python.debugger.PyStackFrameInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConcurrencyStackTracePanel
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    private final Tree myTree;
    @NotNull
    private final DefaultTreeModel myModel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DefaultMutableTreeNode rootNode;

    public ConcurrencyStackTracePanel(@NotNull Project project) {
        if (project == null) {
            ConcurrencyStackTracePanel.$$$reportNull$$$0(0);
        }
        super(false);
        this.myProject = project;
        String root = "root";
        this.rootNode = new DefaultMutableTreeNode(root);
        this.myModel = new DefaultTreeModel(this.rootNode);
        this.myTree = new Tree((TreeModel)this.myModel);
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setLayout((LayoutManager)new BorderLayout());
        TreeUtil.installActions((JTree)this.myTree);
        this.myTree.setLargeModel(true);
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(value2 instanceof DefaultMutableTreeNode)) {
                    @NlsSafe String treeNode = value2.toString();
                    this.append(treeNode, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    return;
                }
                Object userObject = ((DefaultMutableTreeNode)value2).getUserObject();
                if (userObject instanceof PyStackFrameInfo) {
                    PyStackFrameInfo frameInfo = (PyStackFrameInfo)userObject;
                    this.setIcon(AllIcons.Debugger.Frame);
                    PySourcePosition position = frameInfo.getPosition();
                    if (position == null) {
                        this.append(PythonConcurrencyVisualizerBundle.message("concurrency.stack.frame.not.available", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        return;
                    }
                    boolean isExternal = true;
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(position.getFile());
                    if (file != null) {
                        Document document = FileDocumentManager.getInstance().getDocument(file);
                        if (document != null) {
                            isExternal = !ProjectRootManager.getInstance((Project)ConcurrencyStackTracePanel.this.myProject).getFileIndex().isInContent(file);
                        }
                    } else {
                        this.append(PythonConcurrencyVisualizerBundle.message("concurrency.stack.frame.not.available", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                        return;
                    }
                    String filename = file.getName();
                    this.append(frameInfo.getName(), ConcurrencyStackTracePanel.gray(isExternal));
                    this.append(", ", ConcurrencyStackTracePanel.gray(isExternal));
                    this.append(filename, ConcurrencyStackTracePanel.gray(isExternal));
                    this.append(":", ConcurrencyStackTracePanel.gray(isExternal));
                    this.append(Integer.toString(position.getLine()), ConcurrencyStackTracePanel.gray(isExternal));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/python/concurrencyVisualizer/tool/panels/ConcurrencyStackTracePanel$1", "customizeCellRenderer"));
            }
        });
        this.myTree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DefaultMutableTreeNode frameNode;
                Object userObject;
                TreePath path2 = ConcurrencyStackTracePanel.this.myTree.getPathForLocation(e.getX(), e.getY());
                if (path2 != null && (userObject = (frameNode = (DefaultMutableTreeNode)path2.getLastPathComponent()).getUserObject()) instanceof PyStackFrameInfo) {
                    PyStackFrameInfo frameInfo = (PyStackFrameInfo)userObject;
                    PySourcePosition position = frameInfo.getPosition();
                    VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(position.getFile());
                    ConcurrencyStackTracePanel.this.navigateToSource(XDebuggerUtil.getInstance().createPosition(vFile, position.getLine() - 1));
                }
            }
        });
        TreeUtil.expand((JTree)this.myTree, (int)1);
        this.add(ScrollPaneFactory.createScrollPane((Component)this.myTree));
    }

    private void navigateToSource(@Nullable XSourcePosition sourcePosition) {
        if (sourcePosition != null) {
            ((AppUIExecutor)AppUIExecutor.onUiThread().expireWith(PythonPluginDisposable.getInstance((Project)this.myProject))).submit(() -> sourcePosition.createNavigatable(this.myProject).navigate(false));
        }
    }

    private static SimpleTextAttributes gray(boolean gray) {
        if (!gray) {
            return SimpleTextAttributes.REGULAR_ATTRIBUTES;
        }
        return (SimpleTextAttributes.REGULAR_ATTRIBUTES.getStyle() & 2) != 0 ? SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    public void buildStackTrace(@NotNull List<PyStackFrameInfo> frames) {
        if (frames == null) {
            ConcurrencyStackTracePanel.$$$reportNull$$$0(1);
        }
        TreeState treeState = TreeState.createOn((JTree)this.myTree, (DefaultMutableTreeNode)this.rootNode);
        this.rootNode.removeAllChildren();
        for (PyStackFrameInfo frame : frames) {
            DefaultMutableTreeNode frameNode = new DefaultMutableTreeNode(frame);
            this.rootNode.add(frameNode);
        }
        this.myModel.nodeStructureChanged(this.rootNode);
        treeState.applyTo((JTree)this.myTree);
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/concurrencyVisualizer/tool/panels/ConcurrencyStackTracePanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildStackTrace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

