/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.parsing;

import com.google.common.collect.ImmutableSet;
import com.intellij.jinja.Jinja2Bundle;
import com.intellij.jinja.lexer.Jinja2TokenTypes;
import com.intellij.jinja.parsing.Jinja2CallTagParser;
import com.intellij.jinja.parsing.Jinja2ElementTypes;
import com.intellij.jinja.parsing.Jinja2ExpressionTagParser;
import com.intellij.jinja.parsing.Jinja2ForTagParser;
import com.intellij.jinja.parsing.Jinja2FromTagParser;
import com.intellij.jinja.parsing.Jinja2ImportTagParser;
import com.intellij.jinja.parsing.Jinja2IncludeTagParser;
import com.intellij.jinja.parsing.Jinja2MacroTagParser;
import com.intellij.jinja.parsing.Jinja2SetTagParser;
import com.intellij.jinja.parsing.Jinja2WithTagParser;
import com.intellij.jinja.template.parsing.DjangoTemplateTokenTypes;
import com.intellij.jinja.template.parsing.parser.DjangoTemplateParsing;
import com.intellij.jinja.template.parsing.parser.Jinja2TagParser;
import com.intellij.jinja.template.parsing.parser.TagParserRegistry;
import com.intellij.jinja.template.psi.Jinja2TemplateElementTypes;
import com.intellij.jinja.template.tags.Jinja2BlockTagParser;
import com.intellij.jinja.template.tags.Jinja2FilterTagParser;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.Contract;

public class Jinja2TemplateParsing
extends DjangoTemplateParsing {
    private static final TagParserRegistry JINJA2_TAG_PARSER_REGISTRY = new TagParserRegistry<Jinja2TemplateParsing>().with("if", new Jinja2ExpressionTagParser(Jinja2TemplateElementTypes.IF_TAG)).with("for", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2ForTagParser()).with("filter", new Jinja2FilterTagParser()).with("include", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2IncludeTagParser()).with("extends", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2ExpressionTagParser(Jinja2TemplateElementTypes.INCLUDE_EXTENDS_TAG)).with("set", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2SetTagParser()).with("macro", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2MacroTagParser()).with("import", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2ImportTagParser()).with("from", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2FromTagParser()).with("call", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2CallTagParser()).with("with", (Jinja2TagParser<Jinja2TemplateParsing>)new Jinja2WithTagParser()).with("block", new Jinja2BlockTagParser("scoped"));
    private static final TokenSet STOP_TOKENS = TokenSet.create((IElementType[])new IElementType[]{DjangoTemplateTokenTypes.DJANGO_TAG_END, Jinja2TokenTypes.TAG_END_TRIM, Jinja2TokenTypes.TAG_END_PRESERVE, DjangoTemplateTokenTypes.DJANGO_EXPRESSION_END, DjangoTemplateTokenTypes.FILTER});
    private static final ImmutableSet<String> CONSTANTS = ImmutableSet.of((Object)"true", (Object)"True", (Object)"false", (Object)"False", (Object)"none", (Object)"None", (Object[])new String[0]);

    public Jinja2TemplateParsing(PsiBuilder builder) {
        super(builder, JINJA2_TAG_PARSER_REGISTRY);
    }

    @Override
    protected boolean isTagInjectionStart() {
        return this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_TAG_START, Jinja2TokenTypes.TAG_START_TRIM, Jinja2TokenTypes.TAG_START_PRESERVE);
    }

    @Override
    protected boolean isTagInjectionEnd() {
        return this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_TAG_END, Jinja2TokenTypes.TAG_END_TRIM, Jinja2TokenTypes.TAG_END_PRESERVE);
    }

    @Override
    protected boolean isExpressionInjectionStart() {
        return this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_EXPRESSION_START, Jinja2TokenTypes.EXPRESSION_START_TRIM);
    }

    @Override
    protected boolean isExpressionInjectionEnd() {
        return this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_EXPRESSION_END, Jinja2TokenTypes.EXPRESSION_END_TRIM);
    }

    @Override
    public boolean parseFilterArguments() {
        return !this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0]) || this.parseArgumentList();
    }

    private boolean parseArgumentList() {
        this.advance();
        if (this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
            this.advance();
            return true;
        }
        if (!this.parseArgument()) {
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
            this.advance();
            if (this.parseArgument()) continue;
            return false;
        }
        if (!this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
            this.error(Jinja2Bundle.message("jinja2.parsing.error.closing.parenthesis.expected", new Object[0]));
            return false;
        }
        this.advance();
        return true;
    }

    private boolean parseArgument() {
        if (this.hasTokenTypeSequence(DjangoTemplateTokenTypes.ID, DjangoTemplateTokenTypes.ASSIGN)) {
            PsiBuilder.Marker kwargMarker = this.mark();
            this.advance();
            this.advance();
            if (!this.parseSingleExpression()) {
                kwargMarker.drop();
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                return false;
            }
            kwargMarker.done((IElementType)Jinja2ElementTypes.KEYWORD_ARGUMENT);
            return true;
        }
        if (this.hasTokenType(Jinja2TokenTypes.MUL, new IElementType[0]) || this.hasTokenType(Jinja2TokenTypes.POW, new IElementType[0])) {
            PsiBuilder.Marker starArgMarker = this.mark();
            this.advance();
            if (!this.parseSingleExpression()) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                starArgMarker.drop();
                return false;
            }
            starArgMarker.done((IElementType)Jinja2ElementTypes.STAR_ARGUMENT);
            return true;
        }
        return this.parseSingleExpression();
    }

    @Override
    protected boolean parseExpression() {
        return this.parseTuple();
    }

    private boolean parseTuple() {
        return this.parseTuple(TokenSet.EMPTY, false, true);
    }

    public boolean parseTuple(TokenSet stopAtTokens, boolean advanceOverStopToken, boolean condexpr) {
        PsiBuilder.Marker tupleStart = this.mark();
        boolean foundComma = false;
        boolean foundExpression = false;
        TokenSet allStopTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{stopAtTokens, STOP_TOKENS});
        while (!this.hasTokenType(allStopTokens)) {
            boolean result;
            boolean bl = result = condexpr ? this.parseSingleExpression() : this.parseOr();
            if (!result) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                tupleStart.drop();
                return false;
            }
            foundExpression = true;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                foundComma = true;
                continue;
            }
            if (!condexpr && this.hasTokenText("if")) break;
            if (this.hasTokenType(allStopTokens)) continue;
            if (stopAtTokens.getTypes().length <= 0) break;
            this.error(Jinja2Bundle.message("jinja2.parsing.error.closing.parenthesis.expected", new Object[0]));
            break;
        }
        if (foundComma || !foundExpression && stopAtTokens.getTypes().length > 0) {
            tupleStart.done((IElementType)Jinja2ElementTypes.TUPLE);
        } else {
            tupleStart.drop();
        }
        if (advanceOverStopToken && this.hasTokenType(stopAtTokens)) {
            this.advance();
        }
        return true;
    }

    @Contract(mutates="this")
    public boolean parseSingleExpression() {
        PsiBuilder.Marker condExprStart = this.mark();
        if (!this.parseOr()) {
            condExprStart.drop();
            return false;
        }
        if (this.hasTokenText("if")) {
            this.createTokenElement(Jinja2ElementTypes.SOFT_KEYWORD);
            if (!this.parseOr()) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                condExprStart.drop();
                return false;
            }
            if (this.hasTokenText("else")) {
                this.createTokenElement(Jinja2ElementTypes.SOFT_KEYWORD);
                if (!this.parseOr()) {
                    this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                    condExprStart.drop();
                    return false;
                }
            }
            condExprStart.done((IElementType)Jinja2ElementTypes.CONDEXPR);
        } else {
            condExprStart.drop();
        }
        return true;
    }

    public boolean parseOr() {
        PsiBuilder.Marker orStart = this.mark();
        if (!this.parseAnd()) {
            orStart.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.OR, new IElementType[0])) {
            this.advance();
            if (!this.parseAnd()) {
                orStart.drop();
                return false;
            }
            orStart.done((IElementType)Jinja2ElementTypes.BINOP);
            orStart = orStart.precede();
        }
        orStart.drop();
        return true;
    }

    private boolean parseAnd() {
        PsiBuilder.Marker andStart = this.mark();
        if (!this.parseNot()) {
            andStart.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.AND, new IElementType[0])) {
            this.advance();
            if (!this.parseNot()) {
                andStart.drop();
                return false;
            }
            andStart.done((IElementType)Jinja2ElementTypes.BINOP);
            andStart = andStart.precede();
        }
        andStart.drop();
        return true;
    }

    private boolean parseNot() {
        if (this.hasTokenType(DjangoTemplateTokenTypes.NOT, new IElementType[0])) {
            PsiBuilder.Marker notStart = this.mark();
            this.advance();
            if (!this.parseNot()) {
                notStart.drop();
                return false;
            }
            notStart.done((IElementType)Jinja2ElementTypes.UNARY);
            return true;
        }
        return this.parseCompare();
    }

    private boolean parseCompare() {
        PsiBuilder.Marker compareStart = this.mark();
        if (!this.parseAdd()) {
            compareStart.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.DJANGO_RELATION_OPERATORS) || this.hasTokenTypeSequence(DjangoTemplateTokenTypes.NOT, DjangoTemplateTokenTypes.IN)) {
            if (this.hasTokenTypeSequence(DjangoTemplateTokenTypes.NOT, DjangoTemplateTokenTypes.IN)) {
                this.advance();
            }
            this.advance();
            if (!this.parseAdd()) {
                compareStart.drop();
                return false;
            }
            compareStart.done((IElementType)Jinja2ElementTypes.BINOP);
            compareStart = compareStart.precede();
        }
        compareStart.drop();
        return true;
    }

    private boolean parseAdd() {
        PsiBuilder.Marker addStart = this.mark();
        if (!this.parseSub()) {
            addStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.ADD, new IElementType[0])) {
            this.advance();
            if (!this.parseSub()) {
                addStart.drop();
                return false;
            }
            addStart.done((IElementType)Jinja2ElementTypes.BINOP);
            addStart = addStart.precede();
        }
        addStart.drop();
        return true;
    }

    private boolean parseSub() {
        PsiBuilder.Marker subStart = this.mark();
        if (!this.parseConcat()) {
            subStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.SUB, new IElementType[0])) {
            this.advance();
            if (!this.parseConcat()) {
                subStart.drop();
                return false;
            }
            subStart.done((IElementType)Jinja2ElementTypes.BINOP);
            subStart = subStart.precede();
        }
        subStart.drop();
        return true;
    }

    private boolean parseConcat() {
        PsiBuilder.Marker concatStart = this.mark();
        if (!this.parseMul()) {
            concatStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.TILDE, new IElementType[0])) {
            this.advance();
            if (!this.parseMul()) {
                concatStart.drop();
                return false;
            }
            concatStart.done((IElementType)Jinja2ElementTypes.BINOP);
            concatStart = concatStart.precede();
        }
        concatStart.drop();
        return true;
    }

    private boolean parseMul() {
        PsiBuilder.Marker mulStart = this.mark();
        if (!this.parseDiv()) {
            mulStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.MUL, new IElementType[0])) {
            this.advance();
            if (!this.parseDiv()) {
                mulStart.drop();
                return false;
            }
            mulStart.done((IElementType)Jinja2ElementTypes.BINOP);
            mulStart = mulStart.precede();
        }
        mulStart.drop();
        return true;
    }

    private boolean parseDiv() {
        PsiBuilder.Marker divStart = this.mark();
        if (!this.parseFloorDiv()) {
            divStart.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.SLASH, new IElementType[0])) {
            this.advance();
            if (!this.parseFloorDiv()) {
                divStart.drop();
                return false;
            }
            divStart.done((IElementType)Jinja2ElementTypes.BINOP);
            divStart = divStart.precede();
        }
        divStart.drop();
        return true;
    }

    private boolean parseFloorDiv() {
        PsiBuilder.Marker divStart = this.mark();
        if (!this.parseMod()) {
            divStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.FLOORDIV, new IElementType[0])) {
            this.advance();
            if (!this.parseMod()) {
                divStart.drop();
                return false;
            }
            divStart.done((IElementType)Jinja2ElementTypes.BINOP);
            divStart = divStart.precede();
        }
        divStart.drop();
        return true;
    }

    private boolean parseMod() {
        PsiBuilder.Marker modStart = this.mark();
        if (!this.parsePow()) {
            modStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.MOD, new IElementType[0])) {
            this.advance();
            if (!this.parsePow()) {
                modStart.drop();
                return false;
            }
            modStart.done((IElementType)Jinja2ElementTypes.BINOP);
            modStart = modStart.precede();
        }
        modStart.drop();
        return true;
    }

    private boolean parsePow() {
        PsiBuilder.Marker powStart = this.mark();
        if (!this.parseUnary(true)) {
            powStart.drop();
            return false;
        }
        while (this.hasTokenType(Jinja2TokenTypes.POW, new IElementType[0])) {
            this.advance();
            if (!this.parseUnary(true)) {
                powStart.drop();
                return false;
            }
            powStart.done((IElementType)Jinja2ElementTypes.BINOP);
            powStart = powStart.precede();
        }
        powStart.drop();
        return true;
    }

    private boolean parseUnary(boolean withFilter) {
        if (this.hasTokenType(Jinja2TokenTypes.SUB, new IElementType[0]) || this.hasTokenType(Jinja2TokenTypes.ADD, new IElementType[0])) {
            PsiBuilder.Marker unaryStart = this.mark();
            this.advance();
            if (!this.parseUnary(false)) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                unaryStart.drop();
                return false;
            }
            unaryStart.done((IElementType)Jinja2ElementTypes.UNARY);
            return true;
        }
        return withFilter ? this.parseWithFilter() : this.parseWithPostfix();
    }

    private boolean parseWithFilter() {
        PsiBuilder.Marker filtersMarker = this.mark();
        if (!this.parseWithPostfix()) {
            filtersMarker.drop();
            return false;
        }
        if (this.hasTokenType(DjangoTemplateTokenTypes.FILTER, new IElementType[0])) {
            while (this.hasTokenType(DjangoTemplateTokenTypes.FILTER, new IElementType[0])) {
                this.advance();
                if (this.parseFilterExpression()) continue;
                this.error(Jinja2Bundle.message("jinja2.parsing.error.filter.expression.expected", new Object[0]));
                filtersMarker.drop();
                return false;
            }
            filtersMarker.done(Jinja2TemplateElementTypes.FILTERS);
        } else if (this.hasTokenType(Jinja2TokenTypes.IS, new IElementType[0])) {
            this.advance();
            if (this.hasTokenType(DjangoTemplateTokenTypes.NOT, new IElementType[0])) {
                this.advance();
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.ID, new IElementType[0])) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.test.name.expected", new Object[0]));
                filtersMarker.drop();
                return false;
            }
            PsiBuilder.Marker testNameMarker = this.mark();
            this.advance();
            testNameMarker.done((IElementType)Jinja2ElementTypes.TEST_NAME);
            if (this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0])) {
                this.parseArgumentList();
            } else if (!(this.hasTokenText("else") || this.hasTokenText("or") || this.hasTokenText("and") || this.hasTokenType(Jinja2TokenTypes.CLOSING_BRACES))) {
                this.parseExpression();
            }
            filtersMarker.done((IElementType)Jinja2ElementTypes.TEST);
        } else {
            filtersMarker.drop();
        }
        return true;
    }

    private boolean parseWithPostfix() {
        PsiBuilder.Marker postfixMarker = this.mark();
        if (!this.parsePrimary()) {
            postfixMarker.drop();
            return false;
        }
        while (this.hasTokenType(DjangoTemplateTokenTypes.DOT, new IElementType[0])) {
            this.advance();
            if (!this.parsePrimary()) {
                postfixMarker.drop();
                return false;
            }
            postfixMarker.done(Jinja2TemplateElementTypes.MEMBER);
            postfixMarker = postfixMarker.precede();
        }
        postfixMarker.drop();
        return true;
    }

    private boolean parsePrimary() {
        PsiBuilder.Marker exprStart = this.mark();
        boolean result = this.parseIdOrLiteral();
        if (!result) {
            exprStart.drop();
            return false;
        }
        while (true) {
            if (this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0])) {
                if (!this.parseArgumentList()) {
                    exprStart.drop();
                    return false;
                }
                exprStart.done((IElementType)Jinja2ElementTypes.FUNCTION_CALL);
                exprStart = exprStart.precede();
                continue;
            }
            if (!this.hasTokenType(Jinja2TokenTypes.LBRACKET, new IElementType[0])) break;
            if (!this.parseSubscription()) {
                exprStart.drop();
                return false;
            }
            exprStart.done((IElementType)Jinja2ElementTypes.SUBSCRIPTION);
            exprStart = exprStart.precede();
        }
        exprStart.drop();
        return true;
    }

    private boolean parseSubscription() {
        while (true) {
            this.advance();
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0]) && !this.parseSingleExpression()) {
                return false;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0])) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.closing.bracket.comma.or.colon.expected", new Object[0]));
                return false;
            }
            this.advance();
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0]) && !this.parseSingleExpression()) {
                return false;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0])) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.colon.expected", new Object[0]));
                return false;
            }
            this.advance();
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (!this.parseSingleExpression()) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                return false;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) break;
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            this.error(Jinja2Bundle.message("jinja2.parsing.error.closing.bracket.or.comma.expected", new Object[0]));
        }
        this.advance();
        return true;
    }

    @Override
    protected boolean isAtExpression() {
        return true;
    }

    @Override
    public boolean isLiteral() {
        return super.isLiteral() || this.hasTokenType(Jinja2TokenTypes.OPENING_BRACES) || this.hasTokenType(Jinja2TokenTypes.FLOAT_LITERAL, new IElementType[0]);
    }

    @Override
    public void parseLiteral() {
        if (this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0])) {
            this.advance();
            this.parseTuple(Jinja2TokenTypes.RPAR_TOKENSET, true, true);
        } else if (this.hasTokenType(Jinja2TokenTypes.LBRACKET, new IElementType[0])) {
            this.parseList();
        } else if (this.hasTokenType(Jinja2TokenTypes.LBRACE, new IElementType[0])) {
            this.parseDict();
        } else if (this.isStringLiteral()) {
            PsiBuilder.Marker literalStart = this.mark();
            while (this.isStringLiteral()) {
                this.advance();
            }
            literalStart.done(Jinja2TemplateElementTypes.STRING);
        } else if (this.hasTokenType(Jinja2TokenTypes.FLOAT_LITERAL, new IElementType[0])) {
            this.createTokenElement(Jinja2TemplateElementTypes.NUMBER);
        } else {
            super.parseLiteral();
        }
    }

    private void parseList() {
        PsiBuilder.Marker listStart = this.mark();
        this.advance();
        while (!this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) {
            if (!this.parseSingleExpression()) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                listStart.drop();
                return;
            }
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACKET, new IElementType[0])) continue;
            this.error(Jinja2Bundle.message("jinja2.parsing.error.closing.bracket.expected", new Object[0]));
            break;
        }
        this.advance();
        listStart.done((IElementType)Jinja2ElementTypes.LIST);
    }

    private void parseDict() {
        PsiBuilder.Marker dictStart = this.mark();
        this.advance();
        while (!this.hasTokenType(Jinja2TokenTypes.RBRACE, new IElementType[0])) {
            if (!this.parseSingleExpression()) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                dictStart.drop();
                return;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COLON, new IElementType[0])) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.colon.expected", new Object[0]));
                dictStart.drop();
                return;
            }
            this.advance();
            if (!this.parseSingleExpression()) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.expression.expected", new Object[0]));
                dictStart.drop();
                return;
            }
            if (this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.advance();
                continue;
            }
            if (this.hasTokenType(Jinja2TokenTypes.RBRACE, new IElementType[0])) continue;
            this.error(Jinja2Bundle.message("jinja2.parsing.error.closing.bracket.expected", new Object[0]));
            break;
        }
        this.advance();
        dictStart.done((IElementType)Jinja2ElementTypes.DICT);
    }

    @Override
    public boolean parseLogical() {
        return this.parseExpression();
    }

    void parseSignature() {
        this.advance();
        while (!this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
            PsiBuilder.Marker paramStart = this.mark();
            if (!this.parseNamedExpr()) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.parameter.name.expected", new Object[0]));
                paramStart.drop();
                break;
            }
            if (this.hasTokenType(DjangoTemplateTokenTypes.ASSIGN, new IElementType[0])) {
                this.advance();
                if (!this.parseSingleExpression()) {
                    this.error(Jinja2Bundle.message("jinja2.parsing.error.default.parameter.value.expected", new Object[0]));
                    paramStart.drop();
                    break;
                }
            }
            paramStart.done((IElementType)Jinja2ElementTypes.MACRO_PARAMETER);
            if (!this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0]) && !this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.comma.or.closing.parenthesis.expected", new Object[0]));
                break;
            }
            if (!this.hasTokenType(DjangoTemplateTokenTypes.COMMA, new IElementType[0])) continue;
            this.advance();
        }
        if (this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
            this.advance();
        }
    }

    void parseContext() {
        if (this.hasTokenText("with") || this.hasTokenText("without")) {
            PsiBuilder.Marker keyword = this.mark();
            this.advance();
            if (!this.hasTokenText("context")) {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.context.expected", new Object[0]));
            } else {
                this.advance();
            }
            keyword.done((IElementType)Jinja2ElementTypes.SOFT_KEYWORD);
        }
    }

    @Override
    public void parseNameList() {
        while (true) {
            if (this.hasTokenType(ID, new IElementType[0])) {
                PsiBuilder.Marker namedExpression = this.mark();
                this.advance();
                namedExpression.done(Jinja2TemplateElementTypes.NAMED_EXPR);
            } else if (this.hasTokenType(Jinja2TokenTypes.LPAR, new IElementType[0])) {
                this.advance();
                this.parseNameList();
                if (this.hasTokenType(Jinja2TokenTypes.RPAR, new IElementType[0])) {
                    this.advance();
                } else {
                    this.error(Jinja2Bundle.message("jinja2.parsing.error.closing.parenthesis.expected", new Object[0]));
                }
            } else {
                this.error(Jinja2Bundle.message("jinja2.parsing.error.identifier.expected", new Object[0]));
            }
            if (this.tagEnded() || !this.hasTokenType(COMMA, new IElementType[0])) break;
            this.advance();
        }
    }

    @Override
    public boolean parseMemberExpr(IElementType elementType, boolean wrapByMemberAnyway) {
        if (!this.isId()) {
            this.error(Jinja2Bundle.message("jinja2.parsing.error.identifier.expected", new Object[0]));
            return false;
        }
        String tokenText = this.myPsiBuilder.getTokenText();
        if (CONSTANTS.contains((Object)tokenText)) {
            this.createTokenElement(Jinja2ElementTypes.CONST);
            return true;
        }
        return super.parseMemberExpr(elementType, wrapByMemberAnyway);
    }
}

