/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters.values;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.XmlDomBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharacterValueConverter
extends Converter<String> {
    @NonNls
    private static final String UNICODE_PREFIX = "\\u";
    private static final int UNICODE_LENGTH = 6;
    private final boolean myAllowEmpty;

    public CharacterValueConverter(boolean allowEmpty) {
        this.myAllowEmpty = allowEmpty;
    }

    @Override
    public String fromString(@Nullable @NonNls String s, @NotNull ConvertContext context) {
        if (context == null) {
            CharacterValueConverter.$$$reportNull$$$0(0);
        }
        if (s == null) {
            return null;
        }
        if (this.myAllowEmpty && s.trim().isEmpty()) {
            return s;
        }
        if (s.trim().length() == 1) {
            return s;
        }
        if (CharacterValueConverter.isUnicodeCharacterSequence(s)) {
            try {
                Integer.parseInt(s.substring(UNICODE_PREFIX.length()), 16);
                return s;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    private static boolean isUnicodeCharacterSequence(String sequence) {
        return sequence.startsWith(UNICODE_PREFIX) && sequence.length() == 6;
    }

    @Override
    public String toString(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            CharacterValueConverter.$$$reportNull$$$0(1);
        }
        return s;
    }

    @Override
    public String getErrorMessage(@Nullable String s, @NotNull ConvertContext context) {
        if (context == null) {
            CharacterValueConverter.$$$reportNull$$$0(2);
        }
        return XmlDomBundle.message("dom.converter.format.exception", s, "char");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "context";
        objectArray2[1] = "com/intellij/util/xml/converters/values/CharacterValueConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "fromString";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "toString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

