/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.math3;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.BaseUnivariateSolver;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.Incrementor;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.UnivariateFunction;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.UnivariateSolverUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\b&\u0018\u0000 8*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00018B\u000f\b\u0014\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0004J\b\u0010!\u001a\u00020\u0005H$J\b\u0010\"\u001a\u00020#H\u0004J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0004J \u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u0005H\u0004J5\u0010,\u001a\u00020#2\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0004\u00a2\u0006\u0002\u0010/J%\u00100\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u00101J-\u00100\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u00102J5\u00100\u001a\u00020\u00052\u0006\u0010-\u001a\u00020\r2\u0006\u0010.\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0004J\u0018\u00105\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0004J \u00106\u001a\u00020#2\u0006\u0010&\u001a\u00020\u00052\u0006\u00107\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0005H\u0004R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0011R\u0014\u0010\b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR\u001e\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000bR\u0014\u0010\u0016\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u001e\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000bR\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000bR\u001e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000b\u00a8\u00069"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/BaseAbstractUnivariateSolver;", "FUNC", "Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/UnivariateFunction;", "Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/BaseUnivariateSolver;", "absoluteAccuracy", "", "(D)V", "relativeAccuracy", "functionValueAccuracy", "(DDD)V", "getAbsoluteAccuracy", "()D", "evaluations", "", "getEvaluations", "()I", "function", "Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/UnivariateFunction;", "getFunctionValueAccuracy", "<set-?>", "max", "getMax", "maxEvaluations", "getMaxEvaluations", "min", "getMin", "myEvaluations", "Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/Incrementor;", "getRelativeAccuracy", "startValue", "getStartValue", "computeObjectiveValue", "point", "doSolve", "incrementEvaluationCount", "", "isBracketing", "", "lower", "upper", "isSequence", "start", "mid", "end", "setup", "maxEval", "f", "(ILorg/jetbrains/letsPlot/core/plot/base/stat/math3/UnivariateFunction;DDD)V", "solve", "(ILorg/jetbrains/letsPlot/core/plot/base/stat/math3/UnivariateFunction;D)D", "(ILorg/jetbrains/letsPlot/core/plot/base/stat/math3/UnivariateFunction;DD)D", "(ILorg/jetbrains/letsPlot/core/plot/base/stat/math3/UnivariateFunction;DDD)D", "verifyBracketing", "verifyInterval", "verifySequence", "initial", "Companion", "plot-base"})
public abstract class BaseAbstractUnivariateSolver<FUNC extends UnivariateFunction>
implements BaseUnivariateSolver<FUNC> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double relativeAccuracy;
    private final double absoluteAccuracy;
    private final double functionValueAccuracy;
    @NotNull
    private final Incrementor myEvaluations;
    private double min;
    private double max;
    private double startValue;
    @Nullable
    private FUNC function;
    private final int evaluations;
    private static final double DEFAULT_RELATIVE_ACCURACY = 1.0E-14;
    private static final double DEFAULT_FUNCTION_VALUE_ACCURACY = 1.0E-15;

    @JvmOverloads
    protected BaseAbstractUnivariateSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        this.relativeAccuracy = relativeAccuracy;
        this.absoluteAccuracy = absoluteAccuracy;
        this.functionValueAccuracy = functionValueAccuracy;
        this.myEvaluations = new Incrementor(0, null, 3, null);
        this.evaluations = this.myEvaluations.getCount();
    }

    public /* synthetic */ BaseAbstractUnivariateSolver(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d3 = DEFAULT_FUNCTION_VALUE_ACCURACY;
        }
        this(d, d2, d3);
    }

    @Override
    public double getRelativeAccuracy() {
        return this.relativeAccuracy;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.absoluteAccuracy;
    }

    @Override
    public double getFunctionValueAccuracy() {
        return this.functionValueAccuracy;
    }

    public final double getMin() {
        return this.min;
    }

    public final double getMax() {
        return this.max;
    }

    public final double getStartValue() {
        return this.startValue;
    }

    @Override
    public int getMaxEvaluations() {
        return this.myEvaluations.getMaximalCount();
    }

    protected BaseAbstractUnivariateSolver(double absoluteAccuracy) {
        this(DEFAULT_RELATIVE_ACCURACY, absoluteAccuracy, DEFAULT_FUNCTION_VALUE_ACCURACY);
    }

    @Override
    public int getEvaluations() {
        return this.evaluations;
    }

    protected final double computeObjectiveValue(double point2) {
        this.incrementEvaluationCount();
        FUNC FUNC = this.function;
        Intrinsics.checkNotNull(FUNC);
        return FUNC.value(point2);
    }

    protected final void setup(int maxEval, @NotNull FUNC f, double min, double max, double startValue) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.min = min;
        this.max = max;
        this.startValue = startValue;
        this.function = f;
        this.myEvaluations.setMaximalCount(maxEval);
        this.myEvaluations.resetCount();
    }

    @Override
    public double solve(int maxEval, @NotNull FUNC f, double min, double max, double startValue) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.setup(maxEval, f, min, max, startValue);
        return this.doSolve();
    }

    @Override
    public double solve(int maxEval, @NotNull FUNC f, double min, double max) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return this.solve(maxEval, f, min, max, min + 0.5 * (max - min));
    }

    @Override
    public double solve(int maxEval, @NotNull FUNC f, double startValue) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        return this.solve(maxEval, f, Double.NaN, Double.NaN, startValue);
    }

    protected abstract double doSolve();

    protected final boolean isBracketing(double lower2, double upper2) {
        FUNC FUNC = this.function;
        Intrinsics.checkNotNull(FUNC);
        return UnivariateSolverUtils.INSTANCE.isBracketing((UnivariateFunction)FUNC, lower2, upper2);
    }

    protected final boolean isSequence(double start2, double mid, double end) {
        return UnivariateSolverUtils.INSTANCE.isSequence(start2, mid, end);
    }

    protected final void verifyInterval(double lower2, double upper2) {
        UnivariateSolverUtils.INSTANCE.verifyInterval(lower2, upper2);
    }

    protected final void verifySequence(double lower2, double initial, double upper2) {
        UnivariateSolverUtils.INSTANCE.verifySequence(lower2, initial, upper2);
    }

    protected final void verifyBracketing(double lower2, double upper2) {
        FUNC FUNC = this.function;
        Intrinsics.checkNotNull(FUNC);
        UnivariateSolverUtils.INSTANCE.verifyBracketing((UnivariateFunction)FUNC, lower2, upper2);
    }

    protected final void incrementEvaluationCount() {
        this.myEvaluations.incrementCount();
    }

    @JvmOverloads
    protected BaseAbstractUnivariateSolver(double relativeAccuracy, double absoluteAccuracy) {
        this(relativeAccuracy, absoluteAccuracy, 0.0, 4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/math3/BaseAbstractUnivariateSolver$Companion;", "", "()V", "DEFAULT_FUNCTION_VALUE_ACCURACY", "", "DEFAULT_RELATIVE_ACCURACY", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

