/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.aes.AesScaling;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.WithHeight;
import org.jetbrains.letsPlot.core.plot.base.geom.WithWidth;
import org.jetbrains.letsPlot.core.plot.base.geom.legend.LollipopLegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.render.LegendKeyElementFactory;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.render.point.NamedShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShape;
import org.jetbrains.letsPlot.core.plot.base.render.point.PointShapeSvg;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.slim.SvgSlimObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 A2\u00020\u00012\u00020\u00022\u00020\u0003:\u0003ABCB\u0005\u00a2\u0006\u0002\u0010\u0004J>\u0010\u001b\u001a\u00020\u001c2\n\u0010\u001d\u001a\u00060\u001eR\u00020\u00002\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u00020'0&0$H\u0002J0\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0014J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000204H\u0002J0\u00106\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020%2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\f0:2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0016J\u0014\u0010>\u001a\u00020=2\n\u0010?\u001a\u0006\u0012\u0002\b\u00030:H\u0016J0\u0010@\u001a\u0004\u0018\u0001072\u0006\u00108\u001a\u00020%2\f\u00109\u001a\b\u0012\u0004\u0012\u00020\f0:2\u0006\u0010;\u001a\u00020\f2\u0006\u0010<\u001a\u00020=H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010\u00a8\u0006D"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithWidth;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/WithHeight;", "()V", "direction", "Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Direction;", "getDirection", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Direction;", "setDirection", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Direction;)V", "fatten", "", "getFatten", "()D", "setFatten", "(D)V", "intercept", "getIntercept", "setIntercept", "legendKeyElementFactory", "Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "getLegendKeyElementFactory", "()Lorg/jetbrains/letsPlot/core/plot/base/render/LegendKeyElementFactory;", "slope", "getSlope", "setSlope", "buildHint", "", "lollipop", "Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Lollipop;", "helper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "targetCollector", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/GeomTargetCollector;", "colorsByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "", "Lorg/jetbrains/letsPlot/commons/values/Color;", "buildIntern", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "getBase", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "head", "heightSpan", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "p", "coordAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "resolution", "isDiscrete", "", "rangeIncludesZero", "aes", "widthSpan", "Companion", "Direction", "Lollipop", "plot-base"})
@SourceDebugExtension(value={"SMAP\nLollipopGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LollipopGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,210:1\n1054#2:211\n*S KotlinDebug\n*F\n+ 1 LollipopGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom\n*L\n63#1:211\n*E\n"})
public final class LollipopGeom
extends GeomBase
implements WithWidth,
WithHeight {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double fatten = 2.5;
    private double slope;
    private double intercept;
    @NotNull
    private Direction direction = DEF_DIRECTION;
    public static final double DEF_FATTEN = 2.5;
    public static final double DEF_SLOPE = 0.0;
    public static final double DEF_INTERCEPT = 0.0;
    @NotNull
    private static final Direction DEF_DIRECTION = Direction.ORTHOGONAL_TO_AXIS;
    public static final boolean HANDLES_GROUPS = false;

    public final double getFatten() {
        return this.fatten;
    }

    public final void setFatten(double d) {
        this.fatten = d;
    }

    public final double getSlope() {
        return this.slope;
    }

    public final void setSlope(double d) {
        this.slope = d;
    }

    public final double getIntercept() {
        return this.intercept;
    }

    public final void setIntercept(double d) {
        this.intercept = d;
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    public final void setDirection(@NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"<set-?>");
        this.direction = direction;
    }

    @Override
    @NotNull
    public LegendKeyElementFactory getLegendKeyElementFactory() {
        return new LollipopLegendKeyElementFactory(0.0, 0.0, 3, null);
    }

    @Override
    public boolean rangeIncludesZero(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return Intrinsics.areEqual(aes2, Aes.Companion.getY()) && this.slope == 0.0 && this.intercept == 0.0 && this.direction != Direction.ALONG_AXIS;
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper helper2 = new GeomHelper(pos, coord, ctx2);
        GeomTargetCollector targetCollector = this.getGeomTargetCollector(ctx2);
        Function1<DataPointAesthetics, List<Color>> colorsByDataPoint = HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.LOLLIPOP, ctx2);
        List lollipops = new ArrayList();
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            DoubleVector head;
            if (GeomUtil.INSTANCE.toLocation(p, Aes.Companion.getX(), Aes.Companion.getY()) == null) continue;
            DoubleVector base = this.getBase(head);
            double stickLength = Math.sqrt(Math.pow(head.getX() - base.getX(), 2) + Math.pow(head.getY() - base.getY(), 2));
            lollipops.add(new Lollipop(p, head, base, stickLength));
        }
        Iterable $this$sortedByDescending$iv = lollipops;
        boolean $i$f$sortedByDescending = false;
        for (Lollipop lollipop2 : CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a2, T b2) {
                Lollipop it = (Lollipop)b2;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getLength());
                it = (Lollipop)a2;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getLength()));
            }
        })) {
            SvgLineElement stick = lollipop2.createStick(helper2);
            if (stick != null) {
                root.add(stick);
            }
            root.add(lollipop2.createCandy(helper2));
            this.buildHint(lollipop2, helper2, targetCollector, colorsByDataPoint);
        }
    }

    private final void buildHint(Lollipop lollipop2, GeomHelper helper2, GeomTargetCollector targetCollector, Function1<? super DataPointAesthetics, ? extends List<Color>> colorsByDataPoint) {
        int n = lollipop2.getPoint().index();
        DoubleVector doubleVector = helper2.toClient(lollipop2.getHead(), lollipop2.getPoint());
        Intrinsics.checkNotNull((Object)doubleVector);
        GeomTargetCollector.DefaultImpls.addPoint$default(targetCollector, n, doubleVector, lollipop2.getCandyRadius(), new GeomTargetCollector.TooltipParams(null, null, null, (List)colorsByDataPoint.invoke((Object)lollipop2.getPoint()), 7, null), null, 16, null);
    }

    @Override
    @Nullable
    public DoubleSpan widthSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        DoubleVector doubleVector = GeomUtil.INSTANCE.toLocation(p, Aes.Companion.getX(), Aes.Companion.getY());
        if (doubleVector == null) {
            return null;
        }
        DoubleVector loc = doubleVector;
        DoubleVector head = loc.flipIf(Intrinsics.areEqual(coordAes, Aes.Companion.getY()));
        return new DoubleSpan(this.getBase(head).getX(), head.getX());
    }

    @Override
    @Nullable
    public DoubleSpan heightSpan(@NotNull DataPointAesthetics p, @NotNull Aes<Double> coordAes, double resolution, boolean isDiscrete) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter(coordAes, (String)"coordAes");
        DoubleVector doubleVector = GeomUtil.INSTANCE.toLocation(p, Aes.Companion.getX(), Aes.Companion.getY());
        if (doubleVector == null) {
            return null;
        }
        DoubleVector loc = doubleVector;
        DoubleVector head = loc.flipIf(Intrinsics.areEqual(coordAes, Aes.Companion.getX()));
        return new DoubleSpan(this.getBase(head).getY(), head.getY());
    }

    private final DoubleVector getBase(DoubleVector head) {
        DoubleVector doubleVector;
        switch (WhenMappings.$EnumSwitchMapping$0[this.direction.ordinal()]) {
            case 1: {
                doubleVector = new DoubleVector(head.getX(), this.slope * head.getX() + this.intercept);
                break;
            }
            case 2: {
                if (this.slope == 0.0) {
                    doubleVector = new DoubleVector(this.intercept, head.getY());
                    break;
                }
                doubleVector = new DoubleVector((head.getY() - this.intercept) / this.slope, head.getY());
                break;
            }
            case 3: {
                double baseX = (head.getX() + this.slope * (head.getY() - this.intercept)) / (1.0 + Math.pow(this.slope, 2));
                double baseY = this.slope * baseX + this.intercept;
                doubleVector = new DoubleVector(baseX, baseY);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Companion;", "", "()V", "DEF_DIRECTION", "Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Direction;", "getDEF_DIRECTION", "()Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Direction;", "DEF_FATTEN", "", "DEF_INTERCEPT", "DEF_SLOPE", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Direction getDEF_DIRECTION() {
            return DEF_DIRECTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Direction;", "", "(Ljava/lang/String;I)V", "ORTHOGONAL_TO_AXIS", "ALONG_AXIS", "SLOPE", "plot-base"})
    public static final class Direction
    extends Enum<Direction> {
        public static final /* enum */ Direction ORTHOGONAL_TO_AXIS = new Direction();
        public static final /* enum */ Direction ALONG_AXIS = new Direction();
        public static final /* enum */ Direction SLOPE = new Direction();
        private static final /* synthetic */ Direction[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Direction[] values() {
            return (Direction[])$VALUES.clone();
        }

        public static Direction valueOf(String value) {
            return Enum.valueOf(Direction.class, value);
        }

        @NotNull
        public static EnumEntries<Direction> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = directionArray = new Direction[]{Direction.ORTHOGONAL_TO_AXIS, Direction.ALONG_AXIS, Direction.SLOPE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\bH\u0002R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom$Lollipop;", "", "point", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "head", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "base", "length", "", "(Lorg/jetbrains/letsPlot/core/plot/base/geom/LollipopGeom;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;D)V", "getBase", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "candyRadius", "getCandyRadius", "()D", "getHead", "getLength", "getPoint", "()Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "createCandy", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "helper", "Lorg/jetbrains/letsPlot/core/plot/base/geom/util/GeomHelper;", "createStick", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgLineElement;", "shiftHeadToBase", "clientBase", "clientHead", "shiftLength", "plot-base"})
    private final class Lollipop {
        @NotNull
        private final DataPointAesthetics point;
        @NotNull
        private final DoubleVector head;
        @NotNull
        private final DoubleVector base;
        private final double length;

        public Lollipop(@NotNull DataPointAesthetics point2, @NotNull DoubleVector head, DoubleVector base, double length) {
            Intrinsics.checkNotNullParameter((Object)point2, (String)"point");
            Intrinsics.checkNotNullParameter((Object)head, (String)"head");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.point = point2;
            this.head = head;
            this.base = base;
            this.length = length;
        }

        @NotNull
        public final DataPointAesthetics getPoint() {
            return this.point;
        }

        @NotNull
        public final DoubleVector getHead() {
            return this.head;
        }

        @NotNull
        public final DoubleVector getBase() {
            return this.base;
        }

        public final double getLength() {
            return this.length;
        }

        public final double getCandyRadius() {
            PointShape shape;
            PointShape pointShape = this.point.shape();
            Intrinsics.checkNotNull((Object)pointShape);
            PointShape pointShape2 = shape = pointShape;
            double shapeCoeff = ((pointShape2 == NamedShape.STICK_PLUS ? true : pointShape2 == NamedShape.STICK_STAR) ? true : pointShape2 == NamedShape.STICK_CROSS) ? 0.0 : 1.0;
            return (shape.size(this.point, LollipopGeom.this.getFatten()) + shapeCoeff * shape.strokeWidth(this.point)) / 2.0;
        }

        @NotNull
        public final SvgGElement createCandy(@NotNull GeomHelper helper2) {
            Intrinsics.checkNotNullParameter((Object)helper2, (String)"helper");
            DoubleVector doubleVector = helper2.toClient(this.head, this.point);
            Intrinsics.checkNotNull((Object)doubleVector);
            DoubleVector location2 = doubleVector;
            PointShape pointShape = this.point.shape();
            Intrinsics.checkNotNull((Object)pointShape);
            PointShape shape = pointShape;
            SvgSlimObject o = PointShapeSvg.create$default(PointShapeSvg.INSTANCE, shape, location2, this.point, LollipopGeom.this.getFatten(), false, 16, null);
            return GeomBase.Companion.wrap(o);
        }

        @Nullable
        public final SvgLineElement createStick(@NotNull GeomHelper helper2) {
            Intrinsics.checkNotNullParameter((Object)helper2, (String)"helper");
            DoubleVector doubleVector = helper2.toClient(this.base, this.point);
            if (doubleVector == null) {
                return null;
            }
            DoubleVector clientBase = doubleVector;
            DoubleVector doubleVector2 = helper2.toClient(this.head, this.point);
            if (doubleVector2 == null) {
                return null;
            }
            DoubleVector clientHead = doubleVector2;
            double stickLength = Math.sqrt(Math.pow(clientHead.getX() - clientBase.getX(), 2) + Math.pow(clientHead.getY() - clientBase.getY(), 2));
            if (this.getCandyRadius() > stickLength) {
                return null;
            }
            DoubleVector neck = this.shiftHeadToBase(clientBase, clientHead, this.getCandyRadius());
            SvgLineElement line2 = new SvgLineElement(clientBase.getX(), clientBase.getY(), neck.getX(), neck.getY());
            GeomHelper.Companion.decorate$default(GeomHelper.Companion, line2, this.point, true, (Function1)new Function1<DataPointAesthetics, Double>((Object)AesScaling.INSTANCE){

                @NotNull
                public final Double invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((AesScaling)this.receiver).lineWidth(p0);
                }
            }, false, 16, null);
            return line2;
        }

        private final DoubleVector shiftHeadToBase(DoubleVector clientBase, DoubleVector clientHead, double shiftLength) {
            double x0 = clientBase.getX();
            double x1 = clientHead.getX();
            double y0 = clientBase.getY();
            double y1 = clientHead.getY();
            if (x0 == x1) {
                double dy = y0 < y1 ? -shiftLength : shiftLength;
                return new DoubleVector(x1, y1 + dy);
            }
            double dx = Math.sqrt(Math.pow(shiftLength, 2) / (1.0 + Math.pow(y0 - y1, 2) / Math.pow(x0 - x1, 2)));
            double x2 = x0 < x1 ? x1 - dx : x1 + dx;
            double y2 = (x2 - x1) * (y0 - y1) / (x0 - x1) + y1;
            return new DoubleVector(x2, y2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.ORTHOGONAL_TO_AXIS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.ALONG_AXIS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.SLOPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

