/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.BasicElementTypeProvider;
import com.intellij.lang.javascript.BasicElementTypesSupplierService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.tree.IElementType;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/BasicElementTypeFactory;", "T", "Lcom/intellij/lang/javascript/BasicElementTypesSupplierService;", "", "serviceClass", "Lkotlin/reflect/KClass;", "<init>", "(Lkotlin/reflect/KClass;)V", "elementTypeProvider", "Lcom/intellij/lang/javascript/BasicElementTypeProvider;", "getElementTypeProvider", "()Lcom/intellij/lang/javascript/BasicElementTypeProvider;", "elementTypeProvider$delegate", "Lkotlin/Lazy;", "getElementType", "Lcom/intellij/psi/tree/IElementType;", "name", "", "intellij.javascript.parser"})
@ApiStatus.Internal
public final class BasicElementTypeFactory<T extends BasicElementTypesSupplierService> {
    @NotNull
    private final KClass<T> serviceClass;
    @NotNull
    private final Lazy elementTypeProvider$delegate;

    public BasicElementTypeFactory(@NotNull KClass<T> serviceClass) {
        Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
        this.serviceClass = serviceClass;
        this.elementTypeProvider$delegate = LazyKt.lazy(() -> BasicElementTypeFactory.elementTypeProvider_delegate$lambda$0(this));
    }

    private final BasicElementTypeProvider getElementTypeProvider() {
        Lazy lazy = this.elementTypeProvider$delegate;
        return (BasicElementTypeProvider)lazy.getValue();
    }

    @NotNull
    public final IElementType getElementType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IElementType iElementType = this.getElementTypeProvider().get(name);
        if (iElementType == null) {
            throw new IllegalStateException(("Unknown element type: " + name).toString());
        }
        return iElementType;
    }

    private static final BasicElementTypeProvider elementTypeProvider_delegate$lambda$0(BasicElementTypeFactory this$0) {
        return ((BasicElementTypesSupplierService)ApplicationManager.getApplication().getService(JvmClassMappingKt.getJavaClass(this$0.serviceClass))).get();
    }
}

