/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules.imports.filter;

import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.filter.JSImportCandidatesFilter;
import com.intellij.lang.javascript.modules.imports.filter.SimilarModulesFilterKt;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.psi.PsiElement;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/SimilarModulesFilter;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "candidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "<init>", "(Ljava/util/List;)V", "dtsDuplicates", "", "uniqueModuleNamesForSymbols", "", "", "uniqueModuleNamesForModules", "accept", "", "candidate", "Factory", "intellij.javascript.impl"})
public final class SimilarModulesFilter
implements JSImportCandidatesFilter {
    @NotNull
    private final Set<JSImportCandidate> dtsDuplicates;
    @NotNull
    private final Set<String> uniqueModuleNamesForSymbols;
    @NotNull
    private final Set<String> uniqueModuleNamesForModules;

    public SimilarModulesFilter(@NotNull List<? extends JSImportCandidate> candidates) {
        Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
        this.dtsDuplicates = SimilarModulesFilterKt.access$getDtsDuplicates(candidates);
        this.uniqueModuleNamesForSymbols = new LinkedHashSet();
        this.uniqueModuleNamesForModules = new LinkedHashSet();
    }

    @Override
    public boolean accept(@NotNull JSImportCandidate candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        JSImportDescriptor jSImportDescriptor = candidate.getDescriptor();
        if (jSImportDescriptor == null) {
            return true;
        }
        JSImportDescriptor descriptor = jSImportDescriptor;
        JSModuleDescriptor jSModuleDescriptor = descriptor.getModuleDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)jSModuleDescriptor, (String)"getModuleDescriptor(...)");
        JSModuleDescriptor moduleDescriptor = jSModuleDescriptor;
        PsiElement psiElement = candidate.getElement();
        if (psiElement == null) {
            return true;
        }
        PsiElement elementToImport = psiElement;
        if (this.dtsDuplicates.contains(candidate)) {
            return true;
        }
        String key = moduleDescriptor.getModuleName() + "#" + candidate.getName();
        if (elementToImport instanceof TypeScriptModule) {
            return this.uniqueModuleNamesForModules.add(key);
        }
        if (SimilarModulesFilterKt.access$isFromInternalModule(elementToImport)) {
            return true;
        }
        return this.uniqueModuleNamesForSymbols.add(key);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/lang/javascript/modules/imports/filter/SimilarModulesFilter$Factory;", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter$FilterFactory;", "<init>", "()V", "createFilter", "Lcom/intellij/lang/javascript/modules/imports/filter/JSImportCandidatesFilter;", "candidates", "", "Lcom/intellij/lang/javascript/modules/imports/JSImportCandidate;", "intellij.javascript.impl"})
    public static final class Factory
    implements JSImportCandidatesFilter.FilterFactory {
        @Override
        @Nullable
        public JSImportCandidatesFilter createFilter(@NotNull List<? extends JSImportCandidate> candidates) {
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            return candidates.size() > 1 ? (JSImportCandidatesFilter)new SimilarModulesFilter(candidates) : null;
        }
    }
}

