/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointUtil;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class NodeModulesIndexableFileNamesProvider {
    private static final ExtensionPointName<NodeModulesIndexableFileNamesProvider> EP_NAME = ExtensionPointName.create((String)"JavaScript.nodeModulesIndexableFileNamesProvider");
    @NotNull
    private static final ClearableLazyValue<Map<DependencyKind, Pair<String[], String[]>>> INFOS = ExtensionPointUtil.dropLazyValueOnChange((ClearableLazyValue)ClearableLazyValue.createAtomic(() -> {
        List providers = EP_NAME.getExtensionList();
        EnumMap<DependencyKind, Pair> extensionsMap = new EnumMap<DependencyKind, Pair>(DependencyKind.class);
        for (DependencyKind value : DependencyKind.values()) {
            HashSet<String> extensions = new HashSet<String>();
            HashSet<String> fileNames = new HashSet<String>();
            for (NodeModulesIndexableFileNamesProvider provider : providers) {
                extensions.addAll(provider.getIndexableExtensions(value));
                fileNames.addAll(provider.getIndexableFileNames(value));
            }
            extensionsMap.put(value, new Pair((Object)ArrayUtilRt.toStringArray(extensions), (Object)ArrayUtilRt.toStringArray(fileNames)));
        }
        return extensionsMap;
    }), EP_NAME, null);

    public static boolean isIndexableFileName(@NotNull CharSequence name, @NotNull DependencyKind kind) {
        if (name == null) {
            NodeModulesIndexableFileNamesProvider.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            NodeModulesIndexableFileNamesProvider.$$$reportNull$$$0(1);
        }
        Map value = (Map)INFOS.getValue();
        Pair extensionsAndFileNames = (Pair)value.get((Object)kind);
        String[] extensions = (String[])extensionsAndFileNames.first;
        for (int i = 0; i < extensions.length; ++i) {
            if (!StringUtil.endsWith((CharSequence)name, (CharSequence)extensions[i])) continue;
            return true;
        }
        String[] fileNames = (String[])extensionsAndFileNames.second;
        for (int i = 0; i < fileNames.length; ++i) {
            if (!StringUtil.equals((CharSequence)fileNames[i], (CharSequence)name)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected List<String> getIndexableExtensions(@NotNull DependencyKind kind) {
        if (kind == null) {
            NodeModulesIndexableFileNamesProvider.$$$reportNull$$$0(2);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            NodeModulesIndexableFileNamesProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    protected List<String> getIndexableFileNames(@NotNull DependencyKind kind) {
        if (kind == null) {
            NodeModulesIndexableFileNamesProvider.$$$reportNull$$$0(4);
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            NodeModulesIndexableFileNamesProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/NodeModulesIndexableFileNamesProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/NodeModulesIndexableFileNamesProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableExtensions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexableFileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isIndexableFileName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableExtensions";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIndexableFileNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5 -> new IllegalStateException(string);
        };
    }

    public static enum DependencyKind {
        DIRECT,
        INDIRECT,
        DIRECT_TYPINGS,
        INDIRECT_TYPINGS;

    }
}

