/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.highlighting.IntentionAndInspectionFilter;
import com.intellij.lang.javascript.psi.JSDocOwner;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSSuppressionHolder;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInspectionSuppressor
implements InspectionSuppressor {
    public boolean isSuppressedFor(@NotNull PsiElement element2, @NotNull String toolId) {
        if (element2 == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(0);
        }
        if (toolId == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(1);
        }
        return !IntentionAndInspectionFilter.isInspectionSupportedForElement(toolId, element2) || JSAnalysisHandlersFactory.forElement(element2).getInspectionSuppressor().isSuppressedFor(element2, toolId);
    }

    public SuppressQuickFix @NotNull [] getSuppressActions(@Nullable PsiElement element2, @NotNull String toolId) {
        if (toolId == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(2);
        }
        SuppressQuickFix[] suppressQuickFixArray = JSAnalysisHandlersFactory.forElement(element2).getInspectionSuppressor().getSuppressActions(element2, toolId);
        if (suppressQuickFixArray == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(3);
        }
        return suppressQuickFixArray;
    }

    @Nullable
    public static JSSuppressionHolder getHolderElement(@Nullable PsiElement element2, @NotNull Class<? extends JSSuppressionHolder> holderClass) {
        PsiElement parent;
        JSSuppressionHolder holder;
        if (holderClass == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(4);
        }
        if ((holder = (JSSuppressionHolder)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element2, (Class[])new Class[]{holderClass})) instanceof JSVarStatement && (parent = holder.getParent()) instanceof JSVariableDeclaringScope && parent instanceof JSSuppressionHolder) {
            holder = (JSSuppressionHolder)parent;
        }
        return holder;
    }

    @NotNull
    public static Class<? extends JSSuppressionHolder> getHolderClass(@Nullable PsiElement element2) {
        return JSInspectionSuppressor.getHolderClass(element2, JSSuppressionHolder.class);
    }

    @NotNull
    public static Class<? extends JSSuppressionHolder> getHolderClass(@Nullable PsiElement element2, @NotNull Class<? extends JSSuppressionHolder> holderClass) {
        JSSuppressionHolder holder;
        if (holderClass == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(5);
        }
        Class<JSSuppressionHolder> clazz = (holder = JSInspectionSuppressor.getHolderElement(element2, holderClass)) != null ? holder.getClass() : holderClass;
        if (clazz == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(6);
        }
        return clazz;
    }

    @NotNull
    public static PsiElement getContainerToAnnotate(@NotNull JSSuppressionHolder holder) {
        if (holder == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(7);
        }
        JSSuppressionHolder container = holder instanceof JSExpression ? PsiTreeUtil.getParentOfType((PsiElement)holder, JSStatement.class) : holder;
        PsiElement psiElement = (PsiElement)ObjectUtils.coalesce((Object)container, (Object)holder);
        if (psiElement == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(8);
        }
        return psiElement;
    }

    public static boolean isSuppressedForElement(@Nullable PsiElement element2, @NotNull String toolId) {
        if (toolId == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(9);
        }
        return JSInspectionSuppressor.isSuppressedForElement(element2, toolId, JSSuppressionHolder.class);
    }

    public static boolean isSuppressedForElement(@Nullable PsiElement element2, @NotNull String toolId, @NotNull Class<? extends JSSuppressionHolder> holderClass) {
        if (toolId == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(10);
        }
        if (holderClass == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(11);
        }
        List<PsiComment> comments = JSInspectionSuppressor.extractCommentsFromHolder(element2, holderClass);
        for (PsiComment comment : comments) {
            String text = comment.getText();
            Matcher matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text);
            if (!matcher.matches() || !SuppressionUtil.isInspectionToolIdMentioned((String)matcher.group(1), (String)toolId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<PsiComment> extractCommentsFromHolder(@Nullable PsiElement element2, @NotNull Class<? extends JSSuppressionHolder> holderClass) {
        JSSuppressionHolder holder;
        if (holderClass == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(12);
        }
        if ((holder = JSInspectionSuppressor.getHolderElement(element2, holderClass)) == null) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                JSInspectionSuppressor.$$$reportNull$$$0(13);
            }
            return list;
        }
        if (holder instanceof JSFile) {
            return JSInspectionSuppressor.getSuppressCandidatesForFile((JSFile)holder);
        }
        PsiElement containerToAnnotate = JSInspectionSuppressor.getContainerToAnnotate(holder);
        PsiElement beforeContainer = PsiTreeUtil.skipWhitespacesBackward((PsiElement)containerToAnnotate);
        PsiElement afterDocComment = null;
        if (containerToAnnotate instanceof JSDocOwner && ((JSDocOwner)containerToAnnotate).hasJSDoc()) {
            JSDocComment docComment = JSDocumentationUtils.findOwnDocComment(containerToAnnotate);
            afterDocComment = PsiTreeUtil.skipWhitespacesForward((PsiElement)docComment);
        }
        if (!(beforeContainer instanceof PsiComment) && !(afterDocComment instanceof PsiComment)) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                JSInspectionSuppressor.$$$reportNull$$$0(14);
            }
            return list;
        }
        ArrayList<PsiComment> result2 = new ArrayList<PsiComment>(2);
        if (beforeContainer instanceof PsiComment) {
            result2.add((PsiComment)beforeContainer);
        }
        if (afterDocComment instanceof PsiComment) {
            result2.add((PsiComment)afterDocComment);
        }
        ArrayList<PsiComment> arrayList = result2;
        if (arrayList == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(15);
        }
        return arrayList;
    }

    @NotNull
    public static List<PsiComment> getSuppressCandidatesForFile(@NotNull JSFile container) {
        PsiElement nextSibling;
        PsiElement child;
        if (container == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(16);
        }
        if ((child = container.getFirstChild()) instanceof PsiWhiteSpace && JSInspectionSuppressor.isAllowedElementBeforeFileSuppressComment(child)) {
            child = child.getNextSibling();
        }
        if (!(child instanceof PsiComment)) {
            List<PsiComment> list = Collections.emptyList();
            if (list == null) {
                JSInspectionSuppressor.$$$reportNull$$$0(17);
            }
            return list;
        }
        ArrayList<PsiComment> comments = new ArrayList<PsiComment>();
        while (JSInspectionSuppressor.isAllowedElementBeforeFileSuppressComment(child)) {
            if (child instanceof PsiComment) {
                comments.add((PsiComment)child);
            }
            child = child.getNextSibling();
        }
        if (!comments.isEmpty() && (nextSibling = comments.get(comments.size() - 1).getNextSibling()) instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)nextSibling.getText(), (char)'\n') <= 1) {
            comments.remove(comments.size() - 1);
        }
        ArrayList<PsiComment> arrayList = comments;
        if (arrayList == null) {
            JSInspectionSuppressor.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    public static boolean isAllowedElementBeforeFileSuppressComment(PsiElement anchor) {
        return anchor instanceof PsiComment && !anchor.textContains('\n') || anchor instanceof PsiWhiteSpace && StringUtil.countChars((CharSequence)anchor.getText(), (char)'\n') <= 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6, 8, 13, 14, 15, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSInspectionSuppressor";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holderClass";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSInspectionSuppressor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHolderClass";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerToAnnotate";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "extractCommentsFromHolder";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressCandidatesForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressActions";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHolderElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getHolderClass";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainerToAnnotate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressedForElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "extractCommentsFromHolder";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressCandidatesForFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6, 8, 13, 14, 15, 17, 18 -> new IllegalStateException(string);
        };
    }
}

