/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSConstStatusOwner;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.TypeScriptMergedTypeImplicitElement;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSConstantReassignmentInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSConstantReassignmentInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            JSConstantReassignmentInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(){

            @Override
            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                ReadWriteAccessDetector.Access expressionAccess;
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!JSResolveUtil.isSelfReference((PsiElement)node) && (expressionAccess = JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)node)) != ReadWriteAccessDetector.Access.Read) {
                    JSConstantReassignmentInspection.checkAssignmentToConst(node, holder);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSConstantReassignmentInspection$1", "visitJSReferenceExpression"));
            }
        };
    }

    private static boolean isConstAssignable(@NotNull JSReferenceExpression node, PsiElement resolved) {
        JSExecutionScope contextParent;
        JSAttributeList attributeList;
        if (node == null) {
            JSConstantReassignmentInspection.$$$reportNull$$$0(2);
        }
        if (DialectDetector.isActionScript(resolved)) {
            return false;
        }
        if (resolved instanceof JSParameter && (attributeList = ((JSParameter)resolved).getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.READONLY)) {
            JSFunction ctor = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)resolved, (Class[])new Class[]{JSFunction.class});
            while (ctor != null && !ctor.isConstructor()) {
                ctor = (JSFunction)PsiTreeUtil.getContextOfType((PsiElement)ctor, JSFunction.class, (boolean)true, (Class[])new Class[]{JSClass.class});
            }
            if (ctor != null && PsiTreeUtil.isContextAncestor((PsiElement)ctor, (PsiElement)node, (boolean)true)) {
                return true;
            }
        }
        if (JSResolveUtil.isSameReference(node, resolved)) {
            return true;
        }
        return node.getQualifier() instanceof JSThisExpression && JSResolveUtil.isConstructorFunction(contextParent = (JSExecutionScope)PsiTreeUtil.getParentOfType((PsiElement)node, JSExecutionScope.class));
    }

    private static void checkAssignmentToConst(@NotNull JSReferenceExpression node, @NotNull ProblemsHolder holder) {
        ResolveResult[] results;
        ResolveResult[] resolveResultArray;
        int n;
        int n2;
        PsiElement resolved;
        if (node == null) {
            JSConstantReassignmentInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            JSConstantReassignmentInspection.$$$reportNull$$$0(4);
        }
        if ((resolved = node.resolve()) == null && DialectDetector.isTypeScript((PsiElement)node) && (n2 = 0) < (n = (resolveResultArray = (results = node.multiResolve(false))).length)) {
            ResolveResult result2 = resolveResultArray[n2];
            if (!result2.isValidResult()) {
                return;
            }
            PsiElement element2 = result2.getElement();
            if (!(element2 instanceof TypeScriptMergedTypeImplicitElement)) {
                return;
            }
            resolved = element2;
        }
        if (JSConstantReassignmentInspection.isConst(node, resolved)) {
            if (JSConstantReassignmentInspection.isConstAssignable(node, resolved)) {
                return;
            }
            Object place = node.getReferenceNameElement();
            if (place == null) {
                place = node;
            }
            LocalQuickFix quickFix = JSConstantReassignmentInspection.getQuickFix(resolved);
            holder.registerProblem(place, JavaScriptBundle.message("javascript.validation.message.assignment.to.const", new Object[0]), ProblemHighlightType.GENERIC_ERROR, LocalQuickFix.notNullElements((LocalQuickFix)quickFix));
        }
    }

    @Nullable
    private static LocalQuickFix getQuickFix(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSConstantReassignmentInspection.$$$reportNull$$$0(5);
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element2.getProject()).getFileIndex();
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)element2);
        if (file == null || index.isInLibrary(file) || JSLibraryUtil.isProbableLibraryFile(file)) {
            return null;
        }
        if (element2 instanceof TypeScriptField) {
            TypeScriptField typeScriptField = (TypeScriptField)element2;
            JSAttributeList attributeList = typeScriptField.getAttributeList();
            if (attributeList == null || !attributeList.hasModifier(JSAttributeList.ModifierType.READONLY)) {
                return null;
            }
            return JSFixFactory.getInstance().removeReadonlyModifierFix(typeScriptField);
        }
        if (element2 instanceof JSVariable) {
            JSVariable jsVariable = (JSVariable)element2;
            PsiElement parent = JSDestructuringUtil.getParentSkippingDestructuring(jsVariable);
            if (!(parent instanceof JSVarStatementBase)) {
                return null;
            }
            JSVarStatementBase varStatementBase = (JSVarStatementBase)parent;
            JSVarStatement.VarKeyword keyword = varStatementBase.getVarKeyword();
            if (keyword != JSVarStatement.VarKeyword.CONST) {
                return null;
            }
            return LocalQuickFix.from((ModCommandAction)new ReplaceConstWithLetKeywordFix(jsVariable));
        }
        return null;
    }

    @Contract(value="_, null -> false")
    private static boolean isConst(@NotNull JSReferenceExpression expression, @Nullable PsiElement resolved) {
        if (expression == null) {
            JSConstantReassignmentInspection.$$$reportNull$$$0(6);
        }
        if (resolved == null) {
            return false;
        }
        if (DialectDetector.isTypeScript((PsiElement)expression) || DialectDetector.isActionScript((PsiElement)expression)) {
            return resolved instanceof JSConstStatusOwner && ((JSConstStatusOwner)resolved).isConst();
        }
        if (resolved instanceof JSVariable) {
            return ((JSVariable)resolved).isConst();
        }
        if (resolved instanceof JSImplicitElement) {
            return ((JSImplicitElement)resolved).isConst();
        }
        if (resolved instanceof JSFunction) {
            return !(resolved instanceof JSFunctionExpression) && !JSPsiImplUtils.isGetterOrSetter((JSFunction)resolved) && JSReadWriteAccessDetector.ourInstance.getExpressionAccess((PsiElement)expression) == ReadWriteAccessDetector.Access.ReadWrite;
        }
        if ((resolved instanceof JSDefinitionExpression || resolved instanceof JSProperty) && DialectDetector.isJavaScript(resolved)) {
            JSDocComment comment = JSStubBasedPsiTreeUtil.findDocComment(resolved);
            return comment != null && comment.hasConstTag();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConstantReassignmentInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstAssignable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAssignmentToConst";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getQuickFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isConst";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ReplaceConstWithLetKeywordFix
    extends PsiUpdateModCommandAction<JSVariable> {
        ReplaceConstWithLetKeywordFix(@NotNull JSVariable variable) {
            if (variable == null) {
                ReplaceConstWithLetKeywordFix.$$$reportNull$$$0(0);
            }
            super((PsiElement)variable);
        }

        @Nullable
        protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull JSVariable element2) {
            if (context2 == null) {
                ReplaceConstWithLetKeywordFix.$$$reportNull$$$0(1);
            }
            if (element2 == null) {
                ReplaceConstWithLetKeywordFix.$$$reportNull$$$0(2);
            }
            return Presentation.of((String)JavaScriptBundle.message("javascript.validation.message.assignment.to.const.fix.replace", new Object[0]));
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message("javascript.validation.message.assignment.to.const", new Object[0]);
            if (string == null) {
                ReplaceConstWithLetKeywordFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        protected void invoke(@NotNull ActionContext context2, @NotNull JSVariable nodeToUpdate, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (context2 == null) {
                ReplaceConstWithLetKeywordFix.$$$reportNull$$$0(4);
            }
            if (nodeToUpdate == null) {
                ReplaceConstWithLetKeywordFix.$$$reportNull$$$0(5);
            }
            if (updater == null) {
                ReplaceConstWithLetKeywordFix.$$$reportNull$$$0(6);
            }
            if (!((parent = JSDestructuringUtil.getParentSkippingDestructuring(nodeToUpdate)) instanceof JSVarStatement)) {
                return;
            }
            ASTNode constKeyword = parent.getNode().findChildByType(JSTokenTypes.CONST_KEYWORD);
            if (constKeyword == null) {
                return;
            }
            PsiElement letKeyword = JSChangeUtil.createTokenElement((PsiElement)nodeToUpdate, JSTokenTypes.LET_KEYWORD, "let");
            constKeyword.getPsi().replace(letKeyword);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSConstantReassignmentInspection$ReplaceConstWithLetKeywordFix";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nodeToUpdate";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSConstantReassignmentInspection$ReplaceConstWithLetKeywordFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentation";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

