/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.impl.JsTestFileInfo;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"isEligibleTestFileFast", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isEligibleTestFile", "isTestFile", "project", "Lcom/intellij/openapi/project/Project;", "intellij.javascript.impl"})
public final class JsTestFileUtilsKt {
    private static final boolean isEligibleTestFileFast(VirtualFile file) {
        return file.isValid() && !file.isDirectory() && file.isInLocalFileSystem();
    }

    public static final boolean isEligibleTestFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!JsTestFileUtilsKt.isEligibleTestFileFast(file)) {
            return false;
        }
        if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)0x100000L)) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!JsTestFileInfo.Companion.isTestFileName(string)) {
                return false;
            }
        }
        return !JSLibraryUtil.isProbableLibraryFile(file) && !TypeScriptUtil.isDefinitionFile(file);
    }

    public static final boolean isTestFile(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!JsTestFileUtilsKt.isEligibleTestFileFast(file)) {
            return false;
        }
        PsiFile psiFile = (PsiFile)ReadAction.compute(() -> JsTestFileUtilsKt.isTestFile$lambda$0(project, file));
        if (psiFile instanceof JSFile) {
            return ((JSFile)psiFile).isTestFile();
        }
        return false;
    }

    private static final PsiFile isTestFile$lambda$0(Project $project, VirtualFile $file) {
        return PsiManager.getInstance((Project)$project).findFile($file);
    }
}

