/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.highlighting.highlight;

import com.intellij.docker.dockerFile.highlighting.highlight.DockerSyntaxHighlighterColors;
import com.intellij.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.docker.dockerFile.parser.psi.DockerFileExposeCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.docker.dockerFile.parser.psi.DockerFileRegularOption;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiDeclaration;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiVariableReference;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

final class DockerColorAnnotator
implements Annotator,
DumbAware {
    private static final String AS_PSEUDO_KEYWORD = "AS";
    private static final Pattern portRegex = Pattern.compile("\\d+");
    private static final Pattern portRangeRegex = Pattern.compile("\\d+-\\d+");

    DockerColorAnnotator() {
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            DockerColorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof DockerPsiVariableReference) {
            DockerColorAnnotator.annotatePsiNameReference((DockerPsiVariableReference)element, holder);
        } else if (element instanceof DockerPsiDeclaration) {
            DockerColorAnnotator.annotatePsiDeclaration((DockerPsiDeclaration)element, holder);
        } else if (element instanceof DockerFileRegularOption) {
            DockerColorAnnotator.annotateRegularOption((DockerFileRegularOption)element, holder);
        } else if (element instanceof DockerFileExposeCommand) {
            DockerColorAnnotator.annotateExposePortNumber((DockerFileExposeCommand)element, holder);
        } else if (DockerColorAnnotator.isPseudoKeywordAs(element)) {
            DockerColorAnnotator.annotatePseudoKeyword(holder);
        }
    }

    private static boolean isPseudoKeywordAs(@NotNull PsiElement psi) {
        if (psi == null) {
            DockerColorAnnotator.$$$reportNull$$$0(2);
        }
        return psi.getNode().getElementType() == DockerTokenTypes.IDENTIFIER && StringUtil.equals((CharSequence)psi.getText(), (CharSequence)AS_PSEUDO_KEYWORD) && PsiTreeUtil.getParentOfType((PsiElement)psi, DockerFileFromCommand.class) != null;
    }

    private static void annotatePseudoKeyword(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(3);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(DockerSyntaxHighlighterColors.KEYWORD).create();
    }

    private static void annotatePsiNameReference(@NotNull DockerPsiVariableReference reference, @NotNull AnnotationHolder holder) {
        PsiElement referencedName;
        if (reference == null) {
            DockerColorAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(5);
        }
        if ((referencedName = reference.getReferencedName()) == null) {
            return;
        }
        if (!DumbService.isDumb((Project)reference.getProject()) && reference.resolve() == null) {
            holder.newAnnotation(HighlightSeverity.WEAK_WARNING, DockerBundle.message((String)"DockerColorAnnotator.unresolvedVariableRef", (Object[])new Object[]{referencedName.getText()})).range(referencedName).textAttributes(DockerSyntaxHighlighterColors.VARIABLE).create();
        } else {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(referencedName).textAttributes(DockerSyntaxHighlighterColors.VARIABLE).create();
        }
    }

    private static void annotateRegularOption(@NotNull DockerFileRegularOption referenceHost, @NotNull AnnotationHolder holder) {
        PsiReference reference;
        if (referenceHost == null) {
            DockerColorAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(7);
        }
        if ((reference = referenceHost.getReference()) == null) {
            return;
        }
        TextRange referencingRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset());
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(referencingRange).textAttributes(DockerSyntaxHighlighterColors.VARIABLE).create();
    }

    private static void annotatePsiDeclaration(@NotNull DockerPsiDeclaration declaration, @NotNull AnnotationHolder holder) {
        if (declaration == null) {
            DockerColorAnnotator.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(9);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(declaration.getDeclaredName()).textAttributes(DockerSyntaxHighlighterColors.VARIABLE).create();
    }

    private static void annotateExposePortNumber(@NotNull DockerFileExposeCommand command, @NotNull AnnotationHolder holder) {
        if (command == null) {
            DockerColorAnnotator.$$$reportNull$$$0(10);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(11);
        }
        for (PsiElement elem = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)command.getFirstChild()); elem != null; elem = elem.getNextSibling()) {
            if (elem.getNode().getElementType() != DockerTokenTypes.IDENTIFIER) continue;
            String text = elem.getText();
            TextRange range = elem.getTextRange();
            if (portRegex.matcher(text).matches()) {
                DockerColorAnnotator.highlightNumber(holder, range);
                continue;
            }
            if (!portRangeRegex.matcher(text).matches()) continue;
            int idx = text.indexOf(45);
            int startOffset = range.getStartOffset();
            DockerColorAnnotator.highlightNumber(holder, new TextRange(startOffset, startOffset + idx));
            DockerColorAnnotator.highlightNumber(holder, new TextRange(startOffset + idx + 1, range.getEndOffset()));
        }
    }

    private static void highlightNumber(@NotNull AnnotationHolder holder, @NotNull TextRange range) {
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(12);
        }
        if (range == null) {
            DockerColorAnnotator.$$$reportNull$$$0(13);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(range).textAttributes(DockerSyntaxHighlighterColors.NUMBER).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceHost";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/dockerFile/highlighting/highlight/DockerColorAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPseudoKeywordAs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePseudoKeyword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePsiNameReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateRegularOption";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePsiDeclaration";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateExposePortNumber";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightNumber";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

