/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.polyglot.impl;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.graalvm.polyglot.impl.UnnamedToModuleBridge;
import org.graalvm.polyglot.io.MessageEndpoint;

final class UnnamedToModuleMessageEndpointGen
extends UnnamedToModuleBridge.UnnamedToModuleMessageEndpoint {
    private static final Handles HANDLES;
    final Object receiver;

    public UnnamedToModuleMessageEndpointGen(Object receiver) {
        this.receiver = Objects.requireNonNull(receiver);
    }

    @Override
    public void sendBinary(ByteBuffer data_) {
        try {
            UnnamedToModuleMessageEndpointGen.HANDLES.sendBinary_.invoke(this.receiver, data_);
        }
        catch (Throwable t) {
            throw UnnamedToModuleMessageEndpointGen.handleException_(t);
        }
    }

    @Override
    public void sendClose() {
        try {
            UnnamedToModuleMessageEndpointGen.HANDLES.sendClose_.invoke(this.receiver);
        }
        catch (Throwable t) {
            throw UnnamedToModuleMessageEndpointGen.handleException_(t);
        }
    }

    @Override
    public void sendPing(ByteBuffer data_) {
        try {
            UnnamedToModuleMessageEndpointGen.HANDLES.sendPing_.invoke(this.receiver, data_);
        }
        catch (Throwable t) {
            throw UnnamedToModuleMessageEndpointGen.handleException_(t);
        }
    }

    @Override
    public void sendPong(ByteBuffer data_) {
        try {
            UnnamedToModuleMessageEndpointGen.HANDLES.sendPong_.invoke(this.receiver, data_);
        }
        catch (Throwable t) {
            throw UnnamedToModuleMessageEndpointGen.handleException_(t);
        }
    }

    @Override
    public void sendText(String text_) {
        try {
            UnnamedToModuleMessageEndpointGen.HANDLES.sendText_.invoke(this.receiver, text_);
        }
        catch (Throwable t) {
            throw UnnamedToModuleMessageEndpointGen.handleException_(t);
        }
    }

    private static <T extends Throwable> RuntimeException handleException_(Throwable t) throws T {
        throw t;
    }

    static {
        MethodHandles.Lookup lookup = UnnamedToModuleMessageEndpointGen.methodHandleLookup();
        if (lookup != null) {
            try {
                HANDLES = new Handles(lookup);
            }
            catch (ReflectiveOperationException e) {
                throw new InternalError("Failed to initialize method handles for module bridge.", e);
            }
        } else {
            HANDLES = null;
        }
    }

    static final class Handles {
        private final MethodHandle sendBinary_;
        private final MethodHandle sendClose_;
        private final MethodHandle sendPing_;
        private final MethodHandle sendPong_;
        private final MethodHandle sendText_;

        Handles(MethodHandles.Lookup lookup) throws ReflectiveOperationException {
            Class<?> typeMessageEndpoint = lookup.findClass(MessageEndpoint.class.getName());
            this.sendBinary_ = lookup.findVirtual(typeMessageEndpoint, "sendBinary", MethodType.methodType(Void.TYPE, List.of(ByteBuffer.class)));
            this.sendClose_ = lookup.findVirtual(typeMessageEndpoint, "sendClose", MethodType.methodType(Void.TYPE, List.of()));
            this.sendPing_ = lookup.findVirtual(typeMessageEndpoint, "sendPing", MethodType.methodType(Void.TYPE, List.of(ByteBuffer.class)));
            this.sendPong_ = lookup.findVirtual(typeMessageEndpoint, "sendPong", MethodType.methodType(Void.TYPE, List.of(ByteBuffer.class)));
            this.sendText_ = lookup.findVirtual(typeMessageEndpoint, "sendText", MethodType.methodType(Void.TYPE, List.of(String.class)));
        }
    }
}

