/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.colors;

import com.intellij.css.util.CssPsiUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.actions.colors.CssConvertColorIntention;
import com.intellij.psi.css.browse.ColorDeclarationType;
import com.intellij.psi.css.impl.util.CssPsiColorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public final class CssConvertToLchIntention
extends CssConvertColorIntention {
    public CssConvertToLchIntention() {
        super("lch()");
    }

    @Override
    @NotNull
    protected String convert(@NotNull Color color, @NotNull PsiElement context) {
        if (color == null) {
            CssConvertToLchIntention.$$$reportNull$$$0(0);
        }
        if (context == null) {
            CssConvertToLchIntention.$$$reportNull$$$0(1);
        }
        String string = CssPsiColorUtil.toLchColor(color);
        if (string == null) {
            CssConvertToLchIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected String getNewColorTypeName(boolean withAlphaChannel) {
        return "lch()";
    }

    @Override
    protected boolean isApplied(@NotNull ColorDeclarationType colorType, @NotNull Color color) {
        if (colorType == null) {
            CssConvertToLchIntention.$$$reportNull$$$0(3);
        }
        if (color == null) {
            CssConvertToLchIntention.$$$reportNull$$$0(4);
        }
        return colorType != ColorDeclarationType.LCH;
    }

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiElement colorTerm;
        if (project == null) {
            CssConvertToLchIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            CssConvertToLchIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            CssConvertToLchIntention.$$$reportNull$$$0(7);
        }
        if (!(colorTerm = CssConvertToLchIntention.getPossibleColorTerm(element)).getText().startsWith("oklch")) {
            super.invoke(project, editor, element);
        } else {
            PsiElement functionElement = CssPsiColorUtil.getColorFunctionElement(colorTerm);
            if (functionElement != null) {
                CssTermList termList = (CssTermList)PsiTreeUtil.getChildOfType((PsiElement)functionElement, CssTermList.class);
                if (termList != null) {
                    String oklchFunctionArguments = termList.getText();
                    double[] oklch = CssPsiColorUtil.getOklch(oklchFunctionArguments);
                    if (oklch != null) {
                        String color = CssPsiColorUtil.convertFromOklchToLch(oklch);
                        colorTerm.replace((PsiElement)CssElementFactory.getInstance(project).createTerm(color, CssPsiUtil.getStylesheetLanguage(colorTerm)));
                    }
                } else {
                    CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)CssBundle.message("css.intentions.color.convert.error", colorTerm.getText(), this.getNewColorTypeName(true)), (String)"", null);
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/actions/colors/CssConvertToLchIntention";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/actions/colors/CssConvertToLchIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isApplied";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

