/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.core.actions.analysis;

import com.intellij.diagram.util.DiagramAlgorithmsService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.uml.utils.DiagramBundle;
import java.util.concurrent.CompletableFuture;
import javax.swing.Action;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/uml/core/actions/analysis/DiagramMeasureCentralityDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myShowFuture", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/diagram/util/DiagramAlgorithmsService$CentralityMeasureType;", "myViewModel", "Lcom/intellij/uml/core/actions/analysis/DiagramMeasureCentralityDialog$MyViewModel;", "showAsync", "doOKAction", "", "doCancelAction", "createCenterPanel", "Ljavax/swing/JComponent;", "getOKAction", "Ljavax/swing/Action;", "MyViewModel", "intellij.diagram.impl"})
@SourceDebugExtension(value={"SMAP\nDiagramMeasureCentralityDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagramMeasureCentralityDialog.kt\ncom/intellij/uml/core/actions/analysis/DiagramMeasureCentralityDialog\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,121:1\n27#2:122\n*S KotlinDebug\n*F\n+ 1 DiagramMeasureCentralityDialog.kt\ncom/intellij/uml/core/actions/analysis/DiagramMeasureCentralityDialog\n*L\n106#1:122\n*E\n"})
public final class DiagramMeasureCentralityDialog
extends DialogWrapper {
    @NotNull
    private final CompletableFuture<DiagramAlgorithmsService.CentralityMeasureType> myShowFuture;
    @NotNull
    private final MyViewModel myViewModel;

    public DiagramMeasureCentralityDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.myShowFuture = new CompletableFuture();
        this.myViewModel = new MyViewModel(null, false, false, false, 15, null);
        this.init();
        this.setTitle(DiagramBundle.message("dialog.diagram.measure.centrality", new Object[0]));
    }

    @NotNull
    public final CompletableFuture<DiagramAlgorithmsService.CentralityMeasureType> showAsync() {
        ApplicationManager.getApplication().invokeLater(() -> DiagramMeasureCentralityDialog.showAsync$lambda$0(this));
        return this.myShowFuture;
    }

    protected void doOKAction() {
        super.doOKAction();
        this.myShowFuture.complete(this.myViewModel.getCentralityMeasureType());
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.myShowFuture.cancel(true);
    }

    @NotNull
    protected JComponent createCenterPanel() {
        DialogPanel contentPanel2 = BuilderKt.panel(arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13(this, arg_0));
        return (JComponent)contentPanel2;
    }

    @NotNull
    protected Action getOKAction() {
        Action action;
        Action action2 = super.getOKAction();
        Intrinsics.checkNotNullExpressionValue((Object)action2, (String)"getOKAction(...)");
        Action $this$getOKAction_u24lambda_u2414 = action = action2;
        boolean bl = false;
        $this$getOKAction_u24lambda_u2414.putValue("Name", DiagramBundle.message("dialog.diagram.centrality.measure.button.title", new Object[0]));
        return action;
    }

    private static final void showAsync$lambda$0(DiagramMeasureCentralityDialog this$0) {
        this$0.show();
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9$lambda$1(Ref.ObjectRef $numberOfConnectedEdgesCentrality, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.centrality.number.of.connected.edges", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $numberOfConnectedEdgesCentrality.element = Cell.comment$default((Cell)$this$row.radioButton(string, DiagramAlgorithmsService.CentralityMeasureType.DegreeCentrality.class), (String)DiagramBundle.message("dialog.diagram.centrality.number.of.connected.edges.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9$lambda$5$lambda$4$lambda$2(DiagramMeasureCentralityDialog this$0, Ref.ObjectRef $numberOfConnectedEdgesCentrality, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.centrality.edges.to.consider.incoming", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell2 = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.myViewModel){

            public Object get() {
                return ((MyViewModel)this.receiver).getConsiderIncomingEdges();
            }

            public void set(Object value) {
                ((MyViewModel)this.receiver).setConsiderIncomingEdges((Boolean)value);
            }
        }));
        if ($numberOfConnectedEdgesCentrality.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"numberOfConnectedEdgesCentrality");
            cell = null;
        } else {
            cell = (Cell)$numberOfConnectedEdgesCentrality.element;
        }
        cell2.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9$lambda$5$lambda$4$lambda$3(DiagramMeasureCentralityDialog this$0, Ref.ObjectRef $numberOfConnectedEdgesCentrality, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.centrality.edges.to.consider.outgoing", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell cell2 = ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.myViewModel){

            public Object get() {
                return ((MyViewModel)this.receiver).getConsiderOutgoingEdges();
            }

            public void set(Object value) {
                ((MyViewModel)this.receiver).setConsiderOutgoingEdges((Boolean)value);
            }
        }));
        if ($numberOfConnectedEdgesCentrality.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"numberOfConnectedEdgesCentrality");
            cell = null;
        } else {
            cell = (Cell)$numberOfConnectedEdgesCentrality.element;
        }
        cell2.enabledIf(ButtonKt.getSelected((Cell)cell));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9$lambda$5$lambda$4(DiagramMeasureCentralityDialog this$0, Ref.ObjectRef $numberOfConnectedEdgesCentrality, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$9$lambda$5$lambda$4$lambda$2(this$0, $numberOfConnectedEdgesCentrality, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$9$lambda$5$lambda$4$lambda$3(this$0, $numberOfConnectedEdgesCentrality, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9$lambda$5(DiagramMeasureCentralityDialog this$0, Ref.ObjectRef $numberOfConnectedEdgesCentrality, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        Panel.buttonsGroup$default((Panel)$this$indent, (String)DiagramBundle.message("dialog.diagram.centrality.edges.to.consider", new Object[0]), (boolean)false, arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$9$lambda$5$lambda$4(this$0, $numberOfConnectedEdgesCentrality, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9$lambda$6(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.centrality.graph.centrality", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)$this$row.radioButton(string, DiagramAlgorithmsService.CentralityMeasureType.GraphCentrality.class), (String)DiagramBundle.message("dialog.diagram.centrality.graph.centrality.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9$lambda$7(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.centrality.nodes.betweenness.centrality", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)$this$row.radioButton(string, DiagramAlgorithmsService.CentralityMeasureType.NodeBetweenness.class), (String)DiagramBundle.message("dialog.diagram.centrality.nodes.betweenness.centrality.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9$lambda$8(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.centrality.closeness.centrality", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell.comment$default((Cell)$this$row.radioButton(string, DiagramAlgorithmsService.CentralityMeasureType.ClosenessCentrality.class), (String)DiagramBundle.message("dialog.diagram.centrality.closeness.centrality.description", new Object[0]), (int)0, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$9(DiagramMeasureCentralityDialog this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Ref.ObjectRef numberOfConnectedEdgesCentrality = new Ref.ObjectRef();
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$9$lambda$1(numberOfConnectedEdgesCentrality, arg_0), (int)1, null);
        $this$buttonsGroup.indent(arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$9$lambda$5(this$0, numberOfConnectedEdgesCentrality, arg_0));
        Panel.row$default((Panel)$this$buttonsGroup, null, DiagramMeasureCentralityDialog::createCenterPanel$lambda$13$lambda$9$lambda$6, (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, DiagramMeasureCentralityDialog::createCenterPanel$lambda$13$lambda$9$lambda$7, (int)1, null);
        Panel.row$default((Panel)$this$buttonsGroup, null, DiagramMeasureCentralityDialog::createCenterPanel$lambda$13$lambda$9$lambda$8, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Class createCenterPanel$lambda$13$lambda$10(DiagramMeasureCentralityDialog this$0) {
        return this$0.myViewModel.getCentralityType();
    }

    private static final Unit createCenterPanel$lambda$13$lambda$11(DiagramMeasureCentralityDialog this$0, Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.myViewModel.setCentralityType(it);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$13$lambda$12(DiagramMeasureCentralityDialog this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = DiagramBundle.message("dialog.diagram.centrality.consider.edge.directions", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        ButtonKt.bindSelected((Cell)$this$row.checkBox(string), (KMutableProperty0)((KMutableProperty0)new MutablePropertyReference0Impl(this$0.myViewModel){

            public Object get() {
                return ((MyViewModel)this.receiver).getConsiderEdgeDirections();
            }

            public void set(Object value) {
                ((MyViewModel)this.receiver).setConsiderEdgeDirections((Boolean)value);
            }
        }));
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createCenterPanel$lambda$13(DiagramMeasureCentralityDialog this$0, Panel $this$panel) {
        void getter$iv;
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, (String)DiagramBundle.message("dialog.diagram.measure.centrality", new Object[0]), (boolean)false, arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$9(this$0, arg_0), (int)2, null);
        Function0 function0 = () -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$10(this$0);
        Function1 setter$iv = arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$11(this$0, arg_0);
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Class.class);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DiagramMeasureCentralityDialog.createCenterPanel$lambda$13$lambda$12(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B3\u0012\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0016\u001a\u00020\u0017J\r\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J5\u0010\u001c\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u001e\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/intellij/uml/core/actions/analysis/DiagramMeasureCentralityDialog$MyViewModel;", "", "centralityType", "Ljava/lang/Class;", "considerIncomingEdges", "", "considerOutgoingEdges", "considerEdgeDirections", "<init>", "(Ljava/lang/Class;ZZZ)V", "getCentralityType", "()Ljava/lang/Class;", "setCentralityType", "(Ljava/lang/Class;)V", "getConsiderIncomingEdges", "()Z", "setConsiderIncomingEdges", "(Z)V", "getConsiderOutgoingEdges", "setConsiderOutgoingEdges", "getConsiderEdgeDirections", "setConsiderEdgeDirections", "getCentralityMeasureType", "Lcom/intellij/diagram/util/DiagramAlgorithmsService$CentralityMeasureType;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.diagram.impl"})
    private static final class MyViewModel {
        @NotNull
        private Class<?> centralityType;
        private boolean considerIncomingEdges;
        private boolean considerOutgoingEdges;
        private boolean considerEdgeDirections;

        public MyViewModel(@NotNull Class<?> centralityType, boolean considerIncomingEdges, boolean considerOutgoingEdges, boolean considerEdgeDirections) {
            Intrinsics.checkNotNullParameter(centralityType, (String)"centralityType");
            this.centralityType = centralityType;
            this.considerIncomingEdges = considerIncomingEdges;
            this.considerOutgoingEdges = considerOutgoingEdges;
            this.considerEdgeDirections = considerEdgeDirections;
        }

        public /* synthetic */ MyViewModel(Class clazz, boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                clazz = DiagramAlgorithmsService.CentralityMeasureType.DegreeCentrality.class;
            }
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = true;
            }
            if ((n & 8) != 0) {
                bl3 = true;
            }
            this(clazz, bl, bl2, bl3);
        }

        @NotNull
        public final Class<?> getCentralityType() {
            return this.centralityType;
        }

        public final void setCentralityType(@NotNull Class<?> clazz) {
            Intrinsics.checkNotNullParameter(clazz, (String)"<set-?>");
            this.centralityType = clazz;
        }

        public final boolean getConsiderIncomingEdges() {
            return this.considerIncomingEdges;
        }

        public final void setConsiderIncomingEdges(boolean bl) {
            this.considerIncomingEdges = bl;
        }

        public final boolean getConsiderOutgoingEdges() {
            return this.considerOutgoingEdges;
        }

        public final void setConsiderOutgoingEdges(boolean bl) {
            this.considerOutgoingEdges = bl;
        }

        public final boolean getConsiderEdgeDirections() {
            return this.considerEdgeDirections;
        }

        public final void setConsiderEdgeDirections(boolean bl) {
            this.considerEdgeDirections = bl;
        }

        @NotNull
        public final DiagramAlgorithmsService.CentralityMeasureType getCentralityMeasureType() {
            DiagramAlgorithmsService.CentralityMeasureType centralityMeasureType;
            Class<?> clazz = this.centralityType;
            if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.CentralityMeasureType.DegreeCentrality.class)) {
                centralityMeasureType = new DiagramAlgorithmsService.CentralityMeasureType.DegreeCentrality(this.considerIncomingEdges, this.considerOutgoingEdges);
            } else if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.CentralityMeasureType.GraphCentrality.class)) {
                centralityMeasureType = new DiagramAlgorithmsService.CentralityMeasureType.GraphCentrality(this.considerEdgeDirections);
            } else if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.CentralityMeasureType.NodeBetweenness.class)) {
                centralityMeasureType = new DiagramAlgorithmsService.CentralityMeasureType.NodeBetweenness(this.considerEdgeDirections);
            } else if (Intrinsics.areEqual(clazz, DiagramAlgorithmsService.CentralityMeasureType.ClosenessCentrality.class)) {
                centralityMeasureType = new DiagramAlgorithmsService.CentralityMeasureType.ClosenessCentrality(this.considerEdgeDirections);
            } else {
                throw new IllegalStateException(("Unknown centrality type: " + this.centralityType).toString());
            }
            return centralityMeasureType;
        }

        @NotNull
        public final Class<?> component1() {
            return this.centralityType;
        }

        public final boolean component2() {
            return this.considerIncomingEdges;
        }

        public final boolean component3() {
            return this.considerOutgoingEdges;
        }

        public final boolean component4() {
            return this.considerEdgeDirections;
        }

        @NotNull
        public final MyViewModel copy(@NotNull Class<?> centralityType, boolean considerIncomingEdges, boolean considerOutgoingEdges, boolean considerEdgeDirections) {
            Intrinsics.checkNotNullParameter(centralityType, (String)"centralityType");
            return new MyViewModel(centralityType, considerIncomingEdges, considerOutgoingEdges, considerEdgeDirections);
        }

        public static /* synthetic */ MyViewModel copy$default(MyViewModel myViewModel, Class clazz, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                clazz = myViewModel.centralityType;
            }
            if ((n & 2) != 0) {
                bl = myViewModel.considerIncomingEdges;
            }
            if ((n & 4) != 0) {
                bl2 = myViewModel.considerOutgoingEdges;
            }
            if ((n & 8) != 0) {
                bl3 = myViewModel.considerEdgeDirections;
            }
            return myViewModel.copy(clazz, bl, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "MyViewModel(centralityType=" + this.centralityType + ", considerIncomingEdges=" + this.considerIncomingEdges + ", considerOutgoingEdges=" + this.considerOutgoingEdges + ", considerEdgeDirections=" + this.considerEdgeDirections + ")";
        }

        public int hashCode() {
            int result = this.centralityType.hashCode();
            result = result * 31 + Boolean.hashCode(this.considerIncomingEdges);
            result = result * 31 + Boolean.hashCode(this.considerOutgoingEdges);
            result = result * 31 + Boolean.hashCode(this.considerEdgeDirections);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MyViewModel)) {
                return false;
            }
            MyViewModel myViewModel = (MyViewModel)other;
            if (!Intrinsics.areEqual(this.centralityType, myViewModel.centralityType)) {
                return false;
            }
            if (this.considerIncomingEdges != myViewModel.considerIncomingEdges) {
                return false;
            }
            if (this.considerOutgoingEdges != myViewModel.considerOutgoingEdges) {
                return false;
            }
            return this.considerEdgeDirections == myViewModel.considerEdgeDirections;
        }

        public MyViewModel() {
            this(null, false, false, false, 15, null);
        }
    }
}

