/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.sass.completion.SassScssCompletionContributor;
import org.jetbrains.plugins.scss.SASSSCSSLangUtil;
import org.jetbrains.plugins.scss.psi.SassScssMixinDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssStylesheetFile;
import org.jetbrains.plugins.scss.psi.SassScssUseAtRule;
import org.jetbrains.plugins.scss.psi.stubs.SassScssMixinIndex;
import org.jetbrains.plugins.scss.references.SassScssQualifierReference;

public class MixinNamesProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            MixinNamesProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            MixinNamesProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            MixinNamesProvider.$$$reportNull$$$0(2);
        }
        PsiFile originalFile = parameters.getOriginalFile();
        PsiElement position = parameters.getPosition();
        Project project = parameters.getPosition().getProject();
        String existingQualifier = SassScssCompletionContributor.getQualifier(position);
        if (existingQualifier != null) {
            MixinNamesProvider.addMixinsForQualifier(result, position, existingQualifier);
            return;
        }
        String prefix = result.getPrefixMatcher().getPrefix();
        Map<PsiFile, SASSSCSSLangUtil.QualifierInfo> fileToQualifierInfoMap = SASSSCSSLangUtil.getFileToQualifierInfoMap(position);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)originalFile, (PsiElement)position, (boolean)false);
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        for (String name : StubIndex.getInstance().getAllKeys(SassScssMixinIndex.KEY, project)) {
            SassScssMixinIndex.process(name, project, scope, (Processor<? super SassScssMixinDeclaration>)((Processor)declaration -> {
                if (SASSSCSSLangUtil.isVisibleDeclaration((PsiElement)declaration, position)) {
                    PsiFile declFile = declaration.getContainingFile();
                    SASSSCSSLangUtil.QualifierInfo info = (SASSSCSSLangUtil.QualifierInfo)fileToQualifierInfoMap.get(declFile);
                    if (info != null) {
                        String targetName = declaration.getName();
                        if (!targetName.startsWith("-") && !targetName.startsWith("_")) {
                            LookupElement lookupItem = SASSSCSSLangUtil.createMixinLookupItem(info.prefixFromForwards, declaration, info.qualifier, true, prefix);
                            result.addElement(lookupItem);
                        }
                    } else {
                        boolean validResult = importedFiles.contains(declaration.getContainingFile().getVirtualFile());
                        result.addElement(SASSSCSSLangUtil.createMixinLookupItem(null, declaration, null, validResult, prefix));
                    }
                }
                return true;
            }));
        }
        result.restartCompletionOnPrefixChange(SassScssCompletionContributor.RESTART_IDENTIFIER_COMPLETION_CONDITION);
    }

    private static void addMixinsForQualifier(@NotNull CompletionResultSet result, @NotNull PsiElement position, @NotNull String qualifier) {
        PsiElement resolve;
        SassScssUseAtRule useAtRule;
        if (result == null) {
            MixinNamesProvider.$$$reportNull$$$0(3);
        }
        if (position == null) {
            MixinNamesProvider.$$$reportNull$$$0(4);
        }
        if (qualifier == null) {
            MixinNamesProvider.$$$reportNull$$$0(5);
        }
        PsiFile[] files = (useAtRule = (SassScssUseAtRule)PsiTreeUtil.getParentOfType((PsiElement)(resolve = SassScssQualifierReference.resolve(position, qualifier)), SassScssUseAtRule.class)) != null ? useAtRule.resolveTargetFiles() : PsiFile.EMPTY_ARRAY;
        HashSet<PsiFile> visited = new HashSet<PsiFile>();
        visited.add(position.getContainingFile().getOriginalFile());
        for (PsiFile file : files) {
            if (!(file instanceof SassScssStylesheetFile)) continue;
            for (SassScssMixinDeclaration mixin : ((SassScssStylesheetFile)file).getTopLevelDeclarations(SassScssMixinDeclaration.class)) {
                String name = mixin.getName();
                if (name.isEmpty() || name.startsWith("-") || name.startsWith("_")) continue;
                result.addElement(SASSSCSSLangUtil.createMixinLookupItem(null, mixin, null, true, result.getPrefixMatcher().getPrefix()));
            }
        }
        for (PsiFile file : files) {
            if (!(file instanceof SassScssStylesheetFile)) continue;
            SASSSCSSLangUtil.processForwardsAndImports((SassScssStylesheetFile)file, "", visited, (PairConsumer<SassScssStylesheetFile, String>)((PairConsumer)(forwardedFile, prefix) -> {
                for (SassScssMixinDeclaration mixin : forwardedFile.getTopLevelDeclarations(SassScssMixinDeclaration.class)) {
                    String name = mixin.getName();
                    if (name.isEmpty() || name.startsWith("-") || name.startsWith("_")) continue;
                    result.addElement(SASSSCSSLangUtil.createMixinLookupItem(prefix, mixin, null, true, result.getPrefixMatcher().getPrefix()));
                }
            }));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/sass/completion/MixinNamesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "addMixinsForQualifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

