/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.filters.ModifiedFilesFilter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoverageAnnotator
implements CoverageAnnotator {
    private final Project myProject;
    private ModifiedFilesFilter myModifiedFilesFilter;

    @Nullable
    protected abstract Runnable createRenewRequest(@NotNull CoverageSuitesBundle var1, @NotNull CoverageDataManager var2);

    public BaseCoverageAnnotator(Project project) {
        this.myProject = project;
    }

    @Override
    public void onSuiteChosen(@Nullable CoverageSuitesBundle newSuite) {
        this.myModifiedFilesFilter = null;
    }

    @Override
    @ApiStatus.Internal
    public final void renewCoverageData(final @NotNull CoverageSuitesBundle suite, final @NotNull CoverageDataManager dataManager) {
        Runnable request;
        if (suite == null) {
            BaseCoverageAnnotator.$$$reportNull$$$0(0);
        }
        if (dataManager == null) {
            BaseCoverageAnnotator.$$$reportNull$$$0(1);
        }
        if ((request = this.createRenewRequest(suite, dataManager)) != null) {
            if (this.myProject.isDisposed()) {
                return;
            }
            final Project project = this.myProject;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, CoverageBundle.message("coverage.view.loading.data", new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    BaseCoverageAnnotator.this.myModifiedFilesFilter = ModifiedFilesFilter.create(project);
                    request.run();
                }

                public void onSuccess() {
                    if (project.isDisposed()) {
                        return;
                    }
                    dataManager.coverageDataCalculated(suite);
                }

                public void onCancel() {
                    super.onCancel();
                    if (project.isDisposed()) {
                        return;
                    }
                    dataManager.closeSuitesBundle(suite);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/coverage/BaseCoverageAnnotator$1", "run"));
                }
            });
        }
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    @ApiStatus.Internal
    @Nullable
    public ModifiedFilesFilter getModifiedFilesFilter() {
        return this.myModifiedFilesFilter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "suite";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "dataManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/coverage/BaseCoverageAnnotator";
        objectArray[2] = "renewCoverageData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class DirCoverageInfo
    extends FileCoverageInfo {
        public int totalFilesCount;
        public int coveredFilesCount;
    }

    public static class FileCoverageInfo {
        public int totalLineCount;
        public int coveredLineCount;
    }
}

