//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cksubscriptiontype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKSubscriptionType(pub NSInteger);
impl CKSubscriptionType {
    #[doc(alias = "CKSubscriptionTypeQuery")]
    pub const Query: Self = Self(1);
    #[doc(alias = "CKSubscriptionTypeRecordZone")]
    pub const RecordZone: Self = Self(2);
    #[doc(alias = "CKSubscriptionTypeDatabase")]
    pub const Database: Self = Self(3);
}

unsafe impl Encode for CKSubscriptionType {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for CKSubscriptionType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cksubscriptionid?language=objc)
pub type CKSubscriptionID = NSString;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cksubscription?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKSubscription;
);

extern_conformance!(
    unsafe impl NSCoding for CKSubscription {}
);

extern_conformance!(
    unsafe impl NSCopying for CKSubscription {}
);

unsafe impl CopyingHelper for CKSubscription {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKSubscription {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKSubscription {}
);

impl CKSubscription {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[unsafe(method(subscriptionID))]
        #[unsafe(method_family = none)]
        pub unsafe fn subscriptionID(&self) -> Retained<CKSubscriptionID>;

        #[unsafe(method(subscriptionType))]
        #[unsafe(method_family = none)]
        pub unsafe fn subscriptionType(&self) -> CKSubscriptionType;

        /// Describes the notification that will be sent when the subscription fires.
        ///
        ///
        /// This property must be set to a non-nil value before saving the
        /// `CKSubscription.`
        #[unsafe(method(notificationInfo))]
        #[unsafe(method_family = none)]
        pub unsafe fn notificationInfo(&self) -> Option<Retained<CKNotificationInfo>>;

        /// Setter for [`notificationInfo`][Self::notificationInfo].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setNotificationInfo:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNotificationInfo(&self, notification_info: Option<&CKNotificationInfo>);
    );
}

/// [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckquerysubscriptionoptions?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CKQuerySubscriptionOptions(pub NSUInteger);
bitflags::bitflags! {
    impl CKQuerySubscriptionOptions: NSUInteger {
        #[doc(alias = "CKQuerySubscriptionOptionsFiresOnRecordCreation")]
        const FiresOnRecordCreation = 1<<0;
        #[doc(alias = "CKQuerySubscriptionOptionsFiresOnRecordUpdate")]
        const FiresOnRecordUpdate = 1<<1;
        #[doc(alias = "CKQuerySubscriptionOptionsFiresOnRecordDeletion")]
        const FiresOnRecordDeletion = 1<<2;
        #[doc(alias = "CKQuerySubscriptionOptionsFiresOnce")]
        const FiresOnce = 1<<3;
    }
}

unsafe impl Encode for CKQuerySubscriptionOptions {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for CKQuerySubscriptionOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// A subscription that fires whenever a change matching the predicate occurs.
    ///
    ///
    /// `CKQuerySubscriptions`are not supported in a
    /// `sharedCloudDatabase`
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckquerysubscription?language=objc)
    #[unsafe(super(CKSubscription, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKQuerySubscription;
);

extern_conformance!(
    unsafe impl NSCoding for CKQuerySubscription {}
);

extern_conformance!(
    unsafe impl NSCopying for CKQuerySubscription {}
);

unsafe impl CopyingHelper for CKQuerySubscription {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKQuerySubscription {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKQuerySubscription {}
);

impl CKQuerySubscription {
    extern_methods!(
        #[cfg(feature = "CKRecord")]
        #[deprecated]
        #[unsafe(method(initWithRecordType:predicate:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRecordType_predicate_options(
            this: Allocated<Self>,
            record_type: &CKRecordType,
            predicate: &NSPredicate,
            query_subscription_options: CKQuerySubscriptionOptions,
        ) -> Retained<Self>;

        #[cfg(feature = "CKRecord")]
        #[unsafe(method(initWithRecordType:predicate:subscriptionID:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithRecordType_predicate_subscriptionID_options(
            this: Allocated<Self>,
            record_type: &CKRecordType,
            predicate: &NSPredicate,
            subscription_id: &CKSubscriptionID,
            query_subscription_options: CKQuerySubscriptionOptions,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `a_decoder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, a_decoder: &NSCoder) -> Retained<Self>;

        #[cfg(feature = "CKRecord")]
        /// The record type that this subscription watches
        #[unsafe(method(recordType))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordType(&self) -> Retained<CKRecordType>;

        /// A predicate that determines when the subscription fires.
        #[unsafe(method(predicate))]
        #[unsafe(method_family = none)]
        pub unsafe fn predicate(&self) -> Retained<NSPredicate>;

        #[cfg(feature = "CKRecordZoneID")]
        /// Optional property.  If set, a query subscription is scoped to only record changes in the indicated zone.
        /// Query Subscriptions that do not specify a
        /// `zoneID`are scoped to record changes across all zones in the database.
        #[unsafe(method(zoneID))]
        #[unsafe(method_family = none)]
        pub unsafe fn zoneID(&self) -> Option<Retained<CKRecordZoneID>>;

        #[cfg(feature = "CKRecordZoneID")]
        /// Setter for [`zoneID`][Self::zoneID].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setZoneID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setZoneID(&self, zone_id: Option<&CKRecordZoneID>);

        /// Options flags describing the firing behavior subscription.
        ///
        ///
        /// One of
        /// `CKQuerySubscriptionOptionsFiresOnRecordCreation,``CKQuerySubscriptionOptionsFiresOnRecordUpdate,`or
        /// `CKQuerySubscriptionOptionsFiresOnRecordDeletion`must be specified or an
        /// `NSInvalidArgumentException`will be thrown.
        #[unsafe(method(querySubscriptionOptions))]
        #[unsafe(method_family = none)]
        pub unsafe fn querySubscriptionOptions(&self) -> CKQuerySubscriptionOptions;
    );
}

/// Methods declared on superclass `CKSubscription`.
impl CKQuerySubscription {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// A subscription that fires whenever any change happens in the indicated Record Zone.
    ///
    ///
    /// The RecordZone must have the capability
    /// `CKRecordZoneCapabilityFetchChanges``CKRecordZoneSubscriptions`are not supported in a
    /// `sharedCloudDatabase`
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckrecordzonesubscription?language=objc)
    #[unsafe(super(CKSubscription, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKRecordZoneSubscription;
);

extern_conformance!(
    unsafe impl NSCoding for CKRecordZoneSubscription {}
);

extern_conformance!(
    unsafe impl NSCopying for CKRecordZoneSubscription {}
);

unsafe impl CopyingHelper for CKRecordZoneSubscription {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKRecordZoneSubscription {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKRecordZoneSubscription {}
);

impl CKRecordZoneSubscription {
    extern_methods!(
        #[cfg(feature = "CKRecordZoneID")]
        #[deprecated]
        #[unsafe(method(initWithZoneID:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithZoneID(
            this: Allocated<Self>,
            zone_id: &CKRecordZoneID,
        ) -> Retained<Self>;

        #[cfg(feature = "CKRecordZoneID")]
        #[unsafe(method(initWithZoneID:subscriptionID:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithZoneID_subscriptionID(
            this: Allocated<Self>,
            zone_id: &CKRecordZoneID,
            subscription_id: &CKSubscriptionID,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `a_decoder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, a_decoder: &NSCoder) -> Retained<Self>;

        #[cfg(feature = "CKRecordZoneID")]
        #[unsafe(method(zoneID))]
        #[unsafe(method_family = none)]
        pub unsafe fn zoneID(&self) -> Retained<CKRecordZoneID>;

        #[cfg(feature = "CKRecord")]
        /// Optional property. If set, a zone subscription is scoped to record changes for this record type
        #[unsafe(method(recordType))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordType(&self) -> Option<Retained<CKRecordType>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`recordType`][Self::recordType].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setRecordType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordType(&self, record_type: Option<&CKRecordType>);
    );
}

/// Methods declared on superclass `CKSubscription`.
impl CKRecordZoneSubscription {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}

extern_class!(
    /// A subscription fires whenever any change happens in the database that this subscription was saved in.
    ///
    ///
    /// `CKDatabaseSubscription`is only supported in the Private and Shared databases.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/ckdatabasesubscription?language=objc)
    #[unsafe(super(CKSubscription, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKDatabaseSubscription;
);

extern_conformance!(
    unsafe impl NSCoding for CKDatabaseSubscription {}
);

extern_conformance!(
    unsafe impl NSCopying for CKDatabaseSubscription {}
);

unsafe impl CopyingHelper for CKDatabaseSubscription {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKDatabaseSubscription {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKDatabaseSubscription {}
);

impl CKDatabaseSubscription {
    extern_methods!(
        #[deprecated]
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;

        #[unsafe(method(initWithSubscriptionID:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithSubscriptionID(
            this: Allocated<Self>,
            subscription_id: &CKSubscriptionID,
        ) -> Retained<Self>;

        /// # Safety
        ///
        /// `a_decoder` possibly has further requirements.
        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(this: Allocated<Self>, a_decoder: &NSCoder) -> Retained<Self>;

        #[cfg(feature = "CKRecord")]
        /// Optional property. If set, a database subscription is scoped to record changes for this record type
        #[unsafe(method(recordType))]
        #[unsafe(method_family = none)]
        pub unsafe fn recordType(&self) -> Option<Retained<CKRecordType>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`recordType`][Self::recordType].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setRecordType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setRecordType(&self, record_type: Option<&CKRecordType>);
    );
}

extern_class!(
    /// The payload of a push notification delivered in the UIApplication
    /// `application:didReceiveRemoteNotification:`delegate method contains information about the firing subscription.
    ///
    /// Use
    ///
    /// ```text
    ///  +[CKNotification notificationFromRemoteNotificationDictionary:]
    /// ```
    ///
    /// to parse that payload.
    /// On tvOS, alerts, badges, sounds, and categories are not handled in push notifications. However, CKSubscriptions remain available to help you avoid polling the server.
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/cloudkit/cknotificationinfo?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct CKNotificationInfo;
);

extern_conformance!(
    unsafe impl NSCoding for CKNotificationInfo {}
);

extern_conformance!(
    unsafe impl NSCopying for CKNotificationInfo {}
);

unsafe impl CopyingHelper for CKNotificationInfo {
    type Result = Self;
}

extern_conformance!(
    unsafe impl NSObjectProtocol for CKNotificationInfo {}
);

extern_conformance!(
    unsafe impl NSSecureCoding for CKNotificationInfo {}
);

impl CKNotificationInfo {
    extern_methods!(
        /// Optional alert string to display in a push notification.
        #[unsafe(method(alertBody))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertBody(&self) -> Option<Retained<NSString>>;

        /// Setter for [`alertBody`][Self::alertBody].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAlertBody:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlertBody(&self, alert_body: Option<&NSString>);

        /// Instead of a raw alert string, you may optionally specify a key for a localized string in your app's Localizable.strings file.
        #[unsafe(method(alertLocalizationKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertLocalizationKey(&self) -> Option<Retained<NSString>>;

        /// Setter for [`alertLocalizationKey`][Self::alertLocalizationKey].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAlertLocalizationKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlertLocalizationKey(&self, alert_localization_key: Option<&NSString>);

        #[cfg(feature = "CKRecord")]
        /// A list of field names to take from the matching record that is used as substitution variables in a formatted alert string.
        #[unsafe(method(alertLocalizationArgs))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertLocalizationArgs(&self) -> Option<Retained<NSArray<CKRecordFieldKey>>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`alertLocalizationArgs`][Self::alertLocalizationArgs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAlertLocalizationArgs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlertLocalizationArgs(
            &self,
            alert_localization_args: Option<&NSArray<CKRecordFieldKey>>,
        );

        /// Optional title of the alert to display in a push notification.
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Option<Retained<NSString>>;

        /// Setter for [`title`][Self::title].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitle(&self, title: Option<&NSString>);

        /// Instead of a raw title string, you may optionally specify a key for a localized string in your app's Localizable.strings file.
        #[unsafe(method(titleLocalizationKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn titleLocalizationKey(&self) -> Option<Retained<NSString>>;

        /// Setter for [`titleLocalizationKey`][Self::titleLocalizationKey].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitleLocalizationKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitleLocalizationKey(&self, title_localization_key: Option<&NSString>);

        #[cfg(feature = "CKRecord")]
        /// A list of field names to take from the matching record that is used as substitution variables in a formatted title string.
        #[unsafe(method(titleLocalizationArgs))]
        #[unsafe(method_family = none)]
        pub unsafe fn titleLocalizationArgs(&self) -> Option<Retained<NSArray<CKRecordFieldKey>>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`titleLocalizationArgs`][Self::titleLocalizationArgs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setTitleLocalizationArgs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitleLocalizationArgs(
            &self,
            title_localization_args: Option<&NSArray<CKRecordFieldKey>>,
        );

        /// Optional subtitle of the alert to display in a push notification.
        #[unsafe(method(subtitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtitle(&self) -> Option<Retained<NSString>>;

        /// Setter for [`subtitle`][Self::subtitle].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSubtitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSubtitle(&self, subtitle: Option<&NSString>);

        /// Instead of a raw subtitle string, you may optionally specify a key for a localized string in your app's Localizable.strings file.
        #[unsafe(method(subtitleLocalizationKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtitleLocalizationKey(&self) -> Option<Retained<NSString>>;

        /// Setter for [`subtitleLocalizationKey`][Self::subtitleLocalizationKey].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSubtitleLocalizationKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSubtitleLocalizationKey(
            &self,
            subtitle_localization_key: Option<&NSString>,
        );

        #[cfg(feature = "CKRecord")]
        /// A list of field names to take from the matching record that is used as substitution variables in a formatted subtitle string.
        #[unsafe(method(subtitleLocalizationArgs))]
        #[unsafe(method_family = none)]
        pub unsafe fn subtitleLocalizationArgs(
            &self,
        ) -> Option<Retained<NSArray<CKRecordFieldKey>>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`subtitleLocalizationArgs`][Self::subtitleLocalizationArgs].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSubtitleLocalizationArgs:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSubtitleLocalizationArgs(
            &self,
            subtitle_localization_args: Option<&NSArray<CKRecordFieldKey>>,
        );

        /// A key for a localized string to be used as the alert action in a modal style notification.
        #[unsafe(method(alertActionLocalizationKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertActionLocalizationKey(&self) -> Option<Retained<NSString>>;

        /// Setter for [`alertActionLocalizationKey`][Self::alertActionLocalizationKey].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAlertActionLocalizationKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlertActionLocalizationKey(
            &self,
            alert_action_localization_key: Option<&NSString>,
        );

        /// The name of an image in your app bundle to be used as the launch image when launching in response to the notification.
        #[unsafe(method(alertLaunchImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn alertLaunchImage(&self) -> Option<Retained<NSString>>;

        /// Setter for [`alertLaunchImage`][Self::alertLaunchImage].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setAlertLaunchImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlertLaunchImage(&self, alert_launch_image: Option<&NSString>);

        /// The name of a sound file in your app bundle to play upon receiving the notification.
        #[unsafe(method(soundName))]
        #[unsafe(method_family = none)]
        pub unsafe fn soundName(&self) -> Option<Retained<NSString>>;

        /// Setter for [`soundName`][Self::soundName].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setSoundName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSoundName(&self, sound_name: Option<&NSString>);

        #[cfg(feature = "CKRecord")]
        /// A list of keys from the matching record to include in the notification payload.
        ///
        ///
        /// Only some keys are allowed.  The value types associated with those keys on the server must be one of these classes:
        /// - CKReference
        /// - CLLocation
        /// - NSDate
        /// - NSNumber
        /// - NSString
        #[unsafe(method(desiredKeys))]
        #[unsafe(method_family = none)]
        pub unsafe fn desiredKeys(&self) -> Option<Retained<NSArray<CKRecordFieldKey>>>;

        #[cfg(feature = "CKRecord")]
        /// Setter for [`desiredKeys`][Self::desiredKeys].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setDesiredKeys:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDesiredKeys(&self, desired_keys: Option<&NSArray<CKRecordFieldKey>>);

        /// Indicates that the notification should increment the app's badge count. Default value is
        /// `NO.`
        #[unsafe(method(shouldBadge))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldBadge(&self) -> bool;

        /// Setter for [`shouldBadge`][Self::shouldBadge].
        #[unsafe(method(setShouldBadge:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShouldBadge(&self, should_badge: bool);

        /// Indicates that the notification should be sent with the "content-available" flag to allow for background downloads in the application.
        ///
        ///
        /// Default value is
        /// `NO.`
        #[unsafe(method(shouldSendContentAvailable))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldSendContentAvailable(&self) -> bool;

        /// Setter for [`shouldSendContentAvailable`][Self::shouldSendContentAvailable].
        #[unsafe(method(setShouldSendContentAvailable:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShouldSendContentAvailable(&self, should_send_content_available: bool);

        /// Indicates that the notification should be sent with the "mutable-content" flag to allow a Notification Service app extension to modify or replace the push payload.
        ///
        ///
        /// Default value is
        /// `NO.`
        #[unsafe(method(shouldSendMutableContent))]
        #[unsafe(method_family = none)]
        pub unsafe fn shouldSendMutableContent(&self) -> bool;

        /// Setter for [`shouldSendMutableContent`][Self::shouldSendMutableContent].
        #[unsafe(method(setShouldSendMutableContent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShouldSendMutableContent(&self, should_send_mutable_content: bool);

        /// Optional property for the category to be sent with the push when this subscription fires.
        ///
        ///
        /// Categories allow you to present custom actions to the user on your push notifications.
        ///
        ///
        /// See: UIMutableUserNotificationCategory
        #[unsafe(method(category))]
        #[unsafe(method_family = none)]
        pub unsafe fn category(&self) -> Option<Retained<NSString>>;

        /// Setter for [`category`][Self::category].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCategory:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCategory(&self, category: Option<&NSString>);

        /// Optional property specifying a field name to take from the matching record whose value is used as the apns-collapse-id header.
        ///
        ///
        /// See: APNs Notification API documentation
        #[unsafe(method(collapseIDKey))]
        #[unsafe(method_family = none)]
        pub unsafe fn collapseIDKey(&self) -> Option<Retained<NSString>>;

        /// Setter for [`collapseIDKey`][Self::collapseIDKey].
        ///
        /// This is [copied][objc2_foundation::NSCopying::copy] when set.
        #[unsafe(method(setCollapseIDKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setCollapseIDKey(&self, collapse_id_key: Option<&NSString>);
    );
}

/// Methods declared on superclass `NSObject`.
impl CKNotificationInfo {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
