// SPDX-License-Identifier: GPL-2.0-only
/*
 * Copyright (C) 2025 Ivaylo Ivanov <ivo.ivanov.ivanov1@gmail.com>
 * Author: Ivaylo Ivanov <ivo.ivanov.ivanov1@gmail.com>
 *
 * Common Clock Framework support for Exynos2200 SoC.
 */

#include <linux/clk-provider.h>
#include <linux/mod_devicetable.h>
#include <linux/of.h>
#include <linux/platform_device.h>

#include <dt-bindings/clock/samsung,exynos2200-cmu.h>

#include "clk.h"
#include "clk-exynos-arm64.h"

/* NOTE: Must be equal to the last clock ID increased by one */
#define CLKS_NR_TOP			(CLK_DOUT_TCXO_DIV4 + 1)
#define CLKS_NR_ALIVE			(CLK_DOUT_ALIVE_DSP_NOC + 1)
#define CLKS_NR_PERIS			(CLK_DOUT_PERIS_DDD_CTRL + 1)
#define CLKS_NR_CMGP			(CLK_DOUT_CMGP_USI6 + 1)
#define CLKS_NR_HSI0			(CLK_DOUT_DIV_CLK_HSI0_EUSB + 1)
#define CLKS_NR_PERIC0			(CLK_DOUT_PERIC0_USI04 + 1)
#define CLKS_NR_PERIC1			(CLK_DOUT_PERIC1_USI10 + 1)
#define CLKS_NR_PERIC2			(CLK_DOUT_PERIC2_USI11 + 1)
#define CLKS_NR_UFS			(CLK_MOUT_UFS_UFS_EMBD_USER + 1)
#define CLKS_NR_VTS			(CLK_DOUT_CLKVTS_SERIAL_LIF_CORE + 1)

/* ---- CMU_TOP ------------------------------------------------------------ */

/* Register Offset definitions for CMU_TOP (0x1a320000) */
#define PLL_LOCKTIME_PLL_MMC				0x0
#define PLL_LOCKTIME_PLL_SHARED0			0x4
#define PLL_LOCKTIME_PLL_SHARED1			0x8
#define PLL_LOCKTIME_PLL_SHARED2			0xc
#define PLL_LOCKTIME_PLL_SHARED3			0x10
#define PLL_LOCKTIME_PLL_SHARED4			0x14
#define PLL_LOCKTIME_PLL_SHARED_MIF			0x18
#define PLL_CON3_PLL_MMC				0x10c
#define PLL_CON8_PLL_MMC				0x120
#define PLL_CON3_PLL_SHARED0				0x14c
#define PLL_CON8_PLL_SHARED0				0x160
#define PLL_CON3_PLL_SHARED1				0x18c
#define PLL_CON8_PLL_SHARED1				0x1a0
#define PLL_CON3_PLL_SHARED2				0x1cc
#define PLL_CON8_PLL_SHARED2				0x1e0
#define PLL_CON3_PLL_SHARED3				0x20c
#define PLL_CON8_PLL_SHARED3				0x220
#define PLL_CON3_PLL_SHARED4				0x24c
#define PLL_CON8_PLL_SHARED4				0x260
#define PLL_CON3_PLL_SHARED_MIF				0x28c
#define PLL_CON8_PLL_SHARED_MIF				0x2a0
#define PLL_CON0_MUX_CP_MPLL_CLK_D2_USER		0x600
#define PLL_CON1_MUX_CP_MPLL_CLK_D2_USER		0x604
#define PLL_CON0_MUX_CP_MPLL_CLK_USER			0x610
#define PLL_CON1_MUX_CP_MPLL_CLK_USER			0x614
#define CLK_CON_MUX_CLKCMU_AUD_AUDIF0			0x1000
#define CLK_CON_MUX_CLKCMU_AUD_AUDIF1			0x1004
#define CLK_CON_MUX_CLKCMU_AUD_CPU			0x1008
#define CLK_CON_MUX_CLKCMU_CPUCL0_DBG_NOC		0x100c
#define CLK_CON_MUX_CLKCMU_CPUCL0_SWITCH		0x1010
#define CLK_CON_MUX_CLKCMU_CPUCL1_SWITCH		0x1014
#define CLK_CON_MUX_CLKCMU_CPUCL2_SWITCH		0x1018
#define CLK_CON_MUX_CLKCMU_DNC_NOC			0x101c
#define CLK_CON_MUX_CLKCMU_DPUB_NOC			0x1020
#define CLK_CON_MUX_CLKCMU_DPUF_NOC			0x1024
#define CLK_CON_MUX_CLKCMU_DSP_NOC			0x102c
#define CLK_CON_MUX_CLKCMU_DSU_SWITCH			0x1030
#define CLK_CON_MUX_CLKCMU_G3D_SWITCH			0x1034
#define CLK_CON_MUX_CLKCMU_GNPU_NOC			0x103c
#define CLK_CON_MUX_CLKCMU_UFS_MMC_CARD			0x1040
#define CLK_CON_MUX_CLKCMU_M2M_NOC			0x1044
#define CLK_CON_MUX_CLKCMU_NOCL0_NOC			0x1048
#define CLK_CON_MUX_CLKCMU_NOCL1A_NOC			0x104c
#define CLK_CON_MUX_CLKCMU_NOCL1B_NOC0			0x1050
#define CLK_CON_MUX_CLKCMU_NOCL1C_NOC			0x1054
#define CLK_CON_MUX_CLKCMU_SDMA_NOC			0x1058
#define CLK_CON_MUX_CP_HISPEEDY_CLK			0x105c
#define CLK_CON_MUX_CP_SHARED0_CLK			0x1060
#define CLK_CON_MUX_CP_SHARED2_CLK			0x1064
#define CLK_CON_MUX_MUX_CLKCMU_ALIVE_NOC		0x1068
#define CLK_CON_MUX_MUX_CLKCMU_AUD_AUDIF0		0x106c
#define CLK_CON_MUX_MUX_CLKCMU_AUD_AUDIF1		0x1070
#define CLK_CON_MUX_MUX_CLKCMU_AUD_CPU			0x1074
#define CLK_CON_MUX_MUX_CLKCMU_AUD_NOC			0x1078
#define CLK_CON_MUX_MUX_CLKCMU_BRP_NOC			0x107c
#define CLK_CON_MUX_MUX_CLKCMU_CIS_CLK0			0x1080
#define CLK_CON_MUX_MUX_CLKCMU_CIS_CLK1			0x1084
#define CLK_CON_MUX_MUX_CLKCMU_CIS_CLK2			0x1088
#define CLK_CON_MUX_MUX_CLKCMU_CIS_CLK3			0x108c
#define CLK_CON_MUX_MUX_CLKCMU_CIS_CLK4			0x1090
#define CLK_CON_MUX_MUX_CLKCMU_CIS_CLK5			0x1094
#define CLK_CON_MUX_MUX_CLKCMU_CIS_CLK6			0x1098
#define CLK_CON_MUX_MUX_CLKCMU_CIS_CLK7			0x109c
#define CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST		0x10a0
#define CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_CAM		0x10a4
#define CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_CPU		0x10a8
#define CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_MIF		0x10ac
#define CLK_CON_MUX_MUX_CLKCMU_CPUCL0_DBG_NOC		0x10b0
#define CLK_CON_MUX_MUX_CLKCMU_CPUCL0_NOCP		0x10b4
#define CLK_CON_MUX_MUX_CLKCMU_CPUCL0_SWITCH		0x10b8
#define CLK_CON_MUX_MUX_CLKCMU_CPUCL1_SWITCH		0x10bc
#define CLK_CON_MUX_MUX_CLKCMU_CPUCL2_SWITCH		0x10c0
#define CLK_CON_MUX_MUX_CLKCMU_CSIS_DCPHY		0x10c4
#define CLK_CON_MUX_MUX_CLKCMU_CSIS_NOC			0x10c8
#define CLK_CON_MUX_MUX_CLKCMU_CSIS_OIS_MCU		0x10cc
#define CLK_CON_MUX_MUX_CLKCMU_CSTAT_NOC		0x10d0
#define CLK_CON_MUX_MUX_CLKCMU_DNC_NOC			0x10d4
#define CLK_CON_MUX_MUX_CLKCMU_DPUB			0x10d8
#define CLK_CON_MUX_MUX_CLKCMU_DPUB_ALT			0x10dc
#define CLK_CON_MUX_MUX_CLKCMU_DPUB_DSIM		0x10e0
#define CLK_CON_MUX_MUX_CLKCMU_DPUF			0x10e4
#define CLK_CON_MUX_MUX_CLKCMU_DPUF_ALT			0x10e8
#define CLK_CON_MUX_MUX_CLKCMU_DSP_NOC			0x10f8
#define CLK_CON_MUX_MUX_CLKCMU_DSU_SWITCH		0x10fc
#define CLK_CON_MUX_MUX_CLKCMU_G3D_NOCP			0x1100
#define CLK_CON_MUX_MUX_CLKCMU_G3D_SWITCH		0x1104
#define CLK_CON_MUX_MUX_CLKCMU_GNPU_NOC			0x110c
#define CLK_CON_MUX_MUX_CLKCMU_HSI0_DPGTC		0x1114
#define CLK_CON_MUX_MUX_CLKCMU_HSI0_DPOSC		0x1118
#define CLK_CON_MUX_MUX_CLKCMU_HSI0_NOC			0x111c
#define CLK_CON_MUX_MUX_CLKCMU_HSI0_USB32DRD		0x1120
#define CLK_CON_MUX_MUX_CLKCMU_UFS_MMC_CARD		0x1124
#define CLK_CON_MUX_MUX_CLKCMU_HSI1_NOC			0x1128
#define CLK_CON_MUX_MUX_CLKCMU_HSI1_PCIE		0x112c
#define CLK_CON_MUX_MUX_CLKCMU_UFS_UFS_EMBD		0x1130
#define CLK_CON_MUX_MUX_CLKCMU_LME_LME			0x1134
#define CLK_CON_MUX_MUX_CLKCMU_LME_NOC			0x1138
#define CLK_CON_MUX_MUX_CLKCMU_M2M_NOC			0x1140
#define CLK_CON_MUX_MUX_CLKCMU_MCSC_MCSC		0x1148
#define CLK_CON_MUX_MUX_CLKCMU_MCSC_NOC			0x114c
#define CLK_CON_MUX_MUX_CLKCMU_MFC0_MFC0		0x1150
#define CLK_CON_MUX_MUX_CLKCMU_MFC0_WFD			0x1154
#define CLK_CON_MUX_MUX_CLKCMU_MFC1_MFC1		0x1158
#define CLK_CON_MUX_MUX_CLKCMU_MIF_NOCP			0x115c
#define CLK_CON_MUX_MUX_CLKCMU_MIF_SWITCH		0x1160
#define CLK_CON_MUX_MUX_CLKCMU_NOCL0_NOC		0x1164
#define CLK_CON_MUX_MUX_CLKCMU_NOCL1A_NOC		0x1168
#define CLK_CON_MUX_MUX_CLKCMU_NOCL1B_NOC0		0x116c
#define CLK_CON_MUX_MUX_CLKCMU_NOCL1B_NOC1		0x1170
#define CLK_CON_MUX_MUX_CLKCMU_NOCL1C_NOC		0x1174
#define CLK_CON_MUX_MUX_CLKCMU_PERIC0_IP0		0x1178
#define CLK_CON_MUX_MUX_CLKCMU_PERIC0_IP1		0x117c
#define CLK_CON_MUX_MUX_CLKCMU_PERIC0_NOC		0x1180
#define CLK_CON_MUX_MUX_CLKCMU_PERIC1_IP0		0x1184
#define CLK_CON_MUX_MUX_CLKCMU_PERIC1_IP1		0x1188
#define CLK_CON_MUX_MUX_CLKCMU_PERIC1_NOC		0x118c
#define CLK_CON_MUX_MUX_CLKCMU_PERIC2_IP0		0x1190
#define CLK_CON_MUX_MUX_CLKCMU_PERIC2_IP1		0x1194
#define CLK_CON_MUX_MUX_CLKCMU_PERIC2_NOC		0x1198
#define CLK_CON_MUX_MUX_CLKCMU_PERIS_GIC		0x119c
#define CLK_CON_MUX_MUX_CLKCMU_PERIS_NOC		0x11a0
#define CLK_CON_MUX_MUX_CLKCMU_SDMA_NOC			0x11a8
#define CLK_CON_MUX_MUX_CLKCMU_SSP_NOC			0x11ac
#define CLK_CON_MUX_MUX_CLKCMU_VTS_DMIC			0x11b0
#define CLK_CON_MUX_MUX_CLKCMU_YUVP_NOC			0x11b4
#define CLK_CON_MUX_MUX_CMU_CMUREF			0x11b8
#define CLK_CON_MUX_MUX_CP_HISPEEDY_CLK			0x11bc
#define CLK_CON_MUX_MUX_CP_SHARED0_CLK			0x11c0
#define CLK_CON_MUX_MUX_CP_SHARED1_CLK			0x11c4
#define CLK_CON_MUX_MUX_CP_SHARED2_CLK			0x11c8
#define CLK_CON_MUX_CLKCMU_M2M_FRC			0x11cc
#define CLK_CON_MUX_CLKCMU_MCSC_MCSC			0x11d0
#define CLK_CON_MUX_CLKCMU_MCSC_NOC			0x11d4
#define CLK_CON_MUX_MUX_CLKCMU_M2M_FRC			0x11d8
#define CLK_CON_MUX_MUX_CLKCMU_UFS_NOC			0x11dc
#define CLK_CON_DIV_CLKCMU_ALIVE_NOC			0x1800
#define CLK_CON_DIV_CLKCMU_AUD_NOC			0x1804
#define CLK_CON_DIV_CLKCMU_BRP_NOC			0x1808
#define CLK_CON_DIV_CLKCMU_CMU_BOOST			0x180c
#define CLK_CON_DIV_CLKCMU_CMU_BOOST_CAM		0x1810
#define CLK_CON_DIV_CLKCMU_CMU_BOOST_CPU		0x1814
#define CLK_CON_DIV_CLKCMU_CMU_BOOST_MIF		0x1818
#define CLK_CON_DIV_CLKCMU_CPUCL0_NOCP			0x181c
#define CLK_CON_DIV_CLKCMU_CSIS_DCPHY			0x1820
#define CLK_CON_DIV_CLKCMU_CSIS_NOC			0x1824
#define CLK_CON_DIV_CLKCMU_CSIS_OIS_MCU			0x1828
#define CLK_CON_DIV_CLKCMU_CSTAT_NOC			0x182c
#define CLK_CON_DIV_CLKCMU_DPUB_DSIM			0x1830
#define CLK_CON_DIV_CLKCMU_LME_LME			0x1834
#define CLK_CON_DIV_CLKCMU_G3D_NOCP			0x1838
#define CLK_CON_DIV_CLKCMU_HSI0_DPGTC			0x1840
#define CLK_CON_DIV_CLKCMU_HSI0_DPOSC			0x1844
#define CLK_CON_DIV_CLKCMU_HSI0_NOC			0x1848
#define CLK_CON_DIV_CLKCMU_HSI0_USB32DRD		0x184c
#define CLK_CON_DIV_CLKCMU_HSI1_NOC			0x1850
#define CLK_CON_DIV_CLKCMU_HSI1_PCIE			0x1854
#define CLK_CON_DIV_CLKCMU_UFS_UFS_EMBD			0x1858
#define CLK_CON_DIV_CLKCMU_LME_NOC			0x1860
#define CLK_CON_DIV_CLKCMU_MFC0_MFC0			0x1874
#define CLK_CON_DIV_CLKCMU_MFC0_WFD			0x1878
#define CLK_CON_DIV_CLKCMU_MFC1_MFC1			0x187c
#define CLK_CON_DIV_CLKCMU_MIF_NOCP			0x1880
#define CLK_CON_DIV_CLKCMU_NOCL1B_NOC1			0x1884
#define CLK_CON_DIV_CLKCMU_PERIC0_IP0			0x1888
#define CLK_CON_DIV_CLKCMU_PERIC0_IP1			0x188c
#define CLK_CON_DIV_CLKCMU_PERIC0_NOC			0x1890
#define CLK_CON_DIV_CLKCMU_PERIC1_IP0			0x1894
#define CLK_CON_DIV_CLKCMU_PERIC1_IP1			0x1898
#define CLK_CON_DIV_CLKCMU_PERIC1_NOC			0x189c
#define CLK_CON_DIV_CLKCMU_PERIC2_IP0			0x18a0
#define CLK_CON_DIV_CLKCMU_PERIC2_IP1			0x18a4
#define CLK_CON_DIV_CLKCMU_PERIC2_NOC			0x18a8
#define CLK_CON_DIV_CLKCMU_PERIS_GIC			0x18ac
#define CLK_CON_DIV_CLKCMU_PERIS_NOC			0x18b0
#define CLK_CON_DIV_CLKCMU_SSP_NOC			0x18b8
#define CLK_CON_DIV_CLKCMU_VTS_DMIC			0x18bc
#define CLK_CON_DIV_CLKCMU_YUVP_NOC			0x18c0
#define CLK_CON_DIV_CP_SHARED1_CLK			0x18c4
#define CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF0		0x18c8
#define CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF0_SM		0x18cc
#define CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF1		0x18d0
#define CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF1_SM		0x18d4
#define CLK_CON_DIV_DIV_CLKCMU_AUD_CPU			0x18d8
#define CLK_CON_DIV_DIV_CLKCMU_AUD_CPU_SM		0x18dc
#define CLK_CON_DIV_DIV_CLKCMU_CIS_CLK0			0x18e0
#define CLK_CON_DIV_DIV_CLKCMU_CIS_CLK1			0x18e4
#define CLK_CON_DIV_DIV_CLKCMU_CIS_CLK2			0x18e8
#define CLK_CON_DIV_DIV_CLKCMU_CIS_CLK3			0x18ec
#define CLK_CON_DIV_DIV_CLKCMU_CIS_CLK4			0x18f0
#define CLK_CON_DIV_DIV_CLKCMU_CIS_CLK5			0x18f4
#define CLK_CON_DIV_DIV_CLKCMU_CIS_CLK6			0x18f8
#define CLK_CON_DIV_DIV_CLKCMU_CIS_CLK7			0x18fc
#define CLK_CON_DIV_DIV_CLKCMU_CPUCL0_DBG_NOC		0x1900
#define CLK_CON_DIV_DIV_CLKCMU_CPUCL0_DBG_NOC_SM	0x1904
#define CLK_CON_DIV_DIV_CLKCMU_CPUCL0_SWITCH		0x1908
#define CLK_CON_DIV_DIV_CLKCMU_CPUCL0_SWITCH_SM		0x190c
#define CLK_CON_DIV_DIV_CLKCMU_CPUCL1_SWITCH		0x1910
#define CLK_CON_DIV_DIV_CLKCMU_CPUCL1_SWITCH_SM		0x1914
#define CLK_CON_DIV_DIV_CLKCMU_CPUCL2_SWITCH		0x1918
#define CLK_CON_DIV_DIV_CLKCMU_CPUCL2_SWITCH_SM		0x191c
#define CLK_CON_DIV_DIV_CLKCMU_DNC_NOC			0x1920
#define CLK_CON_DIV_DIV_CLKCMU_DNC_NOC_SM		0x1924
#define CLK_CON_DIV_DIV_CLKCMU_DPUB			0x1928
#define CLK_CON_DIV_DIV_CLKCMU_DPUB_ALT			0x192c
#define CLK_CON_DIV_DIV_CLKCMU_DPUF			0x1930
#define CLK_CON_DIV_DIV_CLKCMU_DPUF_ALT			0x1934
#define CLK_CON_DIV_DIV_CLKCMU_DSP_NOC			0x1940
#define CLK_CON_DIV_DIV_CLKCMU_DSP_NOC_SM		0x1944
#define CLK_CON_DIV_DIV_CLKCMU_DSU_SWITCH		0x1948
#define CLK_CON_DIV_DIV_CLKCMU_DSU_SWITCH_SM		0x194c
#define CLK_CON_DIV_DIV_CLKCMU_G3D_SWITCH		0x1950
#define CLK_CON_DIV_DIV_CLKCMU_G3D_SWITCH_SM		0x1954
#define CLK_CON_DIV_DIV_CLKCMU_GNPU_NOC			0x1960
#define CLK_CON_DIV_DIV_CLKCMU_GNPU_NOC_SM		0x1964
#define CLK_CON_DIV_DIV_CLKCMU_UFS_MMC_CARD		0x1968
#define CLK_CON_DIV_DIV_CLKCMU_UFS_MMC_CARD_SM		0x196c
#define CLK_CON_DIV_DIV_CLKCMU_M2M_NOC			0x1970
#define CLK_CON_DIV_DIV_CLKCMU_M2M_NOC_SM		0x1974
#define CLK_CON_DIV_DIV_CLKCMU_NOCL0_NOC		0x1978
#define CLK_CON_DIV_DIV_CLKCMU_NOCL0_NOC_SM		0x197c
#define CLK_CON_DIV_DIV_CLKCMU_NOCL1A_NOC		0x1980
#define CLK_CON_DIV_DIV_CLKCMU_NOCL1A_NOC_SM		0x1984
#define CLK_CON_DIV_DIV_CLKCMU_NOCL1B_NOC0		0x1988
#define CLK_CON_DIV_DIV_CLKCMU_NOCL1B_NOC0_SM		0x198c
#define CLK_CON_DIV_DIV_CLKCMU_NOCL1C_NOC		0x1990
#define CLK_CON_DIV_DIV_CLKCMU_NOCL1C_NOC_SM		0x1994
#define CLK_CON_DIV_DIV_CLKCMU_SDMA_NOC			0x1998
#define CLK_CON_DIV_DIV_CLKCMU_SDMA_NOC_SM		0x199c
#define CLK_CON_DIV_DIV_CP_HISPEEDY_CLK			0x19a0
#define CLK_CON_DIV_DIV_CP_HISPEEDY_CLK_SM		0x19a4
#define CLK_CON_DIV_DIV_CP_SHARED0_CLK			0x19a8
#define CLK_CON_DIV_DIV_CP_SHARED0_CLK_SM		0x19ac
#define CLK_CON_DIV_DIV_CP_SHARED2_CLK			0x19b0
#define CLK_CON_DIV_DIV_CP_SHARED2_CLK_SM		0x19b4
#define CLK_CON_DIV_CLKCMU_UFS_NOC			0x19b8
#define CLK_CON_DIV_DIV_CLKCMU_M2M_FRC			0x19bc
#define CLK_CON_DIV_DIV_CLKCMU_M2M_FRC_SM		0x19c0
#define CLK_CON_DIV_DIV_CLKCMU_MCSC_MCSC		0x19c4
#define CLK_CON_DIV_DIV_CLKCMU_MCSC_MCSC_SM		0x19c8
#define CLK_CON_DIV_DIV_CLKCMU_MCSC_NOC			0x19cc
#define CLK_CON_DIV_DIV_CLKCMU_MCSC_NOC_SM		0x19d0
#define CLK_CON_GAT_CLKCMU_MIF01_SWITCH			0x2000
#define CLK_CON_GAT_CLKCMU_MIF23_SWITCH			0x2004
#define CLK_CON_GAT_GATE_CLKCMU_ALIVE_NOC		0x200c
#define CLK_CON_GAT_GATE_CLKCMU_AUD_AUDIF0		0x2010
#define CLK_CON_GAT_GATE_CLKCMU_AUD_AUDIF0_SM		0x2014
#define CLK_CON_GAT_GATE_CLKCMU_AUD_AUDIF1		0x2018
#define CLK_CON_GAT_GATE_CLKCMU_AUD_AUDIF1_SM		0x201c
#define CLK_CON_GAT_GATE_CLKCMU_AUD_CPU			0x2020
#define CLK_CON_GAT_GATE_CLKCMU_AUD_CPU_SM		0x2024
#define CLK_CON_GAT_GATE_CLKCMU_AUD_NOC			0x2028
#define CLK_CON_GAT_GATE_CLKCMU_BRP_NOC			0x202c
#define CLK_CON_GAT_GATE_CLKCMU_CIS_CLK0		0x2030
#define CLK_CON_GAT_GATE_CLKCMU_CIS_CLK1		0x2034
#define CLK_CON_GAT_GATE_CLKCMU_CIS_CLK2		0x2038
#define CLK_CON_GAT_GATE_CLKCMU_CIS_CLK3		0x203c
#define CLK_CON_GAT_GATE_CLKCMU_CIS_CLK4		0x2040
#define CLK_CON_GAT_GATE_CLKCMU_CIS_CLK5		0x2044
#define CLK_CON_GAT_GATE_CLKCMU_CIS_CLK6		0x2048
#define CLK_CON_GAT_GATE_CLKCMU_CIS_CLK7		0x204c
#define CLK_CON_GAT_GATE_CLKCMU_CMU_BOOST		0x2050
#define CLK_CON_GAT_GATE_CLKCMU_CMU_BOOST_CAM		0x2054
#define CLK_CON_GAT_GATE_CLKCMU_CMU_BOOST_CPU		0x2058
#define CLK_CON_GAT_GATE_CLKCMU_CMU_BOOST_CPU_MIF	0x205c
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL0_DBG_NOC		0x2060
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL0_DBG_NOC_SM	0x2064
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL0_NOCP		0x2068
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL0_SWITCH		0x206c
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL0_SWITCH_SM	0x2070
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL1_SWITCH		0x2074
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL1_SWITCH_SM	0x2078
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL2_SWITCH		0x207c
#define CLK_CON_GAT_GATE_CLKCMU_CPUCL2_SWITCH_SM	0x2080
#define CLK_CON_GAT_GATE_CLKCMU_CSIS_DCPHY		0x2084
#define CLK_CON_GAT_GATE_CLKCMU_CSIS_NOC		0x2088
#define CLK_CON_GAT_GATE_CLKCMU_CSIS_OIS_MCU		0x208c
#define CLK_CON_GAT_GATE_CLKCMU_CSTAT_NOC		0x2090
#define CLK_CON_GAT_GATE_CLKCMU_DNC_NOC			0x2094
#define CLK_CON_GAT_GATE_CLKCMU_DNC_NOC_SM		0x2098
#define CLK_CON_GAT_GATE_CLKCMU_DPUB			0x209c
#define CLK_CON_GAT_GATE_CLKCMU_DPUB_ALT		0x20a0
#define CLK_CON_GAT_GATE_CLKCMU_DPUB_DSIM		0x20a4
#define CLK_CON_GAT_GATE_CLKCMU_DPUF			0x20a8
#define CLK_CON_GAT_GATE_CLKCMU_DPUF_ALT		0x20ac
#define CLK_CON_GAT_GATE_CLKCMU_DSP_NOC			0x20bc
#define CLK_CON_GAT_GATE_CLKCMU_DSP_NOC_SM		0x20c0
#define CLK_CON_GAT_GATE_CLKCMU_DSU_SWITCH		0x20c4
#define CLK_CON_GAT_GATE_CLKCMU_DSU_SWITCH_SM		0x20c8
#define CLK_CON_GAT_GATE_CLKCMU_G3D_NOCP		0x20cc
#define CLK_CON_GAT_GATE_CLKCMU_G3D_SWITCH		0x20d0
#define CLK_CON_GAT_GATE_CLKCMU_G3D_SWITCH_SM		0x20d4
#define CLK_CON_GAT_GATE_CLKCMU_GNPU_NOC		0x20e0
#define CLK_CON_GAT_GATE_CLKCMU_GNPU_NOC_SM		0x20e4
#define CLK_CON_GAT_GATE_CLKCMU_HSI0_DPGTC		0x20ec
#define CLK_CON_GAT_GATE_CLKCMU_HSI0_DPOSC		0x20f0
#define CLK_CON_GAT_GATE_CLKCMU_HSI0_NOC		0x20f4
#define CLK_CON_GAT_GATE_CLKCMU_HSI0_USB32DRD		0x20f8
#define CLK_CON_GAT_GATE_CLKCMU_UFS_MMC_CARD		0x20fc
#define CLK_CON_GAT_GATE_CLKCMU_UFS_MMC_CARD_SM		0x2100
#define CLK_CON_GAT_GATE_CLKCMU_HSI1_NOC		0x2104
#define CLK_CON_GAT_GATE_CLKCMU_HSI1_PCIE		0x2108
#define CLK_CON_GAT_GATE_CLKCMU_UFS_UFS_EMBD		0x210c
#define CLK_CON_GAT_GATE_CLKCMU_LME_LME			0x2110
#define CLK_CON_GAT_GATE_CLKCMU_LME_NOC			0x2114
#define CLK_CON_GAT_GATE_CLKCMU_M2M_NOC			0x2118
#define CLK_CON_GAT_GATE_CLKCMU_M2M_NOC_SM		0x211c
#define CLK_CON_GAT_GATE_CLKCMU_MFC0_MFC0		0x212c
#define CLK_CON_GAT_GATE_CLKCMU_MFC0_WFD		0x2130
#define CLK_CON_GAT_GATE_CLKCMU_MFC1_MFC1		0x2134
#define CLK_CON_GAT_GATE_CLKCMU_MIF_NOCP		0x2138
#define CLK_CON_GAT_GATE_CLKCMU_NOCL0_NOC		0x213c
#define CLK_CON_GAT_GATE_CLKCMU_NOCL0_NOC_SM		0x2140
#define CLK_CON_GAT_GATE_CLKCMU_NOCL1A_NOC		0x2144
#define CLK_CON_GAT_GATE_CLKCMU_NOCL1A_NOC_SM		0x2148
#define CLK_CON_GAT_GATE_CLKCMU_NOCL1B_NOC0		0x214c
#define CLK_CON_GAT_GATE_CLKCMU_NOCL1B_NOC0_SM		0x2150
#define CLK_CON_GAT_GATE_CLKCMU_NOCL1B_NOC1		0x2154
#define CLK_CON_GAT_GATE_CLKCMU_NOCL1C_NOC		0x2158
#define CLK_CON_GAT_GATE_CLKCMU_NOCL1C_NOC_SM		0x215c
#define CLK_CON_GAT_GATE_CLKCMU_PERIC0_IP0		0x2160
#define CLK_CON_GAT_GATE_CLKCMU_PERIC0_IP1		0x2164
#define CLK_CON_GAT_GATE_CLKCMU_PERIC0_NOC		0x2168
#define CLK_CON_GAT_GATE_CLKCMU_PERIC1_IP0		0x216c
#define CLK_CON_GAT_GATE_CLKCMU_PERIC1_IP1		0x2170
#define CLK_CON_GAT_GATE_CLKCMU_PERIC1_NOC		0x2174
#define CLK_CON_GAT_GATE_CLKCMU_PERIC2_IP0		0x2178
#define CLK_CON_GAT_GATE_CLKCMU_PERIC2_IP1		0x217c
#define CLK_CON_GAT_GATE_CLKCMU_PERIC2_NOC		0x2180
#define CLK_CON_GAT_GATE_CLKCMU_PERIS_GIC		0x2184
#define CLK_CON_GAT_GATE_CLKCMU_PERIS_NOC		0x2188
#define CLK_CON_GAT_GATE_CLKCMU_SDMA_NOC		0x2190
#define CLK_CON_GAT_GATE_CLKCMU_SDMA_NOC_SM		0x2194
#define CLK_CON_GAT_GATE_CLKCMU_SSP_NOC			0x2198
#define CLK_CON_GAT_GATE_CLKCMU_VTS_DMIC		0x219c
#define CLK_CON_GAT_GATE_CLKCMU_YUVP_NOC		0x21a0
#define CLK_CON_GAT_GATE_CP_HISPEEDY_CLK		0x21a4
#define CLK_CON_GAT_GATE_CP_HISPEEDY_CLK_SM		0x21a8
#define CLK_CON_GAT_GATE_CP_SHARED0_CLK			0x21ac
#define CLK_CON_GAT_GATE_CP_SHARED0_CLK_SM		0x21b0
#define CLK_CON_GAT_GATE_CP_SHARED1_CLK			0x21b4
#define CLK_CON_GAT_GATE_CP_SHARED2_CLK			0x21b8
#define CLK_CON_GAT_GATE_CP_SHARED2_CLK_SM		0x21bc
#define CLK_CON_GAT_GATE_CLKCMU_UFS_NOC			0x21c0
#define CLK_CON_GAT_GATE_CLKCMU_M2M_FRC			0x21c4
#define CLK_CON_GAT_GATE_CLKCMU_M2M_FRC_SM		0x21c8
#define CLK_CON_GAT_GATE_CLKCMU_MCSC_MCSC		0x21cc
#define CLK_CON_GAT_GATE_CLKCMU_MCSC_MCSC_SM		0x21d0
#define CLK_CON_GAT_GATE_CLKCMU_MCSC_NOC		0x21d4
#define CLK_CON_GAT_GATE_CLKCMU_MCSC_NOC_SM		0x21d8

static const unsigned long top_clk_regs[] __initconst = {
	PLL_LOCKTIME_PLL_MMC,
	PLL_LOCKTIME_PLL_SHARED0,
	PLL_LOCKTIME_PLL_SHARED1,
	PLL_LOCKTIME_PLL_SHARED2,
	PLL_LOCKTIME_PLL_SHARED3,
	PLL_LOCKTIME_PLL_SHARED4,
	PLL_LOCKTIME_PLL_SHARED_MIF,
	PLL_CON3_PLL_MMC,
	PLL_CON8_PLL_MMC,
	PLL_CON3_PLL_SHARED0,
	PLL_CON8_PLL_SHARED0,
	PLL_CON3_PLL_SHARED1,
	PLL_CON8_PLL_SHARED1,
	PLL_CON3_PLL_SHARED2,
	PLL_CON8_PLL_SHARED2,
	PLL_CON3_PLL_SHARED3,
	PLL_CON8_PLL_SHARED3,
	PLL_CON3_PLL_SHARED4,
	PLL_CON8_PLL_SHARED4,
	PLL_CON3_PLL_SHARED_MIF,
	PLL_CON8_PLL_SHARED_MIF,
	PLL_CON0_MUX_CP_MPLL_CLK_D2_USER,
	PLL_CON1_MUX_CP_MPLL_CLK_D2_USER,
	PLL_CON0_MUX_CP_MPLL_CLK_USER,
	PLL_CON1_MUX_CP_MPLL_CLK_USER,
	CLK_CON_MUX_CLKCMU_AUD_AUDIF0,
	CLK_CON_MUX_CLKCMU_AUD_AUDIF1,
	CLK_CON_MUX_CLKCMU_AUD_CPU,
	CLK_CON_MUX_CLKCMU_CPUCL0_DBG_NOC,
	CLK_CON_MUX_CLKCMU_CPUCL0_SWITCH,
	CLK_CON_MUX_CLKCMU_CPUCL1_SWITCH,
	CLK_CON_MUX_CLKCMU_CPUCL2_SWITCH,
	CLK_CON_MUX_CLKCMU_DNC_NOC,
	CLK_CON_MUX_CLKCMU_DPUB_NOC,
	CLK_CON_MUX_CLKCMU_DPUF_NOC,
	CLK_CON_MUX_CLKCMU_DSP_NOC,
	CLK_CON_MUX_CLKCMU_DSU_SWITCH,
	CLK_CON_MUX_CLKCMU_G3D_SWITCH,
	CLK_CON_MUX_CLKCMU_GNPU_NOC,
	CLK_CON_MUX_CLKCMU_UFS_MMC_CARD,
	CLK_CON_MUX_CLKCMU_M2M_NOC,
	CLK_CON_MUX_CLKCMU_NOCL0_NOC,
	CLK_CON_MUX_CLKCMU_NOCL1A_NOC,
	CLK_CON_MUX_CLKCMU_NOCL1B_NOC0,
	CLK_CON_MUX_CLKCMU_NOCL1C_NOC,
	CLK_CON_MUX_CLKCMU_SDMA_NOC,
	CLK_CON_MUX_CP_HISPEEDY_CLK,
	CLK_CON_MUX_CP_SHARED0_CLK,
	CLK_CON_MUX_CP_SHARED2_CLK,
	CLK_CON_MUX_MUX_CLKCMU_ALIVE_NOC,
	CLK_CON_MUX_MUX_CLKCMU_AUD_AUDIF0,
	CLK_CON_MUX_MUX_CLKCMU_AUD_AUDIF1,
	CLK_CON_MUX_MUX_CLKCMU_AUD_CPU,
	CLK_CON_MUX_MUX_CLKCMU_AUD_NOC,
	CLK_CON_MUX_MUX_CLKCMU_BRP_NOC,
	CLK_CON_MUX_MUX_CLKCMU_CIS_CLK0,
	CLK_CON_MUX_MUX_CLKCMU_CIS_CLK1,
	CLK_CON_MUX_MUX_CLKCMU_CIS_CLK2,
	CLK_CON_MUX_MUX_CLKCMU_CIS_CLK3,
	CLK_CON_MUX_MUX_CLKCMU_CIS_CLK4,
	CLK_CON_MUX_MUX_CLKCMU_CIS_CLK5,
	CLK_CON_MUX_MUX_CLKCMU_CIS_CLK6,
	CLK_CON_MUX_MUX_CLKCMU_CIS_CLK7,
	CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST,
	CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_CAM,
	CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_CPU,
	CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_MIF,
	CLK_CON_MUX_MUX_CLKCMU_CPUCL0_DBG_NOC,
	CLK_CON_MUX_MUX_CLKCMU_CPUCL0_NOCP,
	CLK_CON_MUX_MUX_CLKCMU_CPUCL0_SWITCH,
	CLK_CON_MUX_MUX_CLKCMU_CPUCL1_SWITCH,
	CLK_CON_MUX_MUX_CLKCMU_CPUCL2_SWITCH,
	CLK_CON_MUX_MUX_CLKCMU_CSIS_DCPHY,
	CLK_CON_MUX_MUX_CLKCMU_CSIS_NOC,
	CLK_CON_MUX_MUX_CLKCMU_CSIS_OIS_MCU,
	CLK_CON_MUX_MUX_CLKCMU_CSTAT_NOC,
	CLK_CON_MUX_MUX_CLKCMU_DNC_NOC,
	CLK_CON_MUX_MUX_CLKCMU_DPUB,
	CLK_CON_MUX_MUX_CLKCMU_DPUB_ALT,
	CLK_CON_MUX_MUX_CLKCMU_DPUB_DSIM,
	CLK_CON_MUX_MUX_CLKCMU_DPUF,
	CLK_CON_MUX_MUX_CLKCMU_DPUF_ALT,
	CLK_CON_MUX_MUX_CLKCMU_DSP_NOC,
	CLK_CON_MUX_MUX_CLKCMU_DSU_SWITCH,
	CLK_CON_MUX_MUX_CLKCMU_G3D_NOCP,
	CLK_CON_MUX_MUX_CLKCMU_G3D_SWITCH,
	CLK_CON_MUX_MUX_CLKCMU_GNPU_NOC,
	CLK_CON_MUX_MUX_CLKCMU_HSI0_DPGTC,
	CLK_CON_MUX_MUX_CLKCMU_HSI0_DPOSC,
	CLK_CON_MUX_MUX_CLKCMU_HSI0_NOC,
	CLK_CON_MUX_MUX_CLKCMU_HSI0_USB32DRD,
	CLK_CON_MUX_MUX_CLKCMU_UFS_MMC_CARD,
	CLK_CON_MUX_MUX_CLKCMU_HSI1_NOC,
	CLK_CON_MUX_MUX_CLKCMU_HSI1_PCIE,
	CLK_CON_MUX_MUX_CLKCMU_UFS_UFS_EMBD,
	CLK_CON_MUX_MUX_CLKCMU_LME_LME,
	CLK_CON_MUX_MUX_CLKCMU_LME_NOC,
	CLK_CON_MUX_MUX_CLKCMU_M2M_NOC,
	CLK_CON_MUX_MUX_CLKCMU_MCSC_MCSC,
	CLK_CON_MUX_MUX_CLKCMU_MCSC_NOC,
	CLK_CON_MUX_MUX_CLKCMU_MFC0_MFC0,
	CLK_CON_MUX_MUX_CLKCMU_MFC0_WFD,
	CLK_CON_MUX_MUX_CLKCMU_MFC1_MFC1,
	CLK_CON_MUX_MUX_CLKCMU_MIF_NOCP,
	CLK_CON_MUX_MUX_CLKCMU_MIF_SWITCH,
	CLK_CON_MUX_MUX_CLKCMU_NOCL0_NOC,
	CLK_CON_MUX_MUX_CLKCMU_NOCL1A_NOC,
	CLK_CON_MUX_MUX_CLKCMU_NOCL1B_NOC0,
	CLK_CON_MUX_MUX_CLKCMU_NOCL1B_NOC1,
	CLK_CON_MUX_MUX_CLKCMU_NOCL1C_NOC,
	CLK_CON_MUX_MUX_CLKCMU_PERIC0_IP0,
	CLK_CON_MUX_MUX_CLKCMU_PERIC0_IP1,
	CLK_CON_MUX_MUX_CLKCMU_PERIC0_NOC,
	CLK_CON_MUX_MUX_CLKCMU_PERIC1_IP0,
	CLK_CON_MUX_MUX_CLKCMU_PERIC1_IP1,
	CLK_CON_MUX_MUX_CLKCMU_PERIC1_NOC,
	CLK_CON_MUX_MUX_CLKCMU_PERIC2_IP0,
	CLK_CON_MUX_MUX_CLKCMU_PERIC2_IP1,
	CLK_CON_MUX_MUX_CLKCMU_PERIC2_NOC,
	CLK_CON_MUX_MUX_CLKCMU_PERIS_GIC,
	CLK_CON_MUX_MUX_CLKCMU_PERIS_NOC,
	CLK_CON_MUX_MUX_CLKCMU_SDMA_NOC,
	CLK_CON_MUX_MUX_CLKCMU_SSP_NOC,
	CLK_CON_MUX_MUX_CLKCMU_VTS_DMIC,
	CLK_CON_MUX_MUX_CLKCMU_YUVP_NOC,
	CLK_CON_MUX_MUX_CMU_CMUREF,
	CLK_CON_MUX_MUX_CP_HISPEEDY_CLK,
	CLK_CON_MUX_MUX_CP_SHARED0_CLK,
	CLK_CON_MUX_MUX_CP_SHARED1_CLK,
	CLK_CON_MUX_MUX_CP_SHARED2_CLK,
	CLK_CON_MUX_CLKCMU_M2M_FRC,
	CLK_CON_MUX_CLKCMU_MCSC_MCSC,
	CLK_CON_MUX_CLKCMU_MCSC_NOC,
	CLK_CON_MUX_MUX_CLKCMU_M2M_FRC,
	CLK_CON_MUX_MUX_CLKCMU_UFS_NOC,
	CLK_CON_DIV_CLKCMU_ALIVE_NOC,
	CLK_CON_DIV_CLKCMU_AUD_NOC,
	CLK_CON_DIV_CLKCMU_BRP_NOC,
	CLK_CON_DIV_CLKCMU_CMU_BOOST,
	CLK_CON_DIV_CLKCMU_CMU_BOOST_CAM,
	CLK_CON_DIV_CLKCMU_CMU_BOOST_CPU,
	CLK_CON_DIV_CLKCMU_CMU_BOOST_MIF,
	CLK_CON_DIV_CLKCMU_CPUCL0_NOCP,
	CLK_CON_DIV_CLKCMU_CSIS_DCPHY,
	CLK_CON_DIV_CLKCMU_CSIS_NOC,
	CLK_CON_DIV_CLKCMU_CSIS_OIS_MCU,
	CLK_CON_DIV_CLKCMU_CSTAT_NOC,
	CLK_CON_DIV_CLKCMU_DPUB_DSIM,
	CLK_CON_DIV_CLKCMU_LME_LME,
	CLK_CON_DIV_CLKCMU_G3D_NOCP,
	CLK_CON_DIV_CLKCMU_HSI0_DPGTC,
	CLK_CON_DIV_CLKCMU_HSI0_DPOSC,
	CLK_CON_DIV_CLKCMU_HSI0_NOC,
	CLK_CON_DIV_CLKCMU_HSI0_USB32DRD,
	CLK_CON_DIV_CLKCMU_HSI1_NOC,
	CLK_CON_DIV_CLKCMU_HSI1_PCIE,
	CLK_CON_DIV_CLKCMU_UFS_UFS_EMBD,
	CLK_CON_DIV_CLKCMU_LME_NOC,
	CLK_CON_DIV_CLKCMU_MFC0_MFC0,
	CLK_CON_DIV_CLKCMU_MFC0_WFD,
	CLK_CON_DIV_CLKCMU_MFC1_MFC1,
	CLK_CON_DIV_CLKCMU_MIF_NOCP,
	CLK_CON_DIV_CLKCMU_NOCL1B_NOC1,
	CLK_CON_DIV_CLKCMU_PERIC0_IP0,
	CLK_CON_DIV_CLKCMU_PERIC0_IP1,
	CLK_CON_DIV_CLKCMU_PERIC0_NOC,
	CLK_CON_DIV_CLKCMU_PERIC1_IP0,
	CLK_CON_DIV_CLKCMU_PERIC1_IP1,
	CLK_CON_DIV_CLKCMU_PERIC1_NOC,
	CLK_CON_DIV_CLKCMU_PERIC2_IP0,
	CLK_CON_DIV_CLKCMU_PERIC2_IP1,
	CLK_CON_DIV_CLKCMU_PERIC2_NOC,
	CLK_CON_DIV_CLKCMU_PERIS_GIC,
	CLK_CON_DIV_CLKCMU_PERIS_NOC,
	CLK_CON_DIV_CLKCMU_SSP_NOC,
	CLK_CON_DIV_CLKCMU_VTS_DMIC,
	CLK_CON_DIV_CLKCMU_YUVP_NOC,
	CLK_CON_DIV_CP_SHARED1_CLK,
	CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF0,
	CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF0_SM,
	CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF1,
	CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF1_SM,
	CLK_CON_DIV_DIV_CLKCMU_AUD_CPU,
	CLK_CON_DIV_DIV_CLKCMU_AUD_CPU_SM,
	CLK_CON_DIV_DIV_CLKCMU_CIS_CLK0,
	CLK_CON_DIV_DIV_CLKCMU_CIS_CLK1,
	CLK_CON_DIV_DIV_CLKCMU_CIS_CLK2,
	CLK_CON_DIV_DIV_CLKCMU_CIS_CLK3,
	CLK_CON_DIV_DIV_CLKCMU_CIS_CLK4,
	CLK_CON_DIV_DIV_CLKCMU_CIS_CLK5,
	CLK_CON_DIV_DIV_CLKCMU_CIS_CLK6,
	CLK_CON_DIV_DIV_CLKCMU_CIS_CLK7,
	CLK_CON_DIV_DIV_CLKCMU_CPUCL0_DBG_NOC,
	CLK_CON_DIV_DIV_CLKCMU_CPUCL0_DBG_NOC_SM,
	CLK_CON_DIV_DIV_CLKCMU_CPUCL0_SWITCH,
	CLK_CON_DIV_DIV_CLKCMU_CPUCL0_SWITCH_SM,
	CLK_CON_DIV_DIV_CLKCMU_CPUCL1_SWITCH,
	CLK_CON_DIV_DIV_CLKCMU_CPUCL1_SWITCH_SM,
	CLK_CON_DIV_DIV_CLKCMU_CPUCL2_SWITCH,
	CLK_CON_DIV_DIV_CLKCMU_CPUCL2_SWITCH_SM,
	CLK_CON_DIV_DIV_CLKCMU_DNC_NOC,
	CLK_CON_DIV_DIV_CLKCMU_DNC_NOC_SM,
	CLK_CON_DIV_DIV_CLKCMU_DPUB,
	CLK_CON_DIV_DIV_CLKCMU_DPUB_ALT,
	CLK_CON_DIV_DIV_CLKCMU_DPUF,
	CLK_CON_DIV_DIV_CLKCMU_DPUF_ALT,
	CLK_CON_DIV_DIV_CLKCMU_DSP_NOC,
	CLK_CON_DIV_DIV_CLKCMU_DSP_NOC_SM,
	CLK_CON_DIV_DIV_CLKCMU_DSU_SWITCH,
	CLK_CON_DIV_DIV_CLKCMU_DSU_SWITCH_SM,
	CLK_CON_DIV_DIV_CLKCMU_G3D_SWITCH,
	CLK_CON_DIV_DIV_CLKCMU_G3D_SWITCH_SM,
	CLK_CON_DIV_DIV_CLKCMU_GNPU_NOC,
	CLK_CON_DIV_DIV_CLKCMU_GNPU_NOC_SM,
	CLK_CON_DIV_DIV_CLKCMU_UFS_MMC_CARD,
	CLK_CON_DIV_DIV_CLKCMU_UFS_MMC_CARD_SM,
	CLK_CON_DIV_DIV_CLKCMU_M2M_NOC,
	CLK_CON_DIV_DIV_CLKCMU_M2M_NOC_SM,
	CLK_CON_DIV_DIV_CLKCMU_NOCL0_NOC,
	CLK_CON_DIV_DIV_CLKCMU_NOCL0_NOC_SM,
	CLK_CON_DIV_DIV_CLKCMU_NOCL1A_NOC,
	CLK_CON_DIV_DIV_CLKCMU_NOCL1A_NOC_SM,
	CLK_CON_DIV_DIV_CLKCMU_NOCL1B_NOC0,
	CLK_CON_DIV_DIV_CLKCMU_NOCL1B_NOC0_SM,
	CLK_CON_DIV_DIV_CLKCMU_NOCL1C_NOC,
	CLK_CON_DIV_DIV_CLKCMU_NOCL1C_NOC_SM,
	CLK_CON_DIV_DIV_CLKCMU_SDMA_NOC,
	CLK_CON_DIV_DIV_CLKCMU_SDMA_NOC_SM,
	CLK_CON_DIV_DIV_CP_HISPEEDY_CLK,
	CLK_CON_DIV_DIV_CP_HISPEEDY_CLK_SM,
	CLK_CON_DIV_DIV_CP_SHARED0_CLK,
	CLK_CON_DIV_DIV_CP_SHARED0_CLK_SM,
	CLK_CON_DIV_DIV_CP_SHARED2_CLK,
	CLK_CON_DIV_DIV_CP_SHARED2_CLK_SM,
	CLK_CON_DIV_CLKCMU_UFS_NOC,
	CLK_CON_DIV_DIV_CLKCMU_M2M_FRC,
	CLK_CON_DIV_DIV_CLKCMU_M2M_FRC_SM,
	CLK_CON_DIV_DIV_CLKCMU_MCSC_MCSC,
	CLK_CON_DIV_DIV_CLKCMU_MCSC_MCSC_SM,
	CLK_CON_DIV_DIV_CLKCMU_MCSC_NOC,
	CLK_CON_DIV_DIV_CLKCMU_MCSC_NOC_SM,
	CLK_CON_GAT_CLKCMU_MIF01_SWITCH,
	CLK_CON_GAT_CLKCMU_MIF23_SWITCH,
	CLK_CON_GAT_GATE_CLKCMU_ALIVE_NOC,
	CLK_CON_GAT_GATE_CLKCMU_AUD_AUDIF0,
	CLK_CON_GAT_GATE_CLKCMU_AUD_AUDIF0_SM,
	CLK_CON_GAT_GATE_CLKCMU_AUD_AUDIF1,
	CLK_CON_GAT_GATE_CLKCMU_AUD_AUDIF1_SM,
	CLK_CON_GAT_GATE_CLKCMU_AUD_CPU,
	CLK_CON_GAT_GATE_CLKCMU_AUD_CPU_SM,
	CLK_CON_GAT_GATE_CLKCMU_AUD_NOC,
	CLK_CON_GAT_GATE_CLKCMU_BRP_NOC,
	CLK_CON_GAT_GATE_CLKCMU_CIS_CLK0,
	CLK_CON_GAT_GATE_CLKCMU_CIS_CLK1,
	CLK_CON_GAT_GATE_CLKCMU_CIS_CLK2,
	CLK_CON_GAT_GATE_CLKCMU_CIS_CLK3,
	CLK_CON_GAT_GATE_CLKCMU_CIS_CLK4,
	CLK_CON_GAT_GATE_CLKCMU_CIS_CLK5,
	CLK_CON_GAT_GATE_CLKCMU_CIS_CLK6,
	CLK_CON_GAT_GATE_CLKCMU_CIS_CLK7,
	CLK_CON_GAT_GATE_CLKCMU_CMU_BOOST,
	CLK_CON_GAT_GATE_CLKCMU_CMU_BOOST_CAM,
	CLK_CON_GAT_GATE_CLKCMU_CMU_BOOST_CPU,
	CLK_CON_GAT_GATE_CLKCMU_CMU_BOOST_CPU_MIF,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL0_DBG_NOC,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL0_DBG_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL0_NOCP,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL0_SWITCH,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL0_SWITCH_SM,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL1_SWITCH,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL1_SWITCH_SM,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL2_SWITCH,
	CLK_CON_GAT_GATE_CLKCMU_CPUCL2_SWITCH_SM,
	CLK_CON_GAT_GATE_CLKCMU_CSIS_DCPHY,
	CLK_CON_GAT_GATE_CLKCMU_CSIS_NOC,
	CLK_CON_GAT_GATE_CLKCMU_CSIS_OIS_MCU,
	CLK_CON_GAT_GATE_CLKCMU_CSTAT_NOC,
	CLK_CON_GAT_GATE_CLKCMU_DNC_NOC,
	CLK_CON_GAT_GATE_CLKCMU_DNC_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_DPUB,
	CLK_CON_GAT_GATE_CLKCMU_DPUB_ALT,
	CLK_CON_GAT_GATE_CLKCMU_DPUB_DSIM,
	CLK_CON_GAT_GATE_CLKCMU_DPUF,
	CLK_CON_GAT_GATE_CLKCMU_DPUF_ALT,
	CLK_CON_GAT_GATE_CLKCMU_DSP_NOC,
	CLK_CON_GAT_GATE_CLKCMU_DSP_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_DSU_SWITCH,
	CLK_CON_GAT_GATE_CLKCMU_DSU_SWITCH_SM,
	CLK_CON_GAT_GATE_CLKCMU_G3D_NOCP,
	CLK_CON_GAT_GATE_CLKCMU_G3D_SWITCH,
	CLK_CON_GAT_GATE_CLKCMU_G3D_SWITCH_SM,
	CLK_CON_GAT_GATE_CLKCMU_GNPU_NOC,
	CLK_CON_GAT_GATE_CLKCMU_GNPU_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_HSI0_DPGTC,
	CLK_CON_GAT_GATE_CLKCMU_HSI0_DPOSC,
	CLK_CON_GAT_GATE_CLKCMU_HSI0_NOC,
	CLK_CON_GAT_GATE_CLKCMU_HSI0_USB32DRD,
	CLK_CON_GAT_GATE_CLKCMU_UFS_MMC_CARD,
	CLK_CON_GAT_GATE_CLKCMU_UFS_MMC_CARD_SM,
	CLK_CON_GAT_GATE_CLKCMU_HSI1_NOC,
	CLK_CON_GAT_GATE_CLKCMU_HSI1_PCIE,
	CLK_CON_GAT_GATE_CLKCMU_UFS_UFS_EMBD,
	CLK_CON_GAT_GATE_CLKCMU_LME_LME,
	CLK_CON_GAT_GATE_CLKCMU_LME_NOC,
	CLK_CON_GAT_GATE_CLKCMU_M2M_NOC,
	CLK_CON_GAT_GATE_CLKCMU_M2M_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_MFC0_MFC0,
	CLK_CON_GAT_GATE_CLKCMU_MFC0_WFD,
	CLK_CON_GAT_GATE_CLKCMU_MFC1_MFC1,
	CLK_CON_GAT_GATE_CLKCMU_MIF_NOCP,
	CLK_CON_GAT_GATE_CLKCMU_NOCL0_NOC,
	CLK_CON_GAT_GATE_CLKCMU_NOCL0_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_NOCL1A_NOC,
	CLK_CON_GAT_GATE_CLKCMU_NOCL1A_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_NOCL1B_NOC0,
	CLK_CON_GAT_GATE_CLKCMU_NOCL1B_NOC0_SM,
	CLK_CON_GAT_GATE_CLKCMU_NOCL1B_NOC1,
	CLK_CON_GAT_GATE_CLKCMU_NOCL1C_NOC,
	CLK_CON_GAT_GATE_CLKCMU_NOCL1C_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_PERIC0_IP0,
	CLK_CON_GAT_GATE_CLKCMU_PERIC0_IP1,
	CLK_CON_GAT_GATE_CLKCMU_PERIC0_NOC,
	CLK_CON_GAT_GATE_CLKCMU_PERIC1_IP0,
	CLK_CON_GAT_GATE_CLKCMU_PERIC1_IP1,
	CLK_CON_GAT_GATE_CLKCMU_PERIC1_NOC,
	CLK_CON_GAT_GATE_CLKCMU_PERIC2_IP0,
	CLK_CON_GAT_GATE_CLKCMU_PERIC2_IP1,
	CLK_CON_GAT_GATE_CLKCMU_PERIC2_NOC,
	CLK_CON_GAT_GATE_CLKCMU_PERIS_GIC,
	CLK_CON_GAT_GATE_CLKCMU_PERIS_NOC,
	CLK_CON_GAT_GATE_CLKCMU_SDMA_NOC,
	CLK_CON_GAT_GATE_CLKCMU_SDMA_NOC_SM,
	CLK_CON_GAT_GATE_CLKCMU_SSP_NOC,
	CLK_CON_GAT_GATE_CLKCMU_VTS_DMIC,
	CLK_CON_GAT_GATE_CLKCMU_YUVP_NOC,
	CLK_CON_GAT_GATE_CP_HISPEEDY_CLK,
	CLK_CON_GAT_GATE_CP_HISPEEDY_CLK_SM,
	CLK_CON_GAT_GATE_CP_SHARED0_CLK,
	CLK_CON_GAT_GATE_CP_SHARED0_CLK_SM,
	CLK_CON_GAT_GATE_CP_SHARED1_CLK,
	CLK_CON_GAT_GATE_CP_SHARED2_CLK,
	CLK_CON_GAT_GATE_CP_SHARED2_CLK_SM,
	CLK_CON_GAT_GATE_CLKCMU_UFS_NOC,
	CLK_CON_GAT_GATE_CLKCMU_M2M_FRC,
	CLK_CON_GAT_GATE_CLKCMU_M2M_FRC_SM,
	CLK_CON_GAT_GATE_CLKCMU_MCSC_MCSC,
	CLK_CON_GAT_GATE_CLKCMU_MCSC_MCSC_SM,
	CLK_CON_GAT_GATE_CLKCMU_MCSC_NOC,
	CLK_CON_GAT_GATE_CLKCMU_MCSC_NOC_SM,
};

/* List of parent clocks for Muxes in CMU_TOP */
PNAME(mout_cmu_cp_mpll_clk_d2_user_parents)	= { "oscclk" };
PNAME(mout_cmu_cp_mpll_clk_user_parents)	= { "oscclk" };
PNAME(mout_cmu_aud_audif0_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "mout_cmu_cp_mpll_clk_d2_user",
						    "oscclk", "oscclk",
						    "oscclk" };
PNAME(mout_cmu_aud_audif1_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "mout_cmu_cp_mpll_clk_d2_user",
						    "oscclk", "oscclk",
						    "oscclk" };
PNAME(mout_cmu_aud_cpu_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "mout_cmu_cp_mpll_clk_d2_user" };
PNAME(mout_cmu_cpucl0_dbg_noc_p)		= { "dout_shared2_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2" };
PNAME(mout_cmu_cpucl0_switch_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_cpucl1_switch_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_cpucl2_switch_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_dnc_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "oscclk" };
PNAME(mout_cmu_dpub_noc_p)			= { "dout_cmu_div_dpub",
						    "dout_cmu_div_dpub_alt"};
PNAME(mout_cmu_dpuf_noc_p)			= { "dout_cmu_div_dpuf",
						    "dout_cmu_div_dpuf_alt" };
PNAME(mout_cmu_dsp_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "oscclk" };
PNAME(mout_cmu_dsu_switch_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_g3d_switch_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_gnpu_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "oscclk" };
PNAME(mout_cmu_ufs_mmc_card_p)			= { "oscclk",
						    "dout_shared2_div1",
						    "dout_mmc_div1",
						    "dout_shared0_div2" };
PNAME(mout_cmu_m2m_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_nocl0_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "mout_cmu_cp_mpll_clk_d2_user",
						    "dout_shared_mif_div2" };
PNAME(mout_cmu_nocl1a_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_nocl1b_noc0_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_nocl1c_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_sdma_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "oscclk" };
PNAME(mout_cmu_cp_hispeedy_clk_p)		= { "dout_shared2_div1",
						    "dout_shared3_div1" };
PNAME(mout_cmu_cp_shared0_clk_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1" };
PNAME(mout_cmu_cp_shared2_clk_p)		= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared1_div2" };
PNAME(mout_cmu_mux_alive_noc_p)			= { "dout_shared0_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_aud_audif0_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "mout_cmu_cp_mpll_clk_d2_user",
						    "oscclk", "oscclk",
						    "oscclk" };
PNAME(mout_cmu_mux_aud_audif1_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "mout_cmu_cp_mpll_clk_d2_user",
						    "oscclk", "oscclk",
						    "oscclk" };
PNAME(mout_cmu_mux_aud_cpu_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "mout_cmu_cp_mpll_clk_d2_user" };
PNAME(mout_cmu_mux_aud_noc_p)			= { "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "mout_cmu_cp_mpll_clk_d2_user",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_brp_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_cis_clk0_p)			= { "oscclk",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cis_clk1_p)			= { "oscclk",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cis_clk2_p)			= { "oscclk",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cis_clk3_p)			= { "oscclk",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cis_clk4_p)			= { "oscclk",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cis_clk5_p)			= { "oscclk",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cis_clk6_p)			= { "oscclk",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cis_clk7_p)			= { "oscclk",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cmu_boost_p)			= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_cmu_boost_cam_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_cmu_boost_cpu_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_cmu_boost_mif_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_cpucl0_dbg_noc_p)		= { "dout_shared2_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2" };
PNAME(mout_cmu_mux_cpucl0_nocp_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_cpucl0_switch_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_cpucl1_switch_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_cpucl2_switch_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_csis_dcphy_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_csis_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_csis_ois_mcu_p)		= { "dout_shared0_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cstat_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_dnc_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_dpub_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_dpub_alt_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_dpub_dsim_p)			= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2" };
PNAME(mout_cmu_mux_dpuf_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_dpuf_alt_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_dsp_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_dsu_switch_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "oscclk", "oscclk" };
PNAME(mout_cmu_mux_g3d_nocp_p)			= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_g3d_switch_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_gnpu_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_hsi0_dpgtc_p)		= { "oscclk",
						    "dout_shared0_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_hsi0_dposc_p)		= { "oscclk",
						    "dout_shared2_div1" };
PNAME(mout_cmu_mux_hsi0_noc_p)			= { "dout_shared0_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_hsi0_usb32drd_p)		= { "oscclk",
						    "dout_shared0_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_ufs_mmc_card_p)		= { "oscclk",
						    "dout_shared2_div1",
						    "dout_mmc_div1",
						    "dout_shared0_div2" };
PNAME(mout_cmu_mux_hsi1_noc_p)			= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_hsi1_pcie_p)			= { "oscclk",
						    "dout_shared2_div1" };
PNAME(mout_cmu_mux_ufs_ufs_embd_p)		= { "oscclk",
						    "dout_shared0_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_lme_lme_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_lme_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_m2m_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_mcsc_mcsc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_mcsc_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_mfc0_mfc0_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_mfc0_wfd_p)			= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "dout_shared4_div2",
						    "oscclk", "oscclk",
						    "oscclk" };
PNAME(mout_cmu_mux_mfc1_mfc1_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_mif_nocp_p)			= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_mif_switch_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "mout_cmu_cp_mpll_clk_user",
						    "dout_shared_mif_div1" };
PNAME(mout_cmu_mux_nocl0_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "mout_cmu_cp_mpll_clk_d2_user",
						    "dout_shared_mif_div2" };
PNAME(mout_cmu_mux_nocl1a_noc_p)		= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_nocl1b_noc0_p)		= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_nocl1b_noc1_p)		= { "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_nocl1c_noc_p)		= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_peric0_ip0_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_peric0_ip1_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_peric0_noc_p)		= { "dout_shared0_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_peric1_ip0_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_peric1_ip1_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_peric1_noc_p)		= { "dout_shared0_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_peric2_ip0_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_peric2_ip1_p)		= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_peric2_noc_p)		= { "dout_shared0_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_peris_gic_p)			= { "dout_shared0_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_peris_noc_p)			= { "dout_shared0_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_sdma_noc_p)			= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_ssp_noc_p)			= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };
PNAME(mout_cmu_mux_vts_dmic_p)			= { "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2" };
PNAME(mout_cmu_mux_yuvp_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_cmu_cmuref_p)		= { "oscclk",
						    "dout_cmu_boost" };
PNAME(mout_cmu_mux_cp_hispeedy_clk_p)		= { "dout_shared2_div1",
						    "dout_shared3_div1" };
PNAME(mout_cmu_mux_cp_shared0_clk_p)		= { "dout_shared0_div1",
						    "dout_shared1_div1",
						    "dout_shared2_div1",
						    "dout_shared3_div1" };
PNAME(mout_cmu_mux_cp_shared1_clk_p)		= { "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2" };
PNAME(mout_cmu_mux_cp_shared2_clk_p)		= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared1_div2" };
PNAME(mout_cmu_m2m_frc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mcsc_mcsc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mcsc_noc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_m2m_frc_p)			= { "dout_shared2_div1",
						    "dout_shared3_div1",
						    "dout_shared4_div1",
						    "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared3_div2",
						    "oscclk" };
PNAME(mout_cmu_mux_ufs_noc_p)			= { "dout_shared0_div2",
						    "dout_shared1_div2",
						    "dout_shared2_div2",
						    "dout_shared4_div2" };

static const struct samsung_pll_clock top_pll_clks[] __initconst = {
	PLL(pll_4311, CLK_FOUT_SHARED0_PLL, "fout_shared0_pll", "oscclk",
	    PLL_LOCKTIME_PLL_SHARED0, PLL_CON3_PLL_SHARED0, NULL),
	PLL(pll_4311, CLK_FOUT_SHARED1_PLL, "fout_shared1_pll", "oscclk",
	    PLL_LOCKTIME_PLL_SHARED1, PLL_CON3_PLL_SHARED1, NULL),
	PLL(pll_4311, CLK_FOUT_SHARED2_PLL, "fout_shared2_pll", "oscclk",
	    PLL_LOCKTIME_PLL_SHARED2, PLL_CON3_PLL_SHARED2, NULL),
	PLL(pll_4311, CLK_FOUT_SHARED3_PLL, "fout_shared3_pll", "oscclk",
	    PLL_LOCKTIME_PLL_SHARED3, PLL_CON3_PLL_SHARED3, NULL),
	PLL(pll_4311, CLK_FOUT_SHARED4_PLL, "fout_shared4_pll", "oscclk",
	    PLL_LOCKTIME_PLL_SHARED4, PLL_CON3_PLL_SHARED4, NULL),
	PLL(pll_4311, CLK_FOUT_MMC_PLL, "fout_mmc_pll", "oscclk",
	    PLL_LOCKTIME_PLL_MMC, PLL_CON3_PLL_MMC, NULL),
	PLL(pll_4311, CLK_FOUT_SHARED_MIF_PLL, "fout_shared_mif_pll", "oscclk",
	    PLL_LOCKTIME_PLL_SHARED_MIF, PLL_CON3_PLL_SHARED_MIF, NULL),
};

static const struct samsung_mux_clock top_mux_clks[] __initconst = {
	MUX(CLK_MOUT_CMU_CP_MPLL_CLK_D2_USER, "mout_cmu_cp_mpll_clk_d2_user",
	    mout_cmu_cp_mpll_clk_d2_user_parents,
	    PLL_CON0_MUX_CP_MPLL_CLK_D2_USER, 4, 1),
	MUX(CLK_MOUT_CMU_CP_MPLL_CLK_USER, "mout_cmu_cp_mpll_clk_user",
	    mout_cmu_cp_mpll_clk_user_parents, PLL_CON0_MUX_CP_MPLL_CLK_USER,
	    4, 1),
	MUX(CLK_MOUT_CMU_AUD_AUDIF0, "mout_cmu_aud_audif0",
	    mout_cmu_aud_audif0_p, CLK_CON_MUX_CLKCMU_AUD_AUDIF0, 0, 3),
	MUX(CLK_MOUT_CMU_AUD_AUDIF1, "mout_cmu_aud_audif1",
	    mout_cmu_aud_audif1_p, CLK_CON_MUX_CLKCMU_AUD_AUDIF1, 0, 3),
	MUX(CLK_MOUT_CMU_AUD_CPU, "mout_cmu_aud_cpu", mout_cmu_aud_cpu_p,
	    CLK_CON_MUX_CLKCMU_AUD_CPU, 0, 3),
	MUX(CLK_MOUT_CMU_CPUCL0_DBG_NOC, "mout_cmu_cpucl0_dbg_noc",
	    mout_cmu_cpucl0_dbg_noc_p, CLK_CON_MUX_CLKCMU_CPUCL0_DBG_NOC,
	    0, 2),
	MUX(CLK_MOUT_CMU_CPUCL0_SWITCH, "mout_cmu_cpucl0_switch",
	    mout_cmu_cpucl0_switch_p, CLK_CON_MUX_CLKCMU_CPUCL0_SWITCH, 0, 3),
	MUX(CLK_MOUT_CMU_CPUCL1_SWITCH, "mout_cmu_cpucl1_switch",
	    mout_cmu_cpucl1_switch_p, CLK_CON_MUX_CLKCMU_CPUCL1_SWITCH, 0, 3),
	MUX(CLK_MOUT_CMU_CPUCL2_SWITCH, "mout_cmu_cpucl2_switch",
	    mout_cmu_cpucl2_switch_p, CLK_CON_MUX_CLKCMU_CPUCL2_SWITCH, 0, 3),
	MUX(CLK_MOUT_CMU_DNC_NOC, "mout_cmu_dnc_noc", mout_cmu_dnc_noc_p,
	    CLK_CON_MUX_CLKCMU_DNC_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_DPUB_NOC, "mout_cmu_dpub_noc", mout_cmu_dpub_noc_p,
	    CLK_CON_MUX_CLKCMU_DPUB_NOC, 0, 1),
	MUX(CLK_MOUT_CMU_DPUF_NOC, "mout_cmu_dpuf_noc", mout_cmu_dpuf_noc_p,
	    CLK_CON_MUX_CLKCMU_DPUF_NOC, 0, 1),
	MUX(CLK_MOUT_CMU_DSP_NOC, "mout_cmu_dsp_noc", mout_cmu_dsp_noc_p,
	    CLK_CON_MUX_CLKCMU_DSP_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_DSU_SWITCH, "mout_cmu_dsu_switch",
	    mout_cmu_dsu_switch_p, CLK_CON_MUX_CLKCMU_DSU_SWITCH, 0, 3),
	MUX(CLK_MOUT_CMU_G3D_SWITCH, "mout_cmu_g3d_switch",
	    mout_cmu_g3d_switch_p, CLK_CON_MUX_CLKCMU_G3D_SWITCH, 0, 3),
	MUX(CLK_MOUT_CMU_GNPU_NOC, "mout_cmu_gnpu_noc", mout_cmu_gnpu_noc_p,
	    CLK_CON_MUX_CLKCMU_GNPU_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_UFS_MMC_CARD, "mout_cmu_ufs_mmc_card",
	    mout_cmu_ufs_mmc_card_p, CLK_CON_MUX_CLKCMU_UFS_MMC_CARD, 0, 2),
	MUX(CLK_MOUT_CMU_M2M_NOC, "mout_cmu_m2m_noc", mout_cmu_m2m_noc_p,
	    CLK_CON_MUX_CLKCMU_M2M_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_NOCL0_NOC, "mout_cmu_nocl0_noc", mout_cmu_nocl0_noc_p,
	    CLK_CON_MUX_CLKCMU_NOCL0_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_NOCL1A_NOC, "mout_cmu_nocl1a_noc",
	    mout_cmu_nocl1a_noc_p, CLK_CON_MUX_CLKCMU_NOCL1A_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_NOCL1B_NOC0, "mout_cmu_nocl1b_noc0",
	    mout_cmu_nocl1b_noc0_p, CLK_CON_MUX_CLKCMU_NOCL1B_NOC0, 0, 3),
	MUX(CLK_MOUT_CMU_NOCL1C_NOC, "mout_cmu_nocl1c_noc",
	    mout_cmu_nocl1c_noc_p, CLK_CON_MUX_CLKCMU_NOCL1C_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_SDMA_NOC, "mout_cmu_sdma_noc", mout_cmu_sdma_noc_p,
	    CLK_CON_MUX_CLKCMU_SDMA_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_CP_HISPEEDY_CLK, "mout_cmu_cp_hispeedy_clk",
	    mout_cmu_cp_hispeedy_clk_p, CLK_CON_MUX_CP_HISPEEDY_CLK, 0, 1),
	MUX(CLK_MOUT_CMU_CP_SHARED0_CLK, "mout_cmu_cp_shared0_clk",
	    mout_cmu_cp_shared0_clk_p, CLK_CON_MUX_CP_SHARED0_CLK, 0, 2),
	MUX(CLK_MOUT_CMU_CP_SHARED2_CLK, "mout_cmu_cp_shared2_clk",
	    mout_cmu_cp_shared2_clk_p, CLK_CON_MUX_CP_SHARED2_CLK, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_ALIVE_NOC, "mout_cmu_mux_alive_noc",
	    mout_cmu_mux_alive_noc_p, CLK_CON_MUX_MUX_CLKCMU_ALIVE_NOC, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_AUD_AUDIF0, "mout_cmu_mux_aud_audif0",
	    mout_cmu_mux_aud_audif0_p, CLK_CON_MUX_MUX_CLKCMU_AUD_AUDIF0,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_AUD_AUDIF1, "mout_cmu_mux_aud_audif1",
	    mout_cmu_mux_aud_audif1_p, CLK_CON_MUX_MUX_CLKCMU_AUD_AUDIF1,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_AUD_CPU, "mout_cmu_mux_aud_cpu",
	    mout_cmu_mux_aud_cpu_p, CLK_CON_MUX_MUX_CLKCMU_AUD_CPU, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_AUD_NOC, "mout_cmu_mux_aud_noc",
	    mout_cmu_mux_aud_noc_p, CLK_CON_MUX_MUX_CLKCMU_AUD_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_BRP_NOC, "mout_cmu_mux_brp_noc",
	    mout_cmu_mux_brp_noc_p, CLK_CON_MUX_MUX_CLKCMU_BRP_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_CIS_CLK0, "mout_cmu_mux_cis_clk0",
	    mout_cmu_mux_cis_clk0_p, CLK_CON_MUX_MUX_CLKCMU_CIS_CLK0, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CIS_CLK1, "mout_cmu_mux_cis_clk1",
	    mout_cmu_mux_cis_clk1_p, CLK_CON_MUX_MUX_CLKCMU_CIS_CLK1, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CIS_CLK2, "mout_cmu_mux_cis_clk2",
	    mout_cmu_mux_cis_clk2_p, CLK_CON_MUX_MUX_CLKCMU_CIS_CLK2, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CIS_CLK3, "mout_cmu_mux_cis_clk3",
	    mout_cmu_mux_cis_clk3_p, CLK_CON_MUX_MUX_CLKCMU_CIS_CLK3, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CIS_CLK4, "mout_cmu_mux_cis_clk4",
	    mout_cmu_mux_cis_clk4_p, CLK_CON_MUX_MUX_CLKCMU_CIS_CLK4, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CIS_CLK5, "mout_cmu_mux_cis_clk5",
	    mout_cmu_mux_cis_clk5_p, CLK_CON_MUX_MUX_CLKCMU_CIS_CLK5, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CIS_CLK6, "mout_cmu_mux_cis_clk6",
	    mout_cmu_mux_cis_clk6_p, CLK_CON_MUX_MUX_CLKCMU_CIS_CLK6, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CIS_CLK7, "mout_cmu_mux_cis_clk7",
	    mout_cmu_mux_cis_clk7_p, CLK_CON_MUX_MUX_CLKCMU_CIS_CLK7, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CMU_BOOST, "mout_cmu_mux_cmu_boost",
	    mout_cmu_mux_cmu_boost_p, CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_CMU_BOOST_CAM, "mout_cmu_mux_cmu_boost_cam",
	    mout_cmu_mux_cmu_boost_cam_p, CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_CAM,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_CMU_BOOST_CPU, "mout_cmu_mux_cmu_boost_cpu",
	    mout_cmu_mux_cmu_boost_cpu_p, CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_CPU,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_CMU_BOOST_MIF, "mout_cmu_mux_cmu_boost_mif",
	    mout_cmu_mux_cmu_boost_mif_p, CLK_CON_MUX_MUX_CLKCMU_CMU_BOOST_MIF,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_CPUCL0_DBG_NOC, "mout_cmu_mux_cpucl0_dbg_noc",
	    mout_cmu_mux_cpucl0_dbg_noc_p,
	    CLK_CON_MUX_MUX_CLKCMU_CPUCL0_DBG_NOC, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_CPUCL0_NOCP, "mout_cmu_mux_cpucl0_nocp",
	    mout_cmu_mux_cpucl0_nocp_p, CLK_CON_MUX_MUX_CLKCMU_CPUCL0_NOCP,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_CPUCL0_SWITCH, "mout_cmu_mux_cpucl0_switch",
	    mout_cmu_mux_cpucl0_switch_p, CLK_CON_MUX_MUX_CLKCMU_CPUCL0_SWITCH,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_CPUCL1_SWITCH, "mout_cmu_mux_cpucl1_switch",
	    mout_cmu_mux_cpucl1_switch_p, CLK_CON_MUX_MUX_CLKCMU_CPUCL1_SWITCH,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_CPUCL2_SWITCH, "mout_cmu_mux_cpucl2_switch",
	    mout_cmu_mux_cpucl2_switch_p, CLK_CON_MUX_MUX_CLKCMU_CPUCL2_SWITCH,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_CSIS_DCPHY, "mout_cmu_mux_csis_dcphy",
	    mout_cmu_mux_csis_dcphy_p, CLK_CON_MUX_MUX_CLKCMU_CSIS_DCPHY,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_CSIS_NOC, "mout_cmu_mux_csis_noc",
	    mout_cmu_mux_csis_noc_p, CLK_CON_MUX_MUX_CLKCMU_CSIS_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_CSIS_OIS_MCU, "mout_cmu_mux_csis_ois_mcu",
	    mout_cmu_mux_csis_ois_mcu_p, CLK_CON_MUX_MUX_CLKCMU_CSIS_OIS_MCU,
	    0, 1),
	MUX(CLK_MOUT_CMU_MUX_CSTAT_NOC, "mout_cmu_mux_cstat_noc",
	    mout_cmu_mux_cstat_noc_p, CLK_CON_MUX_MUX_CLKCMU_CSTAT_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_DNC_NOC, "mout_cmu_mux_dnc_noc",
	    mout_cmu_mux_dnc_noc_p, CLK_CON_MUX_MUX_CLKCMU_DNC_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_DPUB, "mout_cmu_mux_dpub", mout_cmu_mux_dpub_p,
	    CLK_CON_MUX_MUX_CLKCMU_DPUB, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_DPUB_ALT, "mout_cmu_mux_dpub_alt",
	    mout_cmu_mux_dpub_alt_p, CLK_CON_MUX_MUX_CLKCMU_DPUB_ALT, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_DPUB_DSIM, "mout_cmu_mux_dpub_dsim",
	    mout_cmu_mux_dpub_dsim_p, CLK_CON_MUX_MUX_CLKCMU_DPUB_DSIM, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_DPUF, "mout_cmu_mux_dpuf", mout_cmu_mux_dpuf_p,
	    CLK_CON_MUX_MUX_CLKCMU_DPUF, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_DPUF_ALT, "mout_cmu_mux_dpuf_alt",
	    mout_cmu_mux_dpuf_alt_p, CLK_CON_MUX_MUX_CLKCMU_DPUF_ALT, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_DSP_NOC, "mout_cmu_mux_dsp_noc",
	    mout_cmu_mux_dsp_noc_p, CLK_CON_MUX_MUX_CLKCMU_DSP_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_DSU_SWITCH, "mout_cmu_mux_dsu_switch",
	    mout_cmu_mux_dsu_switch_p, CLK_CON_MUX_MUX_CLKCMU_DSU_SWITCH,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_G3D_NOCP, "mout_cmu_mux_g3d_nocp",
	    mout_cmu_mux_g3d_nocp_p, CLK_CON_MUX_MUX_CLKCMU_G3D_NOCP, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_G3D_SWITCH, "mout_cmu_mux_g3d_switch",
	    mout_cmu_mux_g3d_switch_p, CLK_CON_MUX_MUX_CLKCMU_G3D_SWITCH,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_GNPU_NOC, "mout_cmu_mux_gnpu_noc",
	    mout_cmu_mux_gnpu_noc_p, CLK_CON_MUX_MUX_CLKCMU_GNPU_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_HSI0_DPGTC, "mout_cmu_mux_hsi0_dpgtc",
	    mout_cmu_mux_hsi0_dpgtc_p, CLK_CON_MUX_MUX_CLKCMU_HSI0_DPGTC,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_HSI0_DPOSC, "mout_cmu_mux_hsi0_dposc",
	    mout_cmu_mux_hsi0_dposc_p, CLK_CON_MUX_MUX_CLKCMU_HSI0_DPOSC,
	    0, 1),
	MUX(CLK_MOUT_CMU_MUX_HSI0_NOC, "mout_cmu_mux_hsi0_noc",
	    mout_cmu_mux_hsi0_noc_p, CLK_CON_MUX_MUX_CLKCMU_HSI0_NOC, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_HSI0_USB32DRD, "mout_cmu_mux_hsi0_usb32drd",
	    mout_cmu_mux_hsi0_usb32drd_p, CLK_CON_MUX_MUX_CLKCMU_HSI0_USB32DRD,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_UFS_MMC_CARD, "mout_cmu_mux_ufs_mmc_card",
	    mout_cmu_mux_ufs_mmc_card_p, CLK_CON_MUX_MUX_CLKCMU_UFS_MMC_CARD,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_HSI1_NOC, "mout_cmu_mux_hsi1_noc",
	    mout_cmu_mux_hsi1_noc_p, CLK_CON_MUX_MUX_CLKCMU_HSI1_NOC, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_HSI1_PCIE, "mout_cmu_mux_hsi1_pcie",
	    mout_cmu_mux_hsi1_pcie_p, CLK_CON_MUX_MUX_CLKCMU_HSI1_PCIE, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_UFS_UFS_EMBD, "mout_cmu_mux_ufs_ufs_embd",
	    mout_cmu_mux_ufs_ufs_embd_p, CLK_CON_MUX_MUX_CLKCMU_UFS_UFS_EMBD,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_LME_LME, "mout_cmu_mux_lme_lme",
	    mout_cmu_mux_lme_lme_p, CLK_CON_MUX_MUX_CLKCMU_LME_LME, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_LME_NOC, "mout_cmu_mux_lme_noc",
	    mout_cmu_mux_lme_noc_p, CLK_CON_MUX_MUX_CLKCMU_LME_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_M2M_NOC, "mout_cmu_mux_m2m_noc",
	    mout_cmu_mux_m2m_noc_p, CLK_CON_MUX_MUX_CLKCMU_M2M_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_MCSC_MCSC, "mout_cmu_mux_mcsc_mcsc",
	    mout_cmu_mux_mcsc_mcsc_p, CLK_CON_MUX_MUX_CLKCMU_MCSC_MCSC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_MCSC_NOC, "mout_cmu_mux_mcsc_noc",
	    mout_cmu_mux_mcsc_noc_p, CLK_CON_MUX_MUX_CLKCMU_MCSC_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_MFC0_MFC0, "mout_cmu_mux_mfc0_mfc0",
	    mout_cmu_mux_mfc0_mfc0_p, CLK_CON_MUX_MUX_CLKCMU_MFC0_MFC0, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_MFC0_WFD, "mout_cmu_mux_mfc0_wfd",
	    mout_cmu_mux_mfc0_wfd_p, CLK_CON_MUX_MUX_CLKCMU_MFC0_WFD, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_MFC1_MFC1, "mout_cmu_mux_mfc1_mfc1",
	    mout_cmu_mux_mfc1_mfc1_p, CLK_CON_MUX_MUX_CLKCMU_MFC1_MFC1, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_MIF_NOCP, "mout_cmu_mux_mif_nocp",
	    mout_cmu_mux_mif_nocp_p, CLK_CON_MUX_MUX_CLKCMU_MIF_NOCP, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_MIF_SWITCH, "mout_cmu_mux_mif_switch",
	    mout_cmu_mux_mif_switch_p, CLK_CON_MUX_MUX_CLKCMU_MIF_SWITCH,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_NOCL0_NOC, "mout_cmu_mux_nocl0_noc",
	    mout_cmu_mux_nocl0_noc_p, CLK_CON_MUX_MUX_CLKCMU_NOCL0_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_NOCL1A_NOC, "mout_cmu_mux_nocl1a_noc",
	    mout_cmu_mux_nocl1a_noc_p, CLK_CON_MUX_MUX_CLKCMU_NOCL1A_NOC,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_NOCL1B_NOC0, "mout_cmu_mux_nocl1b_noc0",
	    mout_cmu_mux_nocl1b_noc0_p, CLK_CON_MUX_MUX_CLKCMU_NOCL1B_NOC0,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_NOCL1B_NOC1, "mout_cmu_mux_nocl1b_noc1",
	    mout_cmu_mux_nocl1b_noc1_p, CLK_CON_MUX_MUX_CLKCMU_NOCL1B_NOC1,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_NOCL1C_NOC, "mout_cmu_mux_nocl1c_noc",
	    mout_cmu_mux_nocl1c_noc_p, CLK_CON_MUX_MUX_CLKCMU_NOCL1C_NOC,
	    0, 3),
	MUX(CLK_MOUT_CMU_MUX_PERIC0_IP0, "mout_cmu_mux_peric0_ip0",
	    mout_cmu_mux_peric0_ip0_p, CLK_CON_MUX_MUX_CLKCMU_PERIC0_IP0,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_PERIC0_IP1, "mout_cmu_mux_peric0_ip1",
	    mout_cmu_mux_peric0_ip1_p, CLK_CON_MUX_MUX_CLKCMU_PERIC0_IP1,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_PERIC0_NOC, "mout_cmu_mux_peric0_noc",
	    mout_cmu_mux_peric0_noc_p, CLK_CON_MUX_MUX_CLKCMU_PERIC0_NOC,
	    0, 1),
	MUX(CLK_MOUT_CMU_MUX_PERIC1_IP0, "mout_cmu_mux_peric1_ip0",
	    mout_cmu_mux_peric1_ip0_p, CLK_CON_MUX_MUX_CLKCMU_PERIC1_IP0,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_PERIC1_IP1, "mout_cmu_mux_peric1_ip1",
	    mout_cmu_mux_peric1_ip1_p, CLK_CON_MUX_MUX_CLKCMU_PERIC1_IP1,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_PERIC1_NOC, "mout_cmu_mux_peric1_noc",
	    mout_cmu_mux_peric1_noc_p, CLK_CON_MUX_MUX_CLKCMU_PERIC1_NOC,
	    0, 1),
	MUX(CLK_MOUT_CMU_MUX_PERIC2_IP0, "mout_cmu_mux_peric2_ip0",
	    mout_cmu_mux_peric2_ip0_p, CLK_CON_MUX_MUX_CLKCMU_PERIC2_IP0,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_PERIC2_IP1, "mout_cmu_mux_peric2_ip1",
	    mout_cmu_mux_peric2_ip1_p, CLK_CON_MUX_MUX_CLKCMU_PERIC2_IP1,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_PERIC2_NOC, "mout_cmu_mux_peric2_noc",
	    mout_cmu_mux_peric2_noc_p, CLK_CON_MUX_MUX_CLKCMU_PERIC2_NOC,
	    0, 1),
	MUX(CLK_MOUT_CMU_MUX_PERIS_GIC, "mout_cmu_mux_peris_gic",
	    mout_cmu_mux_peris_gic_p, CLK_CON_MUX_MUX_CLKCMU_PERIS_GIC, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_PERIS_NOC, "mout_cmu_mux_peris_noc",
	    mout_cmu_mux_peris_noc_p, CLK_CON_MUX_MUX_CLKCMU_PERIS_NOC, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_SDMA_NOC, "mout_cmu_mux_sdma_noc",
	    mout_cmu_mux_sdma_noc_p, CLK_CON_MUX_MUX_CLKCMU_SDMA_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_SSP_NOC, "mout_cmu_mux_ssp_noc",
	    mout_cmu_mux_ssp_noc_p, CLK_CON_MUX_MUX_CLKCMU_SSP_NOC, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_VTS_DMIC, "mout_cmu_mux_vts_dmic",
	    mout_cmu_mux_vts_dmic_p, CLK_CON_MUX_MUX_CLKCMU_VTS_DMIC, 0, 2),
	MUX(CLK_MOUT_CMU_MUX_YUVP_NOC, "mout_cmu_mux_yuvp_noc",
	    mout_cmu_mux_yuvp_noc_p, CLK_CON_MUX_MUX_CLKCMU_YUVP_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_CMU_CMUREF, "mout_cmu_mux_cmu_cmuref",
	    mout_cmu_mux_cmu_cmuref_p, CLK_CON_MUX_MUX_CMU_CMUREF, 0, 1),
	MUX(CLK_MOUT_CMU_MUX_CP_HISPEEDY_CLK, "mout_cmu_mux_cp_hispeedy_clk",
	    mout_cmu_mux_cp_hispeedy_clk_p, CLK_CON_MUX_MUX_CP_HISPEEDY_CLK,
	    0, 1),
	MUX(CLK_MOUT_CMU_MUX_CP_SHARED0_CLK, "mout_cmu_mux_cp_shared0_clk",
	    mout_cmu_mux_cp_shared0_clk_p, CLK_CON_MUX_MUX_CP_SHARED0_CLK,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_CP_SHARED1_CLK, "mout_cmu_mux_cp_shared1_clk",
	    mout_cmu_mux_cp_shared1_clk_p, CLK_CON_MUX_MUX_CP_SHARED1_CLK,
	    0, 2),
	MUX(CLK_MOUT_CMU_MUX_CP_SHARED2_CLK, "mout_cmu_mux_cp_shared2_clk",
	    mout_cmu_mux_cp_shared2_clk_p, CLK_CON_MUX_MUX_CP_SHARED2_CLK,
	    0, 2),
	MUX(CLK_MOUT_CMU_M2M_FRC, "mout_cmu_m2m_frc", mout_cmu_m2m_frc_p,
	    CLK_CON_MUX_CLKCMU_M2M_FRC, 0, 3),
	MUX(CLK_MOUT_CMU_MCSC_MCSC, "mout_cmu_mcsc_mcsc", mout_cmu_mcsc_mcsc_p,
	    CLK_CON_MUX_CLKCMU_MCSC_MCSC, 0, 3),
	MUX(CLK_MOUT_CMU_MCSC_NOC, "mout_cmu_mcsc_noc", mout_cmu_mcsc_noc_p,
	    CLK_CON_MUX_CLKCMU_MCSC_NOC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_M2M_FRC, "mout_cmu_mux_m2m_frc",
	    mout_cmu_mux_m2m_frc_p, CLK_CON_MUX_MUX_CLKCMU_M2M_FRC, 0, 3),
	MUX(CLK_MOUT_CMU_MUX_UFS_NOC, "mout_cmu_mux_ufs_noc",
	    mout_cmu_mux_ufs_noc_p, CLK_CON_MUX_MUX_CLKCMU_UFS_NOC, 0, 2),
};

static const struct samsung_div_clock top_div_clks[] __initconst = {
	DIV(CLK_DOUT_CMU_ALIVE_NOC, "dout_cmu_alive_noc",
	    "mout_cmu_mux_alive_noc", CLK_CON_DIV_CLKCMU_ALIVE_NOC, 0, 2),
	DIV(CLK_DOUT_CMU_AUD_NOC, "dout_cmu_aud_noc", "mout_cmu_mux_aud_noc",
	    CLK_CON_DIV_CLKCMU_AUD_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_BRP_NOC, "dout_cmu_brp_noc", "mout_cmu_mux_brp_noc",
	    CLK_CON_DIV_CLKCMU_BRP_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_CMU_BOOST, "dout_cmu_cmu_boost",
	    "mout_cmu_mux_cmu_boost", CLK_CON_DIV_CLKCMU_CMU_BOOST, 0, 3),
	DIV(CLK_DOUT_CMU_CMU_BOOST_CAM, "dout_cmu_cmu_boost_cam",
	    "mout_cmu_mux_cmu_boost_cam", CLK_CON_DIV_CLKCMU_CMU_BOOST_CAM,
	    0, 3),
	DIV(CLK_DOUT_CMU_CMU_BOOST_CPU, "dout_cmu_cmu_boost_cpu",
	    "mout_cmu_mux_cmu_boost_cpu", CLK_CON_DIV_CLKCMU_CMU_BOOST_CPU,
	    0, 3),
	DIV(CLK_DOUT_CMU_CMU_BOOST_MIF, "dout_cmu_cmu_boost_mif",
	    "mout_cmu_mux_cmu_boost_mif", CLK_CON_DIV_CLKCMU_CMU_BOOST_MIF,
	    0, 3),
	DIV(CLK_DOUT_CMU_CPUCL0_NOCP, "dout_cmu_cpucl0_nocp",
	    "mout_cmu_mux_cpucl0_nocp", CLK_CON_DIV_CLKCMU_CPUCL0_NOCP, 0, 4),
	DIV(CLK_DOUT_CMU_CSIS_DCPHY, "dout_cmu_csis_dcphy",
	    "mout_cmu_mux_csis_dcphy", CLK_CON_DIV_CLKCMU_CSIS_DCPHY, 0, 4),
	DIV(CLK_DOUT_CMU_CSIS_NOC, "dout_cmu_csis_noc",
	    "mout_cmu_mux_csis_noc", CLK_CON_DIV_CLKCMU_CSIS_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_CSIS_OIS_MCU, "dout_cmu_csis_ois_mcu",
	    "mout_cmu_mux_csis_ois_mcu", CLK_CON_DIV_CLKCMU_CSIS_OIS_MCU,
	    0, 4),
	DIV(CLK_DOUT_CMU_CSTAT_NOC, "dout_cmu_cstat_noc",
	    "mout_cmu_mux_cstat_noc", CLK_CON_DIV_CLKCMU_CSTAT_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DPUB_DSIM, "dout_cmu_dpub_dsim",
	    "mout_cmu_mux_dpub_dsim", CLK_CON_DIV_CLKCMU_DPUB_DSIM, 0, 4),
	DIV(CLK_DOUT_CMU_LME_LME, "dout_cmu_lme_lme", "mout_cmu_mux_lme_lme",
	    CLK_CON_DIV_CLKCMU_LME_LME, 0, 4),
	DIV(CLK_DOUT_CMU_G3D_NOCP, "dout_cmu_g3d_nocp",
	    "mout_cmu_mux_g3d_nocp", CLK_CON_DIV_CLKCMU_G3D_NOCP, 0, 3),
	DIV(CLK_DOUT_CMU_HSI0_DPGTC, "dout_cmu_hsi0_dpgtc",
	    "mout_cmu_mux_hsi0_dpgtc", CLK_CON_DIV_CLKCMU_HSI0_DPGTC, 0, 3),
	DIV(CLK_DOUT_CMU_HSI0_DPOSC, "dout_cmu_hsi0_dposc",
	    "mout_cmu_mux_hsi0_dposc", CLK_CON_DIV_CLKCMU_HSI0_DPOSC, 0, 5),
	DIV(CLK_DOUT_CMU_HSI0_NOC, "dout_cmu_hsi0_noc",
	    "mout_cmu_mux_hsi0_noc", CLK_CON_DIV_CLKCMU_HSI0_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_HSI0_USB32DRD, "dout_cmu_hsi0_usb32drd",
	    "mout_cmu_mux_hsi0_usb32drd", CLK_CON_DIV_CLKCMU_HSI0_USB32DRD,
	    0, 5),
	DIV(CLK_DOUT_CMU_HSI1_NOC, "dout_cmu_hsi1_noc",
	    "mout_cmu_mux_hsi1_noc", CLK_CON_DIV_CLKCMU_HSI1_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_HSI1_PCIE, "dout_cmu_hsi1_pcie",
	    "mout_cmu_mux_hsi1_pcie", CLK_CON_DIV_CLKCMU_HSI1_PCIE, 0, 8),
	DIV(CLK_DOUT_CMU_UFS_UFS_EMBD, "dout_cmu_ufs_ufs_embd",
	    "mout_cmu_mux_ufs_ufs_embd", CLK_CON_DIV_CLKCMU_UFS_UFS_EMBD,
	    0, 4),
	DIV(CLK_DOUT_CMU_LME_NOC, "dout_cmu_lme_noc", "mout_cmu_mux_lme_noc",
	    CLK_CON_DIV_CLKCMU_LME_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_MFC0_MFC0, "dout_cmu_mfc0_mfc0",
	    "mout_cmu_mux_mfc0_mfc0", CLK_CON_DIV_CLKCMU_MFC0_MFC0, 0, 4),
	DIV(CLK_DOUT_CMU_MFC0_WFD, "dout_cmu_mfc0_wfd",
	    "mout_cmu_mux_mfc0_wfd", CLK_CON_DIV_CLKCMU_MFC0_WFD, 0, 4),
	DIV(CLK_DOUT_CMU_MFC1_MFC1, "dout_cmu_mfc1_mfc1",
	    "mout_cmu_mux_mfc1_mfc1", CLK_CON_DIV_CLKCMU_MFC1_MFC1, 0, 4),
	DIV(CLK_DOUT_CMU_MIF_NOCP, "dout_cmu_mif_nocp",
	    "mout_cmu_mux_mif_nocp", CLK_CON_DIV_CLKCMU_MIF_NOCP, 0, 4),
	DIV(CLK_DOUT_CMU_NOCL1B_NOC1, "dout_cmu_nocl1b_noc1",
	    "mout_cmu_mux_nocl1b_noc1", CLK_CON_DIV_CLKCMU_NOCL1B_NOC1, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC0_IP0, "dout_cmu_peric0_ip0",
	    "mout_cmu_mux_peric0_ip0", CLK_CON_DIV_CLKCMU_PERIC0_IP0, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC0_IP1, "dout_cmu_peric0_ip1",
	    "mout_cmu_mux_peric0_ip1", CLK_CON_DIV_CLKCMU_PERIC0_IP1, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC0_NOC, "dout_cmu_peric0_noc",
	    "mout_cmu_mux_peric0_noc", CLK_CON_DIV_CLKCMU_PERIC0_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC1_IP0, "dout_cmu_peric1_ip0",
	    "mout_cmu_mux_peric1_ip0", CLK_CON_DIV_CLKCMU_PERIC1_IP0, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC1_IP1, "dout_cmu_peric1_ip1",
	    "mout_cmu_mux_peric1_ip1", CLK_CON_DIV_CLKCMU_PERIC1_IP1, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC1_NOC, "dout_cmu_peric1_noc",
	    "mout_cmu_mux_peric1_noc", CLK_CON_DIV_CLKCMU_PERIC1_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC2_IP0, "dout_cmu_peric2_ip0",
	    "mout_cmu_mux_peric2_ip0", CLK_CON_DIV_CLKCMU_PERIC2_IP0, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC2_IP1, "dout_cmu_peric2_ip1",
	    "mout_cmu_mux_peric2_ip1", CLK_CON_DIV_CLKCMU_PERIC2_IP1, 0, 4),
	DIV(CLK_DOUT_CMU_PERIC2_NOC, "dout_cmu_peric2_noc",
	    "mout_cmu_mux_peric2_noc", CLK_CON_DIV_CLKCMU_PERIC2_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_PERIS_GIC, "dout_cmu_peris_gic",
	    "mout_cmu_mux_peris_gic", CLK_CON_DIV_CLKCMU_PERIS_GIC, 0, 4),
	DIV(CLK_DOUT_CMU_PERIS_NOC, "dout_cmu_peris_noc",
	    "mout_cmu_mux_peris_noc", CLK_CON_DIV_CLKCMU_PERIS_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_SSP_NOC, "dout_cmu_ssp_noc", "mout_cmu_mux_ssp_noc",
	    CLK_CON_DIV_CLKCMU_SSP_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_VTS_DMIC, "dout_cmu_vts_dmic",
	    "mout_cmu_mux_vts_dmic", CLK_CON_DIV_CLKCMU_VTS_DMIC, 0, 6),
	DIV(CLK_DOUT_CMU_YUVP_NOC, "dout_cmu_yuvp_noc",
	    "mout_cmu_mux_yuvp_noc", CLK_CON_DIV_CLKCMU_YUVP_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_CP_SHARED1_CLK, "dout_cmu_cp_shared1_clk",
	    "mout_cmu_mux_cp_shared1_clk", CLK_CON_DIV_CP_SHARED1_CLK, 0, 3),
	DIV(CLK_DOUT_CMU_DIV_AUD_AUDIF0, "dout_cmu_div_aud_audif0",
	    "mout_cmu_mux_aud_audif0", CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF0,
	    0, 6),
	DIV(CLK_DOUT_CMU_DIV_AUD_AUDIF0_SM, "dout_cmu_div_aud_audif0_sm",
	    "mout_cmu_aud_audif0", CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF0_SM, 0, 6),
	DIV(CLK_DOUT_CMU_DIV_AUD_AUDIF1, "dout_cmu_div_aud_audif1",
	    "mout_cmu_mux_aud_audif1", CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF1,
	    0, 6),
	DIV(CLK_DOUT_CMU_DIV_AUD_AUDIF1_SM, "dout_cmu_div_aud_audif1_sm",
	    "mout_cmu_aud_audif1", CLK_CON_DIV_DIV_CLKCMU_AUD_AUDIF1_SM, 0, 6),
	DIV(CLK_DOUT_CMU_DIV_AUD_CPU, "dout_cmu_div_aud_cpu",
	    "mout_cmu_mux_aud_cpu", CLK_CON_DIV_DIV_CLKCMU_AUD_CPU, 0, 3),
	DIV(CLK_DOUT_CMU_DIV_AUD_CPU_SM, "dout_cmu_div_aud_cpu_sm",
	    "mout_cmu_aud_cpu", CLK_CON_DIV_DIV_CLKCMU_AUD_CPU_SM, 0, 3),
	DIV(CLK_DOUT_CMU_DIV_CIS_CLK0, "dout_cmu_div_cis_clk0",
	    "mout_cmu_mux_cis_clk0", CLK_CON_DIV_DIV_CLKCMU_CIS_CLK0, 0, 5),
	DIV(CLK_DOUT_CMU_DIV_CIS_CLK1, "dout_cmu_div_cis_clk1",
	    "mout_cmu_mux_cis_clk1", CLK_CON_DIV_DIV_CLKCMU_CIS_CLK1, 0, 5),
	DIV(CLK_DOUT_CMU_DIV_CIS_CLK2, "dout_cmu_div_cis_clk2",
	    "mout_cmu_mux_cis_clk2", CLK_CON_DIV_DIV_CLKCMU_CIS_CLK2, 0, 5),
	DIV(CLK_DOUT_CMU_DIV_CIS_CLK3, "dout_cmu_div_cis_clk3",
	    "mout_cmu_mux_cis_clk3", CLK_CON_DIV_DIV_CLKCMU_CIS_CLK3, 0, 5),
	DIV(CLK_DOUT_CMU_DIV_CIS_CLK4, "dout_cmu_div_cis_clk4",
	    "mout_cmu_mux_cis_clk4", CLK_CON_DIV_DIV_CLKCMU_CIS_CLK4, 0, 5),
	DIV(CLK_DOUT_CMU_DIV_CIS_CLK5, "dout_cmu_div_cis_clk5",
	    "mout_cmu_mux_cis_clk5", CLK_CON_DIV_DIV_CLKCMU_CIS_CLK5, 0, 5),
	DIV(CLK_DOUT_CMU_DIV_CIS_CLK6, "dout_cmu_div_cis_clk6",
	    "mout_cmu_mux_cis_clk6", CLK_CON_DIV_DIV_CLKCMU_CIS_CLK6, 0, 5),
	DIV(CLK_DOUT_CMU_DIV_CIS_CLK7, "dout_cmu_div_cis_clk7",
	    "mout_cmu_mux_cis_clk7", CLK_CON_DIV_DIV_CLKCMU_CIS_CLK7, 0, 5),
	DIV(CLK_DOUT_CMU_DIV_CPUCL0_DBG_NOC, "dout_cmu_div_cpucl0_dbg_noc",
	    "mout_cmu_mux_cpucl0_dbg_noc",
	    CLK_CON_DIV_DIV_CLKCMU_CPUCL0_DBG_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_CPUCL0_DBG_NOC_SM,
	    "dout_cmu_div_cpucl0_dbg_noc_sm", "mout_cmu_cpucl0_dbg_noc",
	    CLK_CON_DIV_DIV_CLKCMU_CPUCL0_DBG_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_CPUCL0_SWITCH, "dout_cmu_div_cpucl0_switch",
	    "mout_cmu_mux_cpucl0_switch", CLK_CON_DIV_DIV_CLKCMU_CPUCL0_SWITCH,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_CPUCL0_SWITCH_SM, "dout_cmu_div_cpucl0_switch_sm",
	    "mout_cmu_cpucl0_switch", CLK_CON_DIV_DIV_CLKCMU_CPUCL0_SWITCH_SM,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_CPUCL1_SWITCH, "dout_cmu_div_cpucl1_switch",
	    "mout_cmu_mux_cpucl1_switch", CLK_CON_DIV_DIV_CLKCMU_CPUCL1_SWITCH,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_CPUCL1_SWITCH_SM, "dout_cmu_div_cpucl1_switch_sm",
	    "mout_cmu_cpucl1_switch", CLK_CON_DIV_DIV_CLKCMU_CPUCL1_SWITCH_SM,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_CPUCL2_SWITCH, "dout_cmu_div_cpucl2_switch",
	    "mout_cmu_mux_cpucl2_switch", CLK_CON_DIV_DIV_CLKCMU_CPUCL2_SWITCH,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_CPUCL2_SWITCH_SM, "dout_cmu_div_cpucl2_switch_sm",
	    "mout_cmu_cpucl2_switch", CLK_CON_DIV_DIV_CLKCMU_CPUCL2_SWITCH_SM,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_DNC_NOC, "dout_cmu_div_dnc_noc",
	    "mout_cmu_mux_dnc_noc", CLK_CON_DIV_DIV_CLKCMU_DNC_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_DNC_NOC_SM, "dout_cmu_div_dnc_noc_sm",
	    "mout_cmu_dnc_noc", CLK_CON_DIV_DIV_CLKCMU_DNC_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_DPUB, "dout_cmu_div_dpub", "mout_cmu_mux_dpub",
	    CLK_CON_DIV_DIV_CLKCMU_DPUB, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_DPUB_ALT, "dout_cmu_div_dpub_alt",
	    "mout_cmu_mux_dpub_alt", CLK_CON_DIV_DIV_CLKCMU_DPUB_ALT, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_DPUF, "dout_cmu_div_dpuf", "mout_cmu_mux_dpuf",
	    CLK_CON_DIV_DIV_CLKCMU_DPUF, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_DPUF_ALT, "dout_cmu_div_dpuf_alt",
	    "mout_cmu_mux_dpuf_alt", CLK_CON_DIV_DIV_CLKCMU_DPUF_ALT, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_DSP_NOC, "dout_cmu_div_dsp_noc",
	    "mout_cmu_mux_dsp_noc", CLK_CON_DIV_DIV_CLKCMU_DSP_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_DSP_NOC_SM, "dout_cmu_div_dsp_noc_sm",
	    "mout_cmu_dsp_noc", CLK_CON_DIV_DIV_CLKCMU_DSP_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_DSU_SWITCH, "dout_cmu_div_dsu_switch",
	    "mout_cmu_mux_dsu_switch", CLK_CON_DIV_DIV_CLKCMU_DSU_SWITCH,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_DSU_SWITCH_SM, "dout_cmu_div_dsu_switch_sm",
	    "mout_cmu_dsu_switch", CLK_CON_DIV_DIV_CLKCMU_DSU_SWITCH_SM, 0, 3),
	DIV(CLK_DOUT_CMU_DIV_G3D_SWITCH, "dout_cmu_div_g3d_switch",
	    "mout_cmu_mux_g3d_switch", CLK_CON_DIV_DIV_CLKCMU_G3D_SWITCH,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_G3D_SWITCH_SM, "dout_cmu_div_g3d_switch_sm",
	    "mout_cmu_g3d_switch", CLK_CON_DIV_DIV_CLKCMU_G3D_SWITCH_SM, 0, 3),
	DIV(CLK_DOUT_CMU_DIV_GNPU_NOC, "dout_cmu_div_gnpu_noc",
	    "mout_cmu_mux_gnpu_noc", CLK_CON_DIV_DIV_CLKCMU_GNPU_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_GNPU_NOC_SM, "dout_cmu_div_gnpu_noc_sm",
	    "mout_cmu_gnpu_noc", CLK_CON_DIV_DIV_CLKCMU_GNPU_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_UFS_MMC_CARD, "dout_cmu_div_ufs_mmc_card",
	    "mout_cmu_mux_ufs_mmc_card", CLK_CON_DIV_DIV_CLKCMU_UFS_MMC_CARD,
	    0, 9),
	DIV(CLK_DOUT_CMU_DIV_UFS_MMC_CARD_SM, "dout_cmu_div_ufs_mmc_card_sm",
	    "mout_cmu_ufs_mmc_card", CLK_CON_DIV_DIV_CLKCMU_UFS_MMC_CARD_SM,
	    0, 9),
	DIV(CLK_DOUT_CMU_DIV_M2M_NOC, "dout_cmu_div_m2m_noc",
	    "mout_cmu_mux_m2m_noc", CLK_CON_DIV_DIV_CLKCMU_M2M_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_M2M_NOC_SM, "dout_cmu_div_m2m_noc_sm",
	    "mout_cmu_m2m_noc", CLK_CON_DIV_DIV_CLKCMU_M2M_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_NOCL0_NOC, "dout_cmu_div_nocl0_noc",
	    "mout_cmu_mux_nocl0_noc", CLK_CON_DIV_DIV_CLKCMU_NOCL0_NOC,
	    0, 4),
	DIV(CLK_DOUT_CMU_DIV_NOCL0_NOC_SM, "dout_cmu_div_nocl0_noc_sm",
	    "mout_cmu_nocl0_noc", CLK_CON_DIV_DIV_CLKCMU_NOCL0_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_NOCL1A_NOC, "dout_cmu_div_nocl1a_noc",
	    "mout_cmu_mux_nocl1a_noc", CLK_CON_DIV_DIV_CLKCMU_NOCL1A_NOC,
	    0, 4),
	DIV(CLK_DOUT_CMU_DIV_NOCL1A_NOC_SM, "dout_cmu_div_nocl1a_noc_sm",
	    "mout_cmu_nocl1a_noc", CLK_CON_DIV_DIV_CLKCMU_NOCL1A_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_NOCL1B_NOC0, "dout_cmu_div_nocl1b_noc0",
	    "mout_cmu_mux_nocl1b_noc0", CLK_CON_DIV_DIV_CLKCMU_NOCL1B_NOC0,
	    0, 4),
	DIV(CLK_DOUT_CMU_DIV_NOCL1B_NOC0_SM, "dout_cmu_div_nocl1b_noc0_sm",
	    "mout_cmu_nocl1b_noc0", CLK_CON_DIV_DIV_CLKCMU_NOCL1B_NOC0_SM,
	    0, 4),
	DIV(CLK_DOUT_CMU_DIV_NOCL1C_NOC, "dout_cmu_div_nocl1c_noc",
	    "mout_cmu_mux_nocl1c_noc", CLK_CON_DIV_DIV_CLKCMU_NOCL1C_NOC,
	    0, 4),
	DIV(CLK_DOUT_CMU_DIV_NOCL1C_NOC_SM, "dout_cmu_div_nocl1c_noc_sm",
	    "mout_cmu_nocl1c_noc", CLK_CON_DIV_DIV_CLKCMU_NOCL1C_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_SDMA_NOC, "dout_cmu_div_sdma_noc",
	    "mout_cmu_mux_sdma_noc", CLK_CON_DIV_DIV_CLKCMU_SDMA_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_SDMA_NOC_SM, "dout_cmu_div_sdma_noc_sm",
	    "mout_cmu_sdma_noc", CLK_CON_DIV_DIV_CLKCMU_SDMA_NOC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_CP_HISPEEDY_CLK, "dout_cmu_div_cp_hispeedy_clk",
	    "mout_cmu_mux_cp_hispeedy_clk", CLK_CON_DIV_DIV_CP_HISPEEDY_CLK,
	    0, 4),
	DIV(CLK_DOUT_CMU_DIV_CP_HISPEEDY_CLK_SM,
	    "dout_cmu_div_cp_hispeedy_clk_sm", "mout_cmu_mux_cp_hispeedy_clk",
	    CLK_CON_DIV_DIV_CP_HISPEEDY_CLK_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_CP_SHARED0_CLK, "dout_cmu_div_cp_shared0_clk",
	    "mout_cmu_mux_cp_shared0_clk", CLK_CON_DIV_DIV_CP_SHARED0_CLK,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_CP_SHARED0_CLK_SM,
	    "dout_cmu_div_cp_shared0_clk_sm", "mout_cmu_cp_shared0_clk",
	    CLK_CON_DIV_DIV_CP_SHARED0_CLK_SM, 0, 3),
	DIV(CLK_DOUT_CMU_DIV_CP_SHARED2_CLK, "dout_cmu_div_cp_shared2_clk",
	    "mout_cmu_mux_cp_shared2_clk", CLK_CON_DIV_DIV_CP_SHARED2_CLK,
	    0, 3),
	DIV(CLK_DOUT_CMU_DIV_CP_SHARED2_CLK_SM,
	    "dout_cmu_div_cp_shared2_clk_sm", "mout_cmu_cp_shared2_clk",
	    CLK_CON_DIV_DIV_CP_SHARED2_CLK_SM, 0, 3),
	DIV(CLK_DOUT_CMU_UFS_NOC, "dout_cmu_ufs_noc", "mout_cmu_mux_ufs_noc",
	    CLK_CON_DIV_CLKCMU_UFS_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_M2M_FRC, "dout_cmu_div_m2m_frc",
	    "mout_cmu_mux_m2m_frc", CLK_CON_DIV_DIV_CLKCMU_M2M_FRC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_M2M_FRC_SM, "dout_cmu_div_m2m_frc_sm",
	    "mout_cmu_m2m_frc", CLK_CON_DIV_DIV_CLKCMU_M2M_FRC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_MCSC_MCSC, "dout_cmu_div_mcsc_mcsc",
	    "mout_cmu_mux_mcsc_mcsc", CLK_CON_DIV_DIV_CLKCMU_MCSC_MCSC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_MCSC_MCSC_SM, "dout_cmu_div_mcsc_mcsc_sm",
	    "mout_cmu_mcsc_mcsc", CLK_CON_DIV_DIV_CLKCMU_MCSC_MCSC_SM, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_MCSC_NOC, "dout_cmu_div_mcsc_noc",
	    "mout_cmu_mux_mcsc_noc", CLK_CON_DIV_DIV_CLKCMU_MCSC_NOC, 0, 4),
	DIV(CLK_DOUT_CMU_DIV_MCSC_NOC_SM, "dout_cmu_div_mcsc_noc_sm",
	    "mout_cmu_mcsc_noc", CLK_CON_DIV_DIV_CLKCMU_MCSC_NOC_SM, 0, 4),
};

static const struct samsung_fixed_factor_clock top_fixed_factor_clks[] __initconst = {
	FFACTOR(CLK_DOUT_SHARED0_DIV1, "dout_shared0_div1",
		"fout_shared0_pll", 1, 1, 0),
	FFACTOR(CLK_DOUT_SHARED0_DIV2, "dout_shared0_div2",
		"fout_shared0_pll", 1, 2, 0),
	FFACTOR(CLK_DOUT_SHARED0_DIV4, "dout_shared0_div4",
		"fout_shared0_pll", 1, 4, 0),
	FFACTOR(CLK_DOUT_SHARED1_DIV1, "dout_shared1_div1",
		"fout_shared1_pll", 1, 1, 0),
	FFACTOR(CLK_DOUT_SHARED1_DIV2, "dout_shared1_div2",
		"fout_shared1_pll", 1, 2, 0),
	FFACTOR(CLK_DOUT_SHARED1_DIV4, "dout_shared1_div4",
		"fout_shared1_pll", 1, 4, 0),
	FFACTOR(CLK_DOUT_SHARED2_DIV1, "dout_shared2_div1",
		"fout_shared2_pll", 1, 1, 0),
	FFACTOR(CLK_DOUT_SHARED2_DIV2, "dout_shared2_div2",
		"fout_shared2_pll", 1, 2, 0),
	FFACTOR(CLK_DOUT_SHARED2_DIV4, "dout_shared2_div4",
		"fout_shared2_pll", 1, 4, 0),
	FFACTOR(CLK_DOUT_SHARED3_DIV1, "dout_shared3_div1",
		"fout_shared3_pll", 1, 1, 0),
	FFACTOR(CLK_DOUT_SHARED3_DIV2, "dout_shared3_div2",
		"fout_shared3_pll", 1, 2, 0),
	FFACTOR(CLK_DOUT_SHARED3_DIV4, "dout_shared3_div4",
		"fout_shared3_pll", 1, 4, 0),
	FFACTOR(CLK_DOUT_SHARED4_DIV1, "dout_shared4_div1",
		"fout_shared4_pll", 1, 1, 0),
	FFACTOR(CLK_DOUT_SHARED4_DIV2, "dout_shared4_div2",
		"fout_shared4_pll", 1, 2, 0),
	FFACTOR(CLK_DOUT_SHARED4_DIV4, "dout_shared4_div4",
		"fout_shared4_pll", 1, 4, 0),
	FFACTOR(CLK_DOUT_SHARED_MIF_DIV1, "dout_shared_mif_div1",
		"fout_shared_mif_pll", 1, 1, 0),
	FFACTOR(CLK_DOUT_SHARED_MIF_DIV2, "dout_shared_mif_div2",
		"fout_shared_mif_pll", 1, 2, 0),
	FFACTOR(CLK_DOUT_SHARED_MIF_DIV4, "dout_shared_mif_div4",
		"fout_shared_mif_pll", 1, 4, 0),
	FFACTOR(CLK_DOUT_SHARED_MIF_DIV4, "dout_mmc_div1",
		"fout_mmc_pll", 1, 1, 0),
	FFACTOR(CLK_DOUT_SHARED_MIF_DIV4, "dout_mmc_div2",
		"fout_mmc_pll", 1, 2, 0),
	FFACTOR(CLK_DOUT_SHARED_MIF_DIV4, "dout_mmc_div4",
		"fout_mmc_pll", 1, 4, 0),
	FFACTOR(CLK_DOUT_TCXO_DIV3, "dout_tcxo_div3",
		"oscclk", 1, 3, 0),
	FFACTOR(CLK_DOUT_TCXO_DIV4, "dout_tcxo_div4",
		"oscclk", 1, 4, 0),
};

static const struct samsung_cmu_info top_cmu_info __initconst = {
	.pll_clks		= top_pll_clks,
	.nr_pll_clks		= ARRAY_SIZE(top_pll_clks),
	.mux_clks		= top_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(top_mux_clks),
	.div_clks		= top_div_clks,
	.nr_div_clks		= ARRAY_SIZE(top_div_clks),
	.fixed_factor_clks	= top_fixed_factor_clks,
	.nr_fixed_factor_clks	= ARRAY_SIZE(top_fixed_factor_clks),
	.nr_clk_ids		= CLKS_NR_TOP,
	.clk_regs		= top_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(top_clk_regs),
};

static void __init exynos2200_cmu_top_init(struct device_node *np)
{
	exynos_arm64_register_cmu(NULL, np, &top_cmu_info);
}

/* Register CMU_TOP early, as it's a dependency for other early domains */
CLK_OF_DECLARE(exynos2200_cmu_top, "samsung,exynos2200-cmu-top",
	       exynos2200_cmu_top_init);

/* ---- CMU_ALIVE ---------------------------------------------------------- */

/* Register Offset definitions for CMU_ALIVE (0x15800000) */
#define PLL_CON0_MUX_CLKCMU_ALIVE_NOC_USER						0x600
#define PLL_CON1_MUX_CLKCMU_ALIVE_NOC_USER						0x604
#define PLL_CON0_MUX_CLKMUX_ALIVE_RCO_SPMI_USER						0x610
#define PLL_CON1_MUX_CLKMUX_ALIVE_RCO_SPMI_USER						0x614
#define PLL_CON0_MUX_CLK_RCO_ALIVE_USER							0x620
#define PLL_CON1_MUX_CLK_RCO_ALIVE_USER							0x624
#define CLK_CON_MUX_MUX_CLKALIVE_CHUB_PERI						0x1004
#define CLK_CON_MUX_MUX_CLKALIVE_CMGP_NOC						0x1008
#define CLK_CON_MUX_MUX_CLKALIVE_CMGP_PERI						0x100c
#define CLK_CON_MUX_MUX_CLKALIVE_DBGCORE_NOC						0x1010
#define CLK_CON_MUX_MUX_CLKALIVE_DNC_NOC						0x1014
#define CLK_CON_MUX_MUX_CLKALIVE_CHUBVTS_NOC						0x1018
#define CLK_CON_MUX_MUX_CLKALIVE_GNPU_NOC						0x101c
#define CLK_CON_MUX_MUX_CLKALIVE_GNSS_NOC						0x1020
#define CLK_CON_MUX_MUX_CLKALIVE_SDMA_NOC						0x1024
#define CLK_CON_MUX_MUX_CLKALIVE_UFD_NOC						0x1028
#define CLK_CON_MUX_MUX_CLK_ALIVE_DBGCORE_UART						0x1030
#define CLK_CON_MUX_MUX_CLK_ALIVE_NOC							0x1034
#define CLK_CON_MUX_MUX_CLK_ALIVE_PMU_SUB						0x1038
#define CLK_CON_MUX_MUX_CLK_ALIVE_SPMI							0x103c
#define CLK_CON_MUX_MUX_CLK_ALIVE_TIMER							0x1040
#define CLK_CON_MUX_MUX_CLKALIVE_CSIS_NOC						0x1044
#define CLK_CON_MUX_MUX_CLKALIVE_DSP_NOC						0x1048
#define CLK_CON_DIV_CLKALIVE_CHUB_PERI							0x1804
#define CLK_CON_DIV_CLKALIVE_CMGP_NOC							0x1808
#define CLK_CON_DIV_CLKALIVE_CMGP_PERI							0x180c
#define CLK_CON_DIV_CLKALIVE_DBGCORE_NOC						0x1810
#define CLK_CON_DIV_CLKALIVE_DNC_NOC							0x1814
#define CLK_CON_DIV_CLKALIVE_CHUBVTS_NOC						0x1818
#define CLK_CON_DIV_CLKALIVE_GNPU_NOC							0x181c
#define CLK_CON_DIV_CLKALIVE_SDMA_NOC							0x1820
#define CLK_CON_DIV_CLKALIVE_UFD_NOC							0x1824
#define CLK_CON_DIV_DIV_CLK_ALIVE_DBGCORE_UART						0x182c
#define CLK_CON_DIV_DIV_CLK_ALIVE_NOC							0x1830
#define CLK_CON_DIV_DIV_CLK_ALIVE_PMU_SUB						0x1834
#define CLK_CON_DIV_DIV_CLK_ALIVE_SPMI							0x1838
#define CLK_CON_DIV_CLKALIVE_CSIS_NOC							0x183c
#define CLK_CON_DIV_CLKALIVE_DSP_NOC							0x1840
#define CLK_CON_GAT_CLKALIVE_CHUBVTS_RCO						0x2000
#define CLK_CON_GAT_CLKALIVE_DNC_RCO							0x2004
#define CLK_CON_GAT_CLKALIVE_CSIS_RCO							0x2008
#define CLK_CON_GAT_CLKALIVE_GNPU_RCO							0x200c
#define CLK_CON_GAT_CLKALIVE_GNSS_NOC							0x2010
#define CLK_CON_GAT_CLKALIVE_SDMA_RCO							0x2014
#define CLK_CON_GAT_CLKALIVE_UFD_RCO							0x2018
#define CLK_CON_GAT_CLKALIVE_DSP_RCO							0x201c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_ALIVE_CMU_ALIVE_IPCLKPORT_PCLK			0x2020
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_GPIO_ALIVE_IPCLKPORT_PCLK			0x2024
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_INTCOMB_VGPIO2APM_IPCLKPORT_PCLK		0x2028
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_INTCOMB_VGPIO2AP_IPCLKPORT_PCLK		0x202c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_INTCOMB_VGPIO2PMU_IPCLKPORT_PCLK		0x2030
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_PMU_ALIVE_IPCLKPORT_PCLK			0x2034
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_APM_DMA_IPCLKPORT_PCLK				0x2038
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_CHUB_RTC_IPCLKPORT_OSCCLK				0x203c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_CHUB_RTC_IPCLKPORT_PCLK				0x2040
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_CLKMON_IPCLKPORT_PCLK				0x2044
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_DBGCORE_UART_IPCLKPORT_IPCLK			0x2048
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_DBGCORE_UART_IPCLKPORT_PCLK			0x204c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_BLK_ALIVE_FRC_OTP_DESERIAL_IPCLKPORT_I_CLK	0x2050
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_DTZPC_ALIVE_IPCLKPORT_PCLK			0x2054
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_GREBEINTEGRATION_IPCLKPORT_HCLK			0x2058
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_HW_SCANDUMP_CLKSTOP_CTRL_IPCLKPORT_ACLK		0x205c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_INTMEM_IPCLKPORT_I_ACLK				0x2060
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_INTMEM_IPCLKPORT_I_PCLK				0x2064
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_LH_AXI_SI_D_APM_IPCLKPORT_I_CLK			0x2068
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_AP_IPCLKPORT_PCLK			0x206c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_CHUB_IPCLKPORT_PCLK			0x2070
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_CP_IPCLKPORT_PCLK			0x2074
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_GNSS_IPCLKPORT_PCLK			0x2078
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_VTS_IPCLKPORT_PCLK			0x207c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_CHUB_IPCLKPORT_PCLK			0x2080
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_CP_IPCLKPORT_PCLK			0x2084
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_CP_S_IPCLKPORT_PCLK			0x2088
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_DBGCORE_IPCLKPORT_PCLK			0x208c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_GNSS_IPCLKPORT_PCLK			0x2090
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_CP_CHUB_IPCLKPORT_PCLK			0x2094
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_CP_GNSS_IPCLKPORT_PCLK			0x2098
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_GNSS_CHUB_IPCLKPORT_PCLK			0x209c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_SHARED_SRAM_IPCLKPORT_PCLK		0x20a0
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_AUD_IPCLKPORT_PCLK			0x20a4
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MCT_ALIVE_IPCLKPORT_I_PCLK			0x20a8
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_PMU_INTR_GEN_IPCLKPORT_PCLK			0x20ac
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_PMU_IPCLKPORT_ACLK				0x20b0
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_PMU_IPCLKPORT_CLKIN_PMU_SUB			0x20b4
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_CP_1_IPCLKPORT_PCLK			0x20b8
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_OTP_DESERIAL_ALIVE_IPCLKPORT_I_CLK		0x20bc
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_DBGCORE_UART_IPCLKPORT_CLK	0x20c0
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_FREE_OSCCLK_IPCLKPORT_CLK	0x20c4
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_GREBE_IPCLKPORT_CLK		0x20c8
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_NOC_IPCLKPORT_CLK		0x20cc
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_OSCCLK_RCO_IPCLKPORT_CLK	0x20d0
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_SPMI_IPCLKPORT_CLK		0x20d4
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_TIMER_IPCLKPORT_CLK		0x20d8
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_NOC_IPCLKPORT_CLK		0x20dc
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RTC_IPCLKPORT_PCLK				0x20e0
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_OTP_HCU_DESERIAL_IPCLKPORT_I_CLK			0x20e4
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_LD_GNSS_IPCLKPORT_I_CLK		0x20e8
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_LP_MODEM_IPCLKPORT_I_CLK		0x20ec
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_LD_CHUBVTS_IPCLKPORT_I_CLK		0x20f0
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_ID_DBGCORE_IPCLKPORT_I_CLK		0x20f4
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_P_APM_IPCLKPORT_I_CLK			0x20f8
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_LP_CMGP_IPCLKPORT_I_CLK		0x20fc
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_IP_APM_IPCLKPORT_I_CLK			0x2100
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_FREE_OSCCLK_IPCLKPORT_CLK	0x2104
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_LP_CHUBVTS_IPCLKPORT_I_CLK		0x2108
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_LP_PPU_IPCLKPORT_I_CLK			0x210c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_LP_ALIVEDNC_IPCLKPORT_I_CLK		0x2110
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SPC_ALIVE_IPCLKPORT_PCLK				0x2114
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SPMI_MASTER_PMIC_IPCLKPORT_I_IPCLK		0x2118
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SPMI_MASTER_PMIC_IPCLKPORT_I_PCLK			0x211c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SWEEPER_P_ALIVE_IPCLKPORT_ACLK			0x2120
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_SYSREG_ALIVE_IPCLKPORT_PCLK			0x2124
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_TOP_RTC_IPCLKPORT_OSCCLK				0x2128
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_TOP_RTC_IPCLKPORT_PCLK				0x212c
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_VGEN_LITE_ALIVE_IPCLKPORT_CLK			0x2130
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_WDT_ALIVE_IPCLKPORT_PCLK				0x2134
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_XIU_DP_ALIVE_IPCLKPORT_ACLK			0x2138
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_OSCCLK_RCO_IPCLKPORT_CLK	0x213c
#define CLK_CON_GAT_GATE_CLKALIVE_CHUB_PERI						0x2140
#define CLK_CON_GAT_GATE_CLKALIVE_CMGP_NOC						0x2144
#define CLK_CON_GAT_GATE_CLKALIVE_CMGP_PERI						0x2148
#define CLK_CON_GAT_GATE_CLKALIVE_DBGCORE_NOC						0x214c
#define CLK_CON_GAT_GATE_CLKALIVE_DNC_NOC						0x2150
#define CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_SPMI_IPCLKPORT_CLK		0x2154
#define CLK_CON_GAT_GATE_CLKALIVE_GNPU_NOC						0x2158
#define CLK_CON_GAT_GATE_CLKALIVE_SDMA_NOC						0x215c
#define CLK_CON_GAT_GATE_CLKALIVE_UFD_NOC						0x2160
#define CLK_CON_GAT_GATE_CLKALIVE_CHUBVTS_NOC						0x2164
#define CLK_CON_GAT_GATE_CLKALIVE_CSIS_NOC						0x2168
#define CLK_CON_GAT_GATE_CLKALIVE_DSP_NOC						0x216c

static const unsigned long alive_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKCMU_ALIVE_NOC_USER,
	PLL_CON1_MUX_CLKCMU_ALIVE_NOC_USER,
	PLL_CON0_MUX_CLKMUX_ALIVE_RCO_SPMI_USER,
	PLL_CON1_MUX_CLKMUX_ALIVE_RCO_SPMI_USER,
	PLL_CON0_MUX_CLK_RCO_ALIVE_USER,
	PLL_CON1_MUX_CLK_RCO_ALIVE_USER,
	CLK_CON_MUX_MUX_CLKALIVE_CHUB_PERI,
	CLK_CON_MUX_MUX_CLKALIVE_CMGP_NOC,
	CLK_CON_MUX_MUX_CLKALIVE_CMGP_PERI,
	CLK_CON_MUX_MUX_CLKALIVE_DBGCORE_NOC,
	CLK_CON_MUX_MUX_CLKALIVE_DNC_NOC,
	CLK_CON_MUX_MUX_CLKALIVE_CHUBVTS_NOC,
	CLK_CON_MUX_MUX_CLKALIVE_GNPU_NOC,
	CLK_CON_MUX_MUX_CLKALIVE_GNSS_NOC,
	CLK_CON_MUX_MUX_CLKALIVE_SDMA_NOC,
	CLK_CON_MUX_MUX_CLKALIVE_UFD_NOC,
	CLK_CON_MUX_MUX_CLK_ALIVE_DBGCORE_UART,
	CLK_CON_MUX_MUX_CLK_ALIVE_NOC,
	CLK_CON_MUX_MUX_CLK_ALIVE_PMU_SUB,
	CLK_CON_MUX_MUX_CLK_ALIVE_SPMI,
	CLK_CON_MUX_MUX_CLK_ALIVE_TIMER,
	CLK_CON_MUX_MUX_CLKALIVE_CSIS_NOC,
	CLK_CON_MUX_MUX_CLKALIVE_DSP_NOC,
	CLK_CON_DIV_CLKALIVE_CHUB_PERI,
	CLK_CON_DIV_CLKALIVE_CMGP_NOC,
	CLK_CON_DIV_CLKALIVE_CMGP_PERI,
	CLK_CON_DIV_CLKALIVE_DBGCORE_NOC,
	CLK_CON_DIV_CLKALIVE_DNC_NOC,
	CLK_CON_DIV_CLKALIVE_CHUBVTS_NOC,
	CLK_CON_DIV_CLKALIVE_GNPU_NOC,
	CLK_CON_DIV_CLKALIVE_SDMA_NOC,
	CLK_CON_DIV_CLKALIVE_UFD_NOC,
	CLK_CON_DIV_DIV_CLK_ALIVE_DBGCORE_UART,
	CLK_CON_DIV_DIV_CLK_ALIVE_NOC,
	CLK_CON_DIV_DIV_CLK_ALIVE_PMU_SUB,
	CLK_CON_DIV_DIV_CLK_ALIVE_SPMI,
	CLK_CON_DIV_CLKALIVE_CSIS_NOC,
	CLK_CON_DIV_CLKALIVE_DSP_NOC,
	CLK_CON_GAT_CLKALIVE_CHUBVTS_RCO,
	CLK_CON_GAT_CLKALIVE_DNC_RCO,
	CLK_CON_GAT_CLKALIVE_CSIS_RCO,
	CLK_CON_GAT_CLKALIVE_GNPU_RCO,
	CLK_CON_GAT_CLKALIVE_GNSS_NOC,
	CLK_CON_GAT_CLKALIVE_SDMA_RCO,
	CLK_CON_GAT_CLKALIVE_UFD_RCO,
	CLK_CON_GAT_CLKALIVE_DSP_RCO,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_ALIVE_CMU_ALIVE_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_GPIO_ALIVE_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_INTCOMB_VGPIO2APM_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_INTCOMB_VGPIO2AP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_INTCOMB_VGPIO2PMU_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_APBIF_PMU_ALIVE_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_APM_DMA_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_CHUB_RTC_IPCLKPORT_OSCCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_CHUB_RTC_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_CLKMON_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_DBGCORE_UART_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_DBGCORE_UART_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_BLK_ALIVE_FRC_OTP_DESERIAL_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_DTZPC_ALIVE_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_GREBEINTEGRATION_IPCLKPORT_HCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_HW_SCANDUMP_CLKSTOP_CTRL_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_INTMEM_IPCLKPORT_I_ACLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_INTMEM_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_LH_AXI_SI_D_APM_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_AP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_CHUB_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_CP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_GNSS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_VTS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_CHUB_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_CP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_CP_S_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_DBGCORE_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_AP_GNSS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_CP_CHUB_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_CP_GNSS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_GNSS_CHUB_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_SHARED_SRAM_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_AUD_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MCT_ALIVE_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_PMU_INTR_GEN_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_PMU_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_PMU_IPCLKPORT_CLKIN_PMU_SUB,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_MAILBOX_APM_CP_1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_OTP_DESERIAL_ALIVE_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_DBGCORE_UART_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_GREBE_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_OSCCLK_RCO_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_SPMI_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_CLK_ALIVE_TIMER_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RTC_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_OTP_HCU_DESERIAL_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_LD_GNSS_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_LP_MODEM_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_LD_CHUBVTS_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_ID_DBGCORE_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_MI_P_APM_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_LP_CMGP_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_IP_APM_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_LP_CHUBVTS_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_LP_PPU_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SLH_AXI_SI_LP_ALIVEDNC_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SPC_ALIVE_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SPMI_MASTER_PMIC_IPCLKPORT_I_IPCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SPMI_MASTER_PMIC_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SWEEPER_P_ALIVE_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_SYSREG_ALIVE_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_TOP_RTC_IPCLKPORT_OSCCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_TOP_RTC_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_VGEN_LITE_ALIVE_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_WDT_ALIVE_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_XIU_DP_ALIVE_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_OSCCLK_RCO_IPCLKPORT_CLK,
	CLK_CON_GAT_GATE_CLKALIVE_CHUB_PERI,
	CLK_CON_GAT_GATE_CLKALIVE_CMGP_NOC,
	CLK_CON_GAT_GATE_CLKALIVE_CMGP_PERI,
	CLK_CON_GAT_GATE_CLKALIVE_DBGCORE_NOC,
	CLK_CON_GAT_GATE_CLKALIVE_DNC_NOC,
	CLK_CON_GAT_CLK_BLK_ALIVE_UID_RSTNSYNC_SR_CLK_ALIVE_SPMI_IPCLKPORT_CLK,
	CLK_CON_GAT_GATE_CLKALIVE_GNPU_NOC,
	CLK_CON_GAT_GATE_CLKALIVE_SDMA_NOC,
	CLK_CON_GAT_GATE_CLKALIVE_UFD_NOC,
	CLK_CON_GAT_GATE_CLKALIVE_CHUBVTS_NOC,
	CLK_CON_GAT_GATE_CLKALIVE_CSIS_NOC,
	CLK_CON_GAT_GATE_CLKALIVE_DSP_NOC,
};

PNAME(mout_alive_noc_user_p)		= { "oscclk", "dout_cmu_alive_noc" };
PNAME(mout_alive_rco_spmi_user_p)	= { "oscclk", "rco_i3c_pmic" };
PNAME(mout_rco_alive_user_p)		= { "oscclk", "rco_alive" };
PNAME(mout_alive_chub_peri_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_cmgp_noc_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_cmgp_peri_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_dbgcore_noc_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_dnc_noc_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_chubvts_noc_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_gnpu_noc_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_gnss_noc_p)		= { "rco_400", "mout_alive_noc_user" };
PNAME(mout_alive_sdma_noc_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_ufd_noc_p)		= { "mout_rco_alive_user",
					    "rco_400",
					    "mout_alive_noc_user",
					    "oscclk" };
PNAME(mout_alive_dbgcore_uart_p)	= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_noc_p)			= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_pmu_sub_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_spmi_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_rco_spmi_user",
					    "oscclk" };
PNAME(mout_alive_timer_p)		= { "oscclk", "oscclk" };
PNAME(mout_alive_csis_noc_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };
PNAME(mout_alive_dsp_noc_p)		= { "mout_rco_alive_user", "rco_400",
					    "mout_alive_noc_user", "oscclk" };

static const struct samsung_mux_clock alive_mux_clks[] __initconst = {
	MUX(CLK_MOUT_ALIVE_NOC_USER, "mout_alive_noc_user",
	    mout_alive_noc_user_p, PLL_CON0_MUX_CLKCMU_ALIVE_NOC_USER, 4, 1),
	MUX(CLK_MOUT_ALIVE_RCO_SPMI_USER, "mout_alive_rco_spmi_user",
	    mout_alive_rco_spmi_user_p,
	    PLL_CON0_MUX_CLKMUX_ALIVE_RCO_SPMI_USER, 4, 1),
	MUX(CLK_MOUT_RCO_ALIVE_USER, "mout_rco_alive_user",
	    mout_rco_alive_user_p, PLL_CON0_MUX_CLK_RCO_ALIVE_USER, 4, 1),
	MUX(CLK_MOUT_ALIVE_CHUB_PERI, "mout_alive_chub_peri",
	    mout_alive_chub_peri_p, CLK_CON_MUX_MUX_CLKALIVE_CHUB_PERI, 0, 2),
	MUX(CLK_MOUT_ALIVE_CMGP_NOC, "mout_alive_cmgp_noc",
	    mout_alive_cmgp_noc_p, CLK_CON_MUX_MUX_CLKALIVE_CMGP_NOC, 0, 2),
	MUX(CLK_MOUT_ALIVE_CMGP_PERI, "mout_alive_cmgp_peri",
	    mout_alive_cmgp_peri_p, CLK_CON_MUX_MUX_CLKALIVE_CMGP_PERI, 0, 2),
	MUX(CLK_MOUT_ALIVE_DBGCORE_NOC, "mout_alive_dbgcore_noc",
	    mout_alive_dbgcore_noc_p, CLK_CON_MUX_MUX_CLKALIVE_DBGCORE_NOC,
	    0, 2),
	MUX(CLK_MOUT_ALIVE_DNC_NOC, "mout_alive_dnc_noc", mout_alive_dnc_noc_p,
	    CLK_CON_MUX_MUX_CLKALIVE_DNC_NOC, 0, 2),
	MUX(CLK_MOUT_ALIVE_CHUBVTS_NOC, "mout_alive_chubvts_noc",
	    mout_alive_chubvts_noc_p, CLK_CON_MUX_MUX_CLKALIVE_CHUBVTS_NOC,
	    0, 2),
	MUX(CLK_MOUT_ALIVE_GNPU_NOC, "mout_alive_gnpu_noc",
	    mout_alive_gnpu_noc_p, CLK_CON_MUX_MUX_CLKALIVE_GNPU_NOC, 0, 2),
	MUX(CLK_MOUT_ALIVE_GNSS_NOC, "mout_alive_gnss_noc",
	    mout_alive_gnss_noc_p, CLK_CON_MUX_MUX_CLKALIVE_GNSS_NOC, 0, 1),
	MUX(CLK_MOUT_ALIVE_SDMA_NOC, "mout_alive_sdma_noc",
	    mout_alive_sdma_noc_p, CLK_CON_MUX_MUX_CLKALIVE_SDMA_NOC, 0, 2),
	MUX(CLK_MOUT_ALIVE_UFD_NOC, "mout_alive_ufd_noc", mout_alive_ufd_noc_p,
	    CLK_CON_MUX_MUX_CLKALIVE_UFD_NOC, 0, 2),
	MUX(CLK_MOUT_ALIVE_DBGCORE_UART, "mout_alive_dbgcore_uart",
	    mout_alive_dbgcore_uart_p, CLK_CON_MUX_MUX_CLK_ALIVE_DBGCORE_UART,
	    0, 2),
	MUX(CLK_MOUT_ALIVE_NOC, "mout_alive_noc", mout_alive_noc_p,
	    CLK_CON_MUX_MUX_CLK_ALIVE_NOC, 0, 2),
	MUX(CLK_MOUT_ALIVE_PMU_SUB, "mout_alive_pmu_sub", mout_alive_pmu_sub_p,
	    CLK_CON_MUX_MUX_CLK_ALIVE_PMU_SUB, 0, 2),
	MUX(CLK_MOUT_ALIVE_SPMI, "mout_alive_spmi", mout_alive_spmi_p,
	    CLK_CON_MUX_MUX_CLK_ALIVE_SPMI, 0, 2),
	MUX(CLK_MOUT_ALIVE_TIMER, "mout_alive_timer", mout_alive_timer_p,
	    CLK_CON_MUX_MUX_CLK_ALIVE_TIMER, 0, 1),
	MUX(CLK_MOUT_ALIVE_CSIS_NOC, "mout_alive_csis_noc",
	    mout_alive_csis_noc_p, CLK_CON_MUX_MUX_CLKALIVE_CSIS_NOC, 0, 2),
	MUX(CLK_MOUT_ALIVE_DSP_NOC, "mout_alive_dsp_noc", mout_alive_dsp_noc_p,
	    CLK_CON_MUX_MUX_CLKALIVE_DSP_NOC, 0, 2),
};

static const struct samsung_div_clock alive_div_clks[] __initconst = {
	DIV(CLK_DOUT_ALIVE_CHUB_PERI, "dout_alive_chub_peri",
	    "mout_alive_chub_peri", CLK_CON_DIV_CLKALIVE_CHUB_PERI, 0, 3),
	DIV(CLK_DOUT_ALIVE_CMGP_NOC, "dout_alive_cmgp_noc",
	    "mout_alive_cmgp_noc", CLK_CON_DIV_CLKALIVE_CMGP_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_CMGP_PERI, "dout_alive_cmgp_peri",
	    "mout_alive_cmgp_peri", CLK_CON_DIV_CLKALIVE_CMGP_PERI, 0, 3),
	DIV(CLK_DOUT_ALIVE_DBGCORE_NOC, "dout_alive_dbgcore_noc",
	    "mout_alive_dbgcore_noc", CLK_CON_DIV_CLKALIVE_DBGCORE_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_DNC_NOC, "dout_alive_dnc_noc", "mout_alive_dnc_noc",
	    CLK_CON_DIV_CLKALIVE_DNC_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_CHUBVTS_NOC, "dout_alive_chubvts_noc",
	    "mout_alive_chubvts_noc", CLK_CON_DIV_CLKALIVE_CHUBVTS_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_GNPU_NOC, "dout_alive_gnpu_noc",
	    "mout_alive_gnpu_noc", CLK_CON_DIV_CLKALIVE_GNPU_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_SDMA_NOC, "dout_alive_sdma_noc",
	    "mout_alive_sdma_noc", CLK_CON_DIV_CLKALIVE_SDMA_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_UFD_NOC, "dout_alive_ufd_noc", "mout_alive_ufd_noc",
	    CLK_CON_DIV_CLKALIVE_UFD_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_DBGCORE_UART, "dout_alive_dbgcore_uart",
	    "mout_alive_dbgcore_uart", CLK_CON_DIV_DIV_CLK_ALIVE_DBGCORE_UART,
	    0, 4),
	DIV(CLK_DOUT_ALIVE_NOC, "dout_alive_noc", "mout_alive_noc",
	    CLK_CON_DIV_DIV_CLK_ALIVE_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_PMU_SUB, "dout_alive_pmu_sub", "mout_alive_pmu_sub",
	    CLK_CON_DIV_DIV_CLK_ALIVE_PMU_SUB, 0, 3),
	DIV(CLK_DOUT_ALIVE_SPMI, "dout_alive_spmi", "mout_alive_spmi",
	    CLK_CON_DIV_DIV_CLK_ALIVE_SPMI, 0, 5),
	DIV(CLK_DOUT_ALIVE_CSIS_NOC, "dout_alive_csis_noc",
	    "mout_alive_csis_noc", CLK_CON_DIV_CLKALIVE_CSIS_NOC, 0, 3),
	DIV(CLK_DOUT_ALIVE_DSP_NOC, "dout_alive_dsp_noc",
	    "mout_alive_dsp_noc", CLK_CON_DIV_CLKALIVE_DSP_NOC, 0, 3),
};

static const struct samsung_fixed_rate_clock alive_fixed_clks[] __initconst = {
	FRATE(0, "rco_i3c_pmic", NULL, 0, 49152000),
	FRATE(0, "rco_alive", NULL, 0, 49152000),
	FRATE(0, "rco_400", NULL, 0, 393216000),
};

static const struct samsung_cmu_info alive_cmu_info __initconst = {
	.mux_clks		= alive_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(alive_mux_clks),
	.div_clks		= alive_div_clks,
	.nr_div_clks		= ARRAY_SIZE(alive_div_clks),
	.fixed_clks		= alive_fixed_clks,
	.nr_fixed_clks		= ARRAY_SIZE(alive_fixed_clks),
	.nr_clk_ids		= CLKS_NR_ALIVE,
	.clk_regs		= alive_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(alive_clk_regs),
	.clk_name		= "noc",
};

static void __init exynos2200_cmu_alive_init(struct device_node *np)
{
	exynos_arm64_register_cmu(NULL, np, &alive_cmu_info);
}

/* Register CMU_ALIVE early, as it's a dependency for other early domains */
CLK_OF_DECLARE(exynos2200_cmu_alive, "samsung,exynos2200-cmu-alive",
	       exynos2200_cmu_alive_init);

/* ---- CMU_PERIS ---------------------------------------------------------- */

/* Register Offset definitions for CMU_PERIS (0x10020000) */
#define PLL_CON0_MUX_CLKCMU_PERIS_GIC_USER						0x600
#define PLL_CON1_MUX_CLKCMU_PERIS_GIC_USER						0x604
#define PLL_CON0_MUX_CLKCMU_PERIS_NOC_USER						0x610
#define PLL_CON1_MUX_CLKCMU_PERIS_NOC_USER						0x614
#define CLK_CON_MUX_MUX_CLK_PERIS_GIC							0x1000
#define CLK_CON_DIV_CLKCMU_OTP								0x1800
#define CLK_CON_DIV_DIV_CLK_PERIS_DDD_CTRL						0x1804
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_BUSIF_DDD_PERIS_IPCLKPORT_ATCLK			0x2000
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_BUSIF_DDD_PERIS_IPCLKPORT_PCLK			0x2004
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_DDD_PERIS_IPCLKPORT_CK_IN				0x2008
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_D_TZPC_PERIS_IPCLKPORT_PCLK			0x200c
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_GIC_IPCLKPORT_GICCLK				0x2010
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_LH_AST_MI_LD_ICC_CPUGIC_CLUSTER0_IPCLKPORT_I_CLK	0x2014
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_LH_AST_SI_LD_IRI_GICCPU_CLUSTER0_IPCLKPORT_I_CLK	0x2018
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_MCT_IPCLKPORT_PCLK				0x201c
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_OTP_CON_BIRA_IPCLKPORT_I_OSCCLK			0x2020
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_OTP_CON_BIRA_IPCLKPORT_PCLK			0x2024
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_OTP_CON_TOP_IPCLKPORT_I_OSCCLK			0x2028
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_OTP_CON_TOP_IPCLKPORT_PCLK			0x202c
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_PERIS_CMU_PERIS_IPCLKPORT_PCLK			0x2030
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_CLK_PERIS_FREE_OSCCLK_IPCLKPORT_CLK	0x2038
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_CLK_PERIS_GIC_IPCLKPORT_CLK		0x203c
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_CLK_PERIS_NOCP_IPCLKPORT_CLK		0x2040
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_SLH_AXI_MI_P_PERISGIC_IPCLKPORT_I_CLK		0x2044
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_SLH_AXI_MI_P_PERIS_IPCLKPORT_I_CLK		0x2048
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_SYSREG_PERIS_IPCLKPORT_PCLK			0x204c
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_TMU_SUB_IPCLKPORT_PCLK				0x2050
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_TMU_TOP_IPCLKPORT_PCLK				0x2054
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_WDT0_IPCLKPORT_PCLK				0x2058
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_WDT1_IPCLKPORT_PCLK				0x205c
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_SR_CLK_PERIS_DDD_CTRL_IPCLKPORT_CLK	0x2060
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_SR_CLK_PERIS_FREE_OSCCLK_IPCLKPORT_CLK	0x2064
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_SR_CLK_PERIS_GIC_IPCLKPORT_CLK		0x2068
#define CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_SR_CLK_PERIS_NOCP_IPCLKPORT_CLK		0x206c

static const unsigned long peris_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKCMU_PERIS_GIC_USER,
	PLL_CON1_MUX_CLKCMU_PERIS_GIC_USER,
	PLL_CON0_MUX_CLKCMU_PERIS_NOC_USER,
	PLL_CON1_MUX_CLKCMU_PERIS_NOC_USER,
	CLK_CON_MUX_MUX_CLK_PERIS_GIC,
	CLK_CON_DIV_CLKCMU_OTP,
	CLK_CON_DIV_DIV_CLK_PERIS_DDD_CTRL,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_BUSIF_DDD_PERIS_IPCLKPORT_ATCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_BUSIF_DDD_PERIS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_DDD_PERIS_IPCLKPORT_CK_IN,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_D_TZPC_PERIS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_GIC_IPCLKPORT_GICCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_LH_AST_MI_LD_ICC_CPUGIC_CLUSTER0_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_LH_AST_SI_LD_IRI_GICCPU_CLUSTER0_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_MCT_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_OTP_CON_BIRA_IPCLKPORT_I_OSCCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_OTP_CON_BIRA_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_OTP_CON_TOP_IPCLKPORT_I_OSCCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_OTP_CON_TOP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_PERIS_CMU_PERIS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_CLK_PERIS_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_CLK_PERIS_GIC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_CLK_PERIS_NOCP_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_SLH_AXI_MI_P_PERISGIC_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_SLH_AXI_MI_P_PERIS_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_SYSREG_PERIS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_TMU_SUB_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_TMU_TOP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_WDT0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_WDT1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_SR_CLK_PERIS_DDD_CTRL_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_SR_CLK_PERIS_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_SR_CLK_PERIS_GIC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIS_UID_RSTNSYNC_SR_CLK_PERIS_NOCP_IPCLKPORT_CLK,
};

PNAME(mout_peris_gic_user_p)	= { "dout_tcxo_div3",
				    "dout_cmu_peris_gic" };
PNAME(mout_peris_noc_user_p)	= { "dout_tcxo_div3",
				    "dout_cmu_peris_noc" };
PNAME(mout_peris_gic_p)		= { "mout_peris_gic_user", "dout_tcxo_div3" };

static const struct samsung_mux_clock peris_mux_clks[] __initconst = {
	MUX(CLK_MOUT_PERIS_GIC_USER, "mout_peris_gic_user",
	    mout_peris_gic_user_p, PLL_CON0_MUX_CLKCMU_PERIS_GIC_USER, 4, 1),
	MUX(CLK_MOUT_PERIS_NOC_USER, "mout_peris_noc_user",
	    mout_peris_noc_user_p, PLL_CON0_MUX_CLKCMU_PERIS_NOC_USER, 4, 1),
	MUX(CLK_MOUT_PERIS_GIC, "mout_peris_gic", mout_peris_gic_p,
	    CLK_CON_MUX_MUX_CLK_PERIS_GIC, 0, 0),
};

static const struct samsung_fixed_factor_clock peris_fixed_factor_clks[] __initconst = {
	FFACTOR(CLK_DOUT_PERIS_OTP, "dout_peris_otp",
		"dout_tcxo_div3", 1, 8, 0),
	FFACTOR(CLK_DOUT_PERIS_DDD_CTRL, "dout_peris_ddd_ctrl",
		"mout_peris_gic", 1, 4, 0),
};

static const struct samsung_cmu_info peris_cmu_info __initconst = {
	.mux_clks		= peris_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(peris_mux_clks),
	.fixed_factor_clks	= peris_fixed_factor_clks,
	.nr_fixed_factor_clks	= ARRAY_SIZE(peris_fixed_factor_clks),
	.nr_clk_ids		= CLKS_NR_PERIS,
	.clk_regs		= peris_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(peris_clk_regs),
	.clk_name		= "noc",
};

static void __init exynos2200_cmu_peris_init(struct device_node *np)
{
	exynos_arm64_register_cmu(NULL, np, &peris_cmu_info);
}

/* Register CMU_PERIS early, as it's a dependency for GIC and MCT */
CLK_OF_DECLARE(exynos2200_cmu_peris, "samsung,exynos2200-cmu-peris",
	       exynos2200_cmu_peris_init);

/* ---- CMU_CMGP ----------------------------------------------------------- */

/* Register Offset definitions for CMU_CMGP (0x14e00000) */
#define PLL_CON0_MUX_CLKALIVE_CMGP_NOC_USER						0x610
#define PLL_CON1_MUX_CLKALIVE_CMGP_NOC_USER						0x614
#define PLL_CON0_MUX_CLKALIVE_CMGP_PERI_USER						0x620
#define PLL_CON1_MUX_CLKALIVE_CMGP_PERI_USER						0x624
#define CLK_CON_MUX_MUX_CLK_CMGP_I2C							0x1000
#define CLK_CON_MUX_MUX_CLK_CMGP_SPI_I2C0						0x1008
#define CLK_CON_MUX_MUX_CLK_CMGP_SPI_I2C1						0x100c
#define CLK_CON_MUX_MUX_CLK_CMGP_SPI_MS_CTRL						0x1010
#define CLK_CON_MUX_MUX_CLK_CMGP_USI0							0x1014
#define CLK_CON_MUX_MUX_CLK_CMGP_USI1							0x1018
#define CLK_CON_MUX_MUX_CLK_CMGP_USI2							0x101c
#define CLK_CON_MUX_MUX_CLK_CMGP_USI3							0x1020
#define CLK_CON_MUX_MUX_CLK_CMGP_USI4							0x1024
#define CLK_CON_MUX_MUX_CLK_CMGP_USI5							0x1028
#define CLK_CON_MUX_MUX_CLK_CMGP_USI6							0x102c
#define CLK_CON_DIV_DIV_CLK_CMGP_I2C							0x1800
#define CLK_CON_DIV_DIV_CLK_CMGP_SPI_I2C0						0x1808
#define CLK_CON_DIV_DIV_CLK_CMGP_SPI_I2C1						0x180c
#define CLK_CON_DIV_DIV_CLK_CMGP_SPI_MS_CTRL						0x1810
#define CLK_CON_DIV_DIV_CLK_CMGP_USI0							0x1814
#define CLK_CON_DIV_DIV_CLK_CMGP_USI1							0x1818
#define CLK_CON_DIV_DIV_CLK_CMGP_USI2							0x181c
#define CLK_CON_DIV_DIV_CLK_CMGP_USI3							0x1820
#define CLK_CON_DIV_DIV_CLK_CMGP_USI4							0x1824
#define CLK_CON_DIV_DIV_CLK_CMGP_USI5							0x1828
#define CLK_CON_DIV_DIV_CLK_CMGP_USI6							0x182c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_APBIF_GPIO_CMGP_IPCLKPORT_PCLK			0x2000
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_CMGP_CMU_CMGP_IPCLKPORT_PCLK			0x2004
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_CMGP_I2C_IPCLKPORT_IPCLK				0x2008
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_CMGP_I2C_IPCLKPORT_PCLK				0x200c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_D_TZPC_CMGP_IPCLKPORT_PCLK				0x2010
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP2_IPCLKPORT_IPCLK				0x2014
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP2_IPCLKPORT_PCLK				0x2018
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP3_IPCLKPORT_IPCLK				0x201c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP3_IPCLKPORT_PCLK				0x2020
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP4_IPCLKPORT_IPCLK				0x2024
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP4_IPCLKPORT_PCLK				0x2028
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP5_IPCLKPORT_IPCLK				0x202c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP5_IPCLKPORT_PCLK				0x2030
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP6_IPCLKPORT_IPCLK				0x2034
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP6_IPCLKPORT_PCLK				0x2038
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_NOC_IPCLKPORT_CLK		0x2040
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_CLK_CMGP_FREE_OSCCLK_IPCLKPORT_CLK	0x2044
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_I2C_IPCLKPORT_CLK		0x2048
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_CLK_CMGP_NOC_IPCLKPORT_CLK		0x2050
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_SPI_I2C0_IPCLKPORT_CLK	0x2054
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_SPI_I2C1_IPCLKPORT_CLK	0x2058
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI0_IPCLKPORT_CLK		0x205c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI1_IPCLKPORT_CLK		0x2060
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI2_IPCLKPORT_CLK		0x2064
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI3_IPCLKPORT_CLK		0x2068
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI4_IPCLKPORT_CLK		0x206c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI5_IPCLKPORT_CLK		0x2070
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI6_IPCLKPORT_CLK		0x2074
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_SPI_MS_CTRL_IPCLKPORT_CLK	0x2078
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SLH_AXI_MI_LP_CMGP_IPCLKPORT_I_CLK			0x207c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SLH_AXI_SI_LP_CMGPUFD_IPCLKPORT_I_CLK		0x2080
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_I2C_CMGP0_IPCLKPORT_IPCLK			0x2084
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_I2C_CMGP0_IPCLKPORT_PCLK			0x2088
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_I2C_CMGP1_IPCLKPORT_IPCLK			0x208c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_I2C_CMGP1_IPCLKPORT_PCLK			0x2090
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_MULTI_SLV_Q_CTRL_CMGP_IPCLKPORT_CLK		0x2094
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2APM_IPCLKPORT_PCLK			0x2098
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2CHUB_IPCLKPORT_PCLK			0x209c
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2CP_IPCLKPORT_PCLK			0x20a0
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2GNSS_IPCLKPORT_PCLK			0x20a4
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2PMU_AP_IPCLKPORT_PCLK			0x20a8
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP_IPCLKPORT_PCLK				0x20ac
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP0_IPCLKPORT_IPCLK				0x20b0
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP0_IPCLKPORT_PCLK				0x20b4
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP1_IPCLKPORT_IPCLK				0x20b8
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP1_IPCLKPORT_PCLK				0x20bc
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP2_IPCLKPORT_IPCLK				0x20c0
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP2_IPCLKPORT_PCLK				0x20c4
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP3_IPCLKPORT_IPCLK				0x20c8
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP3_IPCLKPORT_PCLK				0x20cc
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP4_IPCLKPORT_IPCLK				0x20d0
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP4_IPCLKPORT_PCLK				0x20d4
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP5_IPCLKPORT_IPCLK				0x20d8
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP5_IPCLKPORT_PCLK				0x20dc
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP6_IPCLKPORT_IPCLK				0x20e0
#define CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP6_IPCLKPORT_PCLK				0x20e4

static const unsigned long cmgp_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKALIVE_CMGP_NOC_USER,
	PLL_CON1_MUX_CLKALIVE_CMGP_NOC_USER,
	PLL_CON0_MUX_CLKALIVE_CMGP_PERI_USER,
	PLL_CON1_MUX_CLKALIVE_CMGP_PERI_USER,
	CLK_CON_MUX_MUX_CLK_CMGP_I2C,
	CLK_CON_MUX_MUX_CLK_CMGP_SPI_I2C0,
	CLK_CON_MUX_MUX_CLK_CMGP_SPI_I2C1,
	CLK_CON_MUX_MUX_CLK_CMGP_SPI_MS_CTRL,
	CLK_CON_MUX_MUX_CLK_CMGP_USI0,
	CLK_CON_MUX_MUX_CLK_CMGP_USI1,
	CLK_CON_MUX_MUX_CLK_CMGP_USI2,
	CLK_CON_MUX_MUX_CLK_CMGP_USI3,
	CLK_CON_MUX_MUX_CLK_CMGP_USI4,
	CLK_CON_MUX_MUX_CLK_CMGP_USI5,
	CLK_CON_MUX_MUX_CLK_CMGP_USI6,
	CLK_CON_DIV_DIV_CLK_CMGP_I2C,
	CLK_CON_DIV_DIV_CLK_CMGP_SPI_I2C0,
	CLK_CON_DIV_DIV_CLK_CMGP_SPI_I2C1,
	CLK_CON_DIV_DIV_CLK_CMGP_SPI_MS_CTRL,
	CLK_CON_DIV_DIV_CLK_CMGP_USI0,
	CLK_CON_DIV_DIV_CLK_CMGP_USI1,
	CLK_CON_DIV_DIV_CLK_CMGP_USI2,
	CLK_CON_DIV_DIV_CLK_CMGP_USI3,
	CLK_CON_DIV_DIV_CLK_CMGP_USI4,
	CLK_CON_DIV_DIV_CLK_CMGP_USI5,
	CLK_CON_DIV_DIV_CLK_CMGP_USI6,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_APBIF_GPIO_CMGP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_CMGP_CMU_CMGP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_CMGP_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_CMGP_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_D_TZPC_CMGP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP2_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP2_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP3_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP3_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP4_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP4_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP5_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP5_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP6_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_I2C_CMGP6_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_CLK_CMGP_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_CLK_CMGP_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_SPI_I2C0_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_SPI_I2C1_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI0_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI1_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI2_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI3_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI4_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI5_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_USI6_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_RSTNSYNC_SR_CLK_CMGP_SPI_MS_CTRL_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SLH_AXI_MI_LP_CMGP_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SLH_AXI_SI_LP_CMGPUFD_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_I2C_CMGP0_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_I2C_CMGP0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_I2C_CMGP1_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_I2C_CMGP1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SPI_MULTI_SLV_Q_CTRL_CMGP_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2APM_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2CHUB_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2CP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2GNSS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP2PMU_AP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_SYSREG_CMGP_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP0_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP1_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP2_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP2_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP3_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP3_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP4_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP4_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP5_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP5_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP6_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_CMGP_UID_USI_CMGP6_IPCLKPORT_PCLK,
};

PNAME(mout_cmgp_clkalive_noc_user_p)	= { "oscclk", "dout_alive_cmgp_noc" };
PNAME(mout_cmgp_clkalive_peri_user_p)	= { "oscclk", "dout_alive_cmgp_peri" };
PNAME(mout_cmgp_i2c_p)			= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_spi_i2c0_p)		= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_spi_i2c1_p)		= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_spi_ms_ctrl_p)		= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_usi0_p)			= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_usi1_p)			= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_usi2_p)			= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_usi3_p)			= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_usi4_p)			= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_usi5_p)			= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };
PNAME(mout_cmgp_usi6_p)			= { "oscclk",
					    "mout_cmgp_clkalive_peri_user" };

static const struct samsung_mux_clock cmgp_mux_clks[] __initconst = {
	MUX(CLK_MOUT_CMGP_CLKALIVE_NOC_USER, "mout_cmgp_clkalive_noc_user",
	    mout_cmgp_clkalive_noc_user_p, PLL_CON0_MUX_CLKALIVE_CMGP_NOC_USER,
	    4, 1),
	MUX(CLK_MOUT_CMGP_CLKALIVE_PERI_USER, "mout_cmgp_clkalive_peri_user",
	    mout_cmgp_clkalive_peri_user_p,
	    PLL_CON0_MUX_CLKALIVE_CMGP_PERI_USER, 4, 1),
	MUX(CLK_MOUT_CMGP_I2C, "mout_cmgp_i2c", mout_cmgp_i2c_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_I2C, 0, 1),
	MUX(CLK_MOUT_CMGP_SPI_I2C0, "mout_cmgp_spi_i2c0", mout_cmgp_spi_i2c0_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_SPI_I2C0, 0, 1),
	MUX(CLK_MOUT_CMGP_SPI_I2C1, "mout_cmgp_spi_i2c1", mout_cmgp_spi_i2c1_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_SPI_I2C1, 0, 1),
	MUX(CLK_MOUT_CMGP_SPI_MS_CTRL, "mout_cmgp_spi_ms_ctrl",
	    mout_cmgp_spi_ms_ctrl_p, CLK_CON_MUX_MUX_CLK_CMGP_SPI_MS_CTRL,
	    0, 1),
	MUX(CLK_MOUT_CMGP_USI0, "mout_cmgp_usi0", mout_cmgp_usi0_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_USI0, 0, 1),
	MUX(CLK_MOUT_CMGP_USI1, "mout_cmgp_usi1", mout_cmgp_usi1_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_USI1, 0, 1),
	MUX(CLK_MOUT_CMGP_USI2, "mout_cmgp_usi2", mout_cmgp_usi2_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_USI2, 0, 1),
	MUX(CLK_MOUT_CMGP_USI3, "mout_cmgp_usi3", mout_cmgp_usi3_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_USI3, 0, 1),
	MUX(CLK_MOUT_CMGP_USI4, "mout_cmgp_usi4", mout_cmgp_usi4_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_USI4, 0, 1),
	MUX(CLK_MOUT_CMGP_USI5, "mout_cmgp_usi5", mout_cmgp_usi5_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_USI5, 0, 1),
	MUX(CLK_MOUT_CMGP_USI6, "mout_cmgp_usi6", mout_cmgp_usi6_p,
	    CLK_CON_MUX_MUX_CLK_CMGP_USI6, 0, 1),
};

static const struct samsung_div_clock cmgp_div_clks[] __initconst = {
	DIV(CLK_DOUT_CMGP_I2C, "dout_cmgp_i2c", "mout_cmgp_i2c",
	    CLK_CON_DIV_DIV_CLK_CMGP_I2C, 0, 4),
	DIV(CLK_DOUT_CMGP_SPI_I2C0, "dout_cmgp_spi_i2c0", "mout_cmgp_spi_i2c0",
	    CLK_CON_DIV_DIV_CLK_CMGP_SPI_I2C0, 0, 4),
	DIV(CLK_DOUT_CMGP_SPI_I2C1, "dout_cmgp_spi_i2c1", "mout_cmgp_spi_i2c1",
	    CLK_CON_DIV_DIV_CLK_CMGP_SPI_I2C1, 0, 4),
	DIV(CLK_DOUT_CMGP_SPI_MS_CTRL, "dout_cmgp_spi_ms_ctrl",
	    "mout_cmgp_spi_ms_ctrl", CLK_CON_DIV_DIV_CLK_CMGP_SPI_MS_CTRL,
	    0, 4),
	DIV(CLK_DOUT_CMGP_USI0, "dout_cmgp_usi0", "mout_cmgp_usi0",
	    CLK_CON_DIV_DIV_CLK_CMGP_USI0, 0, 4),
	DIV(CLK_DOUT_CMGP_USI1, "dout_cmgp_usi1", "mout_cmgp_usi1",
	    CLK_CON_DIV_DIV_CLK_CMGP_USI1, 0, 4),
	DIV(CLK_DOUT_CMGP_USI2, "dout_cmgp_usi2", "mout_cmgp_usi2",
	    CLK_CON_DIV_DIV_CLK_CMGP_USI2, 0, 4),
	DIV(CLK_DOUT_CMGP_USI3, "dout_cmgp_usi3", "mout_cmgp_usi3",
	    CLK_CON_DIV_DIV_CLK_CMGP_USI3, 0, 4),
	DIV(CLK_DOUT_CMGP_USI4, "dout_cmgp_usi4", "mout_cmgp_usi4",
	    CLK_CON_DIV_DIV_CLK_CMGP_USI4, 0, 4),
	DIV(CLK_DOUT_CMGP_USI5, "dout_cmgp_usi5", "mout_cmgp_usi5",
	    CLK_CON_DIV_DIV_CLK_CMGP_USI5, 0, 4),
	DIV(CLK_DOUT_CMGP_USI6, "dout_cmgp_usi6", "mout_cmgp_usi6",
	    CLK_CON_DIV_DIV_CLK_CMGP_USI6, 0, 4),
};

static const struct samsung_cmu_info cmgp_cmu_info __initconst = {
	.mux_clks		= cmgp_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(cmgp_mux_clks),
	.div_clks		= cmgp_div_clks,
	.nr_div_clks		= ARRAY_SIZE(cmgp_div_clks),
	.nr_clk_ids		= CLKS_NR_CMGP,
	.clk_regs		= cmgp_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(cmgp_clk_regs),
	.clk_name		= "noc",
};

/* ---- CMU_HSI0 ----------------------------------------------------------- */

/* Register Offset definitions for CMU_HSI0 (0x10a00000) */
#define PLL_CON0_MUX_CLKAUD_HSI0_NOC_USER						0x600
#define PLL_CON1_MUX_CLKAUD_HSI0_NOC_USER						0x604
#define PLL_CON0_MUX_CLKCMU_HSI0_DPGTC_USER						0x610
#define PLL_CON1_MUX_CLKCMU_HSI0_DPGTC_USER						0x614
#define PLL_CON0_MUX_CLKCMU_HSI0_DPOSC_USER						0x620
#define PLL_CON1_MUX_CLKCMU_HSI0_DPOSC_USER						0x624
#define PLL_CON0_MUX_CLKCMU_HSI0_NOC_USER						0x630
#define PLL_CON1_MUX_CLKCMU_HSI0_NOC_USER						0x634
#define PLL_CON0_MUX_CLKCMU_HSI0_USB32DRD_USER						0x640
#define PLL_CON1_MUX_CLKCMU_HSI0_USB32DRD_USER						0x644
#define CLK_CON_MUX_MUX_CLK_HSI0_NOC							0x1000
#define CLK_CON_MUX_MUX_CLK_HSI0_RTCCLK							0x1004
#define CLK_CON_MUX_MUX_CLK_HSI0_USB32DRD						0x1008
#define CLK_CON_DIV_DIV_CLK_HSI0_EUSB							0x1800
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_AS_APB_EUSBPHY_HSI0_IPCLKPORT_PCLKM		0x2000
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_DP_LINK_IPCLKPORT_I_DP_GTC_CLK			0x2004
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_DP_LINK_IPCLKPORT_I_DP_OSC_CLK			0x2008
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_DP_LINK_IPCLKPORT_I_PCLK				0x200c
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_D_TZPC_HSI0_IPCLKPORT_PCLK				0x2010
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_HSI0_CMU_HSI0_IPCLKPORT_PCLK			0x2014
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_PPMU_HSI0_BUS1_IPCLKPORT_ACLK			0x2018
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_PPMU_HSI0_BUS1_IPCLKPORT_PCLK			0x201c
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_RSTNSYNC_CLK_HSI0_EUSB_IPCLKPORT_CLK		0x2020
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_RSTNSYNC_CLK_HSI0_NOC_IPCLKPORT_CLK		0x2024
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_ACEL_SI_D_HSI0_IPCLKPORT_I_CLK			0x2028
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_AST_SI_G_PPMU_HSI0_IPCLKPORT_I_CLK		0x202c
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_AXI_MI_LD_AUDHSI0_IPCLKPORT_I_CLK		0x2030
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_AXI_MI_P_HSI0_IPCLKPORT_I_CLK			0x2034
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_AXI_SI_LD_HSI0AUD_IPCLKPORT_I_CLK		0x2038
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_BLK_HSI0_FRC_OTP_DESERIAL_IPCLKPORT_I_CLK		0x203c
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_SYSMMU_D_HSI0_IPCLKPORT_CLK_S2			0x2040
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_SYSREG_HSI0_IPCLKPORT_PCLK				0x2044
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_URAM_IPCLKPORT_ACLK				0x2048
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_EUSB_APB_CLK			0x204c
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_EUSB_CTRL_PCLK		0x2050
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USB32DRD_REF_CLK_40		0x2054
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USBDPPHY_CTRL_PCLK		0x2058
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USBDPPHY_TCA_APB_CLK		0x205c
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USBLINK_ACLK			0x2060
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USBSUBCTL_APB_PCLK		0x2064
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_VGEN_LITE_HSI0_IPCLKPORT_CLK			0x2068
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_XIU_D_HSI0_IPCLKPORT_ACLK				0x206c
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_XIU_P0_HSI0_IPCLKPORT_ACLK				0x2070
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_OTP_DESERIAL_DPLINK_HDCP_IPCLKPORT_I_CLK		0x2074
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_RSTNSYNC_SR_CLK_HSI0_FREE_OSCCLK_IPCLKPORT_CLK	0x2078
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_RSTNSYNC_SR_CLK_HSI0_NOC_IPCLKPORT_CLK		0x207c
#define CLK_CON_GAT_CLK_BLK_HSI0_UID_SPC_HSI0_IPCLKPORT_PCLK				0x2080

static const unsigned long hsi0_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKAUD_HSI0_NOC_USER,
	PLL_CON1_MUX_CLKAUD_HSI0_NOC_USER,
	PLL_CON0_MUX_CLKCMU_HSI0_DPGTC_USER,
	PLL_CON1_MUX_CLKCMU_HSI0_DPGTC_USER,
	PLL_CON0_MUX_CLKCMU_HSI0_DPOSC_USER,
	PLL_CON1_MUX_CLKCMU_HSI0_DPOSC_USER,
	PLL_CON0_MUX_CLKCMU_HSI0_NOC_USER,
	PLL_CON1_MUX_CLKCMU_HSI0_NOC_USER,
	PLL_CON0_MUX_CLKCMU_HSI0_USB32DRD_USER,
	PLL_CON1_MUX_CLKCMU_HSI0_USB32DRD_USER,
	CLK_CON_MUX_MUX_CLK_HSI0_NOC,
	CLK_CON_MUX_MUX_CLK_HSI0_RTCCLK,
	CLK_CON_MUX_MUX_CLK_HSI0_USB32DRD,
	CLK_CON_DIV_DIV_CLK_HSI0_EUSB,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_AS_APB_EUSBPHY_HSI0_IPCLKPORT_PCLKM,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_DP_LINK_IPCLKPORT_I_DP_GTC_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_DP_LINK_IPCLKPORT_I_DP_OSC_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_DP_LINK_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_D_TZPC_HSI0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_HSI0_CMU_HSI0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_PPMU_HSI0_BUS1_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_PPMU_HSI0_BUS1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_RSTNSYNC_CLK_HSI0_EUSB_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_RSTNSYNC_CLK_HSI0_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_ACEL_SI_D_HSI0_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_AST_SI_G_PPMU_HSI0_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_AXI_MI_LD_AUDHSI0_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_AXI_MI_P_HSI0_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_SLH_AXI_SI_LD_HSI0AUD_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_BLK_HSI0_FRC_OTP_DESERIAL_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_SYSMMU_D_HSI0_IPCLKPORT_CLK_S2,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_SYSREG_HSI0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_URAM_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_EUSB_APB_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_EUSB_CTRL_PCLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USB32DRD_REF_CLK_40,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USBDPPHY_CTRL_PCLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USBDPPHY_TCA_APB_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USBLINK_ACLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_USB32DRD_IPCLKPORT_I_USBSUBCTL_APB_PCLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_VGEN_LITE_HSI0_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_XIU_D_HSI0_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_XIU_P0_HSI0_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_OTP_DESERIAL_DPLINK_HDCP_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_RSTNSYNC_SR_CLK_HSI0_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_RSTNSYNC_SR_CLK_HSI0_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_HSI0_UID_SPC_HSI0_IPCLKPORT_PCLK,
};

PNAME(mout_clkcmu_hsi0_dpgtc_user_p)	= { "oscclk", "dout_cmu_hsi0_dpgtc" };
PNAME(mout_clkcmu_hsi0_dposc_user_p)	= { "oscclk", "dout_cmu_hsi0_dposc" };
PNAME(mout_clkcmu_hsi0_noc_user_p)	= { "oscclk", "dout_cmu_hsi0_noc" };
PNAME(mout_clkcmu_hsi0_usb32drd_user_p)	= { "oscclk",
					    "dout_cmu_hsi0_usb32drd" };
PNAME(mout_mux_clk_hsi0_noc_p)		= { "mout_clkcmu_hsi0_noc_user" };
PNAME(mout_mux_clk_hsi0_rtcclk_p)	= { "rtcclk", "oscclk" };
PNAME(mout_mux_clk_hsi0_usb32drd_p)	= { "dout_tcxo_div4",
					    "mout_clkcmu_hsi0_usb32drd_user" };

static const struct samsung_mux_clock hsi0_mux_clks[] __initconst = {
	MUX(CLK_MOUT_CLKCMU_HSI0_DPGTC_USER, "mout_clkcmu_hsi0_dpgtc_user",
	    mout_clkcmu_hsi0_dpgtc_user_p, PLL_CON0_MUX_CLKCMU_HSI0_DPGTC_USER,
	    4, 1),
	MUX(CLK_MOUT_CLKCMU_HSI0_DPOSC_USER, "mout_clkcmu_hsi0_dposc_user",
	    mout_clkcmu_hsi0_dposc_user_p, PLL_CON0_MUX_CLKCMU_HSI0_DPOSC_USER,
	    4, 1),
	MUX(CLK_MOUT_CLKCMU_HSI0_NOC_USER, "mout_clkcmu_hsi0_noc_user",
	    mout_clkcmu_hsi0_noc_user_p, PLL_CON0_MUX_CLKCMU_HSI0_NOC_USER,
	    4, 1),
	MUX(CLK_MOUT_CLKCMU_HSI0_USB32DRD_USER,
	    "mout_clkcmu_hsi0_usb32drd_user", mout_clkcmu_hsi0_usb32drd_user_p,
	    PLL_CON0_MUX_CLKCMU_HSI0_USB32DRD_USER, 4, 1),
	MUX(CLK_MOUT_HSI0_NOC, "mout_hsi0_noc", mout_mux_clk_hsi0_noc_p,
	    CLK_CON_MUX_MUX_CLK_HSI0_NOC, 0, 1),
	MUX(CLK_MOUT_HSI0_RTCCLK, "mout_hsi0_rtcclk",
	    mout_mux_clk_hsi0_rtcclk_p, CLK_CON_MUX_MUX_CLK_HSI0_RTCCLK, 0, 1),
	MUX(CLK_MOUT_HSI0_USB32DRD, "mout_hsi0_usb32drd",
	    mout_mux_clk_hsi0_usb32drd_p, CLK_CON_MUX_MUX_CLK_HSI0_USB32DRD,
	    0, 1),
};

static const struct samsung_div_clock hsi0_div_clks[] __initconst = {
	DIV(CLK_DOUT_DIV_CLK_HSI0_EUSB, "dout_div_clk_hsi0_eusb",
	    "mout_hsi0_noc", CLK_CON_DIV_DIV_CLK_HSI0_EUSB, 0, 2),
};

static const struct samsung_cmu_info hsi0_cmu_info __initconst = {
	.mux_clks		= hsi0_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(hsi0_mux_clks),
	.div_clks		= hsi0_div_clks,
	.nr_div_clks		= ARRAY_SIZE(hsi0_div_clks),
	.nr_clk_ids		= CLKS_NR_HSI0,
	.clk_regs		= hsi0_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(hsi0_clk_regs),
	.clk_name		= "noc",
};

/* ---- CMU_PERIC0 --------------------------------------------------------- */

/* Register Offset definitions for CMU_PERIC0 (0x10400000) */
#define PLL_CON0_MUX_CLKCMU_PERIC0_IP0_USER						0x600
#define PLL_CON1_MUX_CLKCMU_PERIC0_IP0_USER						0x604
#define PLL_CON0_MUX_CLKCMU_PERIC0_IP1_USER						0x610
#define PLL_CON1_MUX_CLKCMU_PERIC0_IP1_USER						0x614
#define PLL_CON0_MUX_CLKCMU_PERIC0_NOC_USER						0x620
#define PLL_CON1_MUX_CLKCMU_PERIC0_NOC_USER						0x624
#define CLK_CON_MUX_MUX_CLK_PERIC0_I2C							0x1000
#define CLK_CON_MUX_MUX_CLK_PERIC0_USI04						0x1010
#define CLK_CON_DIV_DIV_CLK_PERIC0_I2C							0x1800
#define CLK_CON_DIV_DIV_CLK_PERIC0_USI04						0x1810
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_D_TZPC_PERIC0_IPCLKPORT_PCLK			0x2000
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_GPIO_PERIC0_IPCLKPORT_PCLK			0x2004
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_PERIC0_CMU_PERIC0_IPCLKPORT_PCLK			0x2008
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_CLK_PERIC0_FREE_OSCCLK_IPCLKPORT_CLK	0x200c
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_CLK_PERIC0_I2C_IPCLKPORT_CLK		0x2010
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_CLK_PERIC0_NOCP_IPCLKPORT_CLK		0x2014
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_SR_CLK_PERIC0_USI04_IPCLKPORT_CLK	0x2018
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_SLH_AXI_MI_P_PERIC0_IPCLKPORT_I_CLK		0x201c
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_SYSREG_PERIC0_IPCLKPORT_PCLK			0x2020
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_USI04_I2C_IPCLKPORT_IPCLK			0x2024
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_USI04_I2C_IPCLKPORT_PCLK				0x2028
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_USI04_USI_IPCLKPORT_IPCLK			0x202c
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_USI04_USI_IPCLKPORT_PCLK				0x2030
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C00_IPCLKPORT_I_PCLK				0x2034
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C00_IPCLKPORT_I_SCLK				0x2038
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C01_IPCLKPORT_I_PCLK				0x203c
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C01_IPCLKPORT_I_SCLK				0x2040
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C02_IPCLKPORT_I_PCLK				0x2044
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C02_IPCLKPORT_I_SCLK				0x2048
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_SR_CLK_PERIC0_I2C_IPCLKPORT_CLK		0x204c
#define CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_SR_CLK_PERIC0_NOCP_IPCLKPORT_CLK	0x2050

static const unsigned long peric0_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKCMU_PERIC0_IP0_USER,
	PLL_CON1_MUX_CLKCMU_PERIC0_IP0_USER,
	PLL_CON0_MUX_CLKCMU_PERIC0_IP1_USER,
	PLL_CON1_MUX_CLKCMU_PERIC0_IP1_USER,
	PLL_CON0_MUX_CLKCMU_PERIC0_NOC_USER,
	PLL_CON1_MUX_CLKCMU_PERIC0_NOC_USER,
	CLK_CON_MUX_MUX_CLK_PERIC0_I2C,
	CLK_CON_MUX_MUX_CLK_PERIC0_USI04,
	CLK_CON_DIV_DIV_CLK_PERIC0_I2C,
	CLK_CON_DIV_DIV_CLK_PERIC0_USI04,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_D_TZPC_PERIC0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_GPIO_PERIC0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_PERIC0_CMU_PERIC0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_CLK_PERIC0_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_CLK_PERIC0_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_CLK_PERIC0_NOCP_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_SR_CLK_PERIC0_USI04_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_SLH_AXI_MI_P_PERIC0_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_SYSREG_PERIC0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_USI04_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_USI04_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_USI04_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_USI04_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C00_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C00_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C01_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C01_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C02_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_I3C02_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_SR_CLK_PERIC0_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC0_UID_RSTNSYNC_SR_CLK_PERIC0_NOCP_IPCLKPORT_CLK,
};

PNAME(mout_peric0_ip0_user_p)	= { "oscclk", "dout_cmu_peric0_ip0" };
PNAME(mout_peric0_ip1_user_p)	= { "oscclk", "dout_cmu_peric0_ip1" };
PNAME(mout_peric0_noc_user_p)	= { "oscclk", "dout_cmu_peric0_noc" };
PNAME(mout_peric0_i2c_p)	= { "oscclk", "mout_peric0_ip0_user",
				    "mout_peric0_ip0_user", "oscclk" };
PNAME(mout_peric0_usi04_p)	= { "oscclk", "mout_peric0_ip0_user",
				    "mout_peric0_ip0_user", "oscclk" };

static const struct samsung_mux_clock peric0_mux_clks[] __initconst = {
	MUX(CLK_MOUT_PERIC0_IP0_USER, "mout_peric0_ip0_user",
	    mout_peric0_ip0_user_p, PLL_CON0_MUX_CLKCMU_PERIC0_IP0_USER, 4, 1),
	MUX(CLK_MOUT_PERIC0_IP1_USER, "mout_peric0_ip1_user",
	    mout_peric0_ip1_user_p, PLL_CON0_MUX_CLKCMU_PERIC0_IP1_USER, 4, 1),
	MUX(CLK_MOUT_PERIC0_NOC_USER, "mout_peric0_noc_user",
	    mout_peric0_noc_user_p, PLL_CON0_MUX_CLKCMU_PERIC0_NOC_USER, 4, 1),
	MUX(CLK_MOUT_PERIC0_I2C, "mout_peric0_i2c", mout_peric0_i2c_p,
	    CLK_CON_MUX_MUX_CLK_PERIC0_I2C, 0, 2),
	MUX(CLK_MOUT_PERIC0_USI04, "mout_peric0_usi04", mout_peric0_usi04_p,
	    CLK_CON_MUX_MUX_CLK_PERIC0_USI04, 0, 2),
};

static const struct samsung_div_clock peric0_div_clks[] __initconst = {
	DIV(CLK_DOUT_PERIC0_I2C, "dout_peric0_i2c", "mout_peric0_i2c",
	    CLK_CON_DIV_DIV_CLK_PERIC0_I2C, 0, 4),
	DIV(CLK_DOUT_PERIC0_USI04, "dout_peric0_usi04", "mout_peric0_usi04",
	    CLK_CON_DIV_DIV_CLK_PERIC0_USI04, 0, 7),
};

static const struct samsung_cmu_info peric0_cmu_info __initconst = {
	.mux_clks		= peric0_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(peric0_mux_clks),
	.div_clks		= peric0_div_clks,
	.nr_div_clks		= ARRAY_SIZE(peric0_div_clks),
	.nr_clk_ids		= CLKS_NR_PERIC0,
	.clk_regs		= peric0_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(peric0_clk_regs),
	.clk_name		= "noc",
};

/* ---- CMU_PERIC1 --------------------------------------------------------- */

/* Register Offset definitions for CMU_PERIC1 (0x10700000) */
#define PLL_CON0_MUX_CLKCMU_PERIC1_IP0_USER							0x600
#define PLL_CON1_MUX_CLKCMU_PERIC1_IP0_USER							0x604
#define PLL_CON0_MUX_CLKCMU_PERIC1_IP1_USER							0x610
#define PLL_CON1_MUX_CLKCMU_PERIC1_IP1_USER							0x614
#define PLL_CON0_MUX_CLKCMU_PERIC1_NOC_USER							0x620
#define PLL_CON1_MUX_CLKCMU_PERIC1_NOC_USER							0x624
#define CLK_CON_MUX_MUX_CLK_PERIC1_I2C								0x1000
#define CLK_CON_MUX_MUX_CLK_PERIC1_SPI_MS_CTRL							0x1004
#define CLK_CON_MUX_MUX_CLK_PERIC1_UART_BT							0x1008
#define CLK_CON_MUX_MUX_CLK_PERIC1_USI07							0x100c
#define CLK_CON_MUX_MUX_CLK_PERIC1_USI07_SPI_I2C						0x1010
#define CLK_CON_MUX_MUX_CLK_PERIC1_USI08							0x1014
#define CLK_CON_MUX_MUX_CLK_PERIC1_USI08_SPI_I2C						0x1018
#define CLK_CON_MUX_MUX_CLK_PERIC1_USI09							0x101c
#define CLK_CON_MUX_MUX_CLK_PERIC1_USI10							0x1020
#define CLK_CON_DIV_DIV_CLK_PERIC1_I2C								0x1800
#define CLK_CON_DIV_DIV_CLK_PERIC1_SPI_MS_CTRL							0x1804
#define CLK_CON_DIV_DIV_CLK_PERIC1_UART_BT							0x1808
#define CLK_CON_DIV_DIV_CLK_PERIC1_USI07							0x180c
#define CLK_CON_DIV_DIV_CLK_PERIC1_USI07_SPI_I2C						0x1810
#define CLK_CON_DIV_DIV_CLK_PERIC1_USI08							0x1814
#define CLK_CON_DIV_DIV_CLK_PERIC1_USI08_SPI_I2C						0x1818
#define CLK_CON_DIV_DIV_CLK_PERIC1_USI09							0x181c
#define CLK_CON_DIV_DIV_CLK_PERIC1_USI10							0x1820
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_BT_UART_IPCLKPORT_IPCLK					0x2000
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_BT_UART_IPCLKPORT_PCLK					0x2004
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_D_TZPC_PERIC1_IPCLKPORT_PCLK				0x2008
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_GPIO_PERIC1_IPCLKPORT_PCLK				0x200c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_I2C_IPCLKPORT_CLK			0x2010
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_NOCP_IPCLKPORT_CLK		0x2014
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_PERIC1_CMU_PERIC1_IPCLKPORT_PCLK				0x2028
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_CLK_PERIC1_FREE_OSCCLK_IPCLKPORT_CLK		0x202c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_CLK_PERIC1_NOCP_IPCLKPORT_CLK			0x2034
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_UART_BT_IPCLKPORT_CLK		0x2038
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI07_IPCLKPORT_CLK		0x203c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI07_SPI_I2C_IPCLKPORT_CLK	0x2040
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI08_IPCLKPORT_CLK		0x2044
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI08_SPI_I2C_IPCLKPORT_CLK	0x2048
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI09_IPCLKPORT_CLK		0x204c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI10_IPCLKPORT_CLK		0x2050
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_SPI_MS_CTRL_IPCLKPORT_CLK		0x2054
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_SLH_AXI_MI_P_PERIC1_IPCLKPORT_I_CLK			0x205c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_SPI_MULTI_SLV_Q_CTRL_PERIC1_IPCLKPORT_CLK		0x2060
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_SYSREG_PERIC1_IPCLKPORT_PCLK				0x2064
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI07_SPI_I2C_IPCLKPORT_IPCLK				0x2068
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI07_SPI_I2C_IPCLKPORT_PCLK				0x206c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI07_USI_IPCLKPORT_IPCLK				0x2070
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI07_USI_IPCLKPORT_PCLK					0x2074
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI08_SPI_I2C_IPCLKPORT_IPCLK				0x2078
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI08_SPI_I2C_IPCLKPORT_PCLK				0x207c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI08_USI_IPCLKPORT_IPCLK				0x2080
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI08_USI_IPCLKPORT_PCLK					0x2084
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI09_I2C_IPCLKPORT_IPCLK				0x2088
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI09_I2C_IPCLKPORT_PCLK					0x208c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI09_USI_IPCLKPORT_IPCLK				0x2090
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI09_USI_IPCLKPORT_PCLK					0x2094
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI10_I2C_IPCLKPORT_IPCLK				0x2098
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI10_I2C_IPCLKPORT_PCLK					0x209c
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI10_USI_IPCLKPORT_IPCLK				0x20a0
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI10_USI_IPCLKPORT_PCLK					0x20a4
#define CLK_CON_GAT_CLK_BLK_PERIC1_UID_XIU_P_PERIC1_IPCLKPORT_ACLK				0x20a8

static const unsigned long peric1_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKCMU_PERIC1_IP0_USER,
	PLL_CON1_MUX_CLKCMU_PERIC1_IP0_USER,
	PLL_CON0_MUX_CLKCMU_PERIC1_IP1_USER,
	PLL_CON1_MUX_CLKCMU_PERIC1_IP1_USER,
	PLL_CON0_MUX_CLKCMU_PERIC1_NOC_USER,
	PLL_CON1_MUX_CLKCMU_PERIC1_NOC_USER,
	CLK_CON_MUX_MUX_CLK_PERIC1_I2C,
	CLK_CON_MUX_MUX_CLK_PERIC1_SPI_MS_CTRL,
	CLK_CON_MUX_MUX_CLK_PERIC1_UART_BT,
	CLK_CON_MUX_MUX_CLK_PERIC1_USI07,
	CLK_CON_MUX_MUX_CLK_PERIC1_USI07_SPI_I2C,
	CLK_CON_MUX_MUX_CLK_PERIC1_USI08,
	CLK_CON_MUX_MUX_CLK_PERIC1_USI08_SPI_I2C,
	CLK_CON_MUX_MUX_CLK_PERIC1_USI09,
	CLK_CON_MUX_MUX_CLK_PERIC1_USI10,
	CLK_CON_DIV_DIV_CLK_PERIC1_I2C,
	CLK_CON_DIV_DIV_CLK_PERIC1_SPI_MS_CTRL,
	CLK_CON_DIV_DIV_CLK_PERIC1_UART_BT,
	CLK_CON_DIV_DIV_CLK_PERIC1_USI07,
	CLK_CON_DIV_DIV_CLK_PERIC1_USI07_SPI_I2C,
	CLK_CON_DIV_DIV_CLK_PERIC1_USI08,
	CLK_CON_DIV_DIV_CLK_PERIC1_USI08_SPI_I2C,
	CLK_CON_DIV_DIV_CLK_PERIC1_USI09,
	CLK_CON_DIV_DIV_CLK_PERIC1_USI10,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_BT_UART_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_BT_UART_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_D_TZPC_PERIC1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_GPIO_PERIC1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_NOCP_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_PERIC1_CMU_PERIC1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_CLK_PERIC1_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_CLK_PERIC1_NOCP_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_UART_BT_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI07_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI07_SPI_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI08_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI08_SPI_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI09_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_USI10_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_RSTNSYNC_SR_CLK_PERIC1_SPI_MS_CTRL_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_SLH_AXI_MI_P_PERIC1_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_SPI_MULTI_SLV_Q_CTRL_PERIC1_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_SYSREG_PERIC1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI07_SPI_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI07_SPI_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI07_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI07_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI08_SPI_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI08_SPI_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI08_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI08_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI09_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI09_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI09_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI09_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI10_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI10_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI10_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_USI10_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC1_UID_XIU_P_PERIC1_IPCLKPORT_ACLK,
};

PNAME(mout_peric1_ip0_user_p)		= { "oscclk", "dout_cmu_peric1_ip0" };
PNAME(mout_peric1_ip1_user_p)		= { "oscclk", "dout_cmu_peric1_ip1" };
PNAME(mout_peric1_noc_user_p)		= { "oscclk", "dout_cmu_peric1_noc" };
PNAME(mout_peric1_i2c_p)		= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };
PNAME(mout_peric1_spi_ms_ctrl_p)	= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };
PNAME(mout_peric1_uart_bt_p)		= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };
PNAME(mout_peric1_usi07_p)		= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };
PNAME(mout_peric1_usi07_spi_i2c_p)	= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };
PNAME(mout_peric1_usi08_p)		= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };
PNAME(mout_peric1_usi08_spi_i2c_p)	= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };
PNAME(mout_peric1_usi09_p)		= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };
PNAME(mout_peric1_usi10_p)		= { "oscclk", "mout_peric1_ip0_user",
					    "mout_peric1_ip1_user", "oscclk" };

static const struct samsung_mux_clock peric1_mux_clks[] __initconst = {
	MUX(CLK_MOUT_PERIC1_IP0_USER, "mout_peric1_ip0_user",
	    mout_peric1_ip0_user_p, PLL_CON0_MUX_CLKCMU_PERIC1_IP0_USER, 4, 1),
	MUX(CLK_MOUT_PERIC1_IP1_USER, "mout_peric1_ip1_user",
	    mout_peric1_ip1_user_p, PLL_CON0_MUX_CLKCMU_PERIC1_IP1_USER, 4, 1),
	MUX(CLK_MOUT_PERIC1_NOC_USER, "mout_peric1_noc_user",
	    mout_peric1_noc_user_p, PLL_CON0_MUX_CLKCMU_PERIC1_NOC_USER, 4, 1),
	MUX(CLK_MOUT_PERIC1_I2C, "mout_peric1_i2c", mout_peric1_i2c_p,
	    CLK_CON_MUX_MUX_CLK_PERIC1_I2C, 0, 2),
	MUX(CLK_MOUT_PERIC1_SPI_MS_CTRL, "mout_peric1_spi_ms_ctrl",
	    mout_peric1_spi_ms_ctrl_p, CLK_CON_MUX_MUX_CLK_PERIC1_SPI_MS_CTRL,
	    0, 2),
	MUX(CLK_MOUT_PERIC1_UART_BT, "mout_peric1_uart_bt",
	    mout_peric1_uart_bt_p, CLK_CON_MUX_MUX_CLK_PERIC1_UART_BT, 0, 2),
	MUX(CLK_MOUT_PERIC1_USI07, "mout_peric1_usi07", mout_peric1_usi07_p,
	    CLK_CON_MUX_MUX_CLK_PERIC1_USI07, 0, 2),
	MUX(CLK_MOUT_PERIC1_USI07_SPI_I2C, "mout_peric1_usi07_spi_i2c",
	    mout_peric1_usi07_spi_i2c_p,
	    CLK_CON_MUX_MUX_CLK_PERIC1_USI07_SPI_I2C, 0, 2),
	MUX(CLK_MOUT_PERIC1_USI08, "mout_peric1_usi08", mout_peric1_usi08_p,
	    CLK_CON_MUX_MUX_CLK_PERIC1_USI08, 0, 2),
	MUX(CLK_MOUT_PERIC1_USI08_SPI_I2C, "mout_peric1_usi08_spi_i2c",
	    mout_peric1_usi08_spi_i2c_p,
	    CLK_CON_MUX_MUX_CLK_PERIC1_USI08_SPI_I2C, 0, 2),
	MUX(CLK_MOUT_PERIC1_USI09, "mout_peric1_usi09", mout_peric1_usi09_p,
	    CLK_CON_MUX_MUX_CLK_PERIC1_USI09, 0, 2),
	MUX(CLK_MOUT_PERIC1_USI10, "mout_peric1_usi10", mout_peric1_usi10_p,
	    CLK_CON_MUX_MUX_CLK_PERIC1_USI10, 0, 2),
};

static const struct samsung_div_clock peric1_div_clks[] __initconst = {
	DIV(CLK_DOUT_PERIC1_I2C, "dout_peric1_i2c", "mout_peric1_i2c",
	    CLK_CON_DIV_DIV_CLK_PERIC1_I2C, 0, 4),
	DIV(CLK_DOUT_PERIC1_SPI_MS_CTRL, "dout_peric1_spi_ms_ctrl",
	    "mout_peric1_spi_ms_ctrl", CLK_CON_DIV_DIV_CLK_PERIC1_SPI_MS_CTRL,
	    0, 7),
	DIV(CLK_DOUT_PERIC1_UART_BT, "dout_peric1_uart_bt",
	    "mout_peric1_uart_bt", CLK_CON_DIV_DIV_CLK_PERIC1_UART_BT, 0, 4),
	DIV(CLK_DOUT_PERIC1_USI07, "dout_peric1_usi07", "mout_peric1_usi07",
	    CLK_CON_DIV_DIV_CLK_PERIC1_USI07, 0, 7),
	DIV(CLK_DOUT_PERIC1_USI07_SPI_I2C, "dout_peric1_usi07_spi_i2c",
	    "mout_peric1_usi07_spi_i2c",
	    CLK_CON_DIV_DIV_CLK_PERIC1_USI07_SPI_I2C, 0, 4),
	DIV(CLK_DOUT_PERIC1_USI08, "dout_peric1_usi08", "mout_peric1_usi08",
	    CLK_CON_DIV_DIV_CLK_PERIC1_USI08, 0, 7),
	DIV(CLK_DOUT_PERIC1_USI08_SPI_I2C, "dout_peric1_usi08_spi_i2c",
	    "mout_peric1_usi08_spi_i2c",
	    CLK_CON_DIV_DIV_CLK_PERIC1_USI08_SPI_I2C, 0, 4),
	DIV(CLK_DOUT_PERIC1_USI09, "dout_peric1_usi09", "mout_peric1_usi09",
	    CLK_CON_DIV_DIV_CLK_PERIC1_USI09, 0, 7),
	DIV(CLK_DOUT_PERIC1_USI10, "dout_peric1_usi10", "mout_peric1_usi10",
	    CLK_CON_DIV_DIV_CLK_PERIC1_USI10, 0, 7),
};

static const struct samsung_cmu_info peric1_cmu_info __initconst = {
	.mux_clks		= peric1_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(peric1_mux_clks),
	.div_clks		= peric1_div_clks,
	.nr_div_clks		= ARRAY_SIZE(peric1_div_clks),
	.nr_clk_ids		= CLKS_NR_PERIC1,
	.clk_regs		= peric1_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(peric1_clk_regs),
	.clk_name		= "noc",
};

/* ---- CMU_PERIC2 --------------------------------------------------------- */

/* Register Offset definitions for CMU_PERIC2 (0x11c00000) */
#define PLL_CON0_MUX_CLKCMU_PERIC2_IP0_USER							0x600
#define PLL_CON1_MUX_CLKCMU_PERIC2_IP0_USER							0x604
#define PLL_CON0_MUX_CLKCMU_PERIC2_IP1_USER							0x610
#define PLL_CON1_MUX_CLKCMU_PERIC2_IP1_USER							0x614
#define PLL_CON0_MUX_CLKCMU_PERIC2_NOC_USER							0x620
#define PLL_CON1_MUX_CLKCMU_PERIC2_NOC_USER							0x624
#define CLK_CON_MUX_MUX_CLK_PERIC2_I2C								0x1000
#define CLK_CON_MUX_MUX_CLK_PERIC2_SPI_MS_CTRL							0x1004
#define CLK_CON_MUX_MUX_CLK_PERIC2_UART_DBG							0x1008
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI00							0x100c
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI00_SPI_I2C						0x1010
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI01							0x1014
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI01_SPI_I2C						0x1018
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI02							0x101c
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI03							0x1020
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI05							0x1024
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI06							0x1028
#define CLK_CON_MUX_MUX_CLK_PERIC2_USI11							0x102c
#define CLK_CON_DIV_DIV_CLK_PERIC2_I2C								0x1800
#define CLK_CON_DIV_DIV_CLK_PERIC2_SPI_MS_CTRL							0x1804
#define CLK_CON_DIV_DIV_CLK_PERIC2_UART_DBG							0x1808
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI00							0x180c
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI00_SPI_I2C						0x1810
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI01							0x1814
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI01_SPI_I2C						0x1818
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI02							0x181c
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI03							0x1820
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI05							0x1824
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI06							0x1828
#define CLK_CON_DIV_DIV_CLK_PERIC2_USI11							0x182c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_DBG_UART_IPCLKPORT_IPCLK					0x2000
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_DBG_UART_IPCLKPORT_PCLK					0x2004
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_D_TZPC_PERIC2_IPCLKPORT_PCLK				0x2008
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_GPIO_PERIC2_IPCLKPORT_PCLK				0x200c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C03_OIS_IPCLKPORT_I_PCLK				0x2010
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C03_OIS_IPCLKPORT_I_SCLK				0x2014
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C04_IPCLKPORT_I_PCLK					0x2018
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C04_IPCLKPORT_I_SCLK					0x201c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C05_IPCLKPORT_I_PCLK					0x2020
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C05_IPCLKPORT_I_SCLK					0x2024
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C06_IPCLKPORT_I_PCLK					0x2028
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C06_IPCLKPORT_I_SCLK					0x202c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C07_IPCLKPORT_I_PCLK					0x2030
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C07_IPCLKPORT_I_SCLK					0x2034
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C08_IPCLKPORT_I_PCLK					0x2038
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C08_IPCLKPORT_I_SCLK					0x203c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C09_IPCLKPORT_I_PCLK					0x2040
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C09_IPCLKPORT_I_SCLK					0x2044
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C10_IPCLKPORT_I_PCLK					0x2048
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C10_IPCLKPORT_I_SCLK					0x204c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C11_IPCLKPORT_I_PCLK					0x2050
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C11_IPCLKPORT_I_SCLK					0x2054
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_PERIC2_CMU_PERIC2_IPCLKPORT_PCLK				0x2058
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_PWM_IPCLKPORT_I_PCLK_S0					0x205c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_CLK_PERIC2_FREE_OSCCLK_IPCLKPORT_CLK		0x2060
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_CLK_PERIC2_I2C_IPCLKPORT_CLK			0x2064
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_CLK_PERIC2_NOCP_IPCLKPORT_CLK			0x2068
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_UART_DBG_IPCLKPORT_CLK		0x206c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI00_IPCLKPORT_CLK		0x2070
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI00_SPI_I2C_IPCLKPORT_CLK	0x2074
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI01_IPCLKPORT_CLK		0x2078
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI01_SPI_I2C_IPCLKPORT_CLK	0x207c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI02_IPCLKPORT_CLK		0x2080
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI03_IPCLKPORT_CLK		0x2084
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI05_IPCLKPORT_CLK		0x2088
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI06_IPCLKPORT_CLK		0x208c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI11_IPCLKPORT_CLK		0x2090
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_SPI_MS_CTRL_IPCLKPORT_CLK		0x2094
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_SLH_AXI_MI_P_PERIC2_IPCLKPORT_I_CLK			0x2098
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_SPI_MULTI_SLV_Q_CTRL_PERIC2_IPCLKPORT_CLK		0x209c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_SYSREG_PERIC2_IPCLKPORT_PCLK				0x20a0
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI00_SPI_I2C_IPCLKPORT_IPCLK				0x20a4
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI00_SPI_I2C_IPCLKPORT_PCLK				0x20a8
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI00_USI_IPCLKPORT_IPCLK				0x20ac
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI00_USI_IPCLKPORT_PCLK					0x20b0
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI01_SPI_I2C_IPCLKPORT_IPCLK				0x20b4
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI01_SPI_I2C_IPCLKPORT_PCLK				0x20b8
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI01_USI_IPCLKPORT_IPCLK				0x20bc
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI01_USI_IPCLKPORT_PCLK					0x20c0
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI02_I2C_IPCLKPORT_IPCLK				0x20c4
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI02_I2C_IPCLKPORT_PCLK					0x20c8
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI02_USI_IPCLKPORT_IPCLK				0x20cc
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI02_USI_IPCLKPORT_PCLK					0x20d0
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI03_I2C_IPCLKPORT_IPCLK				0x20d4
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI03_I2C_IPCLKPORT_PCLK					0x20d8
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI03_USI_IPCLKPORT_IPCLK				0x20dc
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI03_USI_IPCLKPORT_PCLK					0x20e0
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI05_I2C_IPCLKPORT_IPCLK				0x20e4
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI05_I2C_IPCLKPORT_PCLK					0x20e8
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI05_USI_OIS_IPCLKPORT_IPCLK				0x20ec
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI05_USI_OIS_IPCLKPORT_PCLK				0x20f0
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI06_I2C_IPCLKPORT_IPCLK				0x20f4
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI06_I2C_IPCLKPORT_PCLK					0x20f8
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI06_USI_OIS_IPCLKPORT_IPCLK				0x20fc
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI06_USI_OIS_IPCLKPORT_PCLK				0x2100
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI11_I2C_IPCLKPORT_IPCLK				0x2104
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI11_I2C_IPCLKPORT_PCLK					0x2108
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI11_USI_IPCLKPORT_IPCLK				0x210c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI11_USI_IPCLKPORT_PCLK					0x2110
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_I2C_IPCLKPORT_CLK			0x2114
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_NOCP_IPCLKPORT_CLK		0x2118
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_SLH_AXI_MI_LP_CSISPERIC2_IPCLKPORT_I_CLK			0x211c
#define CLK_CON_GAT_CLK_BLK_PERIC2_UID_XIU_P_PERIC2_IPCLKPORT_ACLK				0x2120

static const unsigned long peric2_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKCMU_PERIC2_IP0_USER,
	PLL_CON1_MUX_CLKCMU_PERIC2_IP0_USER,
	PLL_CON0_MUX_CLKCMU_PERIC2_IP1_USER,
	PLL_CON1_MUX_CLKCMU_PERIC2_IP1_USER,
	PLL_CON0_MUX_CLKCMU_PERIC2_NOC_USER,
	PLL_CON1_MUX_CLKCMU_PERIC2_NOC_USER,
	CLK_CON_MUX_MUX_CLK_PERIC2_I2C,
	CLK_CON_MUX_MUX_CLK_PERIC2_SPI_MS_CTRL,
	CLK_CON_MUX_MUX_CLK_PERIC2_UART_DBG,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI00,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI00_SPI_I2C,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI01,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI01_SPI_I2C,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI02,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI03,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI05,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI06,
	CLK_CON_MUX_MUX_CLK_PERIC2_USI11,
	CLK_CON_DIV_DIV_CLK_PERIC2_I2C,
	CLK_CON_DIV_DIV_CLK_PERIC2_SPI_MS_CTRL,
	CLK_CON_DIV_DIV_CLK_PERIC2_UART_DBG,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI00,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI00_SPI_I2C,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI01,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI01_SPI_I2C,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI02,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI03,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI05,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI06,
	CLK_CON_DIV_DIV_CLK_PERIC2_USI11,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_DBG_UART_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_DBG_UART_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_D_TZPC_PERIC2_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_GPIO_PERIC2_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C03_OIS_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C03_OIS_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C04_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C04_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C05_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C05_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C06_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C06_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C07_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C07_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C08_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C08_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C09_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C09_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C10_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C10_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C11_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_I3C11_IPCLKPORT_I_SCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_PERIC2_CMU_PERIC2_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_PWM_IPCLKPORT_I_PCLK_S0,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_CLK_PERIC2_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_CLK_PERIC2_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_CLK_PERIC2_NOCP_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_UART_DBG_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI00_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI00_SPI_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI01_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI01_SPI_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI02_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI03_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI05_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI06_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_USI11_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_SPI_MS_CTRL_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_SLH_AXI_MI_P_PERIC2_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_SPI_MULTI_SLV_Q_CTRL_PERIC2_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_SYSREG_PERIC2_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI00_SPI_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI00_SPI_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI00_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI00_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI01_SPI_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI01_SPI_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI01_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI01_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI02_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI02_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI02_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI02_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI03_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI03_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI03_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI03_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI05_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI05_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI05_USI_OIS_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI05_USI_OIS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI06_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI06_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI06_USI_OIS_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI06_USI_OIS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI11_I2C_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI11_I2C_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI11_USI_IPCLKPORT_IPCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_USI11_USI_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_I2C_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_RSTNSYNC_SR_CLK_PERIC2_NOCP_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_SLH_AXI_MI_LP_CSISPERIC2_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_PERIC2_UID_XIU_P_PERIC2_IPCLKPORT_ACLK,
};

PNAME(mout_peric2_ip0_user_p)			= { "oscclk",
						    "dout_cmu_peric2_ip0" };
PNAME(mout_peric2_ip1_user_p)			= { "oscclk",
						    "dout_cmu_peric2_ip1" };
PNAME(mout_peric2_noc_user_p)			= { "oscclk",
						    "dout_cmu_peric2_noc" };
PNAME(mout_peric2_i2c_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_spi_ms_ctrl_p)		= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_uart_dbg_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi00_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi00_spi_i2c_p)		= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi01_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi01_spi_i2c_p)		= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi02_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi03_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi05_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi06_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };
PNAME(mout_peric2_usi11_p)			= { "oscclk",
						    "mout_peric2_ip0_user",
						    "mout_peric2_ip1_user",
						    "oscclk" };

static const struct samsung_mux_clock peric2_mux_clks[] __initconst = {
	MUX(CLK_MOUT_PERIC2_IP0_USER, "mout_peric2_ip0_user",
	    mout_peric2_ip0_user_p, PLL_CON0_MUX_CLKCMU_PERIC2_IP0_USER, 4, 1),
	MUX(CLK_MOUT_PERIC2_IP1_USER, "mout_peric2_ip1_user",
	    mout_peric2_ip1_user_p, PLL_CON0_MUX_CLKCMU_PERIC2_IP1_USER, 4, 1),
	MUX(CLK_MOUT_PERIC2_NOC_USER, "mout_peric2_noc_user",
	    mout_peric2_noc_user_p, PLL_CON0_MUX_CLKCMU_PERIC2_NOC_USER, 4, 1),
	MUX(CLK_MOUT_PERIC2_I2C, "mout_peric2_i2c", mout_peric2_i2c_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_I2C, 0, 2),
	MUX(CLK_MOUT_PERIC2_SPI_MS_CTRL, "mout_peric2_spi_ms_ctrl",
	    mout_peric2_spi_ms_ctrl_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_SPI_MS_CTRL, 0, 2),
	MUX(CLK_MOUT_PERIC2_UART_DBG, "mout_peric2_uart_dbg",
	    mout_peric2_uart_dbg_p, CLK_CON_MUX_MUX_CLK_PERIC2_UART_DBG, 0, 2),
	MUX(CLK_MOUT_PERIC2_USI00, "mout_peric2_usi00", mout_peric2_usi00_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_USI00, 0, 2),
	MUX(CLK_MOUT_PERIC2_USI00_SPI_I2C, "mout_peric2_usi00_spi_i2c",
	    mout_peric2_usi00_spi_i2c_p, CLK_CON_MUX_MUX_CLK_PERIC2_USI00_SPI_I2C,
	    0, 2),
	MUX(CLK_MOUT_PERIC2_USI01, "mout_peric2_usi01", mout_peric2_usi01_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_USI01, 0, 2),
	MUX(CLK_MOUT_PERIC2_USI01_SPI_I2C, "mout_peric2_usi01_spi_i2c",
	    mout_peric2_usi01_spi_i2c_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_USI01_SPI_I2C, 0, 2),
	MUX(CLK_MOUT_PERIC2_USI02, "mout_peric2_usi02", mout_peric2_usi02_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_USI02, 0, 2),
	MUX(CLK_MOUT_PERIC2_USI03, "mout_peric2_usi03", mout_peric2_usi03_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_USI03, 0, 2),
	MUX(CLK_MOUT_PERIC2_USI05, "mout_peric2_usi05", mout_peric2_usi05_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_USI05, 0, 2),
	MUX(CLK_MOUT_PERIC2_USI06, "mout_peric2_usi06", mout_peric2_usi06_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_USI06, 0, 2),
	MUX(CLK_MOUT_PERIC2_USI11, "mout_peric2_usi11", mout_peric2_usi11_p,
	    CLK_CON_MUX_MUX_CLK_PERIC2_USI11, 0, 2),
};

static const struct samsung_div_clock peric2_div_clks[] __initconst = {
	DIV(CLK_DOUT_PERIC2_I2C, "dout_peric2_i2c", "mout_peric2_i2c",
	    CLK_CON_DIV_DIV_CLK_PERIC2_I2C, 0, 4),
	DIV(CLK_DOUT_PERIC2_SPI_MS_CTRL, "dout_peric2_spi_ms_ctrl",
	    "mout_peric2_spi_ms_ctrl", CLK_CON_DIV_DIV_CLK_PERIC2_SPI_MS_CTRL,
	    0, 7),
	DIV(CLK_DOUT_PERIC2_UART_DBG, "dout_peric2_uart_dbg",
	    "mout_peric2_uart_dbg", CLK_CON_DIV_DIV_CLK_PERIC2_UART_DBG, 0, 4),
	DIV(CLK_DOUT_PERIC2_USI00, "dout_peric2_usi00", "mout_peric2_usi00",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI00, 0, 7),
	DIV(CLK_DOUT_PERIC2_USI00_SPI_I2C, "dout_peric2_usi00_spi_i2c",
	    "mout_peric2_usi00_spi_i2c",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI00_SPI_I2C, 0, 4),
	DIV(CLK_DOUT_PERIC2_USI01, "dout_peric2_usi01", "mout_peric2_usi01",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI01, 0, 7),
	DIV(CLK_DOUT_PERIC2_USI01_SPI_I2C, "dout_peric2_usi01_spi_i2c",
	    "mout_peric2_usi01_spi_i2c",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI01_SPI_I2C, 0, 4),
	DIV(CLK_DOUT_PERIC2_USI02, "dout_peric2_usi02", "mout_peric2_usi02",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI02, 0, 7),
	DIV(CLK_DOUT_PERIC2_USI03, "dout_peric2_usi03", "mout_peric2_usi03",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI03, 0, 7),
	DIV(CLK_DOUT_PERIC2_USI05, "dout_peric2_usi05", "mout_peric2_usi05",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI05, 0, 7),
	DIV(CLK_DOUT_PERIC2_USI06, "dout_peric2_usi06", "mout_peric2_usi06",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI06, 0, 7),
	DIV(CLK_DOUT_PERIC2_USI11, "dout_peric2_usi11", "mout_peric2_usi11",
	    CLK_CON_DIV_DIV_CLK_PERIC2_USI11, 0, 7),
};

static const struct samsung_cmu_info peric2_cmu_info __initconst = {
	.mux_clks		= peric2_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(peric2_mux_clks),
	.div_clks		= peric2_div_clks,
	.nr_div_clks		= ARRAY_SIZE(peric2_div_clks),
	.nr_clk_ids		= CLKS_NR_PERIC2,
	.clk_regs		= peric2_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(peric2_clk_regs),
	.clk_name		= "noc",
};

/* ---- CMU_UFS ------------------------------------------------------------ */

/* Register Offset definitions for CMU_UFS(0x11000000) */
#define PLL_CON0_MUX_CLKCMU_UFS_MMC_CARD_USER						0x600
#define PLL_CON1_MUX_CLKCMU_UFS_MMC_CARD_USER						0x604
#define PLL_CON0_MUX_CLKCMU_UFS_NOC_USER						0x610
#define PLL_CON1_MUX_CLKCMU_UFS_NOC_USER						0x614
#define PLL_CON0_MUX_CLKCMU_UFS_UFS_EMBD_USER						0x620
#define PLL_CON1_MUX_CLKCMU_UFS_UFS_EMBD_USER						0x624
#define CLK_CON_GAT_CLK_BLK_UFS_UID_BLK_UFS_FRC_OTP_DESERIAL_IPCLKPORT_I_CLK		0x2000
#define CLK_CON_GAT_CLK_BLK_UFS_UID_D_TZPC_UFS_IPCLKPORT_PCLK				0x2004
#define CLK_CON_GAT_CLK_BLK_UFS_UID_GPIO_HSI1UFS_IPCLKPORT_PCLK				0x2008
#define CLK_CON_GAT_CLK_BLK_UFS_UID_GPIO_UFS_IPCLKPORT_PCLK				0x200c
#define CLK_CON_GAT_CLK_BLK_UFS_UID_LH_ACEL_SI_D_UFS_IPCLKPORT_I_CLK			0x2010
#define CLK_CON_GAT_CLK_BLK_UFS_UID_MMC_CARD_IPCLKPORT_I_ACLK				0x2014
#define CLK_CON_GAT_CLK_BLK_UFS_UID_MMC_CARD_IPCLKPORT_SDCLKIN				0x2018
#define CLK_CON_GAT_CLK_BLK_UFS_UID_OTP_DESERIAL_UFS_EMBD_FMP_IPCLKPORT_I_CLK		0x201c
#define CLK_CON_GAT_CLK_BLK_UFS_UID_PPMU_UFS_IPCLKPORT_ACLK				0x2024
#define CLK_CON_GAT_CLK_BLK_UFS_UID_PPMU_UFS_IPCLKPORT_PCLK				0x2028
#define CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_CLK_UFS_FREE_OSCCLK_IPCLKPORT_CLK		0x202c
#define CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_CLK_UFS_MMC_CARD_IPCLKPORT_CLK		0x2030
#define CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_CLK_UFS_NOC_IPCLKPORT_CLK			0x2034
#define CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_CLK_UFS_UFS_EMBD_IPCLKPORT_CLK		0x2038
#define CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_SR_CLK_UFS_FREE_OSCCLK_IPCLKPORT_CLK	0x203c
#define CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_SR_CLK_UFS_NOC_IPCLKPORT_CLK		0x2040
#define CLK_CON_GAT_CLK_BLK_UFS_UID_SLH_AST_SI_G_PPMU_UFS_IPCLKPORT_I_CLK		0x2044
#define CLK_CON_GAT_CLK_BLK_UFS_UID_SLH_AXI_MI_P_UFS_IPCLKPORT_I_CLK			0x2048
#define CLK_CON_GAT_CLK_BLK_UFS_UID_SPC_UFS_IPCLKPORT_PCLK				0x204c
#define CLK_CON_GAT_CLK_BLK_UFS_UID_SYSMMU_UFS_IPCLKPORT_CLK_S2				0x2050
#define CLK_CON_GAT_CLK_BLK_UFS_UID_SYSREG_UFS_IPCLKPORT_PCLK				0x2054
#define CLK_CON_GAT_CLK_BLK_UFS_UID_UFS_CMU_UFS_IPCLKPORT_PCLK				0x2058
#define CLK_CON_GAT_CLK_BLK_UFS_UID_UFS_EMBD_IPCLKPORT_I_ACLK				0x205c
#define CLK_CON_GAT_CLK_BLK_UFS_UID_UFS_EMBD_IPCLKPORT_I_CLK_UNIPRO			0x2060
#define CLK_CON_GAT_CLK_BLK_UFS_UID_UFS_EMBD_IPCLKPORT_I_FMP_CLK			0x2064
#define CLK_CON_GAT_CLK_BLK_UFS_UID_VGEN_LITE_UFS_IPCLKPORT_CLK				0x2068
#define CLK_CON_GAT_CLK_BLK_UFS_UID_XIU_D_UFS_IPCLKPORT_ACLK				0x206c
#define CLK_CON_GAT_CLK_BLK_UFS_UID_XIU_P_UFS_IPCLKPORT_ACLK				0x2070

static const unsigned long ufs_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKCMU_UFS_MMC_CARD_USER,
	PLL_CON1_MUX_CLKCMU_UFS_MMC_CARD_USER,
	PLL_CON0_MUX_CLKCMU_UFS_NOC_USER,
	PLL_CON1_MUX_CLKCMU_UFS_NOC_USER,
	PLL_CON0_MUX_CLKCMU_UFS_UFS_EMBD_USER,
	PLL_CON1_MUX_CLKCMU_UFS_UFS_EMBD_USER,
	CLK_CON_GAT_CLK_BLK_UFS_UID_BLK_UFS_FRC_OTP_DESERIAL_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_D_TZPC_UFS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_GPIO_HSI1UFS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_GPIO_UFS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_LH_ACEL_SI_D_UFS_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_MMC_CARD_IPCLKPORT_I_ACLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_MMC_CARD_IPCLKPORT_SDCLKIN,
	CLK_CON_GAT_CLK_BLK_UFS_UID_OTP_DESERIAL_UFS_EMBD_FMP_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_PPMU_UFS_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_PPMU_UFS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_CLK_UFS_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_CLK_UFS_MMC_CARD_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_CLK_UFS_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_CLK_UFS_UFS_EMBD_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_SR_CLK_UFS_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_RSTNSYNC_SR_CLK_UFS_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_SLH_AST_SI_G_PPMU_UFS_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_SLH_AXI_MI_P_UFS_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_SPC_UFS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_SYSMMU_UFS_IPCLKPORT_CLK_S2,
	CLK_CON_GAT_CLK_BLK_UFS_UID_SYSREG_UFS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_UFS_CMU_UFS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_UFS_EMBD_IPCLKPORT_I_ACLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_UFS_EMBD_IPCLKPORT_I_CLK_UNIPRO,
	CLK_CON_GAT_CLK_BLK_UFS_UID_UFS_EMBD_IPCLKPORT_I_FMP_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_VGEN_LITE_UFS_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_XIU_D_UFS_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_UFS_UID_XIU_P_UFS_IPCLKPORT_ACLK,
};

PNAME(mout_clkcmu_ufs_mmc_card_user_p)	= { "oscclk",
					    "mout_cmu_ufs_mmc_card" };
PNAME(mout_clkcmu_ufs_noc_user_p)	= { "oscclk", "dout_cmu_ufs_noc" };
PNAME(mout_clkcmu_ufs_ufs_embd_user_p)	= { "oscclk",
					    "dout_cmu_ufs_ufs_embd" };

static const struct samsung_mux_clock ufs_mux_clks[] __initconst = {
	MUX(CLK_MOUT_UFS_MMC_CARD_USER, "mout_ufs_mmc_card_user",
	    mout_clkcmu_ufs_mmc_card_user_p,
	    PLL_CON0_MUX_CLKCMU_UFS_MMC_CARD_USER, 4, 1),
	MUX(CLK_MOUT_UFS_NOC_USER, "mout_ufs_noc_user",
	    mout_clkcmu_ufs_noc_user_p,
	    PLL_CON0_MUX_CLKCMU_UFS_NOC_USER, 4, 1),
	MUX(CLK_MOUT_UFS_UFS_EMBD_USER, "mout_ufs_ufs_embd_user",
	    mout_clkcmu_ufs_ufs_embd_user_p,
	    PLL_CON0_MUX_CLKCMU_UFS_UFS_EMBD_USER, 4, 1),
};

static const struct samsung_cmu_info ufs_cmu_info __initconst = {
	.mux_clks		= ufs_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(ufs_mux_clks),
	.nr_clk_ids		= CLKS_NR_UFS,
	.clk_regs		= ufs_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(ufs_clk_regs),
	.clk_name		= "noc",
};

/* ---- CMU_VTS ------------------------------------------------------------ */

/* Register Offset definitions for CMU_VTS (0x15300000) */
#define PLL_CON0_MUX_CLKALIVE_VTS_NOC_USER						0x600
#define PLL_CON1_MUX_CLKALIVE_VTS_NOC_USER						0x604
#define PLL_CON0_MUX_CLKALIVE_VTS_RCO_USER						0x610
#define PLL_CON1_MUX_CLKALIVE_VTS_RCO_USER						0x614
#define PLL_CON0_MUX_CLKCMU_VTS_DMIC_USER						0x620
#define PLL_CON1_MUX_CLKCMU_VTS_DMIC_USER						0x624
#define CLK_CON_MUX_MUX_CLKVTS_AUD_DMIC1						0x1000
#define CLK_CON_MUX_MUX_CLK_VTS_NOC							0x1004
#define CLK_CON_MUX_MUX_CLK_VTS_DMIC_PAD						0x100c
#define CLK_CON_DIV_DIV_CLKVTS_AUD_DMIC0						0x1800
#define CLK_CON_DIV_DIV_CLKVTS_AUD_DMIC1						0x1804
#define CLK_CON_DIV_DIV_CLK_VTS_CPU							0x1808
#define CLK_CON_DIV_DIV_CLK_VTS_DMIC_IF							0x1814
#define CLK_CON_DIV_DIV_CLK_VTS_DMIC_IF_DIV2						0x1818
#define CLK_CON_DIV_DIV_CLK_VTS_NOC							0x181c
#define CLK_CON_DIV_DIV_CLK_VTS_SERIAL_LIF						0x1820
#define CLK_CON_DIV_DIV_CLK_VTS_SERIAL_LIF_CORE						0x1824
#define CLK_CON_GAT_CLKVTS_AUD_DMIC0							0x2000
#define CLK_CON_GAT_CLKVTS_AUD_DMIC1							0x2004
#define CLK_CON_GAT_CLK_BLK_VTS_UID_BAAW_VTS_IPCLKPORT_I_PCLK				0x2008
#define CLK_CON_GAT_CLK_BLK_VTS_UID_LH_AXI_MI_IP_VC2VTS_IPCLKPORT_I_CLK			0x200c
#define CLK_CON_GAT_CLK_BLK_VTS_UID_LH_AXI_SI_ID_VTS2VC_IPCLKPORT_I_CLK			0x2010
#define CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_CLK_VTS_FREE_OSCCLK_IPCLKPORT_CLK		0x2014
#define CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_DMIC_IF_IPCLKPORT_CLK		0x2018
#define CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_SERIAL_LIF_CORE_IPCLKPORT_CLK	0x2020
#define CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_SERIAL_LIF_IPCLKPORT_CLK	0x2024
#define CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_YAMIN_IPCLKPORT_CLK		0x2028
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SERIAL_LIF_VT_IPCLKPORT_ACLK			0x202c
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_FRC_OTP_DESERIAL_IPCLKPORT_I_CLK		0x2030
#define CLK_CON_GAT_CLK_BLK_VTS_UID_ASYNCINTERRUPT_VTS_IPCLKPORT_CLK			0x2034
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF0_IPCLKPORT_DMIC_IF_CLK			0x2068
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF0_IPCLKPORT_DMIC_IF_DIV2_CLK			0x206c
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF0_IPCLKPORT_PCLK				0x2070
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF1_IPCLKPORT_DMIC_IF_CLK			0x2074
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF1_IPCLKPORT_DMIC_IF_DIV2_CLK			0x2078
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF1_IPCLKPORT_PCLK				0x207c
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF2_IPCLKPORT_DMIC_IF_CLK			0x2080
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF2_IPCLKPORT_DMIC_IF_DIV2_CLK			0x2084
#define CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF2_IPCLKPORT_PCLK				0x2088
#define CLK_CON_GAT_CLK_BLK_VTS_UID_GPIO_VTS_IPCLKPORT_PCLK				0x2090
#define CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_CODE_IPCLKPORT_I_ACLK			0x20ac
#define CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_CODE_IPCLKPORT_I_PCLK			0x20b0
#define CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_DATA0_IPCLKPORT_I_ACLK			0x20b4
#define CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_DATA0_IPCLKPORT_I_PCLK			0x20b8
#define CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_DATA1_IPCLKPORT_I_ACLK			0x20bc
#define CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_DATA1_IPCLKPORT_I_PCLK			0x20c0
#define CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_PCM_IPCLKPORT_I_ACLK				0x20c4
#define CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_PCM_IPCLKPORT_I_PCLK				0x20c8
#define CLK_CON_GAT_CLK_BLK_VTS_UID_MAILBOX_ABOX_VTS_IPCLKPORT_PCLK			0x20cc
#define CLK_CON_GAT_CLK_BLK_VTS_UID_MAILBOX_AP_VTS_IPCLKPORT_PCLK			0x20d0
#define CLK_CON_GAT_CLK_BLK_VTS_UID_MAILBOX_DNC_VTS_IPCLKPORT_PCLK			0x20d4
#define CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_CLK_VTS_NOC_IPCLKPORT_CLK			0x20ec
#define CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_CLK_VTS_YAMIN_IPCLKPORT_CLK		0x20f8
#define CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_NOC_IPCLKPORT_CLK		0x20fc
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SERIAL_LIF_VT_IPCLKPORT_BCLK			0x2104
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SERIAL_LIF_VT_IPCLKPORT_CCLK			0x2108
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SERIAL_LIF_VT_IPCLKPORT_PCLK			0x210c
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_ACLK_CPU			0x2124
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_DMIC_AUD_DIV2_CLK		0x2128
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_DMIC_IF_PAD_CLK0		0x212c
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_DMIC_IF_PAD_CLK1		0x2130
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_DMIC_IF_PAD_CLK2		0x2134
#define CLK_CON_GAT_CLK_BLK_VTS_UID_SYSREG_VTS_IPCLKPORT_PCLK				0x213c
#define CLK_CON_GAT_CLK_BLK_VTS_UID_TIMER1_IPCLKPORT_PCLK				0x2140
#define CLK_CON_GAT_CLK_BLK_VTS_UID_TIMER2_IPCLKPORT_PCLK				0x2144
#define CLK_CON_GAT_CLK_BLK_VTS_UID_TIMER_IPCLKPORT_PCLK				0x2148
#define CLK_CON_GAT_CLK_BLK_VTS_UID_VTS_CMU_VTS_IPCLKPORT_PCLK				0x2150
#define CLK_CON_GAT_CLK_BLK_VTS_UID_WDT_VTS_IPCLKPORT_PCLK				0x2154
#define CLK_CON_GAT_CLK_BLK_VTS_UID_XIU_DP0_VTS_IPCLKPORT_ACLK				0x2158
#define CLK_CON_GAT_CLK_BLK_VTS_UID_YAMIN_MCU_VTS_IPCLKPORT_CLKIN			0x215c
#define CLK_CON_GAT_CLK_BLK_VTS_UID_YAMIN_MCU_VTS_IPCLKPORT_DBGCLK			0x2160
#define CLK_CON_GAT_CLK_BLK_VTS_UID_YAMIN_MCU_VTS_IPCLKPORT_IWICCLK			0x2164

static const unsigned long vts_clk_regs[] __initconst = {
	PLL_CON0_MUX_CLKALIVE_VTS_NOC_USER,
	PLL_CON1_MUX_CLKALIVE_VTS_NOC_USER,
	PLL_CON0_MUX_CLKALIVE_VTS_RCO_USER,
	PLL_CON1_MUX_CLKALIVE_VTS_RCO_USER,
	PLL_CON0_MUX_CLKCMU_VTS_DMIC_USER,
	PLL_CON1_MUX_CLKCMU_VTS_DMIC_USER,
	CLK_CON_MUX_MUX_CLKVTS_AUD_DMIC1,
	CLK_CON_MUX_MUX_CLK_VTS_NOC,
	CLK_CON_MUX_MUX_CLK_VTS_DMIC_PAD,
	CLK_CON_DIV_DIV_CLKVTS_AUD_DMIC0,
	CLK_CON_DIV_DIV_CLKVTS_AUD_DMIC1,
	CLK_CON_DIV_DIV_CLK_VTS_CPU,
	CLK_CON_DIV_DIV_CLK_VTS_DMIC_IF,
	CLK_CON_DIV_DIV_CLK_VTS_DMIC_IF_DIV2,
	CLK_CON_DIV_DIV_CLK_VTS_NOC,
	CLK_CON_DIV_DIV_CLK_VTS_SERIAL_LIF,
	CLK_CON_DIV_DIV_CLK_VTS_SERIAL_LIF_CORE,
	CLK_CON_GAT_CLKVTS_AUD_DMIC0,
	CLK_CON_GAT_CLKVTS_AUD_DMIC1,
	CLK_CON_GAT_CLK_BLK_VTS_UID_BAAW_VTS_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_LH_AXI_MI_IP_VC2VTS_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_LH_AXI_SI_ID_VTS2VC_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_CLK_VTS_FREE_OSCCLK_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_DMIC_IF_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_SERIAL_LIF_CORE_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_SERIAL_LIF_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_YAMIN_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SERIAL_LIF_VT_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_FRC_OTP_DESERIAL_IPCLKPORT_I_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_ASYNCINTERRUPT_VTS_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF0_IPCLKPORT_DMIC_IF_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF0_IPCLKPORT_DMIC_IF_DIV2_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF0_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF1_IPCLKPORT_DMIC_IF_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF1_IPCLKPORT_DMIC_IF_DIV2_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF2_IPCLKPORT_DMIC_IF_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF2_IPCLKPORT_DMIC_IF_DIV2_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_DMIC_IF2_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_GPIO_VTS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_CODE_IPCLKPORT_I_ACLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_CODE_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_DATA0_IPCLKPORT_I_ACLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_DATA0_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_DATA1_IPCLKPORT_I_ACLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_DATA1_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_PCM_IPCLKPORT_I_ACLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_INTMEM_PCM_IPCLKPORT_I_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_MAILBOX_ABOX_VTS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_MAILBOX_AP_VTS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_MAILBOX_DNC_VTS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_CLK_VTS_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_CLK_VTS_YAMIN_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_RSTNSYNC_SR_CLK_VTS_NOC_IPCLKPORT_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SERIAL_LIF_VT_IPCLKPORT_BCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SERIAL_LIF_VT_IPCLKPORT_CCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SERIAL_LIF_VT_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_ACLK_CPU,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_DMIC_AUD_DIV2_CLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_DMIC_IF_PAD_CLK0,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_DMIC_IF_PAD_CLK1,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SS_VTS_GLUE_IPCLKPORT_DMIC_IF_PAD_CLK2,
	CLK_CON_GAT_CLK_BLK_VTS_UID_SYSREG_VTS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_TIMER1_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_TIMER2_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_TIMER_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_VTS_CMU_VTS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_WDT_VTS_IPCLKPORT_PCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_XIU_DP0_VTS_IPCLKPORT_ACLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_YAMIN_MCU_VTS_IPCLKPORT_CLKIN,
	CLK_CON_GAT_CLK_BLK_VTS_UID_YAMIN_MCU_VTS_IPCLKPORT_DBGCLK,
	CLK_CON_GAT_CLK_BLK_VTS_UID_YAMIN_MCU_VTS_IPCLKPORT_IWICCLK,
};

PNAME(mout_clkalive_vts_noc_user_p)	= { "oscclk" };
PNAME(mout_clkalive_vts_rco_user_p)	= { "oscclk" };
PNAME(mout_clkcmu_vts_dmic_user_p)	= { "oscclk", "dout_cmu_vts_dmic" };
PNAME(mout_clkvts_aud_dmic1_p)		= { "dout_clkvts_aud_dmic1",
					    "dout_clkvts_dmic_if_div2",
					    "dmic_clk0_in", "dmic_clk1_in",
					    "dmic_clk2_in", "oscclk", "oscclk",
					    "oscclk" };
PNAME(mout_clkvts_noc_p)		= { "mout_clkalive_vts_noc_user",
					    "mout_clkalive_vts_rco_user" };
PNAME(mout_clkvts_dmic_pad_p)		= { "mout_clkalive_vts_rco_user",
					    "mout_clkcmu_vts_dmic_user" };

static const struct samsung_mux_clock vts_mux_clks[] __initconst = {
	MUX(CLK_MOUT_CLKALIVE_VTS_NOC_USER, "mout_clkalive_vts_noc_user",
	    mout_clkalive_vts_noc_user_p, PLL_CON0_MUX_CLKALIVE_VTS_NOC_USER,
	    4, 1),
	MUX(CLK_MOUT_CLKALIVE_VTS_RCO_USER, "mout_clkalive_vts_rco_user",
	    mout_clkalive_vts_rco_user_p, PLL_CON0_MUX_CLKALIVE_VTS_RCO_USER,
	    4, 1),
	MUX(CLK_MOUT_CLKCMU_VTS_DMIC_USER, "mout_clkcmu_vts_dmic_user",
	    mout_clkcmu_vts_dmic_user_p, PLL_CON0_MUX_CLKCMU_VTS_DMIC_USER,
	    4, 1),
	MUX(CLK_MOUT_CLKVTS_AUD_DMIC1, "mout_clkvts_aud_dmic1",
	    mout_clkvts_aud_dmic1_p, CLK_CON_MUX_MUX_CLKVTS_AUD_DMIC1, 0, 3),
	MUX(CLK_MOUT_CLKVTS_NOC, "mout_clkvts_noc", mout_clkvts_noc_p,
	    CLK_CON_MUX_MUX_CLK_VTS_NOC, 0, 1),
	MUX(CLK_MOUT_CLKVTS_DMIC_PAD, "mout_clkvts_dmic_pad",
	    mout_clkvts_dmic_pad_p, CLK_CON_MUX_MUX_CLK_VTS_DMIC_PAD, 0, 1),
};

static const struct samsung_div_clock vts_div_clks[] __initconst = {
	DIV(CLK_DOUT_CLKVTS_AUD_DMIC0, "dout_clkvts_aud_dmic0",
	    "mout_clkvts_dmic_pad", CLK_CON_DIV_DIV_CLKVTS_AUD_DMIC0, 0, 5),
	DIV(CLK_DOUT_CLKVTS_AUD_DMIC1, "dout_clkvts_aud_dmic1",
	    "dout_clkvts_aud_dmic0", CLK_CON_DIV_DIV_CLKVTS_AUD_DMIC1, 0, 4),
	DIV(CLK_DOUT_CLKVTS_CPU, "dout_clkvts_cpu", "mout_clkvts_noc",
	    CLK_CON_DIV_DIV_CLK_VTS_CPU, 0, 3),
	DIV(CLK_DOUT_CLKVTS_DMIC_IF, "dout_clkvts_dmic_if",
	    "dout_clkvts_aud_dmic0", CLK_CON_DIV_DIV_CLK_VTS_DMIC_IF, 0, 7),
	DIV(CLK_DOUT_CLKVTS_DMIC_IF_DIV2, "dout_clkvts_dmic_if_div2",
	    "dout_clkvts_dmic_if", CLK_CON_DIV_DIV_CLK_VTS_DMIC_IF_DIV2, 0, 4),
	DIV(CLK_DOUT_CLKVTS_NOC, "dout_clkvts_noc", "dout_clkvts_cpu",
	    CLK_CON_DIV_DIV_CLK_VTS_NOC, 0, 3),
	DIV(CLK_DOUT_CLKVTS_SERIAL_LIF, "dout_clkvts_serial_lif",
	    "mout_clkalive_vts_rco_user", CLK_CON_DIV_DIV_CLK_VTS_SERIAL_LIF,
	    0, 7),
	DIV(CLK_DOUT_CLKVTS_SERIAL_LIF_CORE, "dout_clkvts_serial_lif_core",
	    "mout_clkalive_vts_rco_user",
	    CLK_CON_DIV_DIV_CLK_VTS_SERIAL_LIF_CORE, 0, 7),
};

static const struct samsung_fixed_rate_clock vts_fixed_clks[] __initconst = {
	FRATE(0, "dmic_clk0_in", NULL, 0, 100000000),
	FRATE(0, "dmic_clk1_in", NULL, 0, 100000000),
	FRATE(0, "dmic_clk2_in", NULL, 0, 100000000),
};

static const struct samsung_cmu_info vts_cmu_info __initconst = {
	.mux_clks		= vts_mux_clks,
	.nr_mux_clks		= ARRAY_SIZE(vts_mux_clks),
	.div_clks		= vts_div_clks,
	.nr_div_clks		= ARRAY_SIZE(vts_div_clks),
	.fixed_clks		= vts_fixed_clks,
	.nr_fixed_clks		= ARRAY_SIZE(vts_fixed_clks),
	.nr_clk_ids		= CLKS_NR_VTS,
	.clk_regs		= vts_clk_regs,
	.nr_clk_regs		= ARRAY_SIZE(vts_clk_regs),
	.clk_name		= "dmic",
};

static int __init exynos2200_cmu_probe(struct platform_device *pdev)
{
	const struct samsung_cmu_info *info;
	struct device *dev = &pdev->dev;

	info = of_device_get_match_data(dev);
	exynos_arm64_register_cmu(dev, dev->of_node, info);

	return 0;
}

static const struct of_device_id exynos2200_cmu_of_match[] = {
	{
		.compatible = "samsung,exynos2200-cmu-cmgp",
		.data = &cmgp_cmu_info,
	}, {
		.compatible = "samsung,exynos2200-cmu-hsi0",
		.data = &hsi0_cmu_info,
	}, {
		.compatible = "samsung,exynos2200-cmu-peric0",
		.data = &peric0_cmu_info,
	}, {
		.compatible = "samsung,exynos2200-cmu-peric1",
		.data = &peric1_cmu_info,
	}, {
		.compatible = "samsung,exynos2200-cmu-peric2",
		.data = &peric2_cmu_info,
	}, {
		.compatible = "samsung,exynos2200-cmu-ufs",
		.data = &ufs_cmu_info,
	}, {
		.compatible = "samsung,exynos2200-cmu-vts",
		.data = &vts_cmu_info,
	}, { }
};

static struct platform_driver exynos2200_cmu_driver __refdata = {
	.driver = {
		.name = "exynos2200-cmu",
		.of_match_table = exynos2200_cmu_of_match,
		.suppress_bind_attrs = true,
	},
	.probe = exynos2200_cmu_probe,
};

static int __init exynos2200_cmu_init(void)
{
	return platform_driver_register(&exynos2200_cmu_driver);
}
core_initcall(exynos2200_cmu_init);
