// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --filter "^define |^entry:" --version 2
// RUN: %clang_cc1 -triple riscv64 -emit-llvm %s -o - \
// RUN:   | FileCheck -check-prefixes=LP64-LP64F-LP64D,LP64-LP64F,LP64 %s
// RUN: %clang_cc1 -triple riscv64 -target-feature +f -target-abi lp64f -emit-llvm %s -o - \
// RUN:   | FileCheck -check-prefixes=LP64-LP64F-LP64D,LP64F-LP64D,LP64-LP64F,LP64F %s
// RUN: %clang_cc1 -triple riscv64 -target-feature +f -target-feature +d -target-abi lp64d -emit-llvm %s -o - \
// RUN:   | FileCheck -check-prefixes=LP64-LP64F-LP64D,LP64F-LP64D,LP64D %s
// RUN: %clang_cc1 -triple riscv64 -emit-llvm -target-abi lp64e %s -o - \
// RUN:     | FileCheck -check-prefixes=LP64-LP64F-LP64D,LP64-LP64F,LP64,LP64E %s

#include <stddef.h>
#include <stdint.h>

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_void
// LP64-LP64F-LP64D-SAME: () #[[ATTR0:[0-9]+]] {
// LP64-LP64F-LP64D:  entry:
//
void f_void(void) {}

// Scalar arguments and return values smaller than the word size are extended
// according to the sign of their type, up to 32 bits

// LP64-LP64F-LP64D-LABEL: define dso_local zeroext i1 @f_scalar_0
// LP64-LP64F-LP64D-SAME: (i1 noundef zeroext [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
_Bool f_scalar_0(_Bool x) { return x; }

// LP64-LP64F-LP64D-LABEL: define dso_local signext i8 @f_scalar_1
// LP64-LP64F-LP64D-SAME: (i8 noundef signext [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
int8_t f_scalar_1(int8_t x) { return x; }

// LP64-LP64F-LP64D-LABEL: define dso_local zeroext i8 @f_scalar_2
// LP64-LP64F-LP64D-SAME: (i8 noundef zeroext [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
uint8_t f_scalar_2(uint8_t x) { return x; }

// LP64-LP64F-LP64D-LABEL: define dso_local signext i32 @f_scalar_3
// LP64-LP64F-LP64D-SAME: (i32 noundef signext [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
uint32_t f_scalar_3(int32_t x) { return x; }

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_scalar_4
// LP64-LP64F-LP64D-SAME: (i64 noundef [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
int64_t f_scalar_4(int64_t x) { return x; }

// LP64-LP64F-LP64D-LABEL: define dso_local float @f_fp_scalar_1
// LP64-LP64F-LP64D-SAME: (float noundef [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
float f_fp_scalar_1(float x) { return x; }

// LP64-LP64F-LP64D-LABEL: define dso_local double @f_fp_scalar_2
// LP64-LP64F-LP64D-SAME: (double noundef [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
double f_fp_scalar_2(double x) { return x; }

// LP64-LP64F-LP64D-LABEL: define dso_local fp128 @f_fp_scalar_3
// LP64-LP64F-LP64D-SAME: (fp128 noundef [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
long double f_fp_scalar_3(long double x) { return x; }

// LP64-LP64F-LP64D-LABEL: define dso_local half @f_fp_scalar_4
// LP64-LP64F-LP64D-SAME: (half noundef [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
_Float16 f_fp_scalar_4(_Float16 x) { return x; }

// Empty structs or unions are ignored.

struct empty_s {};

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_agg_empty_struct
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct empty_s f_agg_empty_struct(struct empty_s x) {
  return x;
}

union empty_u {};

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_agg_empty_union
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
union empty_u f_agg_empty_union(union empty_u x) {
  return x;
}

// Aggregates <= 2*xlen may be passed in registers, so will be coerced to
// integer arguments. The rules for return are the same.

struct tiny {
  uint16_t a, b, c, d;
};

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_agg_tiny
// LP64-LP64F-LP64D-SAME: (i64 [[X_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_agg_tiny(struct tiny x) {
  x.a += x.b;
  x.c += x.d;
}

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_agg_tiny_ret
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct tiny f_agg_tiny_ret(void) {
  return (struct tiny){1, 2, 3, 4};
}

typedef uint16_t v4i16 __attribute__((vector_size(8)));
typedef int64_t v1i64 __attribute__((vector_size(8)));

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_vec_tiny_v4i16
// LP64-LP64F-LP64D-SAME: (i64 noundef [[X_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_vec_tiny_v4i16(v4i16 x) {
  x[0] = x[1];
  x[2] = x[3];
}

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_vec_tiny_v4i16_ret
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
v4i16 f_vec_tiny_v4i16_ret(void) {
  return (v4i16){1, 2, 3, 4};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_vec_tiny_v1i64
// LP64-LP64F-LP64D-SAME: (i64 noundef [[X_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_vec_tiny_v1i64(v1i64 x) {
  x[0] = 114;
}

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_vec_tiny_v1i64_ret
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
v1i64 f_vec_tiny_v1i64_ret(void) {
  return (v1i64){1};
}

struct small {
  int64_t a, *b;
};

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_agg_small
// LP64-LP64F-LP64D-SAME: ([2 x i64] [[X_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_agg_small(struct small x) {
  x.a += *x.b;
  x.b = &x.a;
}

// LP64-LP64F-LP64D-LABEL: define dso_local [2 x i64] @f_agg_small_ret
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct small f_agg_small_ret(void) {
  return (struct small){1, 0};
}

typedef uint16_t v8i16 __attribute__((vector_size(16)));
typedef __int128_t v1i128 __attribute__((vector_size(16)));

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_vec_small_v8i16
// LP64-LP64F-LP64D-SAME: (i128 noundef [[X_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_vec_small_v8i16(v8i16 x) {
  x[0] = x[7];
}

// LP64-LP64F-LP64D-LABEL: define dso_local i128 @f_vec_small_v8i16_ret
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
v8i16 f_vec_small_v8i16_ret(void) {
  return (v8i16){1, 2, 3, 4, 5, 6, 7, 8};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_vec_small_v1i128
// LP64-LP64F-LP64D-SAME: (i128 noundef [[X_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_vec_small_v1i128(v1i128 x) {
  x[0] = 114;
}

// LP64-LP64F-LP64D-LABEL: define dso_local i128 @f_vec_small_v1i128_ret
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
v1i128 f_vec_small_v1i128_ret(void) {
  return (v1i128){1};
}

// Aggregates of 2*xlen size and 2*xlen alignment should be coerced to a
// single 2*xlen-sized argument, to ensure that alignment can be maintained if
// passed on the stack.

struct small_aligned {
  __int128_t a;
};

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_agg_small_aligned
// LP64-LP64F-LP64D-SAME: (i128 [[X_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_agg_small_aligned(struct small_aligned x) {
  x.a += x.a;
}

// LP64-LP64F-LP64D-LABEL: define dso_local i128 @f_agg_small_aligned_ret
// LP64-LP64F-LP64D-SAME: (i128 [[X_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct small_aligned f_agg_small_aligned_ret(struct small_aligned x) {
  return (struct small_aligned){10};
}

// Aggregates greater > 2*xlen will be passed and returned indirectly
struct large {
  int64_t a, b, c, d;
};

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_agg_large
// LP64-LP64F-LP64D-SAME: (ptr noundef dead_on_return [[X:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_agg_large(struct large x) {
  x.a = x.b + x.c + x.d;
}

// The address where the struct should be written to will be the first
// argument
// LP64-LP64F-LP64D-LABEL: define dso_local void @f_agg_large_ret
// LP64-LP64F-LP64D-SAME: (ptr dead_on_unwind noalias writable sret([[STRUCT_LARGE:%.*]]) align 8 [[AGG_RESULT:%.*]], i32 noundef signext [[I:%.*]], i8 noundef signext [[J:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct large f_agg_large_ret(int32_t i, int8_t j) {
  return (struct large){1, 2, 3, 4};
}

typedef unsigned char v32i8 __attribute__((vector_size(32)));

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_vec_large_v32i8
// LP64-LP64F-LP64D-SAME: (ptr noundef dead_on_return [[TMP0:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_vec_large_v32i8(v32i8 x) {
  x[0] = x[7];
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_vec_large_v32i8_ret
// LP64-LP64F-LP64D-SAME: (ptr dead_on_unwind noalias writable sret(<32 x i8>) align 32 [[AGG_RESULT:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
v32i8 f_vec_large_v32i8_ret(void) {
  return (v32i8){1, 2, 3, 4, 5, 6, 7, 8};
}

// Scalars passed on the stack should have signext/zeroext attributes, just as
// if they were passed in registers.

// LP64-LP64F-LP64D-LABEL: define dso_local signext i32 @f_scalar_stack_1
// LP64-LP64F-LP64D-SAME: (i64 [[A_COERCE:%.*]], [2 x i64] [[B_COERCE:%.*]], i128 [[C_COERCE:%.*]], ptr noundef dead_on_return [[D:%.*]], i8 noundef zeroext [[E:%.*]], i8 noundef signext [[F:%.*]], i8 noundef zeroext [[G:%.*]], i8 noundef signext [[H:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
int f_scalar_stack_1(struct tiny a, struct small b, struct small_aligned c,
                     struct large d, uint8_t e, int8_t f, uint8_t g, int8_t h) {
  return g + h;
}

// LP64-LP64F-LP64D-LABEL: define dso_local signext i32 @f_scalar_stack_2
// LP64-LP64F-LP64D-SAME: (i32 noundef signext [[A:%.*]], i128 noundef [[B:%.*]], i64 noundef [[C:%.*]], fp128 noundef [[D:%.*]], ptr noundef dead_on_return [[TMP0:%.*]], i8 noundef zeroext [[F:%.*]], i8 noundef signext [[G:%.*]], i8 noundef zeroext [[H:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
int f_scalar_stack_2(int32_t a, __int128_t b, int64_t c, long double d, v32i8 e,
                     uint8_t f, int8_t g, uint8_t h) {
  return g + h;
}

// LP64-LP64F-LP64D-LABEL: define dso_local signext i32 @f_scalar_stack_3
// LP64-LP64F-LP64D-SAME: (i32 noundef signext [[A:%.*]], i128 noundef [[B:%.*]], double noundef [[C:%.*]], fp128 noundef [[D:%.*]], ptr noundef dead_on_return [[TMP0:%.*]], i8 noundef zeroext [[F:%.*]], i8 noundef signext [[G:%.*]], i8 noundef zeroext [[H:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
int f_scalar_stack_3(int32_t a, __int128_t b, double c, long double d, v32i8 e,
                     uint8_t f, int8_t g, uint8_t h) {
  return g + h;
}

// Ensure that scalars passed on the stack are still determined correctly in
// the presence of large return values that consume a register due to the need
// to pass a pointer.

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_scalar_stack_4
// LP64-LP64F-LP64D-SAME: (ptr dead_on_unwind noalias writable sret([[STRUCT_LARGE:%.*]]) align 8 [[AGG_RESULT:%.*]], i32 noundef signext [[A:%.*]], i128 noundef [[B:%.*]], fp128 noundef [[C:%.*]], ptr noundef dead_on_return [[TMP0:%.*]], i8 noundef zeroext [[E:%.*]], i8 noundef signext [[F:%.*]], i8 noundef zeroext [[G:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct large f_scalar_stack_4(uint32_t a, __int128_t b, long double c, v32i8 d,
                              uint8_t e, int8_t f, uint8_t g) {
  return (struct large){a, e, f, g};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_scalar_stack_5
// LP64-LP64F-LP64D-SAME: (ptr dead_on_unwind noalias writable sret([[STRUCT_LARGE:%.*]]) align 8 [[AGG_RESULT:%.*]], double noundef [[A:%.*]], i128 noundef [[B:%.*]], fp128 noundef [[C:%.*]], ptr noundef dead_on_return [[TMP0:%.*]], i8 noundef zeroext [[E:%.*]], i8 noundef signext [[F:%.*]], i8 noundef zeroext [[G:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct large f_scalar_stack_5(double a, __int128_t b, long double c, v32i8 d,
                              uint8_t e, int8_t f, uint8_t g) {
  return (struct large){a, e, f, g};
}

// LP64-LP64F-LP64D-LABEL: define dso_local signext i32 @f_scalar_stack_6
// LP64-LP64F-LP64D-SAME: (i32 noundef signext [[A:%.*]], i128 noundef [[B:%.*]], float noundef [[C:%.*]], fp128 noundef [[D:%.*]], ptr noundef dead_on_return [[TMP0:%.*]], i8 noundef zeroext [[F:%.*]], i8 noundef signext [[G:%.*]], i8 noundef zeroext [[H:%.*]], half noundef [[I:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
int f_scalar_stack_6(int32_t a, __int128_t b, float c, long double d, v32i8 e,
                     uint8_t f, int8_t g, uint8_t h, _Float16 i) {
  return g + h;
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_fpr_tracking
// LP64-LP64F-LP64D-SAME: (float noundef [[A:%.*]], float noundef [[B:%.*]], float noundef [[C:%.*]], float noundef [[D:%.*]], float noundef [[E:%.*]], float noundef [[F:%.*]], float noundef [[G:%.*]], float noundef [[H:%.*]], i8 noundef zeroext [[I:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_fpr_tracking(float a, float b, float c, float d, float e, float f,
                    float g, float h, uint8_t i) {}

// Check that fp, fp+fp, and int+fp structs are lowered correctly. These will
// be passed in FPR, FPR+FPR, or GPR+FPR regs if sufficient registers are
// available the widths are <= XLEN and FLEN, and should be expanded to
// separate arguments in IR. They are passed by the same rules for returns,
// but will be lowered to simple two-element structs if necessary (as LLVM IR
// functions cannot return multiple values).

// A struct containing just one floating-point real is passed as though it
// were a standalone floating-point real.

struct float_s { float f; };

// LP64-LABEL: define dso_local void @f_float_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float_s_arg(struct float_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local float @f_ret_float_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float_s f_ret_float_s(void) {
  return (struct float_s){1.0};
}

// A struct containing a float and any number of zero-width bitfields is
// passed as though it were a standalone floating-point real.

struct zbf_float_s { int : 0; float f; };
struct zbf_float_zbf_s { int : 0; float f; int : 0; };

// LP64-LABEL: define dso_local void @f_zbf_float_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_zbf_float_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_zbf_float_s_arg(struct zbf_float_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_zbf_float_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local float @f_ret_zbf_float_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct zbf_float_s f_ret_zbf_float_s(void) {
  return (struct zbf_float_s){1.0};
}

// LP64-LABEL: define dso_local void @f_zbf_float_zbf_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_zbf_float_zbf_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_zbf_float_zbf_s_arg(struct zbf_float_zbf_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_zbf_float_zbf_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local float @f_ret_zbf_float_zbf_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct zbf_float_zbf_s f_ret_zbf_float_zbf_s(void) {
  return (struct zbf_float_zbf_s){1.0};
}

// Check that structs containing two float values (FLEN <= width) are expanded
// provided sufficient FPRs are available.

struct float_float_s { float f; float g; };

// LP64-LABEL: define dso_local void @f_float_float_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float_float_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], float [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float_float_s_arg(struct float_float_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float_float_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, float } @f_ret_float_float_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float_float_s f_ret_float_float_s(void) {
  return (struct float_float_s){1.0, 2.0};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_float_float_s_arg_insufficient_fprs
// LP64-LP64F-LP64D-SAME: (float noundef [[A:%.*]], float noundef [[B:%.*]], float noundef [[C:%.*]], float noundef [[D:%.*]], float noundef [[E:%.*]], float noundef [[F:%.*]], float noundef [[G:%.*]], i64 [[H_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_float_float_s_arg_insufficient_fprs(float a, float b, float c, float d,
    float e, float f, float g, struct float_float_s h) {}

// Check that structs containing int+float values are expanded, provided
// sufficient FPRs and GPRs are available. The integer components are neither
// sign or zero-extended.

struct float_int8_s { float f; int8_t i; };
struct float_uint8_s { float f; uint8_t i; };
struct float_int32_s { float f; int32_t i; };
struct float_int64_s { float f; int64_t i; };
struct float_int128bf_s { float f; __int128_t i : 64; };
struct float_int8_zbf_s { float f; int8_t i; int : 0; };

// LP64-LABEL: define dso_local void @f_float_int8_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float_int8_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float_int8_s_arg(struct float_int8_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float_int8_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, i8 } @f_ret_float_int8_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float_int8_s f_ret_float_int8_s(void) {
  return (struct float_int8_s){1.0, 2};
}

// LP64-LABEL: define dso_local void @f_float_uint8_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float_uint8_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float_uint8_s_arg(struct float_uint8_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float_uint8_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, i8 } @f_ret_float_uint8_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float_uint8_s f_ret_float_uint8_s(void) {
  return (struct float_uint8_s){1.0, 2};
}

// LP64-LABEL: define dso_local void @f_float_int32_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float_int32_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float_int32_s_arg(struct float_int32_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float_int32_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, i32 } @f_ret_float_int32_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float_int32_s f_ret_float_int32_s(void) {
  return (struct float_int32_s){1.0, 2};
}

// LP64-LABEL: define dso_local void @f_float_int64_s_arg
// LP64-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float_int64_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], i64 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float_int64_s_arg(struct float_int64_s a) {}

// LP64-LABEL: define dso_local [2 x i64] @f_ret_float_int64_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, i64 } @f_ret_float_int64_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float_int64_s f_ret_float_int64_s(void) {
  return (struct float_int64_s){1.0, 2};
}

// LP64-LABEL: define dso_local void @f_float_int128bf_s_arg
// LP64-SAME: (i128 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float_int128bf_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], i64 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float_int128bf_s_arg(struct float_int128bf_s a) {}

// LP64-LABEL: define dso_local i128 @f_ret_float_int128bf_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local <{ float, i64 }> @f_ret_float_int128bf_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float_int128bf_s f_ret_float_int128bf_s(void) {
  return (struct float_int128bf_s){1.0, 2};
}

// The zero-width bitfield means the struct can't be passed according to the
// floating point calling convention.

// LP64-LABEL: define dso_local void @f_float_int8_zbf_s
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float_int8_zbf_s
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float_int8_zbf_s(struct float_int8_zbf_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float_int8_zbf_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, i8 } @f_ret_float_int8_zbf_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float_int8_zbf_s f_ret_float_int8_zbf_s(void) {
  return (struct float_int8_zbf_s){1.0, 2};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_float_int8_s_arg_insufficient_gprs
// LP64-LP64F-LP64D-SAME: (i32 noundef signext [[A:%.*]], i32 noundef signext [[B:%.*]], i32 noundef signext [[C:%.*]], i32 noundef signext [[D:%.*]], i32 noundef signext [[E:%.*]], i32 noundef signext [[F:%.*]], i32 noundef signext [[G:%.*]], i32 noundef signext [[H:%.*]], i64 [[I_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_float_int8_s_arg_insufficient_gprs(int a, int b, int c, int d, int e,
                                          int f, int g, int h, struct float_int8_s i) {}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_struct_float_int8_insufficient_fprs
// LP64-LP64F-LP64D-SAME: (float noundef [[A:%.*]], float noundef [[B:%.*]], float noundef [[C:%.*]], float noundef [[D:%.*]], float noundef [[E:%.*]], float noundef [[F:%.*]], float noundef [[G:%.*]], float noundef [[H:%.*]], i64 [[I_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_struct_float_int8_insufficient_fprs(float a, float b, float c, float d,
                                           float e, float f, float g, float h, struct float_int8_s i) {}

// Complex floating-point values or structs containing a single complex
// floating-point value should be passed as if it were an fp+fp struct.

// LP64-LABEL: define dso_local void @f_floatcomplex
// LP64-SAME: (i64 noundef [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatcomplex
// LP64F-LP64D-SAME: (float noundef [[A_COERCE0:%.*]], float noundef [[A_COERCE1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatcomplex(float __complex__ a) {}

// LP64-LABEL: define dso_local i64 @f_ret_floatcomplex
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, float } @f_ret_floatcomplex
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
float __complex__ f_ret_floatcomplex(void) {
  return 1.0;
}

struct floatcomplex_s { float __complex__ c; };

// LP64-LABEL: define dso_local void @f_floatcomplex_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatcomplex_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], float [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatcomplex_s_arg(struct floatcomplex_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_floatcomplex_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, float } @f_ret_floatcomplex_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct floatcomplex_s f_ret_floatcomplex_s(void) {
  return (struct floatcomplex_s){1.0};
}

// Complex floating-point values or structs containing a single complex
// floating-point value should be passed in GPRs if no two FPRs is available.

// LP64-LABEL: define dso_local void @f_floatcomplex_insufficient_fprs1
// LP64-SAME: (i64 noundef [[A_COERCE:%.*]], i64 noundef [[B_COERCE:%.*]], i64 noundef [[C_COERCE:%.*]], i64 noundef [[D_COERCE:%.*]], i64 noundef [[E_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatcomplex_insufficient_fprs1
// LP64F-LP64D-SAME: (float noundef [[A_COERCE0:%.*]], float noundef [[A_COERCE1:%.*]], float noundef [[B_COERCE0:%.*]], float noundef [[B_COERCE1:%.*]], float noundef [[C_COERCE0:%.*]], float noundef [[C_COERCE1:%.*]], float noundef [[D_COERCE0:%.*]], float noundef [[D_COERCE1:%.*]], i64 noundef [[E_COERCE:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatcomplex_insufficient_fprs1(float __complex__ a, float __complex__ b,
                                       float __complex__ c, float __complex__ d,
                                       float __complex__ e) {}


// LP64-LABEL: define dso_local void @f_floatcomplex_s_arg_insufficient_fprs1
// LP64-SAME: (i64 [[A_COERCE:%.*]], i64 [[B_COERCE:%.*]], i64 [[C_COERCE:%.*]], i64 [[D_COERCE:%.*]], i64 [[E_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatcomplex_s_arg_insufficient_fprs1
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], float [[TMP1:%.*]], float [[TMP2:%.*]], float [[TMP3:%.*]], float [[TMP4:%.*]], float [[TMP5:%.*]], float [[TMP6:%.*]], float [[TMP7:%.*]], i64 [[E_COERCE:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatcomplex_s_arg_insufficient_fprs1(struct floatcomplex_s a,
                                             struct floatcomplex_s b,
                                             struct floatcomplex_s c,
                                             struct floatcomplex_s d,
                                             struct floatcomplex_s e) {}

// LP64-LABEL: define dso_local void @f_floatcomplex_insufficient_fprs2
// LP64-SAME: (float noundef [[A:%.*]], i64 noundef [[B_COERCE:%.*]], i64 noundef [[C_COERCE:%.*]], i64 noundef [[D_COERCE:%.*]], i64 noundef [[E_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatcomplex_insufficient_fprs2
// LP64F-LP64D-SAME: (float noundef [[A:%.*]], float noundef [[B_COERCE0:%.*]], float noundef [[B_COERCE1:%.*]], float noundef [[C_COERCE0:%.*]], float noundef [[C_COERCE1:%.*]], float noundef [[D_COERCE0:%.*]], float noundef [[D_COERCE1:%.*]], i64 noundef [[E_COERCE:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatcomplex_insufficient_fprs2(float a,
                                       float __complex__ b, float __complex__ c,
                                       float __complex__ d, float __complex__ e) {}


// LP64-LABEL: define dso_local void @f_floatcomplex_s_arg_insufficient_fprs2
// LP64-SAME: (float noundef [[A:%.*]], i64 [[B_COERCE:%.*]], i64 [[C_COERCE:%.*]], i64 [[D_COERCE:%.*]], i64 [[E_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatcomplex_s_arg_insufficient_fprs2
// LP64F-LP64D-SAME: (float noundef [[A:%.*]], float [[TMP0:%.*]], float [[TMP1:%.*]], float [[TMP2:%.*]], float [[TMP3:%.*]], float [[TMP4:%.*]], float [[TMP5:%.*]], i64 [[E_COERCE:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatcomplex_s_arg_insufficient_fprs2(float a,
                                             struct floatcomplex_s b,
                                             struct floatcomplex_s c,
                                             struct floatcomplex_s d,
                                             struct floatcomplex_s e) {}

// Test single or two-element structs that need flattening. e.g. those
// containing nested structs, floats in small arrays, zero-length structs etc.

struct floatarr1_s { float a[1]; };

// LP64-LABEL: define dso_local void @f_floatarr1_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatarr1_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatarr1_s_arg(struct floatarr1_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_floatarr1_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local float @f_ret_floatarr1_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct floatarr1_s f_ret_floatarr1_s(void) {
  return (struct floatarr1_s){{1.0}};
}

struct floatarr2_s { float a[2]; };

// LP64-LABEL: define dso_local void @f_floatarr2_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatarr2_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], float [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatarr2_s_arg(struct floatarr2_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_floatarr2_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, float } @f_ret_floatarr2_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct floatarr2_s f_ret_floatarr2_s(void) {
  return (struct floatarr2_s){{1.0, 2.0}};
}

struct floatarr2_tricky1_s { struct { float f[1]; } g[2]; };

// LP64-LABEL: define dso_local void @f_floatarr2_tricky1_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatarr2_tricky1_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], float [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatarr2_tricky1_s_arg(struct floatarr2_tricky1_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_floatarr2_tricky1_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, float } @f_ret_floatarr2_tricky1_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct floatarr2_tricky1_s f_ret_floatarr2_tricky1_s(void) {
  return (struct floatarr2_tricky1_s){{{{1.0}}, {{2.0}}}};
}

struct floatarr2_tricky2_s { struct {}; struct { float f[1]; } g[2]; };

// LP64-LABEL: define dso_local void @f_floatarr2_tricky2_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatarr2_tricky2_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], float [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatarr2_tricky2_s_arg(struct floatarr2_tricky2_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_floatarr2_tricky2_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, float } @f_ret_floatarr2_tricky2_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct floatarr2_tricky2_s f_ret_floatarr2_tricky2_s(void) {
  return (struct floatarr2_tricky2_s){{}, {{{1.0}}, {{2.0}}}};
}

struct floatarr2_tricky3_s { union {}; struct { float f[1]; } g[2]; };

// LP64-LABEL: define dso_local void @f_floatarr2_tricky3_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatarr2_tricky3_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], float [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatarr2_tricky3_s_arg(struct floatarr2_tricky3_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_floatarr2_tricky3_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, float } @f_ret_floatarr2_tricky3_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct floatarr2_tricky3_s f_ret_floatarr2_tricky3_s(void) {
  return (struct floatarr2_tricky3_s){{}, {{{1.0}}, {{2.0}}}};
}

struct floatarr2_tricky4_s { union {}; struct { struct {}; float f[1]; } g[2]; };

// LP64-LABEL: define dso_local void @f_floatarr2_tricky4_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_floatarr2_tricky4_s_arg
// LP64F-LP64D-SAME: (float [[TMP0:%.*]], float [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_floatarr2_tricky4_s_arg(struct floatarr2_tricky4_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_floatarr2_tricky4_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { float, float } @f_ret_floatarr2_tricky4_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct floatarr2_tricky4_s f_ret_floatarr2_tricky4_s(void) {
  return (struct floatarr2_tricky4_s){{}, {{{}, {1.0}}, {{}, {2.0}}}};
}

// Test structs that should be passed according to the normal integer calling
// convention.

struct int_float_int_s { int a; float b; int c; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_int_float_int_s_arg
// LP64-LP64F-LP64D-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_int_float_int_s_arg(struct int_float_int_s a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local [2 x i64] @f_ret_int_float_int_s
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct int_float_int_s f_ret_int_float_int_s(void) {
  return (struct int_float_int_s){1, 2.0, 3};
}

struct char_char_float_s { char a; char b; float c; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_char_char_float_s_arg
// LP64-LP64F-LP64D-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_char_char_float_s_arg(struct char_char_float_s a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_ret_char_char_float_s
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct char_char_float_s f_ret_char_char_float_s(void) {
  return (struct char_char_float_s){1, 2, 3.0};
}

// Unions are always passed according to the integer calling convention, even
// if they can only contain a float.

union float_u { float a; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_float_u_arg
// LP64-LP64F-LP64D-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_float_u_arg(union float_u a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_ret_float_u
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
union float_u f_ret_float_u(void) {
  return (union float_u){1.0};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_fpr_tracking2
// LP64-LP64F-LP64D-SAME: (double noundef [[A:%.*]], double noundef [[B:%.*]], double noundef [[C:%.*]], double noundef [[D:%.*]], double noundef [[E:%.*]], double noundef [[F:%.*]], double noundef [[G:%.*]], double noundef [[H:%.*]], i8 noundef zeroext [[I:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_fpr_tracking2(double a, double b, double c, double d, double e, double f,
                     double g, double h, uint8_t i) {}

// Check that fp, fp+fp, and int+fp structs are lowered correctly. These will
// be passed in FPR, FPR+FPR, or GPR+FPR regs if sufficient registers are
// available the widths are <= XLEN and FLEN, and should be expanded to
// separate arguments in IR. They are passed by the same rules for returns,
// but will be lowered to simple two-element structs if necessary (as LLVM IR
// functions cannot return multiple values).

// A struct containing just one floating-point real is passed as though it
// were a standalone floating-point real.

struct double_s { double f; };

// LP64-LP64F-LABEL: define dso_local void @f_double_s_arg
// LP64-LP64F-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_s_arg
// LP64D-SAME: (double [[TMP0:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_s_arg(struct double_s a) {}

// LP64-LP64F-LABEL: define dso_local i64 @f_ret_double_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local double @f_ret_double_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_s f_ret_double_s(void) {
  return (struct double_s){1.0};
}

// A struct containing a double and any number of zero-width bitfields is
// passed as though it were a standalone floating-point real.

struct zbf_double_s { int : 0; double f; };
struct zbf_double_zbf_s { int : 0; double f; int : 0; };

// LP64-LP64F-LABEL: define dso_local void @f_zbf_double_s_arg
// LP64-LP64F-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_zbf_double_s_arg
// LP64D-SAME: (double [[TMP0:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_zbf_double_s_arg(struct zbf_double_s a) {}

// LP64-LP64F-LABEL: define dso_local i64 @f_ret_zbf_double_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local double @f_ret_zbf_double_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct zbf_double_s f_ret_zbf_double_s(void) {
  return (struct zbf_double_s){1.0};
}

// LP64-LP64F-LABEL: define dso_local void @f_zbf_double_zbf_s_arg
// LP64-LP64F-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_zbf_double_zbf_s_arg
// LP64D-SAME: (double [[TMP0:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_zbf_double_zbf_s_arg(struct zbf_double_zbf_s a) {}

// LP64-LP64F-LABEL: define dso_local i64 @f_ret_zbf_double_zbf_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local double @f_ret_zbf_double_zbf_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct zbf_double_zbf_s f_ret_zbf_double_zbf_s(void) {
  return (struct zbf_double_zbf_s){1.0};
}

// Check that structs containing two floating point values (FLEN <= width) are
// expanded provided sufficient FPRs are available.

struct double_double_s { double f; double g; };
struct double_float_s { double f; float g; };

// LP64-LP64F-LABEL: define dso_local void @f_double_double_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_double_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], double [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_double_s_arg(struct double_double_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_double_double_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, double } @f_ret_double_double_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_double_s f_ret_double_double_s(void) {
  return (struct double_double_s){1.0, 2.0};
}

// LP64-LP64F-LABEL: define dso_local void @f_double_float_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_float_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], float [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_float_s_arg(struct double_float_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_double_float_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, float } @f_ret_double_float_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_float_s f_ret_double_float_s(void) {
  return (struct double_float_s){1.0, 2.0};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_double_double_s_arg_insufficient_fprs
// LP64-LP64F-LP64D-SAME: (float noundef [[A:%.*]], double noundef [[B:%.*]], double noundef [[C:%.*]], double noundef [[D:%.*]], double noundef [[E:%.*]], double noundef [[F:%.*]], double noundef [[G:%.*]], [2 x i64] [[H_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_double_double_s_arg_insufficient_fprs(float a, double b, double c, double d,
    double e, double f, double g, struct double_double_s h) {}

// Check that structs containing int+double values are expanded, provided
// sufficient FPRs and GPRs are available. The integer components are neither
// sign or zero-extended.

struct double_int8_s { double f; int8_t i; };
struct double_uint8_s { double f; uint8_t i; };
struct double_int32_s { double f; int32_t i; };
struct double_int64_s { double f; int64_t i; };
struct double_int128bf_s { double f; __int128_t i : 64; };
struct double_int8_zbf_s { double f; int8_t i; int : 0; };

// LP64-LP64F-LABEL: define dso_local void @f_double_int8_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_int8_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_int8_s_arg(struct double_int8_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_double_int8_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, i8 } @f_ret_double_int8_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_int8_s f_ret_double_int8_s(void) {
  return (struct double_int8_s){1.0, 2};
}

// LP64-LP64F-LABEL: define dso_local void @f_double_uint8_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_uint8_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_uint8_s_arg(struct double_uint8_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_double_uint8_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, i8 } @f_ret_double_uint8_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_uint8_s f_ret_double_uint8_s(void) {
  return (struct double_uint8_s){1.0, 2};
}

// LP64-LP64F-LABEL: define dso_local void @f_double_int32_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_int32_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_int32_s_arg(struct double_int32_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_double_int32_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, i32 } @f_ret_double_int32_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_int32_s f_ret_double_int32_s(void) {
  return (struct double_int32_s){1.0, 2};
}

// LP64-LP64F-LABEL: define dso_local void @f_double_int64_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_int64_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], i64 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_int64_s_arg(struct double_int64_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_double_int64_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, i64 } @f_ret_double_int64_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_int64_s f_ret_double_int64_s(void) {
  return (struct double_int64_s){1.0, 2};
}

// LP64-LP64F-LABEL: define dso_local void @f_double_int128bf_s_arg
// LP64-LP64F-SAME: (i128 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_int128bf_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], i64 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_int128bf_s_arg(struct double_int128bf_s a) {}

// LP64-LP64F-LABEL: define dso_local i128 @f_ret_double_int128bf_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, i64 } @f_ret_double_int128bf_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_int128bf_s f_ret_double_int128bf_s(void) {
  return (struct double_int128bf_s){1.0, 2};
}

// The zero-width bitfield means the struct can't be passed according to the
// floating point calling convention.

// LP64-LP64F-LABEL: define dso_local void @f_double_int8_zbf_s
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_int8_zbf_s
// LP64D-SAME: (double [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_int8_zbf_s(struct double_int8_zbf_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_double_int8_zbf_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, i8 } @f_ret_double_int8_zbf_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_int8_zbf_s f_ret_double_int8_zbf_s(void) {
  return (struct double_int8_zbf_s){1.0, 2};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_double_int8_s_arg_insufficient_gprs
// LP64-LP64F-LP64D-SAME: (i32 noundef signext [[A:%.*]], i32 noundef signext [[B:%.*]], i32 noundef signext [[C:%.*]], i32 noundef signext [[D:%.*]], i32 noundef signext [[E:%.*]], i32 noundef signext [[F:%.*]], i32 noundef signext [[G:%.*]], i32 noundef signext [[H:%.*]], [2 x i64] [[I_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_double_int8_s_arg_insufficient_gprs(int a, int b, int c, int d, int e,
                                          int f, int g, int h, struct double_int8_s i) {}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_struct_double_int8_insufficient_fprs
// LP64-LP64F-LP64D-SAME: (float noundef [[A:%.*]], double noundef [[B:%.*]], double noundef [[C:%.*]], double noundef [[D:%.*]], double noundef [[E:%.*]], double noundef [[F:%.*]], double noundef [[G:%.*]], double noundef [[H:%.*]], [2 x i64] [[I_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_struct_double_int8_insufficient_fprs(float a, double b, double c, double d,
                                           double e, double f, double g, double h, struct double_int8_s i) {}

// Complex floating-point values or structs containing a single complex
// floating-point value should be passed as if it were an fp+fp struct.

// LP64-LP64F-LABEL: define dso_local void @f_doublecomplex
// LP64-LP64F-SAME: ([2 x i64] noundef [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_doublecomplex
// LP64D-SAME: (double noundef [[A_COERCE0:%.*]], double noundef [[A_COERCE1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_doublecomplex(double __complex__ a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_doublecomplex
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, double } @f_ret_doublecomplex
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
double __complex__ f_ret_doublecomplex(void) {
  return 1.0;
}

struct doublecomplex_s { double __complex__ c; };

// LP64-LP64F-LABEL: define dso_local void @f_doublecomplex_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_doublecomplex_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], double [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_doublecomplex_s_arg(struct doublecomplex_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_doublecomplex_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, double } @f_ret_doublecomplex_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct doublecomplex_s f_ret_doublecomplex_s(void) {
  return (struct doublecomplex_s){1.0};
}

// Test single or two-element structs that need flattening. e.g. those
// containing nested structs, doubles in small arrays, zero-length structs etc.

struct doublearr1_s { double a[1]; };

// LP64-LP64F-LABEL: define dso_local void @f_doublearr1_s_arg
// LP64-LP64F-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_doublearr1_s_arg
// LP64D-SAME: (double [[TMP0:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_doublearr1_s_arg(struct doublearr1_s a) {}

// LP64-LP64F-LABEL: define dso_local i64 @f_ret_doublearr1_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local double @f_ret_doublearr1_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct doublearr1_s f_ret_doublearr1_s(void) {
  return (struct doublearr1_s){{1.0}};
}

struct doublearr2_s { double a[2]; };

// LP64-LP64F-LABEL: define dso_local void @f_doublearr2_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_doublearr2_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], double [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_doublearr2_s_arg(struct doublearr2_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_doublearr2_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, double } @f_ret_doublearr2_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct doublearr2_s f_ret_doublearr2_s(void) {
  return (struct doublearr2_s){{1.0, 2.0}};
}

struct doublearr2_tricky1_s { struct { double f[1]; } g[2]; };

// LP64-LP64F-LABEL: define dso_local void @f_doublearr2_tricky1_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_doublearr2_tricky1_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], double [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_doublearr2_tricky1_s_arg(struct doublearr2_tricky1_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_doublearr2_tricky1_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, double } @f_ret_doublearr2_tricky1_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct doublearr2_tricky1_s f_ret_doublearr2_tricky1_s(void) {
  return (struct doublearr2_tricky1_s){{{{1.0}}, {{2.0}}}};
}

struct doublearr2_tricky2_s { struct {}; struct { double f[1]; } g[2]; };

// LP64-LP64F-LABEL: define dso_local void @f_doublearr2_tricky2_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_doublearr2_tricky2_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], double [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_doublearr2_tricky2_s_arg(struct doublearr2_tricky2_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_doublearr2_tricky2_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, double } @f_ret_doublearr2_tricky2_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct doublearr2_tricky2_s f_ret_doublearr2_tricky2_s(void) {
  return (struct doublearr2_tricky2_s){{}, {{{1.0}}, {{2.0}}}};
}

struct doublearr2_tricky3_s { union {}; struct { double f[1]; } g[2]; };

// LP64-LP64F-LABEL: define dso_local void @f_doublearr2_tricky3_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_doublearr2_tricky3_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], double [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_doublearr2_tricky3_s_arg(struct doublearr2_tricky3_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_doublearr2_tricky3_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, double } @f_ret_doublearr2_tricky3_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct doublearr2_tricky3_s f_ret_doublearr2_tricky3_s(void) {
  return (struct doublearr2_tricky3_s){{}, {{{1.0}}, {{2.0}}}};
}

struct doublearr2_tricky4_s { union {}; struct { struct {}; double f[1]; } g[2]; };

// LP64-LP64F-LABEL: define dso_local void @f_doublearr2_tricky4_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_doublearr2_tricky4_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], double [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_doublearr2_tricky4_s_arg(struct doublearr2_tricky4_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_doublearr2_tricky4_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, double } @f_ret_doublearr2_tricky4_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct doublearr2_tricky4_s f_ret_doublearr2_tricky4_s(void) {
  return (struct doublearr2_tricky4_s){{}, {{{}, {1.0}}, {{}, {2.0}}}};
}

// Test structs that should be passed according to the normal integer calling
// convention.

struct int_double_int_s { int a; double b; int c; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_int_double_int_s_arg
// LP64-LP64F-LP64D-SAME: (ptr noundef dead_on_return [[A:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_int_double_int_s_arg(struct int_double_int_s a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_ret_int_double_int_s
// LP64-LP64F-LP64D-SAME: (ptr dead_on_unwind noalias writable sret([[STRUCT_INT_DOUBLE_INT_S:%.*]]) align 8 [[AGG_RESULT:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct int_double_int_s f_ret_int_double_int_s(void) {
  return (struct int_double_int_s){1, 2.0, 3};
}

struct char_char_double_s { char a; char b; double c; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_char_char_double_s_arg
// LP64-LP64F-LP64D-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_char_char_double_s_arg(struct char_char_double_s a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local [2 x i64] @f_ret_char_char_double_s
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct char_char_double_s f_ret_char_char_double_s(void) {
  return (struct char_char_double_s){1, 2, 3.0};
}

// Unions are always passed according to the integer calling convention, even
// if they can only contain a double.

union double_u { double a; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_double_u_arg
// LP64-LP64F-LP64D-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_double_u_arg(union double_u a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_ret_double_u
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
union double_u f_ret_double_u(void) {
  return (union double_u){1.0};
}

// Check that fp, fp+fp, and int+fp structs are lowered correctly. These will
// be passed in FPR, FPR+FPR, or GPR+FPR regs if sufficient registers are
// available the widths are <= XLEN and FLEN, and should be expanded to
// separate arguments in IR. They are passed by the same rules for returns,
// but will be lowered to simple two-element structs if necessary (as LLVM IR
// functions cannot return multiple values).

struct float16_s { _Float16 f; };

// A struct containing just one floating-point real is passed as though it
// were a standalone floating-point real.

// LP64-LABEL: define dso_local void @f_float16_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16_s_arg(struct float16_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local half @f_ret_float16_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16_s f_ret_float16_s(void) {
  return (struct float16_s){1.0};
}

// A struct containing a double and any number of zero-width bitfields is
// passed as though it were a standalone floating-point real.

struct zbf_float16_s { int : 0; _Float16 f; };
struct zbf_float16_zbf_s { int : 0; _Float16 f; int : 0; };

// LP64-LABEL: define dso_local void @f_zbf_float16_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_zbf_float16_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_zbf_float16_s_arg(struct zbf_float16_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_zbf_float16_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local half @f_ret_zbf_float16_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct zbf_float16_s f_ret_zbf_float16_s(void) {
  return (struct zbf_float16_s){1.0};
}

// LP64-LABEL: define dso_local void @f_zbf_float16_zbf_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_zbf_float16_zbf_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_zbf_float16_zbf_s_arg(struct zbf_float16_zbf_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_zbf_float16_zbf_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local half @f_ret_zbf_float16_zbf_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct zbf_float16_zbf_s f_ret_zbf_float16_zbf_s(void) {
  return (struct zbf_float16_zbf_s){1.0};
}

// Check that structs containing two floating point values (FLEN <= width) are
// expanded provided sufficient FPRs are available.

struct double_float16_s { double f; _Float16 g; };

// LP64-LP64F-LABEL: define dso_local void @f_double_float16_s_arg
// LP64-LP64F-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_double_float16_s_arg
// LP64D-SAME: (double [[TMP0:%.*]], half [[TMP1:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_double_float16_s_arg(struct double_float16_s a) {}

// LP64-LP64F-LABEL: define dso_local [2 x i64] @f_ret_double_float16_s
// LP64-LP64F-SAME: () #[[ATTR0]] {
// LP64-LP64F:  entry:
//
// LP64D-LABEL: define dso_local { double, half } @f_ret_double_float16_s
// LP64D-SAME: () #[[ATTR0]] {
// LP64D:  entry:
//
struct double_float16_s f_ret_double_float16_s(void) {
  return (struct double_float16_s){1.0, 2.0};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_double_float16_s_arg_insufficient_fprs
// LP64-LP64F-LP64D-SAME: (float noundef [[A:%.*]], double noundef [[B:%.*]], double noundef [[C:%.*]], double noundef [[D:%.*]], double noundef [[E:%.*]], double noundef [[F:%.*]], double noundef [[G:%.*]], [2 x i64] [[H_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_double_float16_s_arg_insufficient_fprs(float a, double b, double c, double d,
    double e, double f, double g, struct double_float16_s h) {}

// Check that structs containing int+_Float16 values are expanded, provided
// sufficient FPRs and GPRs are available. The integer components are neither
// sign or zero-extended.

struct float16_int8_s { _Float16 f; int8_t i; };
struct float16_uint8_s { _Float16 f; uint8_t i; };
struct float16_int32_s { _Float16 f; int32_t i; };
struct float16_int64_s { _Float16 f; int64_t i; };
struct float16_int64bf_s { _Float16 f; int64_t i : 32; };
struct float16_int8_zbf_s { _Float16 f; int8_t i; int : 0; };

// LP64-LABEL: define dso_local void @f_float16_int8_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16_int8_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16_int8_s_arg(struct float16_int8_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16_int8_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, i8 } @f_ret_float16_int8_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16_int8_s f_ret_float16_int8_s(void) {
  return (struct float16_int8_s){1.0, 2};
}

// LP64-LABEL: define dso_local void @f_float16_uint8_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16_uint8_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16_uint8_s_arg(struct float16_uint8_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16_uint8_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, i8 } @f_ret_float16_uint8_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16_uint8_s f_ret_float16_uint8_s(void) {
  return (struct float16_uint8_s){1.0, 2};
}

// LP64-LABEL: define dso_local void @f_float16_int32_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16_int32_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], i32 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16_int32_s_arg(struct float16_int32_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16_int32_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, i32 } @f_ret_float16_int32_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16_int32_s f_ret_float16_int32_s(void) {
  return (struct float16_int32_s){1.0, 2};
}

// LP64-LABEL: define dso_local void @f_float16_int64_s_arg
// LP64-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16_int64_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], i64 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16_int64_s_arg(struct float16_int64_s a) {}

// LP64-LABEL: define dso_local [2 x i64] @f_ret_float16_int64_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, i64 } @f_ret_float16_int64_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16_int64_s f_ret_float16_int64_s(void) {
  return (struct float16_int64_s){1.0, 2};
}

// LP64-LABEL: define dso_local void @f_float16_int64bf_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16_int64bf_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], i64 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16_int64bf_s_arg(struct float16_int64bf_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16_int64bf_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local <{ half, i64 }> @f_ret_float16_int64bf_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16_int64bf_s f_ret_float16_int64bf_s(void) {
  return (struct float16_int64bf_s){1.0, 2};
}

// The zero-width bitfield means the struct can't be passed according to the
// floating point calling convention.

// LP64-LABEL: define dso_local void @f_float16_int8_zbf_s
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16_int8_zbf_s
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16_int8_zbf_s(struct float16_int8_zbf_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16_int8_zbf_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, i8 } @f_ret_float16_int8_zbf_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16_int8_zbf_s f_ret_float16_int8_zbf_s(void) {
  return (struct float16_int8_zbf_s){1.0, 2};
}

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_float16_int8_s_arg_insufficient_gprs
// LP64-LP64F-LP64D-SAME: (i32 noundef signext [[A:%.*]], i32 noundef signext [[B:%.*]], i32 noundef signext [[C:%.*]], i32 noundef signext [[D:%.*]], i32 noundef signext [[E:%.*]], i32 noundef signext [[F:%.*]], i32 noundef signext [[G:%.*]], i32 noundef signext [[H:%.*]], i64 [[I_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_float16_int8_s_arg_insufficient_gprs(int a, int b, int c, int d, int e,
                                            int f, int g, int h, struct float16_int8_s i) {}

// LP64-LABEL: define dso_local void @f_struct_float16_int8_insufficient_fprs
// LP64-SAME: (float noundef [[A:%.*]], double noundef [[B:%.*]], double noundef [[C:%.*]], double noundef [[D:%.*]], double noundef [[E:%.*]], double noundef [[F:%.*]], double noundef [[G:%.*]], double noundef [[H:%.*]], i64 [[I_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LABEL: define dso_local void @f_struct_float16_int8_insufficient_fprs
// LP64F-SAME: (float noundef [[A:%.*]], double noundef [[B:%.*]], double noundef [[C:%.*]], double noundef [[D:%.*]], double noundef [[E:%.*]], double noundef [[F:%.*]], double noundef [[G:%.*]], double noundef [[H:%.*]], half [[TMP0:%.*]], i8 [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F:  entry:
//
// LP64D-LABEL: define dso_local void @f_struct_float16_int8_insufficient_fprs
// LP64D-SAME: (float noundef [[A:%.*]], double noundef [[B:%.*]], double noundef [[C:%.*]], double noundef [[D:%.*]], double noundef [[E:%.*]], double noundef [[F:%.*]], double noundef [[G:%.*]], double noundef [[H:%.*]], i64 [[I_COERCE:%.*]]) #[[ATTR0]] {
// LP64D:  entry:
//
void f_struct_float16_int8_insufficient_fprs(float a, double b, double c, double d,
                                             double e, double f, double g, double h, struct float16_int8_s i) {}

// Complex floating-point values or structs containing a single complex
// floating-point value should be passed as if it were an fp+fp struct.

// LP64-LABEL: define dso_local void @f_float16complex
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16complex
// LP64F-LP64D-SAME: (half noundef [[A_COERCE0:%.*]], half noundef [[A_COERCE1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16complex(_Float16 __complex__ a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16complex
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, half } @f_ret_float16complex
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
_Float16 __complex__ f_ret_float16complex(void) {
  return 1.0;
}

struct float16complex_s { _Float16 __complex__ c; };

// LP64-LABEL: define dso_local void @f_float16complex_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16complex_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], half [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16complex_s_arg(struct float16complex_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16complex_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, half } @f_ret_float16complex_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16complex_s f_ret_float16complex_s(void) {
  return (struct float16complex_s){1.0};
}

// Test single or two-element structs that need flattening. e.g. those
// containing nested structs, _Float16 in small arrays, zero-length structs etc.

struct float16arr1_s { _Float16 a[1]; };

// LP64-LABEL: define dso_local void @f_float16arr1_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16arr1_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16arr1_s_arg(struct float16arr1_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16arr1_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local half @f_ret_float16arr1_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16arr1_s f_ret_float16arr1_s(void) {
  return (struct float16arr1_s){{1.0}};
}

struct float16arr2_s { _Float16 a[2]; };

// LP64-LABEL: define dso_local void @f_float16arr2_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16arr2_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], half [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16arr2_s_arg(struct float16arr2_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16arr2_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, half } @f_ret_float16arr2_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16arr2_s f_ret_float16arr2_s(void) {
  return (struct float16arr2_s){{1.0, 2.0}};
}

struct float16arr2_tricky1_s { struct { _Float16 f[1]; } g[2]; };

// LP64-LABEL: define dso_local void @f_float16arr2_tricky1_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16arr2_tricky1_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], half [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16arr2_tricky1_s_arg(struct float16arr2_tricky1_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16arr2_tricky1_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, half } @f_ret_float16arr2_tricky1_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16arr2_tricky1_s f_ret_float16arr2_tricky1_s(void) {
  return (struct float16arr2_tricky1_s){{{{1.0}}, {{2.0}}}};
}

struct float16arr2_tricky2_s { struct {}; struct { _Float16 f[1]; } g[2]; };

// LP64-LABEL: define dso_local void @f_float16arr2_tricky2_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16arr2_tricky2_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], half [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16arr2_tricky2_s_arg(struct float16arr2_tricky2_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16arr2_tricky2_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, half } @f_ret_float16arr2_tricky2_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16arr2_tricky2_s f_ret_float16arr2_tricky2_s(void) {
  return (struct float16arr2_tricky2_s){{}, {{{1.0}}, {{2.0}}}};
}

struct float16arr2_tricky3_s { union {}; struct { _Float16 f[1]; } g[2]; };

// LP64-LABEL: define dso_local void @f_float16arr2_tricky3_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16arr2_tricky3_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], half [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16arr2_tricky3_s_arg(struct float16arr2_tricky3_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16arr2_tricky3_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, half } @f_ret_float16arr2_tricky3_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16arr2_tricky3_s f_ret_float16arr2_tricky3_s(void) {
  return (struct float16arr2_tricky3_s){{}, {{{1.0}}, {{2.0}}}};
}

struct float16arr2_tricky4_s { union {}; struct { struct {}; _Float16 f[1]; } g[2]; };

// LP64-LABEL: define dso_local void @f_float16arr2_tricky4_s_arg
// LP64-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_float16arr2_tricky4_s_arg
// LP64F-LP64D-SAME: (half [[TMP0:%.*]], half [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_float16arr2_tricky4_s_arg(struct float16arr2_tricky4_s a) {}

// LP64-LABEL: define dso_local i64 @f_ret_float16arr2_tricky4_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { half, half } @f_ret_float16arr2_tricky4_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct float16arr2_tricky4_s f_ret_float16arr2_tricky4_s(void) {
  return (struct float16arr2_tricky4_s){{}, {{{}, {1.0}}, {{}, {2.0}}}};
}

// Test structs that should be passed according to the normal integer calling
// convention.

struct int_float16_int_s { int a; _Float16 b; int c; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_int_float16_int_s_arg
// LP64-LP64F-LP64D-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_int_float16_int_s_arg(struct int_float16_int_s a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local [2 x i64] @f_ret_int_float16_int_s
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct int_float16_int_s f_ret_int_float16_int_s(void) {
  return (struct int_float16_int_s){1, 2.0, 3};
}

struct int64_float16_s { int64_t a; _Float16 b; };

// LP64-LABEL: define dso_local void @f_int64_float16_s_arg
// LP64-SAME: ([2 x i64] [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local void @f_int64_float16_s_arg
// LP64F-LP64D-SAME: (i64 [[TMP0:%.*]], half [[TMP1:%.*]]) #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
void f_int64_float16_s_arg(struct int64_float16_s a) {}

// LP64-LABEL: define dso_local [2 x i64] @f_ret_int64_float16_s
// LP64-SAME: () #[[ATTR0]] {
// LP64:  entry:
//
// LP64F-LP64D-LABEL: define dso_local { i64, half } @f_ret_int64_float16_s
// LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64F-LP64D:  entry:
//
struct int64_float16_s f_ret_int64_float16_s(void) {
  return (struct int64_float16_s){1, 2.0};
}

struct char_char_float16_s { char a; char b; _Float16 c; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_char_char_float16_s_arg
// LP64-LP64F-LP64D-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_char_char_float16_s_arg(struct char_char_float16_s a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_ret_char_char_float16_s
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
struct char_char_float16_s f_ret_char_char_float16_s(void) {
  return (struct char_char_float16_s){1, 2, 3.0};
}

// Unions are always passed according to the integer calling convention, even
// if they can only contain a double.

union float16_u { _Float16 a; };

// LP64-LP64F-LP64D-LABEL: define dso_local void @f_float16_u_arg
// LP64-LP64F-LP64D-SAME: (i64 [[A_COERCE:%.*]]) #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
void f_float16_u_arg(union float16_u a) {}

// LP64-LP64F-LP64D-LABEL: define dso_local i64 @f_ret_float16_u
// LP64-LP64F-LP64D-SAME: () #[[ATTR0]] {
// LP64-LP64F-LP64D:  entry:
//
union float16_u f_ret_float16_u(void) {
  return (union float16_u){1.0};
}

//// NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
// LP64E: {{.*}}
