// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceUIGetApplicationTemplateBundleReader is a Reader for the WaypointServiceUIGetApplicationTemplateBundle structure.
type WaypointServiceUIGetApplicationTemplateBundleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUIGetApplicationTemplateBundleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUIGetApplicationTemplateBundleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUIGetApplicationTemplateBundleDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUIGetApplicationTemplateBundleOK creates a WaypointServiceUIGetApplicationTemplateBundleOK with default headers values
func NewWaypointServiceUIGetApplicationTemplateBundleOK() *WaypointServiceUIGetApplicationTemplateBundleOK {
	return &WaypointServiceUIGetApplicationTemplateBundleOK{}
}

/*
WaypointServiceUIGetApplicationTemplateBundleOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUIGetApplicationTemplateBundleOK struct {
	Payload *models.HashicorpCloudWaypointUIGetApplicationTemplateBundleResponse
}

// IsSuccess returns true when this waypoint service Ui get application template bundle o k response has a 2xx status code
func (o *WaypointServiceUIGetApplicationTemplateBundleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service Ui get application template bundle o k response has a 3xx status code
func (o *WaypointServiceUIGetApplicationTemplateBundleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service Ui get application template bundle o k response has a 4xx status code
func (o *WaypointServiceUIGetApplicationTemplateBundleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service Ui get application template bundle o k response has a 5xx status code
func (o *WaypointServiceUIGetApplicationTemplateBundleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service Ui get application template bundle o k response a status code equal to that given
func (o *WaypointServiceUIGetApplicationTemplateBundleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service Ui get application template bundle o k response
func (o *WaypointServiceUIGetApplicationTemplateBundleOK) Code() int {
	return 200
}

func (o *WaypointServiceUIGetApplicationTemplateBundleOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/ui/application-templates/{application_template.id}][%d] waypointServiceUiGetApplicationTemplateBundleOK %s", 200, payload)
}

func (o *WaypointServiceUIGetApplicationTemplateBundleOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/ui/application-templates/{application_template.id}][%d] waypointServiceUiGetApplicationTemplateBundleOK %s", 200, payload)
}

func (o *WaypointServiceUIGetApplicationTemplateBundleOK) GetPayload() *models.HashicorpCloudWaypointUIGetApplicationTemplateBundleResponse {
	return o.Payload
}

func (o *WaypointServiceUIGetApplicationTemplateBundleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUIGetApplicationTemplateBundleResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUIGetApplicationTemplateBundleDefault creates a WaypointServiceUIGetApplicationTemplateBundleDefault with default headers values
func NewWaypointServiceUIGetApplicationTemplateBundleDefault(code int) *WaypointServiceUIGetApplicationTemplateBundleDefault {
	return &WaypointServiceUIGetApplicationTemplateBundleDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUIGetApplicationTemplateBundleDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUIGetApplicationTemplateBundleDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service UI get application template bundle default response has a 2xx status code
func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service UI get application template bundle default response has a 3xx status code
func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service UI get application template bundle default response has a 4xx status code
func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service UI get application template bundle default response has a 5xx status code
func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service UI get application template bundle default response a status code equal to that given
func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service UI get application template bundle default response
func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/ui/application-templates/{application_template.id}][%d] WaypointService_UI_GetApplicationTemplateBundle default %s", o._statusCode, payload)
}

func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/ui/application-templates/{application_template.id}][%d] WaypointService_UI_GetApplicationTemplateBundle default %s", o._statusCode, payload)
}

func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUIGetApplicationTemplateBundleDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
