// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceListApplicationsReader is a Reader for the WaypointServiceListApplications structure.
type WaypointServiceListApplicationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListApplicationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListApplicationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListApplicationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListApplicationsOK creates a WaypointServiceListApplicationsOK with default headers values
func NewWaypointServiceListApplicationsOK() *WaypointServiceListApplicationsOK {
	return &WaypointServiceListApplicationsOK{}
}

/*
WaypointServiceListApplicationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListApplicationsOK struct {
	Payload *models.HashicorpCloudWaypointListApplicationsResponse
}

// IsSuccess returns true when this waypoint service list applications o k response has a 2xx status code
func (o *WaypointServiceListApplicationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list applications o k response has a 3xx status code
func (o *WaypointServiceListApplicationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list applications o k response has a 4xx status code
func (o *WaypointServiceListApplicationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list applications o k response has a 5xx status code
func (o *WaypointServiceListApplicationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list applications o k response a status code equal to that given
func (o *WaypointServiceListApplicationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list applications o k response
func (o *WaypointServiceListApplicationsOK) Code() int {
	return 200
}

func (o *WaypointServiceListApplicationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/applications][%d] waypointServiceListApplicationsOK %s", 200, payload)
}

func (o *WaypointServiceListApplicationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/applications][%d] waypointServiceListApplicationsOK %s", 200, payload)
}

func (o *WaypointServiceListApplicationsOK) GetPayload() *models.HashicorpCloudWaypointListApplicationsResponse {
	return o.Payload
}

func (o *WaypointServiceListApplicationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListApplicationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListApplicationsDefault creates a WaypointServiceListApplicationsDefault with default headers values
func NewWaypointServiceListApplicationsDefault(code int) *WaypointServiceListApplicationsDefault {
	return &WaypointServiceListApplicationsDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListApplicationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListApplicationsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list applications default response has a 2xx status code
func (o *WaypointServiceListApplicationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list applications default response has a 3xx status code
func (o *WaypointServiceListApplicationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list applications default response has a 4xx status code
func (o *WaypointServiceListApplicationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list applications default response has a 5xx status code
func (o *WaypointServiceListApplicationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list applications default response a status code equal to that given
func (o *WaypointServiceListApplicationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list applications default response
func (o *WaypointServiceListApplicationsDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListApplicationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/applications][%d] WaypointService_ListApplications default %s", o._statusCode, payload)
}

func (o *WaypointServiceListApplicationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/applications][%d] WaypointService_ListApplications default %s", o._statusCode, payload)
}

func (o *WaypointServiceListApplicationsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListApplicationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
