// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointServiceDeleteActionConfigParams creates a new WaypointServiceDeleteActionConfigParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceDeleteActionConfigParams() *WaypointServiceDeleteActionConfigParams {
	return &WaypointServiceDeleteActionConfigParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceDeleteActionConfigParamsWithTimeout creates a new WaypointServiceDeleteActionConfigParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceDeleteActionConfigParamsWithTimeout(timeout time.Duration) *WaypointServiceDeleteActionConfigParams {
	return &WaypointServiceDeleteActionConfigParams{
		timeout: timeout,
	}
}

// NewWaypointServiceDeleteActionConfigParamsWithContext creates a new WaypointServiceDeleteActionConfigParams object
// with the ability to set a context for a request.
func NewWaypointServiceDeleteActionConfigParamsWithContext(ctx context.Context) *WaypointServiceDeleteActionConfigParams {
	return &WaypointServiceDeleteActionConfigParams{
		Context: ctx,
	}
}

// NewWaypointServiceDeleteActionConfigParamsWithHTTPClient creates a new WaypointServiceDeleteActionConfigParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceDeleteActionConfigParamsWithHTTPClient(client *http.Client) *WaypointServiceDeleteActionConfigParams {
	return &WaypointServiceDeleteActionConfigParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceDeleteActionConfigParams contains all the parameters to send to the API endpoint

	for the waypoint service delete action config operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceDeleteActionConfigParams struct {

	/* ActionID.

	   The id of the action config being deleted
	*/
	ActionID *string

	/* ActionName.

	   The name of the action being deleted (will only be used if id not provided)
	*/
	ActionName *string

	/* Force.

	   Force, if set to true, will auto-unassign the action from all apps and templates
	*/
	Force *bool

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service delete action config params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDeleteActionConfigParams) WithDefaults() *WaypointServiceDeleteActionConfigParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service delete action config params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDeleteActionConfigParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithTimeout(timeout time.Duration) *WaypointServiceDeleteActionConfigParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithContext(ctx context.Context) *WaypointServiceDeleteActionConfigParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithHTTPClient(client *http.Client) *WaypointServiceDeleteActionConfigParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionID adds the actionID to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithActionID(actionID *string) *WaypointServiceDeleteActionConfigParams {
	o.SetActionID(actionID)
	return o
}

// SetActionID adds the actionId to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetActionID(actionID *string) {
	o.ActionID = actionID
}

// WithActionName adds the actionName to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithActionName(actionName *string) *WaypointServiceDeleteActionConfigParams {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetActionName(actionName *string) {
	o.ActionName = actionName
}

// WithForce adds the force to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithForce(force *bool) *WaypointServiceDeleteActionConfigParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetForce(force *bool) {
	o.Force = force
}

// WithNamespaceID adds the namespaceID to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithNamespaceID(namespaceID string) *WaypointServiceDeleteActionConfigParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceDeleteActionConfigParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceDeleteActionConfigParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceDeleteActionConfigParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceDeleteActionConfigParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service delete action config params
func (o *WaypointServiceDeleteActionConfigParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceDeleteActionConfigParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ActionID != nil {

		// query param action_id
		var qrActionID string

		if o.ActionID != nil {
			qrActionID = *o.ActionID
		}
		qActionID := qrActionID
		if qActionID != "" {

			if err := r.SetQueryParam("action_id", qActionID); err != nil {
				return err
			}
		}
	}

	if o.ActionName != nil {

		// query param action_name
		var qrActionName string

		if o.ActionName != nil {
			qrActionName = *o.ActionName
		}
		qActionName := qrActionName
		if qActionName != "" {

			if err := r.SetQueryParam("action_name", qActionName); err != nil {
				return err
			}
		}
	}

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
