// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceCreateVariableReader is a Reader for the WaypointServiceCreateVariable structure.
type WaypointServiceCreateVariableReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceCreateVariableReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceCreateVariableOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceCreateVariableDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceCreateVariableOK creates a WaypointServiceCreateVariableOK with default headers values
func NewWaypointServiceCreateVariableOK() *WaypointServiceCreateVariableOK {
	return &WaypointServiceCreateVariableOK{}
}

/*
WaypointServiceCreateVariableOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceCreateVariableOK struct {
	Payload *models.HashicorpCloudWaypointCreateVariableResponse
}

// IsSuccess returns true when this waypoint service create variable o k response has a 2xx status code
func (o *WaypointServiceCreateVariableOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service create variable o k response has a 3xx status code
func (o *WaypointServiceCreateVariableOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service create variable o k response has a 4xx status code
func (o *WaypointServiceCreateVariableOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service create variable o k response has a 5xx status code
func (o *WaypointServiceCreateVariableOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service create variable o k response a status code equal to that given
func (o *WaypointServiceCreateVariableOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service create variable o k response
func (o *WaypointServiceCreateVariableOK) Code() int {
	return 200
}

func (o *WaypointServiceCreateVariableOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/variable][%d] waypointServiceCreateVariableOK %s", 200, payload)
}

func (o *WaypointServiceCreateVariableOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/variable][%d] waypointServiceCreateVariableOK %s", 200, payload)
}

func (o *WaypointServiceCreateVariableOK) GetPayload() *models.HashicorpCloudWaypointCreateVariableResponse {
	return o.Payload
}

func (o *WaypointServiceCreateVariableOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointCreateVariableResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceCreateVariableDefault creates a WaypointServiceCreateVariableDefault with default headers values
func NewWaypointServiceCreateVariableDefault(code int) *WaypointServiceCreateVariableDefault {
	return &WaypointServiceCreateVariableDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceCreateVariableDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceCreateVariableDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service create variable default response has a 2xx status code
func (o *WaypointServiceCreateVariableDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service create variable default response has a 3xx status code
func (o *WaypointServiceCreateVariableDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service create variable default response has a 4xx status code
func (o *WaypointServiceCreateVariableDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service create variable default response has a 5xx status code
func (o *WaypointServiceCreateVariableDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service create variable default response a status code equal to that given
func (o *WaypointServiceCreateVariableDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service create variable default response
func (o *WaypointServiceCreateVariableDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceCreateVariableDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/variable][%d] WaypointService_CreateVariable default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateVariableDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /waypoint/2023-08-18/namespace/{namespace.id}/variable][%d] WaypointService_CreateVariable default %s", o._statusCode, payload)
}

func (o *WaypointServiceCreateVariableDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceCreateVariableDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
