// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewPluginRegistrationStatusParams creates a new PluginRegistrationStatusParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPluginRegistrationStatusParams() *PluginRegistrationStatusParams {
	return &PluginRegistrationStatusParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPluginRegistrationStatusParamsWithTimeout creates a new PluginRegistrationStatusParams object
// with the ability to set a timeout on a request.
func NewPluginRegistrationStatusParamsWithTimeout(timeout time.Duration) *PluginRegistrationStatusParams {
	return &PluginRegistrationStatusParams{
		timeout: timeout,
	}
}

// NewPluginRegistrationStatusParamsWithContext creates a new PluginRegistrationStatusParams object
// with the ability to set a context for a request.
func NewPluginRegistrationStatusParamsWithContext(ctx context.Context) *PluginRegistrationStatusParams {
	return &PluginRegistrationStatusParams{
		Context: ctx,
	}
}

// NewPluginRegistrationStatusParamsWithHTTPClient creates a new PluginRegistrationStatusParams object
// with the ability to set a custom HTTPClient for a request.
func NewPluginRegistrationStatusParamsWithHTTPClient(client *http.Client) *PluginRegistrationStatusParams {
	return &PluginRegistrationStatusParams{
		HTTPClient: client,
	}
}

/*
PluginRegistrationStatusParams contains all the parameters to send to the API endpoint

	for the plugin registration status operation.

	Typically these are written to a http.Request.
*/
type PluginRegistrationStatusParams struct {

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the plugin registration status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PluginRegistrationStatusParams) WithDefaults() *PluginRegistrationStatusParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the plugin registration status params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PluginRegistrationStatusParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the plugin registration status params
func (o *PluginRegistrationStatusParams) WithTimeout(timeout time.Duration) *PluginRegistrationStatusParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the plugin registration status params
func (o *PluginRegistrationStatusParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the plugin registration status params
func (o *PluginRegistrationStatusParams) WithContext(ctx context.Context) *PluginRegistrationStatusParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the plugin registration status params
func (o *PluginRegistrationStatusParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the plugin registration status params
func (o *PluginRegistrationStatusParams) WithHTTPClient(client *http.Client) *PluginRegistrationStatusParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the plugin registration status params
func (o *PluginRegistrationStatusParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithClusterID adds the clusterID to the plugin registration status params
func (o *PluginRegistrationStatusParams) WithClusterID(clusterID string) *PluginRegistrationStatusParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the plugin registration status params
func (o *PluginRegistrationStatusParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the plugin registration status params
func (o *PluginRegistrationStatusParams) WithLocationOrganizationID(locationOrganizationID string) *PluginRegistrationStatusParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the plugin registration status params
func (o *PluginRegistrationStatusParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the plugin registration status params
func (o *PluginRegistrationStatusParams) WithLocationProjectID(locationProjectID string) *PluginRegistrationStatusParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the plugin registration status params
func (o *PluginRegistrationStatusParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the plugin registration status params
func (o *PluginRegistrationStatusParams) WithLocationRegionProvider(locationRegionProvider *string) *PluginRegistrationStatusParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the plugin registration status params
func (o *PluginRegistrationStatusParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the plugin registration status params
func (o *PluginRegistrationStatusParams) WithLocationRegionRegion(locationRegionRegion *string) *PluginRegistrationStatusParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the plugin registration status params
func (o *PluginRegistrationStatusParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *PluginRegistrationStatusParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
