// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-global-network-manager-service/preview/2023-10-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ListClusterNodesReader is a Reader for the ListClusterNodes structure.
type ListClusterNodesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListClusterNodesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListClusterNodesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListClusterNodesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListClusterNodesOK creates a ListClusterNodesOK with default headers values
func NewListClusterNodesOK() *ListClusterNodesOK {
	return &ListClusterNodesOK{}
}

/*
ListClusterNodesOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListClusterNodesOK struct {
	Payload *models.HashicorpCloudConsulCloudManager20231010ListNodesResponse
}

// IsSuccess returns true when this list cluster nodes o k response has a 2xx status code
func (o *ListClusterNodesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list cluster nodes o k response has a 3xx status code
func (o *ListClusterNodesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list cluster nodes o k response has a 4xx status code
func (o *ListClusterNodesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list cluster nodes o k response has a 5xx status code
func (o *ListClusterNodesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list cluster nodes o k response a status code equal to that given
func (o *ListClusterNodesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list cluster nodes o k response
func (o *ListClusterNodesOK) Code() int {
	return 200
}

func (o *ListClusterNodesOK) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/{parent_resource_name}/nodes][%d] listClusterNodesOK  %+v", 200, o.Payload)
}

func (o *ListClusterNodesOK) String() string {
	return fmt.Sprintf("[GET /2023-10-10/{parent_resource_name}/nodes][%d] listClusterNodesOK  %+v", 200, o.Payload)
}

func (o *ListClusterNodesOK) GetPayload() *models.HashicorpCloudConsulCloudManager20231010ListNodesResponse {
	return o.Payload
}

func (o *ListClusterNodesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudConsulCloudManager20231010ListNodesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListClusterNodesDefault creates a ListClusterNodesDefault with default headers values
func NewListClusterNodesDefault(code int) *ListClusterNodesDefault {
	return &ListClusterNodesDefault{
		_statusCode: code,
	}
}

/*
ListClusterNodesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListClusterNodesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this list cluster nodes default response has a 2xx status code
func (o *ListClusterNodesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list cluster nodes default response has a 3xx status code
func (o *ListClusterNodesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list cluster nodes default response has a 4xx status code
func (o *ListClusterNodesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list cluster nodes default response has a 5xx status code
func (o *ListClusterNodesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list cluster nodes default response a status code equal to that given
func (o *ListClusterNodesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list cluster nodes default response
func (o *ListClusterNodesDefault) Code() int {
	return o._statusCode
}

func (o *ListClusterNodesDefault) Error() string {
	return fmt.Sprintf("[GET /2023-10-10/{parent_resource_name}/nodes][%d] List Cluster Nodes default  %+v", o._statusCode, o.Payload)
}

func (o *ListClusterNodesDefault) String() string {
	return fmt.Sprintf("[GET /2023-10-10/{parent_resource_name}/nodes][%d] List Cluster Nodes default  %+v", o._statusCode, o.Payload)
}

func (o *ListClusterNodesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ListClusterNodesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
