package winrm

import (
	"github.com/masterzen/winrm/soap"
	. "gopkg.in/check.v1"
)

func (s *WinRMSuite) TestShellExecuteResponse(c *C) {
	endpoint := NewEndpoint("localhost", 5985, false, false, nil, nil, nil, 0)
	client, err := NewClient(endpoint, "Administrator", "v3r1S3cre7")
	c.Assert(err, IsNil)

	shell := &Shell{client: client, id: "67A74734-DD32-4F10-89DE-49A060483810"}
	first := true
	r := Requester{}
	r.http = func(client *Client, message *soap.SoapMessage) (string, error) {
		if first {
			c.Assert(message.String(), Contains, "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Command")
			first = false
			return executeCommandResponse, nil
		}
		c.Assert(message.String(), Contains, "http://schemas.microsoft.com/wbem/wsman/1/windows/shell/Receive")
		return outputResponse, nil
	}
	client.http = &r
	command, _ := shell.Execute("ipconfig /all")
	c.Assert(command.id, Equals, "1A6DEE6B-EC68-4DD6-87E9-030C0048ECC4")
}

func (s *WinRMSuite) TestShellCloseResponse(c *C) {
	endpoint := NewEndpoint("localhost", 5985, false, false, nil, nil, nil, 0)
	client, err := NewClient(endpoint, "Administrator", "v3r1S3cre7")
	c.Assert(err, IsNil)

	shell := &Shell{client: client, id: "67A74734-DD32-4F10-89DE-49A060483810"}
	r := Requester{}
	r.http = func(client *Client, message *soap.SoapMessage) (string, error) {
		c.Assert(message.String(), Contains, "http://schemas.xmlsoap.org/ws/2004/09/transfer/Delete")
		return "", nil
	}
	client.http = &r

	shell.Close()
}
