// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudWebhookListWebhookDeliveriesResponse hashicorp cloud webhook list webhook deliveries response
//
// swagger:model hashicorp.cloud.webhook.ListWebhookDeliveriesResponse
type HashicorpCloudWebhookListWebhookDeliveriesResponse struct {

	// The list of webhook deliveries.
	Deliveries []*HashicorpCloudWebhookWebhookDelivery `json:"deliveries"`

	// Pagination tokens for a subsequent request.
	Pagination *cloud.HashicorpCloudCommonPaginationResponse `json:"pagination,omitempty"`
}

// Validate validates this hashicorp cloud webhook list webhook deliveries response
func (m *HashicorpCloudWebhookListWebhookDeliveriesResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateDeliveries(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePagination(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookListWebhookDeliveriesResponse) validateDeliveries(formats strfmt.Registry) error {
	if swag.IsZero(m.Deliveries) { // not required
		return nil
	}

	for i := 0; i < len(m.Deliveries); i++ {
		if swag.IsZero(m.Deliveries[i]) { // not required
			continue
		}

		if m.Deliveries[i] != nil {
			if err := m.Deliveries[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("deliveries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("deliveries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWebhookListWebhookDeliveriesResponse) validatePagination(formats strfmt.Registry) error {
	if swag.IsZero(m.Pagination) { // not required
		return nil
	}

	if m.Pagination != nil {
		if err := m.Pagination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud webhook list webhook deliveries response based on the context it is used
func (m *HashicorpCloudWebhookListWebhookDeliveriesResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateDeliveries(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePagination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWebhookListWebhookDeliveriesResponse) contextValidateDeliveries(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Deliveries); i++ {

		if m.Deliveries[i] != nil {

			if swag.IsZero(m.Deliveries[i]) { // not required
				return nil
			}

			if err := m.Deliveries[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("deliveries" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("deliveries" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWebhookListWebhookDeliveriesResponse) contextValidatePagination(ctx context.Context, formats strfmt.Registry) error {

	if m.Pagination != nil {

		if swag.IsZero(m.Pagination) { // not required
			return nil
		}

		if err := m.Pagination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pagination")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pagination")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWebhookListWebhookDeliveriesResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWebhookListWebhookDeliveriesResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWebhookListWebhookDeliveriesResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
