// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceGetVariableParams creates a new WaypointServiceGetVariableParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceGetVariableParams() *WaypointServiceGetVariableParams {
	return &WaypointServiceGetVariableParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceGetVariableParamsWithTimeout creates a new WaypointServiceGetVariableParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceGetVariableParamsWithTimeout(timeout time.Duration) *WaypointServiceGetVariableParams {
	return &WaypointServiceGetVariableParams{
		timeout: timeout,
	}
}

// NewWaypointServiceGetVariableParamsWithContext creates a new WaypointServiceGetVariableParams object
// with the ability to set a context for a request.
func NewWaypointServiceGetVariableParamsWithContext(ctx context.Context) *WaypointServiceGetVariableParams {
	return &WaypointServiceGetVariableParams{
		Context: ctx,
	}
}

// NewWaypointServiceGetVariableParamsWithHTTPClient creates a new WaypointServiceGetVariableParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceGetVariableParamsWithHTTPClient(client *http.Client) *WaypointServiceGetVariableParams {
	return &WaypointServiceGetVariableParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceGetVariableParams contains all the parameters to send to the API endpoint

	for the waypoint service get variable operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceGetVariableParams struct {

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	// VariableActionID.
	VariableActionID *string

	// VariableActionName.
	VariableActionName *string

	// VariableID.
	VariableID *string

	// VariableKey.
	VariableKey *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service get variable params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetVariableParams) WithDefaults() *WaypointServiceGetVariableParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service get variable params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceGetVariableParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithTimeout(timeout time.Duration) *WaypointServiceGetVariableParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithContext(ctx context.Context) *WaypointServiceGetVariableParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithHTTPClient(client *http.Client) *WaypointServiceGetVariableParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithNamespaceID adds the namespaceID to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithNamespaceID(namespaceID string) *WaypointServiceGetVariableParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceGetVariableParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceGetVariableParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceGetVariableParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceGetVariableParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WithVariableActionID adds the variableActionID to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithVariableActionID(variableActionID *string) *WaypointServiceGetVariableParams {
	o.SetVariableActionID(variableActionID)
	return o
}

// SetVariableActionID adds the variableActionId to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetVariableActionID(variableActionID *string) {
	o.VariableActionID = variableActionID
}

// WithVariableActionName adds the variableActionName to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithVariableActionName(variableActionName *string) *WaypointServiceGetVariableParams {
	o.SetVariableActionName(variableActionName)
	return o
}

// SetVariableActionName adds the variableActionName to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetVariableActionName(variableActionName *string) {
	o.VariableActionName = variableActionName
}

// WithVariableID adds the variableID to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithVariableID(variableID *string) *WaypointServiceGetVariableParams {
	o.SetVariableID(variableID)
	return o
}

// SetVariableID adds the variableId to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetVariableID(variableID *string) {
	o.VariableID = variableID
}

// WithVariableKey adds the variableKey to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) WithVariableKey(variableKey *string) *WaypointServiceGetVariableParams {
	o.SetVariableKey(variableKey)
	return o
}

// SetVariableKey adds the variableKey to the waypoint service get variable params
func (o *WaypointServiceGetVariableParams) SetVariableKey(variableKey *string) {
	o.VariableKey = variableKey
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceGetVariableParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.VariableActionID != nil {

		// query param variable.action.id
		var qrVariableActionID string

		if o.VariableActionID != nil {
			qrVariableActionID = *o.VariableActionID
		}
		qVariableActionID := qrVariableActionID
		if qVariableActionID != "" {

			if err := r.SetQueryParam("variable.action.id", qVariableActionID); err != nil {
				return err
			}
		}
	}

	if o.VariableActionName != nil {

		// query param variable.action.name
		var qrVariableActionName string

		if o.VariableActionName != nil {
			qrVariableActionName = *o.VariableActionName
		}
		qVariableActionName := qrVariableActionName
		if qVariableActionName != "" {

			if err := r.SetQueryParam("variable.action.name", qVariableActionName); err != nil {
				return err
			}
		}
	}

	if o.VariableID != nil {

		// query param variable.id
		var qrVariableID string

		if o.VariableID != nil {
			qrVariableID = *o.VariableID
		}
		qVariableID := qrVariableID
		if qVariableID != "" {

			if err := r.SetQueryParam("variable.id", qVariableID); err != nil {
				return err
			}
		}
	}

	if o.VariableKey != nil {

		// query param variable.key
		var qrVariableKey string

		if o.VariableKey != nil {
			qrVariableKey = *o.VariableKey
		}
		qVariableKey := qrVariableKey
		if qVariableKey != "" {

			if err := r.SetQueryParam("variable.key", qVariableKey); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
