// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// NewUpdateRegistryParams creates a new UpdateRegistryParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateRegistryParams() *UpdateRegistryParams {
	return &UpdateRegistryParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateRegistryParamsWithTimeout creates a new UpdateRegistryParams object
// with the ability to set a timeout on a request.
func NewUpdateRegistryParamsWithTimeout(timeout time.Duration) *UpdateRegistryParams {
	return &UpdateRegistryParams{
		timeout: timeout,
	}
}

// NewUpdateRegistryParamsWithContext creates a new UpdateRegistryParams object
// with the ability to set a context for a request.
func NewUpdateRegistryParamsWithContext(ctx context.Context) *UpdateRegistryParams {
	return &UpdateRegistryParams{
		Context: ctx,
	}
}

// NewUpdateRegistryParamsWithHTTPClient creates a new UpdateRegistryParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateRegistryParamsWithHTTPClient(client *http.Client) *UpdateRegistryParams {
	return &UpdateRegistryParams{
		HTTPClient: client,
	}
}

/*
UpdateRegistryParams contains all the parameters to send to the API endpoint

	for the update registry operation.

	Typically these are written to a http.Request.
*/
type UpdateRegistryParams struct {

	/* Data.

	   The updated Registry details.
	*/
	Data *models.HashicorpCloudVagrant20220930Registry

	/* Registry.

	   The name of the Registry to update.
	*/
	Registry string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update registry params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateRegistryParams) WithDefaults() *UpdateRegistryParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update registry params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateRegistryParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update registry params
func (o *UpdateRegistryParams) WithTimeout(timeout time.Duration) *UpdateRegistryParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update registry params
func (o *UpdateRegistryParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update registry params
func (o *UpdateRegistryParams) WithContext(ctx context.Context) *UpdateRegistryParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update registry params
func (o *UpdateRegistryParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update registry params
func (o *UpdateRegistryParams) WithHTTPClient(client *http.Client) *UpdateRegistryParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update registry params
func (o *UpdateRegistryParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithData adds the data to the update registry params
func (o *UpdateRegistryParams) WithData(data *models.HashicorpCloudVagrant20220930Registry) *UpdateRegistryParams {
	o.SetData(data)
	return o
}

// SetData adds the data to the update registry params
func (o *UpdateRegistryParams) SetData(data *models.HashicorpCloudVagrant20220930Registry) {
	o.Data = data
}

// WithRegistry adds the registry to the update registry params
func (o *UpdateRegistryParams) WithRegistry(registry string) *UpdateRegistryParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the update registry params
func (o *UpdateRegistryParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateRegistryParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Data != nil {
		if err := r.SetBodyParam(o.Data); err != nil {
			return err
		}
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
