// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewReadProviderParams creates a new ReadProviderParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewReadProviderParams() *ReadProviderParams {
	return &ReadProviderParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewReadProviderParamsWithTimeout creates a new ReadProviderParams object
// with the ability to set a timeout on a request.
func NewReadProviderParamsWithTimeout(timeout time.Duration) *ReadProviderParams {
	return &ReadProviderParams{
		timeout: timeout,
	}
}

// NewReadProviderParamsWithContext creates a new ReadProviderParams object
// with the ability to set a context for a request.
func NewReadProviderParamsWithContext(ctx context.Context) *ReadProviderParams {
	return &ReadProviderParams{
		Context: ctx,
	}
}

// NewReadProviderParamsWithHTTPClient creates a new ReadProviderParams object
// with the ability to set a custom HTTPClient for a request.
func NewReadProviderParamsWithHTTPClient(client *http.Client) *ReadProviderParams {
	return &ReadProviderParams{
		HTTPClient: client,
	}
}

/*
ReadProviderParams contains all the parameters to send to the API endpoint

	for the read provider operation.

	Typically these are written to a http.Request.
*/
type ReadProviderParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Expanded.

	   Expand the provider child elements.
	*/
	Expanded *bool

	/* Provider.

	   The name of the Provider.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version for the Provider.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the read provider params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReadProviderParams) WithDefaults() *ReadProviderParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the read provider params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReadProviderParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the read provider params
func (o *ReadProviderParams) WithTimeout(timeout time.Duration) *ReadProviderParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the read provider params
func (o *ReadProviderParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the read provider params
func (o *ReadProviderParams) WithContext(ctx context.Context) *ReadProviderParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the read provider params
func (o *ReadProviderParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the read provider params
func (o *ReadProviderParams) WithHTTPClient(client *http.Client) *ReadProviderParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the read provider params
func (o *ReadProviderParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the read provider params
func (o *ReadProviderParams) WithBox(box string) *ReadProviderParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the read provider params
func (o *ReadProviderParams) SetBox(box string) {
	o.Box = box
}

// WithExpanded adds the expanded to the read provider params
func (o *ReadProviderParams) WithExpanded(expanded *bool) *ReadProviderParams {
	o.SetExpanded(expanded)
	return o
}

// SetExpanded adds the expanded to the read provider params
func (o *ReadProviderParams) SetExpanded(expanded *bool) {
	o.Expanded = expanded
}

// WithProvider adds the provider to the read provider params
func (o *ReadProviderParams) WithProvider(provider string) *ReadProviderParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the read provider params
func (o *ReadProviderParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the read provider params
func (o *ReadProviderParams) WithRegistry(registry string) *ReadProviderParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the read provider params
func (o *ReadProviderParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the read provider params
func (o *ReadProviderParams) WithVersion(version string) *ReadProviderParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the read provider params
func (o *ReadProviderParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *ReadProviderParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	if o.Expanded != nil {

		// query param expanded
		var qrExpanded bool

		if o.Expanded != nil {
			qrExpanded = *o.Expanded
		}
		qExpanded := swag.FormatBool(qrExpanded)
		if qExpanded != "" {

			if err := r.SetQueryParam("expanded", qExpanded); err != nil {
				return err
			}
		}
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
