// Code generated by go-swagger; DO NOT EDIT.

package service_principals_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-iam/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ServicePrincipalsServiceGetWorkloadIdentityProviderReader is a Reader for the ServicePrincipalsServiceGetWorkloadIdentityProvider structure.
type ServicePrincipalsServiceGetWorkloadIdentityProviderReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewServicePrincipalsServiceGetWorkloadIdentityProviderOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewServicePrincipalsServiceGetWorkloadIdentityProviderDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewServicePrincipalsServiceGetWorkloadIdentityProviderOK creates a ServicePrincipalsServiceGetWorkloadIdentityProviderOK with default headers values
func NewServicePrincipalsServiceGetWorkloadIdentityProviderOK() *ServicePrincipalsServiceGetWorkloadIdentityProviderOK {
	return &ServicePrincipalsServiceGetWorkloadIdentityProviderOK{}
}

/*
ServicePrincipalsServiceGetWorkloadIdentityProviderOK describes a response with status code 200, with default header values.

A successful response.
*/
type ServicePrincipalsServiceGetWorkloadIdentityProviderOK struct {
	Payload *models.HashicorpCloudIamGetWorkloadIdentityProviderResponse
}

// IsSuccess returns true when this service principals service get workload identity provider o k response has a 2xx status code
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this service principals service get workload identity provider o k response has a 3xx status code
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this service principals service get workload identity provider o k response has a 4xx status code
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this service principals service get workload identity provider o k response has a 5xx status code
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) IsServerError() bool {
	return false
}

// IsCode returns true when this service principals service get workload identity provider o k response a status code equal to that given
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the service principals service get workload identity provider o k response
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) Code() int {
	return 200
}

func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2019-12-10/{resource_name_2}][%d] servicePrincipalsServiceGetWorkloadIdentityProviderOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2019-12-10/{resource_name_2}][%d] servicePrincipalsServiceGetWorkloadIdentityProviderOK %s", 200, payload)
}

func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) GetPayload() *models.HashicorpCloudIamGetWorkloadIdentityProviderResponse {
	return o.Payload
}

func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudIamGetWorkloadIdentityProviderResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewServicePrincipalsServiceGetWorkloadIdentityProviderDefault creates a ServicePrincipalsServiceGetWorkloadIdentityProviderDefault with default headers values
func NewServicePrincipalsServiceGetWorkloadIdentityProviderDefault(code int) *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault {
	return &ServicePrincipalsServiceGetWorkloadIdentityProviderDefault{
		_statusCode: code,
	}
}

/*
ServicePrincipalsServiceGetWorkloadIdentityProviderDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ServicePrincipalsServiceGetWorkloadIdentityProviderDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this service principals service get workload identity provider default response has a 2xx status code
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this service principals service get workload identity provider default response has a 3xx status code
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this service principals service get workload identity provider default response has a 4xx status code
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this service principals service get workload identity provider default response has a 5xx status code
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this service principals service get workload identity provider default response a status code equal to that given
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the service principals service get workload identity provider default response
func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) Code() int {
	return o._statusCode
}

func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2019-12-10/{resource_name_2}][%d] ServicePrincipalsService_GetWorkloadIdentityProvider default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /2019-12-10/{resource_name_2}][%d] ServicePrincipalsService_GetWorkloadIdentityProvider default %s", o._statusCode, payload)
}

func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ServicePrincipalsServiceGetWorkloadIdentityProviderDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
