// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Billing20201105ResourceUsage ResourceUsage contains the usage of a single resource, including all
// the line items from it.
//
// swagger:model billing_20201105ResourceUsage
type Billing20201105ResourceUsage struct {

	// amount is the sum of the amount of all line items.
	Amount string `json:"amount,omitempty"`

	// line_items is the list of line items as they would appear on an invoice.
	// They are a simplified version of the backend one, containing only
	// points useful for the UI.
	LineItems []*Billing20201105InvoiceLineItem `json:"line_items"`

	// resource is a link to the Resource for which this line item charges.
	Resource *LocationLink `json:"resource,omitempty"`

	// total_Hours contains the difference between usage_until and usage_from
	// in units of hours.
	TotalHours float64 `json:"total_hours,omitempty"`

	// usage_from is the start time of the first line item of this resource.
	// Format: date-time
	UsageFrom strfmt.DateTime `json:"usage_from,omitempty"`

	// usage_until is the end time of the last line item of this resource.
	// Format: date-time
	UsageUntil strfmt.DateTime `json:"usage_until,omitempty"`
}

// Validate validates this billing 20201105 resource usage
func (m *Billing20201105ResourceUsage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateLineItems(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsageFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsageUntil(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ResourceUsage) validateLineItems(formats strfmt.Registry) error {
	if swag.IsZero(m.LineItems) { // not required
		return nil
	}

	for i := 0; i < len(m.LineItems); i++ {
		if swag.IsZero(m.LineItems[i]) { // not required
			continue
		}

		if m.LineItems[i] != nil {
			if err := m.LineItems[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("line_items" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("line_items" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105ResourceUsage) validateResource(formats strfmt.Registry) error {
	if swag.IsZero(m.Resource) { // not required
		return nil
	}

	if m.Resource != nil {
		if err := m.Resource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105ResourceUsage) validateUsageFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.UsageFrom) { // not required
		return nil
	}

	if err := validate.FormatOf("usage_from", "body", "date-time", m.UsageFrom.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Billing20201105ResourceUsage) validateUsageUntil(formats strfmt.Registry) error {
	if swag.IsZero(m.UsageUntil) { // not required
		return nil
	}

	if err := validate.FormatOf("usage_until", "body", "date-time", m.UsageUntil.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this billing 20201105 resource usage based on the context it is used
func (m *Billing20201105ResourceUsage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateLineItems(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105ResourceUsage) contextValidateLineItems(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.LineItems); i++ {

		if m.LineItems[i] != nil {

			if swag.IsZero(m.LineItems[i]) { // not required
				return nil
			}

			if err := m.LineItems[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("line_items" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("line_items" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Billing20201105ResourceUsage) contextValidateResource(ctx context.Context, formats strfmt.Registry) error {

	if m.Resource != nil {

		if swag.IsZero(m.Resource) { // not required
			return nil
		}

		if err := m.Resource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105ResourceUsage) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105ResourceUsage) UnmarshalBinary(b []byte) error {
	var res Billing20201105ResourceUsage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
