/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.patterns.CaseConversionHelper;
import org.languagetool.rules.patterns.Match;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tools.StringTools;

public class MatchState {
    private final Match match;
    private final Synthesizer synthesizer;
    private AnalyzedTokenReadings formattedToken;
    private AnalyzedTokenReadings matchedToken;
    private String skippedTokens;

    public MatchState(Match match, Synthesizer synthesizer) {
        this.match = match;
        this.synthesizer = synthesizer;
        String lemma = match.getLemma();
        if (!StringUtils.isEmpty((CharSequence)lemma)) {
            this.formattedToken = new AnalyzedTokenReadings(new AnalyzedToken(lemma, match.getPosTag(), lemma), 0);
        }
    }

    public void setToken(AnalyzedTokenReadings token) {
        if (this.match.isStaticLemma()) {
            this.matchedToken = token;
        } else {
            this.formattedToken = token;
        }
    }

    public final void setToken(AnalyzedTokenReadings[] tokens, int index, int next) {
        int idx = index;
        if (index >= tokens.length) {
            idx = tokens.length - 1;
        }
        this.setToken(tokens[idx]);
        Match.IncludeRange includeSkipped = this.match.getIncludeSkipped();
        if (includeSkipped == Match.IncludeRange.FOLLOWING) {
            this.formattedToken = null;
        }
        if (next > 1 && includeSkipped != Match.IncludeRange.NONE) {
            StringBuilder sb = new StringBuilder();
            for (int k = index + 1; k < index + next; ++k) {
                if (tokens[k].isWhitespaceBefore() && (k != index + 1 || includeSkipped != Match.IncludeRange.FOLLOWING)) {
                    sb.append(' ');
                }
                sb.append(tokens[k].getToken());
            }
            this.skippedTokens = sb.toString();
        } else {
            this.skippedTokens = "";
        }
    }

    public final AnalyzedTokenReadings filterReadings() {
        ArrayList<AnalyzedToken> l = new ArrayList<AnalyzedToken>();
        if (this.formattedToken != null) {
            if (this.match.isStaticLemma()) {
                this.matchedToken.leaveReading(new AnalyzedToken(this.matchedToken.getReadings().get(0).getToken(), this.match.getPosTag(), this.formattedToken.getToken()));
                this.formattedToken = this.matchedToken;
            }
            String token = this.formattedToken.getAnalyzedToken(0).getToken();
            Pattern regexMatch = this.match.getRegexMatch();
            String regexReplace = this.match.getRegexReplace();
            if (regexMatch != null && regexReplace != null) {
                token = regexMatch.matcher(token).replaceAll(regexReplace);
            }
            token = this.convertCase(token, token, null);
            String posTag = this.match.getPosTag();
            if (posTag != null) {
                int numRead = this.formattedToken.getReadingsLength();
                if (this.match.isPostagRegexp()) {
                    Pattern pPosRegexMatch = this.match.getPosRegexMatch();
                    String posTagReplace = this.match.getPosTagReplace();
                    for (int i = 0; i < numRead; ++i) {
                        String testTag = this.formattedToken.getAnalyzedToken(i).getPOSTag();
                        if (testTag == null || !pPosRegexMatch.matcher(testTag).matches()) continue;
                        String targetPosTag = testTag;
                        if (posTagReplace != null) {
                            targetPosTag = pPosRegexMatch.matcher(targetPosTag).replaceAll(posTagReplace);
                        }
                        l.add(new AnalyzedToken(token, targetPosTag, this.formattedToken.getAnalyzedToken(i).getLemma()));
                        ((AnalyzedToken)l.get(l.size() - 1)).setWhitespaceBefore(this.formattedToken.isWhitespaceBefore());
                    }
                    if (l.isEmpty()) {
                        l.addAll(this.getNewToken(numRead, token));
                    }
                } else {
                    l.addAll(this.getNewToken(numRead, token));
                }
                String lemma = this.formattedToken.getAnalyzedToken(0).getLemma();
                if (this.formattedToken.isSentenceEnd()) {
                    l.add(new AnalyzedToken(this.formattedToken.getToken(), "SENT_END", lemma));
                }
                if (this.formattedToken.isParagraphEnd()) {
                    l.add(new AnalyzedToken(this.formattedToken.getToken(), "PARA_END", lemma));
                }
            }
        }
        if (l.isEmpty()) {
            return this.formattedToken;
        }
        AnalyzedTokenReadings anTkRead = new AnalyzedTokenReadings(l.toArray(new AnalyzedToken[0]), this.formattedToken.getStartPos());
        anTkRead.setWhitespaceBefore(this.formattedToken.getWhitespaceBefore());
        if (!this.formattedToken.getChunkTags().isEmpty()) {
            anTkRead.setChunkTags(this.formattedToken.getChunkTags());
        }
        if (this.formattedToken.isImmunized()) {
            anTkRead.immunize(this.formattedToken.getImmunizationSourceLine());
        }
        return anTkRead;
    }

    String convertCase(String s, String sample, Language lang) {
        return CaseConversionHelper.convertCase(this.match.getCaseConversionType(), s, sample, lang);
    }

    private List<AnalyzedToken> getNewToken(int numRead, String token) {
        String posTag = this.match.getPosTag();
        ArrayList<AnalyzedToken> list = new ArrayList<AnalyzedToken>();
        String lemma = "";
        for (int j = 0; j < numRead; ++j) {
            String tempPosTag = this.formattedToken.getAnalyzedToken(j).getPOSTag();
            if (tempPosTag == null) continue;
            if (tempPosTag.equals(posTag) && this.formattedToken.getAnalyzedToken(j).getLemma() != null) {
                lemma = this.formattedToken.getAnalyzedToken(j).getLemma();
            }
            if (StringTools.isEmpty(lemma)) {
                lemma = this.formattedToken.getAnalyzedToken(0).getLemma();
            }
            list.add(new AnalyzedToken(token, posTag, lemma));
            ((AnalyzedToken)list.get(list.size() - 1)).setWhitespaceBefore(this.formattedToken.isWhitespaceBefore());
        }
        return list;
    }

    public final String[] toFinalString(Language lang) throws IOException {
        String[] formattedString = new String[1];
        if (this.formattedToken != null) {
            String posTag;
            int readingCount = this.formattedToken.getReadingsLength();
            formattedString[0] = this.formattedToken.getToken();
            Pattern pRegexMatch = this.match.getRegexMatch();
            String regexReplace = this.match.getRegexReplace();
            if (pRegexMatch != null) {
                if (lang != null && lang.getShortCode().equals("ar")) {
                    formattedString[0] = StringTools.removeTashkeel(formattedString[0]);
                }
                formattedString[0] = pRegexMatch.matcher(formattedString[0]).replaceAll(regexReplace);
            }
            if ((posTag = this.match.getPosTag()) != null) {
                TreeSet<String> wordForms;
                if (this.synthesizer == null) {
                    formattedString[0] = this.formattedToken.getToken();
                } else if (this.match.isPostagRegexp()) {
                    wordForms = new TreeSet<String>();
                    boolean oneForm = false;
                    for (int k = 0; k < readingCount; ++k) {
                        if (this.formattedToken.getAnalyzedToken(k).getLemma() != null) continue;
                        String posUnique = this.formattedToken.getAnalyzedToken(k).getPOSTag();
                        if (posUnique == null) {
                            wordForms.add(this.formattedToken.getToken());
                            oneForm = true;
                            continue;
                        }
                        if ("SENT_START".equals(posUnique) || "SENT_END".equals(posUnique) || "PARA_END".equals(posUnique)) {
                            if (!oneForm) {
                                wordForms.add(this.formattedToken.getToken());
                            }
                            oneForm = true;
                            continue;
                        }
                        oneForm = false;
                    }
                    String targetPosTag = this.getTargetPosTag();
                    if (!oneForm) {
                        for (int i = 0; i < readingCount; ++i) {
                            String[] possibleWordForms = this.synthesizer.synthesize(this.formattedToken.getAnalyzedToken(i), targetPosTag, true);
                            if (possibleWordForms == null || possibleWordForms.length <= 0) continue;
                            wordForms.addAll(Arrays.asList(possibleWordForms));
                        }
                    }
                    if (wordForms.isEmpty()) {
                        formattedString[0] = "(" + this.formattedToken.getToken() + ")";
                    } else {
                        formattedString = wordForms.toArray(new String[0]);
                    }
                } else {
                    wordForms = new TreeSet();
                    for (int i = 0; i < readingCount; ++i) {
                        String[] possibleWordForms = this.synthesizer.synthesize(this.formattedToken.getAnalyzedToken(i), posTag);
                        if (possibleWordForms == null) continue;
                        wordForms.addAll(Arrays.asList(possibleWordForms));
                    }
                    formattedString = wordForms.toArray(new String[0]);
                }
            }
        }
        String original = this.match.isStaticLemma() ? (this.matchedToken != null ? this.matchedToken.getToken() : "") : (this.formattedToken != null ? this.formattedToken.getToken() : "");
        for (int i = 0; i < formattedString.length; ++i) {
            formattedString[i] = this.convertCase(formattedString[i] != null ? formattedString[i] : "", original, lang);
        }
        Match.IncludeRange includeSkipped = this.match.getIncludeSkipped();
        if (includeSkipped != Match.IncludeRange.NONE && this.skippedTokens != null && !this.skippedTokens.isEmpty()) {
            String[] helper = new String[formattedString.length];
            for (int i = 0; i < formattedString.length; ++i) {
                if (formattedString[i] == null) {
                    formattedString[i] = "";
                }
                helper[i] = formattedString[i] + this.skippedTokens;
            }
            formattedString = helper;
        }
        if (this.match.checksSpelling() && lang != null) {
            List<String> formattedStringElements = Arrays.asList(formattedString);
            List<AnalyzedTokenReadings> analyzed = lang.getTagger().tag(formattedStringElements);
            for (int i = 0; i < formattedString.length; ++i) {
                AnalyzedToken analyzedToken = analyzed.get(i).getAnalyzedToken(0);
                if (analyzedToken.getLemma() != null || !analyzedToken.hasNoTag()) continue;
                formattedString[i] = "<mistake/>";
            }
        }
        return formattedString;
    }

    public final String getTargetPosTag() {
        String targetPosTag = this.match.getPosTag();
        ArrayList<String> posTags = new ArrayList<String>();
        Pattern pPosRegexMatch = this.match.getPosRegexMatch();
        String posTagReplace = this.match.getPosTagReplace();
        if (this.match.isStaticLemma()) {
            for (AnalyzedToken analyzedToken : this.matchedToken) {
                String tst = analyzedToken.getPOSTag();
                if (tst == null || !pPosRegexMatch.matcher(tst).matches()) continue;
                posTags.add(tst);
            }
            targetPosTag = this.synthesizer.getTargetPosTag(posTags, targetPosTag);
            if (pPosRegexMatch != null && posTagReplace != null && !posTags.isEmpty()) {
                targetPosTag = pPosRegexMatch.matcher(targetPosTag).replaceAll(posTagReplace);
            }
        } else {
            for (AnalyzedToken analyzedToken : this.formattedToken) {
                String tst = analyzedToken.getPOSTag();
                if (tst == null || !pPosRegexMatch.matcher(tst).matches()) continue;
                posTags.add(tst);
            }
            targetPosTag = this.synthesizer.getTargetPosTag(posTags, targetPosTag);
            if (pPosRegexMatch != null && posTagReplace != null) {
                if (posTags.isEmpty()) {
                    posTags.add(targetPosTag);
                }
                StringBuilder sb = new StringBuilder();
                int posTagLen = posTags.size();
                int l = 0;
                for (String lPosTag : posTags) {
                    ++l;
                    lPosTag = pPosRegexMatch.matcher(lPosTag).replaceAll(posTagReplace);
                    if (this.match.setsPos()) {
                        lPosTag = this.synthesizer.getPosTagCorrection(lPosTag);
                    }
                    sb.append(lPosTag);
                    if (l >= posTagLen) continue;
                    sb.append('|');
                }
                targetPosTag = sb.toString();
            }
        }
        return targetPosTag;
    }

    final String toTokenString() throws IOException {
        String[] stringToFormat = this.toFinalString(null);
        return String.join((CharSequence)"|", Arrays.asList(stringToFormat));
    }

    public Match getMatch() {
        return this.match;
    }
}

